package com.yodo1.plugin.dmp.yodo1.helper;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;

import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.sdk.kit.YFileUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Cache;
import com.yodo1.sdk.kit.Yodo1CommonUtils;
import com.yodo1.sdk.kit.Yodo1DeviceUtils;

import java.io.File;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;

/**
 * Created by yodo1 on 18/5/8.
 */

public class Yodo1AnalyticsManage {
    public static final long upDataTime = 1000 * 60 * 5;//上报时间  五分钟上报一次数据
    private static final String YA_SWITCH_KEY = "Yodo1AnalyticSwitch";
    private static final String SESSIONID = "sessionid";
    private static final String DURATION = "duration";
    private static final String TERMINALTIME = "terminaltime";
    public static String sessionid = "";
    private static long launchtime;//启动时间
    private static long terminaltime;//一次APP运行的结束时间
    private static long duration = 0;
    private static boolean newsession = false;
    private static Yodo1Cache yodo1Cache;
    private static Yodo1AnalyticsForYodo1 helper = Yodo1AnalyticsForYodo1.getInstance();
    private static Yodo1AnalyticsForGA gaHelper = Yodo1AnalyticsForGA.getInstance();
    private static Yodo1AnalyticsManage instance;
    private static Timer timer, timer1;
    private static TimerTask task, task1;
    final int WHAT = 5000;
    final int WHAT_REFRESH = 5001;
    final Handler handler = new Handler() {
        @Override
        public void handleMessage(final Message msg) {
//            YLog.d("Yodo1AnalyticsManage 接收数据 " + msg.what);
            //线程执行内容
            switch (msg.what) {
                case WHAT:
                    helper.Update(helper);
                    gaHelper.Update(gaHelper);
                    break;
                case WHAT_REFRESH:
                    toBackRefreshDate();//每5s刷新一次数据
                    break;
            }
        }
    };
    private final long refashDataTime = 5000;//5s刷新一次数据时间
    private boolean yodo1_analytic_switch = true;
    private boolean isLuanch = false;
    private String device_id = "";
    private String gameKey = "";
    //    public static final long  upDataTime = 30000;//上报时间  30s上报一次数据
    private Activity mainActivity;

    public static Yodo1AnalyticsManage getInstance() {
        if (instance == null) {
            instance = new Yodo1AnalyticsManage();
        }
        return instance;
    }

    /**
     * 本地缓存数据刷新
     */
    public static void toBackRefreshDate() {

        long currentduration = 0;
        terminaltime = Yodo1CommonUtils.getUTCTime();
        currentduration = terminaltime - launchtime;
        launchtime = terminaltime;
        if (newsession) {
            duration = currentduration;
            newsession = false;
        } else {
            duration = duration + currentduration;
        }
        yodo1Cache.putAESData(DURATION, String.valueOf(duration));//保存duration
        yodo1Cache.putAESData(TERMINALTIME, String.valueOf(terminaltime));//保存terminaltime
    }

    public void initSDK(Activity activity, String appKey) {
        this.mainActivity = activity;
        this.gameKey = appKey;
        isLuanch = true;
        if (yodo1Cache == null) {
            yodo1Cache = Yodo1Cache.get(activity);
            device_id = Yodo1DeviceUtils.getDeviceId(activity);//设备ID
        }
        //如果缓存数据大于10M  清除所有缓存
        File f = new File(activity.getCacheDir(), "Yodo1Cache");
        if (YFileUtils.getFolderSize(f) > 10) {
            if (yodo1Cache != null) {
                yodo1Cache.clear();
            }
        }

        String result_OnOff = Yodo1OnlineConfig.getInstance().getConfigParam(YA_SWITCH_KEY, "on");

        if (result_OnOff.equals("off")) {
            yodo1_analytic_switch = false;
            YLog.d("Yodo1数据统计关闭");
            return;

        }


        helper.initSDK(activity, appKey);
        gaHelper.initSDK(activity);

    }

    public void onResume(final Activity activity) {

        if (!yodo1_analytic_switch || TextUtils.isEmpty(gameKey)) {
            YLog.d("Yodo1Analytic关闭");
            return;
        }
        helper.onResume(activity);
        gaHelper.onResume(activity);
        if (yodo1Cache == null) {
            yodo1Cache = Yodo1Cache.get(activity);
        }
        launchtime = Yodo1CommonUtils.getUTCTime();
        sessionid = yodo1Cache.getAESData(SESSIONID);
        String t = yodo1Cache.getAESData(TERMINALTIME);
        terminaltime = Yodo1CommonUtils.getLongValues(t);
        String d = yodo1Cache.getAESData(DURATION);
        duration = Yodo1CommonUtils.getLongValues(d);
        final String lastTimeSessionid = sessionid;

        YLog.d("launchdata   onResume: " + (!TextUtils.isEmpty(sessionid) && launchtime - terminaltime > 1800000));
        //判断sessionid是否存在
        //如果sessionid不存在，或者应用在后台时间超过30s，生成新的并保存到本地
        if (isLuanch || TextUtils.isEmpty(sessionid) || (!TextUtils.isEmpty(sessionid) && launchtime - terminaltime > 1800000)) {
            sessionid = device_id + Yodo1CommonUtils.getUTCTime();
            yodo1Cache.putAESData(SESSIONID, sessionid);//保存sessionid

            final String lastduration = yodo1Cache.getAESData(DURATION);
            yodo1Cache.putAESData(DURATION, "0");
            duration = 0;

            newsession = true;
            YLog.d("launchdata   duration onResume: " + lastduration);
            //保存新建launch事件
            YLog.d("launchdata  sessionid onResume: " + sessionid);

            //启动后延时1s保存launch信息    确保SDK已经初始化完成
            new Handler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    helper.saveLaunchEvent(activity, sessionid, lastTimeSessionid, lastduration);
                }
            }, 1000);

        }


        startUpdate();//定时5min上报事件信息
        refreshDate();//定时5s刷新本地信息
    }

    public void onPause(Activity activity) {
        if (!yodo1_analytic_switch || TextUtils.isEmpty(gameKey)) {
            return;
        }
        if (yodo1Cache == null) {
            yodo1Cache = Yodo1Cache.get(activity);
        }
        isLuanch = false;
        toBackRefreshDate();
        closeUpdate();//关闭定时器
    }

    public void onDestroy() {
        if (!yodo1_analytic_switch || TextUtils.isEmpty(gameKey)) {
            return;
        }

        gaHelper.onDestroy();
    }

    public void onEvent(final String eventId, final HashMap<String, Object> map) {

        if (!yodo1_analytic_switch || TextUtils.isEmpty(gameKey)) {
            return;
        }


        Thread thread = new Thread(new Runnable() {
            @Override
            public void run() {
                //线程执行内容
                Looper.prepare();
                helper.onEvent(eventId, map);
                gaHelper.onEvent(eventId, map);
                Looper.loop();
            }
        });
        //开启线程
        thread.start();


    }

    //定时器  调用update方法
    public void startUpdate() {
        task = new TimerTask() {
            @Override
            public void run() {
                Message message = new Message();
                message.what = WHAT;
                handler.sendMessage(message);
                YLog.d("Yodo1AnalyticsManage 发送数据");
            }
        };

        timer = new Timer();
        timer.schedule(task, 5000, upDataTime);
        YLog.d("Yodo1AnalyticsManage 开启定时上传");
    }


    //定时器 刷新数据
    public void refreshDate() {
        task1 = new TimerTask() {
            @Override
            public void run() {
                Message message = new Message();
                message.what = WHAT_REFRESH;
                handler.sendMessage(message);
            }
        };

        timer1 = new Timer();
        timer1.schedule(task1, 0, refashDataTime);
    }

    //关闭定时器
    public void closeUpdate() {
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
        if (task != null) {
            task.cancel();
            task = null;
        }

        if (timer1 != null) {
            timer1.cancel();
            timer1 = null;
        }
        if (task1 != null) {
            task1.cancel();
            task1 = null;
        }
    }

}
