package com.yodo1.plugin.dmp.yodo1.helper;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;

import com.yodo1.android.ops.net.HttpListener;
import com.yodo1.android.ops.net.Yodo1HttpManage;
import com.yodo1.android.ops.net.Yodo1RequestListener;
import com.yodo1.android.ops.net.Yodo1SDKResponse;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.sdk.kit.YFileUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Cache;
import com.yodo1.sdk.kit.Yodo1CommonUtils;
import com.yodo1.sdk.kit.Yodo1DeviceUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * Created by yodo1 on 18/1/4.
 */

public class Yodo1AnalyticsForGA implements Yodo1RequestListener {

    private static final String SESSION_NUM = "session_num";
    private static final String GA_APPKEY_VALUE = "Platform_GA_GameKey";
    private static final String GA_SECRET_VALUE = "Platform_GA_SecretKey";
    private static final String GA_ONOFF_KEY = "ga_onoff";
    private static long uptime;//数据上报时间戳
    private static String CACHE = "Yodo1GACache";
    private static int session_num = 1;
    private static Yodo1Cache yodo1GACache;
    private static Yodo1AnalyticsForGA instance;
    private final long upDataTime = 1000 * 5 * 60;//上报时间  五分钟上报一次数据
    private String device_id = "";
    //    private static GAHTTPApi gaApi;
    private String initializeUrl = "";
    private String eventsUrl = "";
    private String initsubmitStr = "";
    private String ga_appkey = "";
    private String ga_secret = "";
    private boolean ga_OnOff = false;
    private Activity mainActivity;

    private Yodo1AnalyticsForGA() {
    }

    public static Yodo1AnalyticsForGA getInstance() {
        if (instance == null) {
            instance = new Yodo1AnalyticsForGA();
        }
        return instance;
    }

    private void initGA(String key, String secret, boolean isTest) {
        String protocol = "http";
        String hostName = "api.sdkdev.io";
        if (isTest) {
            hostName = "sandbox-api.gameanalytics.com";
        }
        String version = "v2";

        String baseUrl = (protocol + "://" + hostName + "/" + version);

        initsubmitStr = "{\"platform\": \"android\", \"sdk_version\": \"rest api v2\", \"os_version\": \"android " + android.os.Build.VERSION.SDK_INT + "\"}";

        initializeUrl = baseUrl + "/" + key + "/" + "init";
        eventsUrl = baseUrl + "/" + key + "/" + "events";
    }

    public void initSDK(final Activity activity) {
        mainActivity = activity;
        String result_OnOff = Yodo1OnlineConfig.getInstance().getConfigParam(GA_ONOFF_KEY, "");
        if (TextUtils.isEmpty(result_OnOff)) {
            YLog.d("ga_OnOff未设置，GA默认关闭");
            return;
        }
        if (result_OnOff.equals("on")) {
            ga_OnOff = true;
        }
        ga_appkey = Yodo1OnlineConfig.getInstance().getConfigParam(GA_APPKEY_VALUE, "");
        ga_secret = Yodo1OnlineConfig.getInstance().getConfigParam(GA_SECRET_VALUE, "");

        if (TextUtils.isEmpty(ga_appkey) || TextUtils.isEmpty(ga_secret)) {
            YLog.d("GA统计在线参数获取失败！");
            return;
        }
        if (yodo1GACache == null) {
            yodo1GACache = Yodo1Cache.get(activity,CACHE);
            device_id = Yodo1DeviceUtils.getDeviceId(activity);//设备ID
        }
        //如果缓存数据大于10M  清除所有缓存
        File f = new File(activity.getCacheDir(), "Yodo1Cache");
        if (YFileUtils.getFolderSize(f) > 10) {
            if (yodo1GACache != null) {
                yodo1GACache.clear();
            }

        }
        if (yodo1GACache.getAESData(SESSION_NUM) != null) {
            session_num = Integer.parseInt(yodo1GACache.getAESData(SESSION_NUM));
        }
        initGA(ga_appkey, ga_secret, false);
        //启动后延时1s保存launch信息    确保SDK已经初始化完成
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                pushInitConfig(activity, Yodo1AnalyticsForGA.this);
            }
        }, 1000);
    }

    private void pushInitConfig(final Activity activity, final Yodo1RequestListener listener) {
        if (!ga_OnOff) {
            return;
        }
        if (TextUtils.isEmpty(ga_appkey) || TextUtils.isEmpty(ga_secret)) {
            YLog.d("GA统计在线参数获取失败！");
            return;
        }

        if (TextUtils.isEmpty(initsubmitStr)) {
            YLog.d("GA submitStr is null");
            return;
        }
        if (TextUtils.isEmpty(initializeUrl)) {
            YLog.d("GA initializeUrl is null");
            return;
        }
        YLog.d("call Yodo1AnalyticsForGA上传初始化数据---- ga_appkey=" + ga_appkey);
        Request<String> request = NoHttp.createStringRequest(initializeUrl, RequestMethod.POST);
        request.addHeader("Content-Length", String.valueOf(initsubmitStr.getBytes().length));
        request.addHeader("Authorization", Yodo1CommonUtils.hmacWithKey(ga_secret, initsubmitStr.getBytes()));
        request.setDefineRequestBodyForJson(initsubmitStr);
        Yodo1HttpManage.getInstance().connect(0, request, new HttpListener<String>() {
            @Override
            public void onSucceed(int what, Response<String> response) {
                Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(1, response);
                listener.onYodo1RequestComplete(resp);
                saveLaunchEvent(activity);
            }

            @Override
            public void onFailed(int what, Response<String> response) {
                Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(1, response);
                listener.onYodo1RequestComplete(resp);
            }
        }, false);
    }

    public void onResume(final Activity activity) {
        if (yodo1GACache == null) {
            yodo1GACache = Yodo1Cache.get(activity,CACHE);
            device_id = Yodo1DeviceUtils.getDeviceId(activity);//设备ID
        }
    }

    public void onDestroy() {
        if (!ga_OnOff) {
            return;
        }
        if (TextUtils.isEmpty(ga_appkey) || TextUtils.isEmpty(ga_secret)) {
            YLog.d("GA统计在线参数获取失败！");
            return;
        }
        yodo1GACache.putAESData(SESSION_NUM, String.valueOf((session_num + 1)));
    }


    /**
     * 保存事件信息
     *
     * @param eventId
     * @param map
     */
    public void onEvent(String eventId, HashMap<String, Object> map) {
        if (!ga_OnOff) {
            YLog.d("GA close");
            return;
        }
        if (TextUtils.isEmpty(ga_appkey) || TextUtils.isEmpty(ga_secret)) {
            YLog.d("GA统计在线参数获取失败！");
            return;
        }
        JSONObject eventJson = new JSONObject();
        try {

            eventJson.put("category", "design");
            eventJson.put("device", Yodo1DeviceUtils.getPhoneVersion());
            eventJson.put("v", 2);
            eventJson.put("user_id", device_id);
            eventJson.put("client_ts", Yodo1CommonUtils.getUTCTime());
            eventJson.put("sdk_version", "rest api v2");
            eventJson.put("os_version", "android " + Yodo1DeviceUtils.getOsVersion());
            eventJson.put("manufacturer", android.os.Build.MANUFACTURER);
            eventJson.put("platform", "android");
            UUID uuid = null;
            for (int i = 0; i < 10; i++) {
                uuid = UUID.randomUUID();
            }
            eventJson.put("session_id", uuid);
            eventJson.put("session_num", session_num);
            String event_design = "";
            ArrayList eventinfo = new ArrayList();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getValue() != null && !entry.getValue().equals("")) {
                    eventinfo.add(entry.getValue());
                }
            }
            String eventResult = getEventidResult(eventinfo);
            if (TextUtils.isEmpty(eventResult)) {
                eventResult = eventId;
            } else {
                eventResult = eventId + ":" + eventResult;
            }
            YLog.d("GA，event_id==" + eventResult);
            eventJson.put("event_id", eventResult);
            saveDataForLocal(eventJson);
        } catch (JSONException e) {
            e.printStackTrace();
        }

//        YLog.d("gaeventdata  dataJson : " + eventJson.toString());
    }

    private String getEventidResult(ArrayList list) {
        String result = "";
        for (int x = 0; x < list.size(); x++) {
            if (x == list.size() - 1) {
                result += list.get(x);
            } else {
                // 就拼接元素和逗号以及空格
                result += list.get(x);
                result += ":";
            }
        }
        return result;
    }

    /**
     * 保存启动信息
     *
     * @param context
     */
    private void saveLaunchEvent(Context context) {
        String channel_code = Yodo1OnlineConfig.ChannelCode;

        JSONObject launchJson = new JSONObject();
        try {
            launchJson.put("category", "design");
            launchJson.put("device", Yodo1DeviceUtils.getPhoneVersion());
            launchJson.put("v", 2);
            launchJson.put("user_id", device_id);
            launchJson.put("client_ts", Yodo1CommonUtils.getUTCTime());
            launchJson.put("sdk_version", "rest api v2");
            launchJson.put("os_version", "android " + Yodo1DeviceUtils.getOsVersion());
            launchJson.put("manufacturer", android.os.Build.MANUFACTURER);
            launchJson.put("platform", "android");
            UUID uuid = null;
            for (int i = 0; i < 10; i++) {
                uuid = UUID.randomUUID();
            }
            launchJson.put("session_id", uuid.toString());
            launchJson.put("session_num", session_num);
            launchJson.put("event_id", "launchtime:" + Yodo1CommonUtils.getUTCTime() + ":" + channel_code);
            saveDataForLocal(launchJson);
            Update(Yodo1AnalyticsForGA.this);

        } catch (JSONException e) {
            e.printStackTrace();
        }

    }

    public void Update(final Yodo1RequestListener listener) {
        if (!ga_OnOff) {
            YLog.d("GA close");
            return;
        }
        if (TextUtils.isEmpty(ga_appkey) || TextUtils.isEmpty(ga_secret)) {
            YLog.d("GA统计在线参数获取失败！");
            return;
        }
        if (TextUtils.isEmpty(eventsUrl)) {
            YLog.d("GA eventsUrl is null!");
            return;
        }
        if (Yodo1CommonUtils.getUTCTime() - uptime < upDataTime - 3000) {// 5min上报一次  减3s，忽略数据缓存时时差
            YLog.d("Yodo1AnalyticsForGA   5min上报一次数据");
            return;
        }
        String cache = yodo1GACache.getAESData(CACHE);
        if (TextUtils.isEmpty(cache)) {
            YLog.d("Yodo1AnalyticsForGA  Cache is null  terminate report");
            return;
        }
        Request<String> request = NoHttp.createStringRequest(eventsUrl, RequestMethod.POST);
        request.addHeader("Content-Length", String.valueOf(cache.getBytes().length));
        request.addHeader("Authorization", Yodo1CommonUtils.hmacWithKey(ga_secret, cache.getBytes()));
        request.setDefineRequestBodyForJson(cache);
//        YLog.d("GA开始上传数据： " + cache);
        Yodo1HttpManage.getInstance().connect(0, request, new HttpListener<String>() {
            @Override
            public void onSucceed(int what, Response<String> response) {
                Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(1, response);
                listener.onYodo1RequestComplete(resp);
            }

            @Override
            public void onFailed(int what, Response<String> response) {
                Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(1, response);
                listener.onYodo1RequestComplete(resp);
            }
        }, false);
    }

    @Override
    public void onYodo1RequestComplete(Yodo1SDKResponse responseObject) {
        String resMsg = responseObject.getResponseString();
        if (!TextUtils.isEmpty(resMsg)) {
            try {
                JSONObject jsonObj = new JSONObject(resMsg);
                if (jsonObj.toString().equals("{}")) {
                    YLog.d("GA eventUpload success ");
                    clearData();//上传成功后清除指定数据
                    uptime = Yodo1CommonUtils.getUTCTime();//上报时间
                } else {
                    boolean errorCode = jsonObj.optBoolean("enabled");
                    if (errorCode) {
                        YLog.d("GA init success ");
                    } else {
                        YLog.d("GA failed ");
                    }
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            YLog.d("GA failed for null ");
        }
    }

    /**
     * 将事件缓存至本地
     * 先读取本地后 将新事件添加进去
     */
    private void saveDataForLocal(JSONObject dataJson) {
        if (!ga_OnOff) {
            YLog.d("GA close");
            return;
        }
        if (yodo1GACache == null) {
            yodo1GACache = Yodo1Cache.get(mainActivity,CACHE);
        }
        if (TextUtils.isEmpty(ga_appkey) || TextUtils.isEmpty(ga_secret)) {
            YLog.d("GA统计在线参数获取失败！");
            return;
        }
        String cache = yodo1GACache.getAESData(CACHE);
        JSONArray array = null;
        if (!TextUtils.isEmpty(cache)) {
            try {
                array = new JSONArray(cache);
            } catch (JSONException e) {
                array = new JSONArray();
            }
        } else {
            array = new JSONArray();
        }

        array.put(dataJson);
        yodo1GACache.putAESData(CACHE, array.toString());
        YLog.d("GA事件数据已成功缓存至本地");
    }

    /**
     * 清除指定数据
     */
    private void clearData() {
        yodo1GACache.remove(CACHE);
        YLog.d("GA上报成功，删除本地缓存事件数据");
    }
}
