package com.yodo1.android.ops.net;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;

import com.yodo1.android.ops.constants.Yodo1ErrorCode;
import com.yodo1.nohttp.InitializationConfig;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.URLConnectionNetworkExecutor;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.RequestQueue;
import com.yodo1.nohttp.rest.Response;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by yodo1 on 18/1/2.
 */

public class Yodo1HttpManage {

    private static Yodo1HttpManage instance;
    private static Context mainActivity;

    /**
     * 用来标记取消。
     */
    private Object object = new Object();

    /**
     * 请求队列。
     */
    private RequestQueue mQueue;
    private boolean isInit = false;

    public static Yodo1HttpManage getInstance() {
        if (instance == null) {
            instance = new Yodo1HttpManage();
        }
        return instance;
    }

    public void initHttp(Context activity) {
        if (!isInit) {
            mainActivity = activity;
            Log.d("yodo1-games-sdk", "Yodo1HttpManageInit");
            NoHttp.initialize(InitializationConfig.newBuilder(activity)
                    // 设置全局连接超时时间，单位毫秒，默认10s。
                    .connectionTimeout(30 * 1000)
                    // 设置全局服务器响应超时时间，单位毫秒，默认10s。
                    .readTimeout(30 * 1000)
                    // 配置网络层，URLConnectionNetworkExecutor，如果想用OkHttp：OkHttpNetworkExecutor。
                    .networkExecutor(new URLConnectionNetworkExecutor())
                    .build()
            );
            mQueue = NoHttp.newRequestQueue(1);
            isInit = true;
        }
    }

    /**
     * 发起请求。
     *
     * @param what      what.
     * @param request   请求对象。
     * @param callback  回调函数。
     * @param isLoading 实现显示加载框。
     * @param <T>       想请求到的数据类型。
     */
    public <T> void connect(final int what, final Request<T> request, final HttpListener<T> callback, final boolean isLoading) {
        // 初始化请求队列，传入的参数是请求并发值。
        new Handler(Looper.getMainLooper()).post(new Runnable() {
            @Override
            public void run() {
                mQueue.add(what, request, new HttpResponseListener<>(mainActivity, request, callback));
            }
        });

    }

    public Yodo1SDKResponse getResponseObject(int requestType, Response<String> response) {

        boolean isSuccess = false;
        int errorCode = 0;
        String message = null;
        JSONObject jsonData = null;

        String data = response.get();
        if (TextUtils.isEmpty(data)) {
            isSuccess = false;
            errorCode = Yodo1ErrorCode.ERRORCODE_DATAFORMAT_ERROR;
        } else {
            try {
                JSONObject obj = new JSONObject(data);
                if (obj.optInt("error_code") != 0) {
                    isSuccess = false;
                    errorCode = obj.getInt("error_code");
                    message = obj.optString("error_msg");
                } else {
                    //success
                    isSuccess = true;
                    jsonData = new JSONObject(data);
                }
            } catch (JSONException e) {
                e.printStackTrace();
                isSuccess = false;
                errorCode = Yodo1ErrorCode.ERRORCODE_DATAFORMAT_ERROR;
            }
        }

        Yodo1SDKResponse responseObject = new Yodo1SDKResponse(requestType, isSuccess, errorCode);
        responseObject.setRawData(data);
        responseObject.setMessage(message);
        if (isSuccess) {
            responseObject.setResponse(jsonData);
        }
        return responseObject;
    }

    public void onDestroy() {
        // 和声明周期绑定，退出时取消这个队列中的所有请求，当然可以在你想取消的时候取消也可以，不一定和声明周期绑定。
        mQueue.cancelBySign(object);
        // 因为回调函数持有了activity，所以退出activity时请停止队列。
        mQueue.stop();
    }

}
