package com.yodo1.advert.unity;

import android.app.Activity;

import com.unity3d.player.UnityPlayer;
import com.yodo1.advert.callback.BannerCallback;
import com.yodo1.advert.callback.InterstitialCallback;
import com.yodo1.advert.callback.NativeCallback;
import com.yodo1.advert.callback.VideoCallback;
import com.yodo1.advert.entity.AdErrorCode;
import com.yodo1.advert.entity.AdEventCode;
import com.yodo1.advert.helper.Yodo1AdvertHelper;
import com.yodo1.advert.open.Yodo1Advert;
import com.yodo1.sdk.kit.YLog;

import org.json.JSONException;
import org.json.JSONObject;

public class UnityYodo1Advertising {

    private static Activity activity = null;
    private static UnityYodo1MessageListener listener = null;

    /**
     * 初始化
     *
     * @param gameAppKey
     * @param activity
     */
    public static void initSDK(final Activity activity, String gameAppKey) {
        UnityYodo1Advertising.activity = activity;
        UnityYodo1Advertising.onCreate(new UnityYodo1MessageListener() {
            @Override
            public void unitySendMessage(String go, String m, String p) {
                UnityPlayer.UnitySendMessage(go, m, p);
            }
        });
        Yodo1Advert.initSDK(activity, gameAppKey);
    }

    /**
     * 设置测试模式
     */
    public static void setLogEnable(boolean enable) {
        Yodo1Advert.setOnLog(enable);
    }

    public static void setUserConsent(boolean consent) {
        Yodo1Advert.setUserConsent(consent);
    }

    public static void setTagForUnderAgeOfConsent(boolean underAgeOfConsent) {
        Yodo1Advert.setTagForUnderAgeOfConsent(underAgeOfConsent);
    }

    /**
     * 生命周期onCreate调用
     */
    public static void onCreate(UnityYodo1MessageListener listener) {
        UnityYodo1Advertising.listener = listener;
    }


    public static Activity getActivity() {
        return activity != null ? activity : UnityYodo1SDK.getActivity();
    }

    public static void unitySendMessage(String go, String m, String p) {
        YLog.d("[Yodo1 Ads] GameObject's name is " + go + ", Method's name is " + m);
        YLog.i("[Yodo1 Ads] Android message will send to unity, " + p);

        if (listener != null) {
            listener.unitySendMessage(go, m, p);
        }
    }

    /**
     * 播放视频广告
     *
     * @param gameObject
     * @param callbackName
     */
    public static void showVideo(final String gameObject, final String callbackName) {
        YLog.d("Unity calls the android showVideo method ...");
        final Activity activity = UnityYodo1Advertising.getActivity();
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.showVideo(activity, new VideoCallback() {

                    @Override
                    public void onVideoClosed(boolean isFinished) {
                        if (isFinished) {
                            UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_VIDEO, AdEventCode.ADVERT_EVENT_FINISH, ""));
                        } else {
                            UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_VIDEO, AdEventCode.ADVERT_EVENT_CLOSE, ""));
                        }
                    }

                    @Override
                    public void onVideoShow() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_VIDEO, AdEventCode.ADVERT_EVENT_DISPLAY, ""));
                    }

                    @Override
                    public void onVideoShowFailed(AdErrorCode errorCode) {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_VIDEO, AdEventCode.ADVERT_EVENT_DISPLAY_FAILED, ""));
                    }

                    @Override
                    public void onVideoClicked() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_VIDEO, AdEventCode.ADVERT_EVENT_CLICK, ""));

                    }
                });
            }
        });
    }

    /**
     * 检测是否有视频可以播放
     *
     * @return A boolean value
     */
    public static boolean videoIsReady() {
        YLog.d("Unity calls the android videoIsReady method ...");
        return Yodo1Advert.videoIsReady(UnityYodo1Advertising.getActivity());
    }

    /**
     * 播放插屏
     *
     * @param gameObject
     * @param callbackName
     */
    public static void showInterstitial(final String gameObject, final String callbackName) {
        YLog.d("Unity calls the android showInterstitial method ...");
        final Activity activity = UnityYodo1Advertising.getActivity();
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.showInterstitial(activity, new InterstitialCallback() {

                    @Override
                    public void onInterstitialClosed() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_INTERSTITIAL, AdEventCode.ADVERT_EVENT_CLOSE, ""));
                    }

                    @Override
                    public void onInterstitialShowSucceeded() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_INTERSTITIAL, AdEventCode.ADVERT_EVENT_DISPLAY, ""));
                    }

                    @Override
                    public void onInterstitialShowFailed(AdErrorCode errorCode) {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_INTERSTITIAL, AdEventCode.ADVERT_EVENT_DISPLAY_FAILED, ""));
                    }

                    @Override
                    public void onInterstitialClicked() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_INTERSTITIAL, AdEventCode.ADVERT_EVENT_CLICK, ""));

                    }

                });
            }
        });
    }

    /**
     * 是否已经缓存好插屏广告
     *
     * @return A boolean value
     */
    public static boolean interstitialIsReady() {
        YLog.d("Unity calls the android interstitialIsReady method ...");
        return Yodo1Advert.interstitialIsReady(UnityYodo1Advertising.getActivity());
    }

    /**
     * @param gameObject
     * @param px           广告的x位置，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param py           广告的y位置，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param pw           广告的宽度width，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param ph           广告的高度height，占比屏幕宽度比例，取值（0.001f~1.0f）
     *                     如:showNativeAdvert(this,0.2f, 0.3f,0.6f, 0.3f);
     * @param callbackName
     */
    public static void showNativeAd(final String gameObject, final float px, final float py, final float pw, final float ph, final String callbackName) {
        YLog.d("Unity calls the android showNativeAd method ...");
        UnityYodo1Advertising.getActivity().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1AdvertHelper.getInstance().showNativeAd(UnityYodo1Advertising.getActivity(), px, py, pw, ph, new NativeCallback() {
                    @Override
                    public void onNativeClosed() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_NATIVE, AdEventCode.ADVERT_EVENT_CLOSE, ""));

                    }

                    @Override
                    public void onNativeShow() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_NATIVE, AdEventCode.ADVERT_EVENT_DISPLAY, ""));

                    }

                    @Override
                    public void onNativeShowFailed(AdErrorCode errorCode) {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_NATIVE, AdEventCode.ADVERT_EVENT_DISPLAY_FAILED, ""));

                    }

                    @Override
                    public void onNativeClicked() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_NATIVE, AdEventCode.ADVERT_EVENT_CLICK, ""));

                    }
                });
            }
        });
    }


    /**
     * 关闭原生广告
     */
    public static void removeNativeAd() {
        YLog.d("Unity calls the android removeNativeAd method ...");
        Yodo1AdvertHelper.getInstance().removeNativeAd(UnityYodo1Advertising.getActivity());
    }

    public static boolean nativeIsReady() {
        return Yodo1AdvertHelper.getInstance().nativeAdIsLoaded(UnityYodo1Advertising.getActivity());
    }

    /**
     * 播放Banner
     *
     * @param gameObject
     * @param callbackName
     */
    public static void ShowBanner(final String gameObject, final String callbackName) {
        YLog.d("Unity calls the android ShowBanner method ...");
        final Activity activity = UnityYodo1Advertising.getActivity();
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.showBanner(activity, new BannerCallback() {

                    @Override
                    public void onBannerClosed() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_BANNER, AdEventCode.ADVERT_EVENT_CLOSE, ""));

                    }

                    @Override
                    public void onBannerShow() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_BANNER, AdEventCode.ADVERT_EVENT_DISPLAY, ""));

                    }

                    @Override
                    public void onBannerShowFailed(AdErrorCode errorCode) {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_BANNER, AdEventCode.ADVERT_EVENT_DISPLAY_FAILED, ""));

                    }

                    @Override
                    public void onBannerClicked() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_BANNER, AdEventCode.ADVERT_EVENT_CLICK, ""));

                    }
                });
            }
        });
    }

    /**
     * 设置banner位置
     *
     * @param align
     */
    public static void SetBannerAlign(final int align) {
        YLog.d("Unity calls the android SetBannerAlign method ...");
        final Activity activity = UnityYodo1Advertising.getActivity();
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
//                Yodo1Advert.SetBannerAlign(activity, align);
                Yodo1Advert.setBannerAlign(activity, align);
            }
        });
    }

    /**
     * 隐藏Banner
     */
    public static void HideBanner() {
        YLog.d("Unity calls the android hideBanner method ...");
        final Activity activity = UnityYodo1Advertising.getActivity();
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
//                Yodo1Advert.HideBanner(activity);
                Yodo1Advert.hideBanner(activity);
            }
        });
    }

    /**
     * 关闭Banner
     */
    public static void RemoveBanner() {
        YLog.d("Unity calls the android removeBanner method ...");
        final Activity activity = UnityYodo1Advertising.getActivity();
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
//                Yodo1Advert.RemoveBanner(activity);
                Yodo1Advert.removeBanner(activity);
            }
        });
    }

    /**
     * 将显示广告的状态转换为json字符串
     *
     * @return a string
     */
    private static String convertToJsonString(int flag, int code, String advertCode) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("resulType", flag);
            jsonObj.put("code", code);
//            jsonObj.put("advertCode", advertCode);
        } catch (JSONException ignored) {

        }
        return jsonObj.toString();
    }
}
