package com.yodo1.advert.open;

import android.app.Activity;

import com.yodo1.advert.callback.BannerCallback;
import com.yodo1.advert.callback.InterstitialCallback;
import com.yodo1.advert.callback.NativeCallback;
import com.yodo1.advert.callback.SplashCallback;
import com.yodo1.advert.callback.VideoCallback;
import com.yodo1.advert.helper.Yodo1AdvertHelper;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

/**
 * Advert Open Interface
 * Created by zhuxiaochen on 2017/8/30.
 */
public class Yodo1Advert {
    public static boolean loadAdForTypeMobile = true;
    static Yodo1Privacy privacy = new Yodo1Privacy();
    private static Yodo1AdvertHelper helper = Yodo1AdvertHelper.getInstance();

    public static Yodo1Privacy getPrivacy() {
        return privacy;
    }

    /**
     * Initialize SDK, make sure call the method in your activity’s “onCreate” method.
     *
     * @param activity Activity
     * @param appKey   The app key obtained from MAS Developer Platform
     */
    public static void initSDK(final Activity activity,final String appKey) {

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                helper.init(activity, appKey);
            }
        });

    }

    public static void setOnLog(boolean onLog) {
        if (onLog) {
            YLog.d("The Log has been enabled.");
            YLog.setOnLog(onLog);
        }
    }

    /**
     * SDK requires that publishers set a flag indicating whether a user located in the European Economic Area (i.e., EEA/GDPR data subject) has provided opt-in consent for the collection and use of personal data.
     *
     * @param consent true, If the user has consented, false otherwise.
     */
    public static void setUserConsent(boolean consent) {
        privacy.setHasUserConsent(consent);
        helper.setPrivacy(privacy);
    }

    /**
     * To ensure COPPA, GDPR, and Google Play policy compliance, you should indicate whether a user is a child.
     *
     * @param underAgeOfConsent true, If the user is known to be in an age-restricted category (i.e., under the age of 16), false otherwise.
     */
    public static void setTagForUnderAgeOfConsent(boolean underAgeOfConsent) {
        privacy.setAgeRestrictedUser(underAgeOfConsent);
        helper.setPrivacy(privacy);
    }

    /**
     * 设置是否在4G时加载广告
     */
    public static void setLoadAdForMobile(boolean enable) {
        loadAdForTypeMobile = enable;
        YLog.i("The ad is loaded in the non-wifi state: " + loadAdForTypeMobile);
    }

    /**
     * Show interstitial Ad.
     *
     * @param activity Activity
     * @param callback The callback method of show intertitial ad
     * @return true, if the intertitial ad has been shown, false otherwise.
     */
    public static boolean showInterstitial(final Activity activity, final InterstitialCallback callback) {
        YLog.d("The showInterstitialAd method is called ...");
        return helper.showInterstitialAd(activity, callback);
    }

    /**
     * Whether the intertitial ads have been cached.
     *
     * @param activity Activity
     * @return true, if the intertitial ads have been cached, false otherwise.
     */
    public static boolean interstitialIsReady(Activity activity) {
        YLog.d("The interstitialIsReady method is called ...");
        return helper.interstitialAdIsLoaded(activity);
    }

    /**
     * Show reward video Ad.
     *
     * @param activity Activity
     * @param callback The callback method of show reward video ad
     * @return true, if the reward video ad has been shown, false otherwise.
     */
    public static boolean showVideo(final Activity activity, final VideoCallback callback) {
        YLog.d("The showVideo method is called ...");
        return helper.showVideoAd(activity, callback);
    }

    /**
     * Whether reward video ads have been cached.
     *
     * @param activity Activity
     * @return true, if the reward video ads have been cached, false otherwise.
     */
    public static boolean videoIsReady(Activity activity) {
        YLog.d("The videoIsReady method is called ...");
        return helper.videoAdIsLoaded(activity);
    }

    /**
     * Show the native Ad, the MAS games ignore this method.
     *
     * @param activity Activity
     * @param callback The callback method of show navive ad
     * @return true, if the native ad has been shown, false otherwise.
     */
    public static boolean showNative(final Activity activity, float px, float py, float pw, float ph, final NativeCallback callback) {
        YLog.d("The showNative method is called ...");
        return helper.showNativeAd(activity, px, py, pw, ph, callback);
    }

    /**
     * Whether the native ads have been cached, the MAS games ignore this method.
     *
     * @param activity Activity
     * @return true, if the native ads have been cached, false otherwise.
     */
    public static boolean nativeIsReady(Activity activity) {
        return helper.nativeAdIsLoaded(activity);
    }

    /**
     * Remove the native ad, the MAS games ignore this method.
     *
     * @param activity Activity
     */
    public static void removeNative(Activity activity) {
        helper.removeNativeAd(activity);
    }

    /**
     * Show the splash ad, the MAS games ignore this method.
     *
     * @param activity Activity
     * @param callback callback
     * @return true, if the splash ads have been shown, false otherwise.
     */
    public static boolean showSplash(final Activity activity, final SplashCallback callback) {
        YLog.d("The showSplash method is called ...");
        return helper.showSplashAd(activity, callback);
    }

    /**
     * Set the alignment of banner ad.
     *
     * @param activity Activity
     * @param align    The alignment of banner ad, such as: Bottom center(BannerAlign.HorizontalCenter|BannerAlign.Bottom)
     */
    @Deprecated
    public static void SetBannerAlign(Activity activity, int align) {
        YLog.d("The SetBannerAlign method is called ...");
        helper.SetBannerAlign(activity, align);
    }

    /**
     * Set the alignment of banner ad.
     *
     * @param activity Activity
     * @param align    The alignment of banner ad, such as: Bottom center(BannerAlign.HorizontalCenter|BannerAlign.Bottom)
     */
    public static void setBannerAlign(Activity activity, int align) {
        YLog.d("The setBannerAlign method is called ...");
        helper.SetBannerAlign(activity, align);
    }

    /**
     * Show the banner ad.
     *
     * @param activity Activity
     * @param callback The callback method of banner ad
     */
    @Deprecated
    public static void ShowBanner(Activity activity, BannerCallback callback) {
        YLog.d("The ShowBanner method is called ...");
        helper.ShowBanner(activity, callback);
    }

    /**
     * Show the banner ad.
     *
     * @param activity Activity
     * @param callback The callback method of banner ad
     */
    public static void showBanner(Activity activity, BannerCallback callback) {
        YLog.d("The showBanner method is called ...");
        helper.ShowBanner(activity, callback);
    }

    /**
     * Hide the banner ad.
     *
     * @param activity Activity
     */
    @Deprecated
    public static void HideBanner(Activity activity) {
        YLog.d("The HideBanner method is called ...");
        helper.HideBanner1(activity);
    }

    /**
     * Hide the banner ad.
     *
     * @param activity Activity
     */
    public static void hideBanner(Activity activity) {
        YLog.d("The hideBanner method is called ...");
        helper.HideBanner1(activity);
    }

    /**
     * Remove the banner ad.
     *
     * @param activity Activity
     */
    @Deprecated
    public static void RemoveBanner(Activity activity) {
        YLog.d("The RemoveBanner method is called ...");
        helper.RemoveBanner1(activity);
    }

    /**
     * Remove the banner ad.
     *
     * @param activity Activity
     */
    public static void removeBanner(Activity activity) {
        YLog.d("The removeBanner method is called ...");
        helper.RemoveBanner1(activity);
    }
}
