package com.yodo1.advert.helper;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager.LayoutParams;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.yodo1.advert.callback.BannerCallback;
import com.yodo1.advert.callback.InterstitialCallback;
import com.yodo1.advert.callback.VideoCallback;
import com.yodo1.advert.entity.AdErrorCode;
import com.yodo1.advert.open.Yodo1Advert;
import com.yodo1.advert.utils.YOnlineConfigUtils;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;

public class Yodo1TestHelper {

    private static PopupWindow popWindowDetail;

    public static void showTestWindow(final Activity context) {
        ViewGroup adContainer = ((ViewGroup) context.findViewById(android.R.id.content));
        Button btn = new Button(context);
        btn.setText("Test Mode");
        RelativeLayout.LayoutParams lp1 = new RelativeLayout.LayoutParams
                (ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        lp1.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
        // btn1 位于父 View 的顶部
        adContainer.addView(btn, lp1);
        btn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showTestDeatilWindow(context);
            }
        });
    }

    private static void showTestDeatilWindow(final Activity context) {

        if (popWindowDetail == null) {
            LinearLayout layout = new LinearLayout(context);
            layout.setOrientation(LinearLayout.VERTICAL);
            layout.setBackgroundColor(Color.WHITE);
            layout.setPadding(20, 20, 20, 20);


            String AppKey = YOnlineConfigUtils.getAppKey(context);
//            String AdNetWork = Yodo1SharedPreferences.getString(context,"location_identifer");
            String DeviceId = Yodo1SharedPreferences.getString(context, "YDEVICEID");
//            String Response = Yodo1SharedPreferences.getString(context,"Yodo1ErrorRecentMsg");
            String detail = "AppKey: " + AppKey + "\nDeviceId: " + DeviceId;
//                    + "\nAdNetWork: " + AdNetWork + "\nResponse: " + Response;

            TextView textView = new TextView(context);//文本信息
            textView.setText(detail);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams
                    (ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            layoutParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
            layout.addView(textView, layoutParams);


            String device_source = YOnlineConfigUtils.testDeviceSource(context);
            if (!TextUtils.isEmpty(device_source) && !device_source.equals("PA")) {
                WebView webView = new WebView(context);
                webView.loadUrl("https://docs.yodo1.com/#/");
                webView.getSettings().setJavaScriptEnabled(true);
                webView.getSettings().setCacheMode(WebSettings.LOAD_NO_CACHE);
                webView.getSettings().setSupportZoom(false);
                webView.getSettings().setBuiltInZoomControls(false);

                RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(
                        ViewGroup.LayoutParams.WRAP_CONTENT, 300);
                layout.addView(webView, lp);

            } else {
                Button interAdBtn = new Button(context);
                interAdBtn.setText("InterstitialAd");
                layout.addView(interAdBtn, layoutParams);

                Button videoAdBtn = new Button(context);
                videoAdBtn.setText("VideoAd");
                layout.addView(videoAdBtn, layoutParams);


                Button bannerAdBtn = new Button(context);
                bannerAdBtn.setText("BannerAd");
                layout.addView(bannerAdBtn, layoutParams);


                Button bannerAdBtn2 = new Button(context);
                bannerAdBtn2.setText("HideBannerAd");
                layout.addView(bannerAdBtn2, layoutParams);

                onClick(context, interAdBtn, textView);
                onClick(context, videoAdBtn, textView);
                onClick(context, bannerAdBtn, textView);
                onClick(context, bannerAdBtn2, textView);
            }


            popWindowDetail = new PopupWindow(layout,
                    LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);

        }

        // 需要设置一下此参数，点击外边可消失
        popWindowDetail.setBackgroundDrawable(new BitmapDrawable(context.getResources(), (Bitmap) null));
        // 点击窗外可取消
        popWindowDetail.setTouchable(true);
        popWindowDetail.setOutsideTouchable(true);

        ViewGroup adContainer = ((ViewGroup) context.findViewById(android.R.id.content));
        popWindowDetail.showAtLocation(adContainer, Gravity.CENTER, 0, 0);

    }


    /**
     * 点击事件
     *
     * @param textView
     */
    public static void onClick(final Activity context, final Button btn, final TextView textView) {
        btn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (btn.getText().equals("InterstitialAd")) {
                    Yodo1Advert.showInterstitial(context, new InterstitialCallback() {
                        @Override
                        public void onInterstitialClosed() {


                            context.runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    String AppKey = YOnlineConfigUtils.getAppKey(context);
                                    String DeviceId = Yodo1SharedPreferences.getString(context, "YDEVICEID");
                                    String reDetail = "AppKey: " + AppKey + "\nDeviceId: " + DeviceId;
                                    textView.setText(reDetail);

                                    showTestDeatilWindow(context);
                                }
                            });
                        }

                        @Override
                        public void onInterstitialShowSucceeded() {
//                            Toast.makeText(context,"show showInterstitial",Toast.LENGTH_LONG).show();
                            context.runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    popWindowDetail.dismiss();
                                }
                            });

                        }

                        @Override
                        public void onInterstitialShowFailed(AdErrorCode errorCode) {

                        }

                        @Override
                        public void onInterstitialClicked() {

                        }
                    });

                } else if (btn.getText().equals("VideoAd")) {
                    Yodo1Advert.showVideo(context, new VideoCallback() {
                        @Override
                        public void onVideoClosed(boolean isFinished) {
//                            if(isFinished){
//                                Toast.makeText(context, "播放成功", Toast.LENGTH_LONG).show();
//                            }

                            context.runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    String AppKey = YOnlineConfigUtils.getAppKey(context);
                                    String DeviceId = Yodo1SharedPreferences.getString(context, "YDEVICEID");
                                    String reDetail = "AppKey: " + AppKey + "\nDeviceId: " + DeviceId;
                                    textView.setText(reDetail);
                                }
                            });

                        }

                        @Override
                        public void onVideoShow() {
                        }

                        @Override
                        public void onVideoShowFailed(AdErrorCode errorCode) {

                        }

                        @Override
                        public void onVideoClicked() {

                        }

                    });
                } else if (btn.getText().equals("BannerAd")) {
                    Yodo1Advert.ShowBanner(context, new BannerCallback() {
                        @Override
                        public void onBannerClosed() {

                        }

                        @Override
                        public void onBannerShow() {


                        }

                        @Override
                        public void onBannerShowFailed(AdErrorCode errorCode) {

                        }

                        @Override
                        public void onBannerClicked() {

                        }
                    });
                } else {
                    Yodo1Advert.HideBanner(context);
                }
            }
        });
    }


}
