package com.yodo1.advert.helper;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.net.ConnectivityManager;
import android.os.Handler;
import android.text.TextUtils;

import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.callback.BannerCallback;
import com.yodo1.advert.callback.InterstitialCallback;
import com.yodo1.advert.callback.NativeCallback;
import com.yodo1.advert.callback.SplashCallback;
import com.yodo1.advert.callback.VideoCallback;
import com.yodo1.advert.entity.AdErrorCode;
import com.yodo1.advert.entity.AdEventCode;
import com.yodo1.advert.entity.AdvertType;
import com.yodo1.advert.factory.Yodo1AdvertAdapterFactory;
import com.yodo1.advert.onlineconfig.AdsConfigEntity;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.open.Yodo1Advert;
import com.yodo1.advert.utils.AppsflyerUtils;
import com.yodo1.advert.utils.YOnlineConfigUtils;
import com.yodo1.android.ops.net.Yodo1HttpManage;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.onlineconfig.Yodo1OnlineConfigListener;
import com.yodo1.plugin.dmp.yodo1.constants.AnalyticsConst;
import com.yodo1.plugin.dmp.yodo1.open.Yodo1Analytics;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1NetWorkUtils;
import com.yodo1.sdk.kit.Yodo1PermissonUtils;
import com.yodo1.sdk.kit.Yodo1Privacy;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by yodo1 on 2016/3/18.
 */
public class Yodo1AdvertHelper {
    private static Yodo1AdvertHelper instance;

    private ArrayList<String> playlist_intersital = new ArrayList<String>(); //已经排序好的播放列表, 插屏用
    private ArrayList<AdvertBean> adverts_intersital = new ArrayList<AdvertBean>(); //按权重排序的广告实体, 插屏用
    private int playtimes_interstitial = 0; //插屏广告的播放次数
    private long showtimes_interstitial = 0; //插屏广告的最后显示时间

    private ArrayList<String> playlist_video = new ArrayList<String>(); //已经排序好的播放列表, 游戏视频用
    private ArrayList<AdvertBean> adverts_video = new ArrayList<AdvertBean>(); //按权重排序的广告实体, 游戏视频用
    private int playtimes_video = 0; //游戏视频广告的播放次数

    private ArrayList<String> playlist_banner = new ArrayList<String>(); //已经排序好的播放列表, banner用
    private ArrayList<AdvertBean> adverts_banner = new ArrayList<AdvertBean>(); //按权重排序的广告实体, banner用
    private int playtimes_banner = 0; //banner广告的播放次数

    private ArrayList<String> playlist_native = new ArrayList<String>(); //已经排序好的播放列表, 原生广告用
    private ArrayList<AdvertBean> adverts_native = new ArrayList<AdvertBean>(); //按权重排序的广告实体, 原生广告用
    private int playtimes_native = 0;
    private long showtimes_native = 0;

    private ArrayList<String> playlist_splash = new ArrayList<String>(); //闪屏广告播放列表
    private int showAllTimes_splash = 0;//开屏广告展示总次数

    private boolean initPlayList = false;
    private boolean isInit = false;

    private Yodo1Privacy privacy;
    /**
     * 此处用来关闭延时30s发送播放成功的回调  isDismissBanner为true时ADVERT_EVENT_DISPLAY事件拦截不做处理
     */
    private boolean isDismissBanner = false;

    private Yodo1AdvertHelper() {
    }

    public synchronized static Yodo1AdvertHelper getInstance() {
        if (instance == null) {
            instance = new Yodo1AdvertHelper();
        }
        return instance;
    }

    /**
     * 设置是否在4G时加载广告
     */
    public void setPrivacy(Yodo1Privacy privacy) {
        this.privacy = privacy;
    }


    public void onCreateApplication(Context context) {
        initSplashAds(context);//初始化开屏
    }

    public void init(final Activity activity, final String appKey) {
        if (isInit) {
            YLog.d("Yodo1 Ad core has been initialized");
            return;
        }

        if (activity == null || TextUtils.isEmpty(appKey)) {
            YLog.e("Yodo1 Ad initialization failed, activity is null or appKey is null, please check your code.");
            return;
        }

        isInit = true;

        Yodo1HttpManage.getInstance().initHttp(activity);
        String activityName = activity.getClass().getName();
        Yodo1SharedPreferences.put(activity,"YODO1_MAIN_CLASS",activityName);

        //初始化yodo1在线参数
        Yodo1OnlineConfig.getInstance().init(activity, appKey);

        Yodo1OnlineConfig.getInstance().getOnlineConfig(new Yodo1OnlineConfigListener() {
            @Override
            public void getDataFinish(int code, String onlineConfig) {


                try {
                    if (TextUtils.isEmpty(onlineConfig)) {
                        YLog.d("Yodo1AdvertHelper 在线参数没拿到");
                        return;
                    }
                    loadAdvertPlayList(activity);
                    onCreatAdverts(activity, appKey);
                } catch (Exception e){
                } catch (Error error){
                }

            }
        });

    }

    private void loadAdvertPlayList(Context context) {
        if (initPlayList) {//确保广告列表只初始化一次
            YLog.d("Yodo1 Ad list have been loaded");
            return;
        }
        initPlayList = true;

        if (YOnlineConfigUtils.isTrunOnAdForChina(context)) {
            YLog.v("Yodo1 ads have been configured for simplified Chinese users only.");
            return;
        }

        YLog.d("Initialize the Yodo1 Ads list...");

        Yodo1AdvertAdapterFactory.getInstance().initAdvertAdapters(context);//100毫秒反射各广告平台

        //默认播放次数均为0
        playtimes_interstitial = 0;
        playtimes_video = 0;
        playtimes_banner = 0;
        playtimes_native = 0;

        initAdvertList(context, Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd); //初始化插屏播放列表
        initAdvertList(context, Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd);//初始化游戏视频播放列表
        initAdvertList(context, Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd);//初始化游戏视频播放列表
        initAdvertList(context, Yodo1OnlineConfigAgent.AdvertType.Platform_NativeAd);
    }

    private void onCreatAdverts(Activity activity, String gameAppkey) {

        if (YOnlineConfigUtils.isNeedRequestPermisson()) {
            YLog.v("Yodo1 Ad SDK will request the necessary permissions");
            Yodo1PermissonUtils.requestPermisson(activity);//申请展示广告所需的权限
        }

        //测试模式  展示测试按钮页面
        if (YOnlineConfigUtils.isTestModule(activity) && YOnlineConfigUtils.testDeviceSource(activity).equals("PA")) {
            Yodo1TestHelper.showTestWindow(activity);
        }

        boolean prcy1 = Yodo1Advert.getPrivacy().isHasUserConsent();
        boolean prcy2 = Yodo1Advert.getPrivacy().isAgeRestrictedUser();

        if (!prcy2 && prcy1){
            Yodo1Analytics.initSDK(activity, gameAppkey);
        }

        Yodo1ErrorUpdataHelper.getInstance().updata(activity, gameAppkey);

        //加载全部已引用的广告插件
        //初始化播放列表

        Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdInit, "", "");
        Yodo1Analytics.onEvent(AnalyticsConst.VideoAdInit, "", "");
        Yodo1Analytics.onEvent(AnalyticsConst.BannerAdInit, "", "");
        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdInit, "", "");

        for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters().entrySet()) {
            if (adapter.getValue() != null) {

                if (privacy != null) {
                    adapter.getValue().setPrivacy(privacy, activity);
                }

                adapter.getValue().onCreate(activity);

                Yodo1Analytics.onEvent(AnalyticsConst.BannerAdInitChannel, adapter.getKey(), "");//视频广告平台初始化统计
                Yodo1Analytics.onEvent(AnalyticsConst.NativeAdInitChannel, adapter.getKey(), "");
                Yodo1Analytics.onEvent(AnalyticsConst.VideoAdInitChannel, adapter.getKey(), "");//视频广告平台初始化统计
                Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdInitChannel, adapter.getKey(), "");//插屏广告平台初始化统计

                if (playlist_intersital.contains(adapter.getKey())) {
                    //初始化  预加载插频广告
                    adapter.getValue().initInterstitialAd(activity);
                    reloadInterstitialAdvert(adapter.getValue(), activity, adapter.getKey());
                }
                if (playlist_video.contains(adapter.getKey())) {
                    //初始化  预加载视频广告
                    adapter.getValue().initVideoAd(activity);
                    reloadVideoAdvert(adapter.getValue(), activity, adapter.getKey());
                }
                if (playlist_native.contains(adapter.getKey())) {
                    //初始化  预加原生广告
                    adapter.getValue().initNativeAd(activity);
                    reloadNativeAdvert(adapter.getValue(), activity, adapter.getKey());
                }

                if (playlist_banner.contains(adapter.getKey())) {
                    //初始化Banner
                    adapter.getValue().initBannerAd(activity);
                }

            }
        }

    }

    /**
     * 显示插屏广告
     *
     * @param activity
     * @return 是否允许显示插屏广告，当在线参数上的开关关闭，或没到时间间隔，会返回false
     */
    public boolean showInterstitialAd(final Activity activity, final InterstitialCallback callback) {
        YLog.d("Yodo1AdvertHelper, showInterstitialAd call ...");
        Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShow, "", "");
        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v("Show interstitial ad failed, the network is unavailable.");
            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShow, "", AnalyticsConst.ShowResulet_failed);
            callback.onInterstitialShowFailed(AdErrorCode.ADVERT_ERROR_NETWORK);
            return false;
        }

        if (playlist_intersital.size() == 0) {
            YLog.v("Show interstitial ad failed, ad list is empty");
            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShow, "", AnalyticsConst.ShowResulet_failed);
            callback.onInterstitialShowFailed(AdErrorCode.ADVERT_ERROR_NO_ADLIST);
            return false;
        }

        long interval = YOnlineConfigUtils.getIntervalAdvertInterstitial();
        if (System.currentTimeMillis() - showtimes_interstitial < interval) {
            YLog.v("Show interstitial ad failed, ad interval not completed.");
            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShow, "", AnalyticsConst.ShowResulet_failed);
            callback.onInterstitialShowFailed(AdErrorCode.ADVERT_ERROR_MISS_INTERVAL);
            return false;
        }

        String firstCode = playlist_intersital.get(0);
        YLog.d("The interstitial ads list: " + playlist_intersital.toString() + ", first ad code: " + firstCode);
        showInterstitialAdByChannel(activity, firstCode, new Yodo1AdCallback() {
            private int index = 0; //当前播放次序
            private boolean isFinish = false;

            @Override
            public void onEvent(int eventCode, String advertCode) {

                YLog.d("showInterstitialAd onEvent, event code: " + eventCode + ", advert code: " + advertCode);
                switch (eventCode) {
                    case Yodo1AdConst.ADVERT_EVENT_CLICK:
                        sendMsg(activity, "Click", advertCode);
                        callback.onInterstitialClicked();
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_CLOSE:
                        sendMsg(activity, "Close", advertCode);
                        callback.onInterstitialClosed();
                        Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShow, "", AnalyticsConst.ShowResulet_close);
                        AppsflyerUtils.AF_Event(activity, AppsflyerUtils.AF_AD_MONETIZED_EVENT_NAME, advertCode, AnalyticsConst.ShowResulet_close, AppsflyerUtils.AD_TYPE_INTERSTITIAL);
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_DISPLAY:
                        YLog.d("Display [" + advertCode + "] interstitial ad successfully");

                        //保存当前时间用于进行显示间隔的判断
                        showtimes_interstitial = System.currentTimeMillis();
                        callback.onInterstitialShowSucceeded();

                        sendMsg(activity, "DisPlay", advertCode);
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_LOADED:
//                            callback.interstitialDidLoad();
                        break;
                }
            }

            @Override
            public void onAdError(int errorCode, String errorMsg, String advertCode) {
                sendMsg(activity, "ShowFailed", advertCode);
                if (index < playlist_intersital.size() - 1) { //播放列表还没到最后
                    //播放下一顺位的广告
                    index++;
                    String nextCode = playlist_intersital.get(index);

                    YLog.d("Show [" + advertCode + "] interstitial ad failed," + " error code:" + errorCode + ", error message: " + errorMsg + ", will try to play [" + nextCode + "] interstitial ad.");
                    showInterstitialAdByChannel(activity, nextCode, this);
                } else { //全部播放完毕, 也就是全部失败
                    // 统计失败
                    YLog.d("Show all interstitial ads failed...");
                    Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShow, "", AnalyticsConst.ShowResulet_failed);
                    if (callback != null) {
                        callback.onInterstitialShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                    }
                }
            }
        });
        return true;
    }

    /**
     * 展示某家渠道的插屏广告
     *
     * @param activity
     * @param advertCode 要展示的渠道
     * @param callback
     */
    private void showInterstitialAdByChannel(final Activity activity, final String advertCode, final Yodo1AdCallback callback) {
        YLog.d("Yodo1AdvertHelper, showInterstitialAdByChannel call ... advertCode:" + advertCode);

        final AdapterAdvertBase adapter = (AdapterAdvertBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter == null) {
            YLog.v("Try to show [" + advertCode + "] interstitial ad failed, the network adapter is not exist.");
            callback.onAdError(AdEventCode.ADVERT_ERROR_UNKNOW, "the network adapter is not exist", advertCode);
            return;
        }
        try {
            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShowChannel, advertCode, "");

            adapter.showIntersititalAdvert(activity, new Yodo1AdCallback() {
                @Override
                public void onEvent(int eventCode, String advertCode) {
                    YLog.d("showInterstitialAdByChannel onEvent, event code: " + eventCode + ", ad code: " + advertCode);
                    callback.onEvent(eventCode, advertCode);

                    if (eventCode == Yodo1AdConst.ADVERT_EVENT_CLOSE) {
                        YLog.d("Show [" + advertCode + "] interstitial ad successfully, will preloading it again");

                        Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_close);
                        showEnd(AdvertType.Interstitial, advertCode);
                        reloadInterstitialAdvert(adapter, activity, advertCode);
                    } else if (eventCode == Yodo1AdConst.ADVERT_EVENT_CLICK) {
                        Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_click);
                    }
                }

                @Override
                public void onAdError(int errorCode, String errorMsg, String advertCode) {
                    YLog.d("showInterstitialAdByChannel onAdError, [" + advertCode + "] interstitial ad failed, ErrorCode: " + errorCode + ", ErrorMessage: " + errorMsg);
                    callback.onAdError(errorCode, errorMsg, advertCode);

                    Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_failed);
                    reloadInterstitialAdvert(adapter, activity, advertCode);
                }
            });
        } catch (Exception exception) {
            callback.onAdError(AdEventCode.ADVERT_ERROR_UNKNOW, "try catch", advertCode);
        }
    }

    /**
     * 预加载回调结果
     *
     * @param adapterBase
     * @param activity
     */
    public void reloadInterstitialAdvert(final AdapterAdvertBase adapterBase, final Activity activity, final String advertCode) {
        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v("Load interstitial ad failed, the network is unavailable.");
            return;
        }

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {

                if (!adapterBase.interstitialAdvertIsLoaded(activity)) {//当本地没有缓存的时候再加载下次广告
                    YLog.d("loading [" + advertCode + "] interstitial ad");

                    Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdReloadChannel, advertCode, "");

                    adapterBase.reloadInterstitialAdvert(activity, new Yodo1ReloadCallback() {

                        //预加载结果的回调
                        @Override
                        public void onReloadSuccess(String advertCode) {
                            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdReloadResultChannel, advertCode, AnalyticsConst.ReloadResulet_finish);
                            YLog.d("Load [" + advertCode + "] interstitial ad successfully");
                        }

                        @Override
                        public void onReloadFailed(int errorCode, int adErrorCode, String adErrorMsg, String advertCode) {
                            YLog.d("Load [" + advertCode + "] interstitial ad failed, ErrorCode: " + adErrorCode + ", ErrorMessage: " + adErrorMsg);

                            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdReloadResultChannel, advertCode, AnalyticsConst.ReloadResulet_failed);
                            Yodo1ErrorUpdataHelper.getInstance().ErrorCollection(activity, advertCode, errorCode, adErrorCode, adErrorMsg, AdvertType.Interstitial);
                        }
                    });
                } else {
                    YLog.d("[" + advertCode + "] interstitial ad has been loaded, don't need to reload it again.");
                }
            }
        });
    }

    /**
     * 预加载插屏广告是否成功
     *
     * @param activity
     */
    public boolean interstitialAdIsLoaded(final Activity activity) {
        if (playlist_intersital.size() == 0) {
            YLog.v("No cached interstitial ads, ad list is empty.");
            return false;
        }

        //如果有一个加载成功即为true
        boolean isLoaded = false;
        for (int i = 0; i < playlist_intersital.size(); i++) {
            String advertCode = playlist_intersital.get(i);
            final AdapterAdvertBase adapter = (AdapterAdvertBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter == null) {
                YLog.d("Try to load [" + advertCode + "] interstitial ad failed, the network adapter is not exist.");
                continue;
            }
            if (adapter.interstitialAdvertIsLoaded(activity)) {
                YLog.d("[" + advertCode + "] interstitial ad has been loaded");
                isLoaded = true;
            } else { //没有完成加载的要重新加载
                YLog.d("[" + advertCode + "] interstitial ad preloading failed, will reload it again.");
                reloadInterstitialAdvert(adapter, activity, advertCode);
            }
        }

        return isLoaded;
    }

    /**
     * 显示游戏视频广告
     *
     * @param activity
     * @return 是否允许显示插屏广告，当在线参数上的开关关闭，或没到时间间隔，会返回false
     */
    public boolean showVideoAd(final Activity activity, final VideoCallback callback) {
        Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShow, "", "");
        YLog.d("Yodo1AdvertHelper, showVideoAd call ...");

        if (playlist_video.size() == 0) {
            YLog.v("Show rewarded video ad failed, ads list is empty.");
            Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShow, "", AnalyticsConst.ShowResulet_failed);
            callback.onVideoShowFailed(AdErrorCode.ADVERT_ERROR_NO_ADLIST);
            return false;
        }

        String firstCode = playlist_video.get(0);
        YLog.d("The rewarded video ads list: " + playlist_video.toString() + ", first ad code: " + firstCode);
        showVideoAdByChannel(activity, firstCode, new Yodo1AdCallback() {
            private int index = 0; //当前播放次序
            private boolean isFinish = false;

            @Override
            public void onEvent(int eventCode, final String advertCode) {
                YLog.d("showVideoAd onEvent, event code: " + eventCode + ", ad code: " + advertCode);
                switch (eventCode) {
                    case Yodo1AdConst.ADVERT_EVENT_CLICK:
                        sendMsg(activity, "Click", advertCode);
                        callback.onVideoClicked();
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_FINISH:
                        isFinish = true;
//                        callback.videoDidComplete();
                        //重载
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_CLOSE:
                        //当走close方法时，延时执行0.5s.等待finish回调。确保close方法一定在finish之后再调用
                        new Handler().postDelayed(new Runnable() {
                            public void run() {
                                //execute the task

                                if (isFinish) {
                                    YLog.d("Show [" + advertCode + "] rewarded video ad completely");
                                    callback.onVideoClosed(true);
                                    sendMsg(activity, "Finish", advertCode);

                                    Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShow, "", AnalyticsConst.ShowResulet_finish);
                                    AppsflyerUtils.AF_Event(activity, AppsflyerUtils.AF_AD_MONETIZED_EVENT_NAME, advertCode, AnalyticsConst.ShowResulet_finish, AppsflyerUtils.AD_TYPE_VIDEO);
                                } else {
                                    YLog.d("Show [" + advertCode + "] rewarded video ad incompletely, the ad is skiped");
                                    callback.onVideoClosed(false);
                                    sendMsg(activity, "Close", advertCode);

                                    Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShow, "", AnalyticsConst.ShowResulet_close);
                                    AppsflyerUtils.AF_Event(activity, AppsflyerUtils.AF_AD_MONETIZED_EVENT_NAME, advertCode, AnalyticsConst.ShowResulet_close, AppsflyerUtils.AD_TYPE_VIDEO);
                                }
                            }

                        }, 500);

                        //重载
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_DISPLAY:
                        YLog.d("Display [" + advertCode + "] rewarded video ad successfully");

                        sendMsg(activity, "DisPlay", advertCode);
                        callback.onVideoShow();
                        break;
                }
            }

            @Override
            public void onAdError(int errorCode, String errorMsg, String advertCode) {
                sendMsg(activity, "ShowFailed", advertCode);
                if (index < playlist_video.size() - 1) { //播放列表还没到最后
                    //播放下一顺位的广告
                    index++;
                    String nextCode = playlist_video.get(index);
                    YLog.d("Show [" + advertCode + "] rewarded video ad failed, will try to play [" + nextCode + "] rewarded video ad.");
                    showVideoAdByChannel(activity, nextCode, this);
                } else { //全部播放完毕, 也就是全部失败
                    // 统计失败
                    YLog.d("Show all rewarded video ads failed...");
                    Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShow, "", AnalyticsConst.ShowResulet_failed);
                    if (callback != null) {
                        callback.onVideoShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                    }
                }
            }
        });
        return true;
    }

    /**
     * 展示某家渠道的视频广告
     *
     * @param activity
     * @param advertCode 要展示的渠道
     * @param callback
     */
    private void showVideoAdByChannel(final Activity activity, final String advertCode, final Yodo1AdCallback callback) {
        YLog.d("Yodo1AdvertHelper, showVideoAdByChannel call ...");

        final AdapterAdvertBase adapter = (AdapterAdvertBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter == null) {
            YLog.d("Try to show [" + advertCode + "] rewarded video ad failed, the network adapter is not exist.");
            callback.onAdError(AdEventCode.ADVERT_ERROR_UNKNOW, "the network adapter is not exist", advertCode);
            return;
        }

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShowChannel, advertCode, "");

                adapter.showVideoAdvert(activity, new Yodo1AdCallback() {
                    @Override
                    public void onEvent(int eventCode, String advertCode) {
                        YLog.d("showVideoAdByChannel onEvent, event code: " + eventCode + ", ad code: " + advertCode);
                        callback.onEvent(eventCode, advertCode);

                        if (eventCode == Yodo1AdConst.ADVERT_EVENT_FINISH) {
                            Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_finish);

                            showEnd(AdvertType.Video, advertCode);
                        } else if (eventCode == Yodo1AdConst.ADVERT_EVENT_CLOSE) {
                            Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_close);

                            YLog.d("[" + advertCode + "] rewarded video ad has been shown, will preloading it again.");
                            reloadVideoAdvert(adapter, activity, advertCode);
                        } else if (eventCode == Yodo1AdConst.ADVERT_EVENT_CLICK) {
                            Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_click);
                        }
                    }

                    @Override
                    public void onAdError(int errorCode, String errorMsg, String advertCode) {
                        YLog.d("Show [" + advertCode + "] rewarded video ad failed, ErrorCode: " + errorCode + ", ErrorMessage: " + errorMsg);
                        callback.onAdError(errorCode, errorMsg, advertCode);

                        Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_failed);
                        reloadVideoAdvert(adapter, activity, advertCode);
                    }
                });
            }
        });
    }

    /**
     * 预加载回调结果
     *
     * @param adapterBase
     * @param activity
     */
    public void reloadVideoAdvert(final AdapterAdvertBase adapterBase, final Activity activity, final String advertCode) {
        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v("Load rewarded video ad failed, the network is unavailable.");
            return;
        }

        if (!Yodo1Advert.loadAdForTypeMobile && Yodo1NetWorkUtils.getConnectedType(activity) != ConnectivityManager.TYPE_WIFI) {
            YLog.v("Load rewarded video ad failed, ads are no longer requested in non-wifi state.");
            return;
        }

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {

                if (!adapterBase.videoAdvertIsLoaded(activity)) {//当本地没有缓存的时候再加载下次广告

                    Yodo1Analytics.onEvent(AnalyticsConst.VideoAdReloadChannel, advertCode, "");

                    adapterBase.reloadVideoAdvert(activity, new Yodo1ReloadCallback() {
                        @Override
                        public void onReloadSuccess(String advertCode) {
                            YLog.d("Load [" + advertCode + "] rewarded video ad successfully");
                            Yodo1Analytics.onEvent(AnalyticsConst.VideoAdReloadResultChannel, advertCode, AnalyticsConst.ReloadResulet_finish);
                        }

                        @Override
                        public void onReloadFailed(int errorCode, int adErrorCode, String adErrorMsg, String advertCode) {
                            YLog.d("Load [" + advertCode + "] rewarded video ad failed, ErrorCode: " + adErrorCode + ", ErrorMessage: " + adErrorMsg);

                            Yodo1Analytics.onEvent(AnalyticsConst.VideoAdReloadResultChannel, advertCode, AnalyticsConst.ReloadResulet_failed);
                            Yodo1ErrorUpdataHelper.getInstance().ErrorCollection(activity, advertCode, errorCode, adErrorCode, adErrorMsg, AdvertType.Interstitial);
                        }
                    });
                } else {
                    YLog.d("[" + advertCode + "] rewarded video ad has been loaded, don't need to reload it again.");
                }
            }
        });
    }

    /**
     * 预加载视频广告是否成功
     * <p>
     * 务必在视频广告展示前调用
     *
     * @param activity
     */
    public boolean videoAdIsLoaded(final Activity activity) {
        YLog.d("Yodo1AdvertHelper, videoAdIsLoaded call ...");

        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v("No cached rewarded video ads, the network is unavailable.");
            return false;
        }

        if (playlist_video.size() == 0) {
            YLog.v("No cached rewarded video ads, ad list is empty.");
            return false;
        }

        //如果有一个加载成功即为true
        boolean isLoaded = false;
        for (int i = 0; i < playlist_video.size(); i++) {
            String advertCode = playlist_video.get(i);
            YLog.d("Yodo1AdvertHelper, adverts_video advertCode :  " + advertCode);
            final AdapterAdvertBase adapter = (AdapterAdvertBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter == null) {
                YLog.d("Try to load [" + advertCode + "] rewarded video ad failed, the network adapter is not exist.");
                continue;
            }
            if (adapter.videoAdvertIsLoaded(activity)) {
                YLog.d("[" + advertCode + "] rewarded video ad has been loaded");
                isLoaded = true;
            } else {//没有完成加载的要重新加载
                YLog.d("[" + advertCode + "] rewarded video ad preloading failed, will reload it again.");
                reloadVideoAdvert(adapter, activity, advertCode);//预加载失败时，预加载
            }
        }

        return isLoaded;
    }

    /**
     * 预加载某家渠道的视频广告
     *
     * @param activity
     * @param advertCode
     */
    private void preloadVideoAd(Activity activity, String advertCode) {
        YLog.d("Yodo1AdvertHelper, preloadVideoAd call ...");
        if (TextUtils.isEmpty(advertCode)) {
            YLog.v("Preload rewarded video ad failed, the ad code cannot be empty.");
            return;
        }
        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v("Preload rewarded video ad failed, the network is unavailable.");
            return;
        }

        final AdapterAdvertBase adapter = (AdapterAdvertBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter != null) {
            reloadVideoAdvert(adapter, activity, advertCode);
        } else {
            YLog.d("Try to preload [" + advertCode + "] rewarded video ad failed, the network adapter is not exist.");
        }
    }

    /**
     * 预加载某家渠道的插屏广告
     *
     * @param activity
     * @param advertCode
     */
    private void preloadInterstitialAd(Activity activity, String advertCode) {
        YLog.d("Yodo1AdvertHelper, preloadInterstitialAd call ...");
        if (TextUtils.isEmpty(advertCode)) {
            YLog.v("Preload interstitial ad failed, the ad code cannot be empty.");
            return;
        }
        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v("Preload interstitial ad failed, the network is unavailable.");
            return;
        }

        final AdapterAdvertBase adapter = (AdapterAdvertBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter != null) {
            reloadInterstitialAdvert(adapter, activity, advertCode);
        } else {
            YLog.d("Try to preload [" + advertCode + "] interstitial ad failed, the network adapter is not exist.");
        }
    }

    /**
     * 显示Banner广告
     *
     * @param activity
     */
    public void SetBannerAlign(final Activity activity, final int align) {
        YLog.d("Yodo1AdvertHelper, SetBannerAlign call ...");
        for (int i = 0; i < playlist_banner.size(); i++) {
            String advertCode = playlist_banner.get(i);//根据播放列表循环拿到advertCode
            final AdapterAdvertBase adapter = (AdapterAdvertBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter == null) {
                YLog.d("Try to set [" + advertCode + "] banner ad align failed, the network adapter is not exist.");
                continue;
            }
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    adapter.setBannerAlign(activity, align);
                }
            });
        }
    }

    /**
     * 显示Banner广告
     *
     * @param activity
     */

    public void ShowBanner(final Activity activity, final BannerCallback callback) {
        YLog.d("Yodo1AdvertHelper, showBannerAd call ...");
        HideBanner(activity);//展示广告之前首先隐藏广告
        Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShow, "", "");
        isDismissBanner = false;

        if (playlist_banner.size() == 0) {
            YLog.v("Show banner ad failed, ad list is empty.");
            Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShow, "", AnalyticsConst.ShowResulet_failed);
            callback.onBannerShowFailed(AdErrorCode.ADVERT_ERROR_NO_ADLIST);
            return;
        }

        //获取banner时间间隔
        final long interval = YOnlineConfigUtils.getSwitchingCycle();
        //统计调用

        //展示banner广告
        final String advertCode = playlist_banner.get(0);//根据播放列表拿到第一家advertCode
        YLog.d("The banner ads list: " + playlist_banner.toString() + ", first ad code: " + advertCode);

        showBannerAdByChannel(activity, advertCode, interval, new Yodo1AdCallback() {
            private int index = 0; //当前播放次序
            private long time = 0; //时间标记
            private boolean disPlaySuccessful = false;//标识是否播放成功过   如果曾经播放成功过  最后一家广告播放失败后重头开始播，如果没有播放成功过，播放至最后一家返回播放失败

            @Override
            public void onEvent(int eventCode, String advertCode) {
                YLog.d("ShowBanne onEvent, event code: " + eventCode + ", ad code: " + advertCode);

                switch (eventCode) {
                    case Yodo1AdConst.ADVERT_EVENT_CLICK:
                        callback.onBannerClicked();
                        sendMsg(activity, "Click", advertCode);
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_CLOSE:
                        callback.onBannerClosed();
                        HideBanner(activity);
                        sendMsg(activity, "Close", advertCode);
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_DISPLAYSUCCESS://该字段用来给外部抛出回调
                        YLog.d("Show [" + advertCode + "] banner ad successfully");

                        Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShow, "", AnalyticsConst.ShowResulet_success);
                        time = System.currentTimeMillis();
                        YLog.d("Yodo1AdvertHelper，Time1 == " + time + "   " + advertCode);
                        callback.onBannerShow();
                        sendMsg(activity, "DisPlay", advertCode);
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_DISPLAY://该字段用来表示  banner展示成功之后的逻辑
                        if (isDismissBanner) {
                            YLog.d("Yodo1AdvertHelper, Banner广告隐藏或者关闭  中止循环");
                            return;
                        }

                        if (playlist_banner.size() == 1) {
                            YLog.d("Yodo1AdvertHelper, Banner列表唯一  中止循环");
                            return;
                        }
                        disPlaySuccessful = true;
                        YLog.d("Yodo1AdvertHelper，Time2 == " + System.currentTimeMillis() + "   " + advertCode);
                        YLog.d("Yodo1AdvertHelper，Time3 == " + (System.currentTimeMillis() - time) + "   " + advertCode);


                        YLog.d("Yodo1AdvertHelper，Banner正常播放  advertCode == " + advertCode);
                        String nextCode = "";
                        if (index < playlist_banner.size() - 1) { //播放列表还没到最后
                            //播放下一顺位的广告
                            index++;
                            nextCode = playlist_banner.get(index);
                            YLog.d("[" + advertCode + "] banner ad has been shown, will try to play [" + nextCode + "] banner ad.");
                        } else { //全部播放完毕, 重新开始播
                            index = 0;
                            nextCode = playlist_banner.get(index);
                            YLog.d("All banner ads are played finish, in one loop, the ad code: " + nextCode);
                        }

                        HideBanner(activity);
                        showBannerAdByChannel(activity, nextCode, interval, this);
                        break;

                }
            }

            @Override
            public void onAdError(int errorCode, String errorMsg, String advertCode) {
                sendMsg(activity, "ShowFailed", advertCode);
                Yodo1ErrorUpdataHelper.getInstance().ErrorCollection(activity, advertCode, errorCode, 0, errorMsg, AdvertType.Banner);

                if (index < playlist_banner.size() - 1) { //播放列表还没到最后
                    //播放下一顺位的广告
                    index++;
                    String nextCode = playlist_banner.get(index);

                    YLog.d("Show [" + advertCode + "] banner ad failed, will try to play [" + nextCode + "] banner ad.");
                    showBannerAdByChannel(activity, nextCode, interval, this);
                } else { //全部播放完毕, 也就是全部失败
                    YLog.d("Show all banner ads failed...");

                    if (disPlaySuccessful) {
                        disPlaySuccessful = false;
                        index = 0;
                        String nextCode = playlist_banner.get(index);
                        HideBanner(activity);
                        YLog.d("Will try to play [" + nextCode + "] banner ad.");
                        showBannerAdByChannel(activity, nextCode, interval, this);
                    } else {
                        Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShow, "", AnalyticsConst.ShowResulet_failed);
                        callback.onBannerShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                    }
                }
            }

        });
    }

    /**
     * 展示某家渠道的banner广告
     *
     * @param activity
     * @param advertCode 要展示的渠道
     * @param callback
     */
    private void showBannerAdByChannel(final Activity activity, final String advertCode, final long interval, final Yodo1AdCallback callback) {
        YLog.d("Yodo1AdvertHelper, showBannerAdByChannel call ..." + advertCode);

        Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShowChannel, advertCode, "");

        final AdapterAdvertBase adapter = (AdapterAdvertBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter == null) {
            YLog.d("Try to show [" + advertCode + "] banner ad failed, the network adapter is not exist.");

            Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShowChannel, advertCode, AnalyticsConst.ShowResulet_failed);
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, "the network adapter is not exist", advertCode);
            return;
        }

        if (!bannerIsIsLoaded(advertCode)) {
            YLog.d("Try to show [" + advertCode + "] banner ad failed, no cached ads.");

            Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShowChannel, advertCode, AnalyticsConst.ShowResulet_failed);
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, "no cached banner ads", advertCode);
            return;
        }

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                adapter.showBanner(activity, new Yodo1AdCallback() {
                    @Override
                    public void onEvent(int eventCode, final String advertCode) {
                        YLog.d("showBannerAdByChannel onEvent, event code: " + eventCode + ", ad code: " + advertCode);
                        switch (eventCode) {
                            case Yodo1AdConst.ADVERT_EVENT_CLICK:
                                Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShowChannel, advertCode, AnalyticsConst.ShowResulet_click);
                                callback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, advertCode);
                                break;
                            case Yodo1AdConst.ADVERT_EVENT_CLOSE:
                                callback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, advertCode);
                                break;
                            case Yodo1AdConst.ADVERT_EVENT_DISPLAY:
                                showEnd(AdvertType.Banner, advertCode);
                                Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShowChannel, advertCode, AnalyticsConst.ShowResulet_success);
                                callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAYSUCCESS, advertCode);

                                YLog.d("Yodo1AdvertHelper, showBannerAdByChannel 切换时间 = " + interval);
                                new Handler().postDelayed(new Runnable() {
                                    @Override
                                    public void run() {
                                        callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, advertCode);
                                    }
                                }, interval);

                                break;
                        }
                    }

                    @Override
                    public void onAdError(int errorCode, String errorMsg, String advertCode) {
                        YLog.d("Show [" + advertCode + "] banner ad failed, ErrorCode: " + errorCode + ", ErrorMessage: " + errorMsg);
                        Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShowChannel, advertCode, AnalyticsConst.ShowResulet_failed);

                        callback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, errorMsg, advertCode);
                    }
                });
            }
        });
    }

    /**
     * 预加载Banner广告是否成功
     *
     * @param advertCode
     */
    public boolean bannerIsIsLoaded(String advertCode) {

        final AdapterAdvertBase adapter = (AdapterAdvertBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter != null) {
            if (adapter.hasLoadBanner()) {
                return true;
            }
        }

        return false;
    }

    public void RemoveBanner1(Activity activity) {
        isDismissBanner = true;
        RemoveBanner(activity);
    }

    public void HideBanner1(Activity activity) {
        isDismissBanner = true;
        HideBanner(activity);
    }

    /**
     * 关闭Banner广告
     *
     * @param activity
     */

    public void RemoveBanner(final Activity activity) {
        YLog.d("Yodo1AdvertHelper, removeBannerAd call ...");

        for (int i = 0; i < playlist_banner.size(); i++) {
            String advertCode = playlist_banner.get(i);//根据播放列表循环拿到advertCode
            final AdapterAdvertBase adapter = (AdapterAdvertBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter != null) {
                adapter.removeBanner(activity);
            }
        }
    }

    /**
     * 隐藏Banner广告
     *
     * @param activity
     */

    public void HideBanner(final Activity activity) {
        YLog.d("Yodo1AdvertHelper, HideBanner call ...");
        for (int i = 0; i < playlist_banner.size(); i++) {
            String advertCode = playlist_banner.get(i);//根据播放列表循环拿到advertCode

            final AdapterAdvertBase adapter = (AdapterAdvertBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter != null) {
                //统计调用
                adapter.hideBanner(activity);
            }
        }
    }


    /**
     * 扎实Native 广告
     *
     * @param activity
     * @param px
     * @param py
     * @param pw
     * @param ph
     * @param callback
     * @return
     */
    public boolean showNativeAd(final Activity activity, final float px, final float py, final float pw, final float ph, final NativeCallback callback) {
        YLog.d("Yodo1AdvertHelper, showNative call ...");
        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShow, "", "");
        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v("Show native ad failed, the network is unavailable.");
            Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShow, "", AnalyticsConst.ShowResulet_failed);
            callback.onNativeShowFailed(AdErrorCode.ADVERT_ERROR_NETWORK);
            return false;
        }

        if (playlist_native.size() == 0) {
            YLog.v("Show native ad failed, native ad list is null.");
            Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShow, "", AnalyticsConst.ShowResulet_failed);
            callback.onNativeShowFailed(AdErrorCode.ADVERT_ERROR_NO_ADLIST);
            return false;
        }

        long interval = YOnlineConfigUtils.getNativeAdvertInterstitial();
        if (System.currentTimeMillis() - showtimes_native < interval) {
            YLog.v("Show native ad failed, ad interval not completed.");
            Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShow, "", AnalyticsConst.ShowResulet_failed);
            callback.onNativeShowFailed(AdErrorCode.ADVERT_ERROR_MISS_INTERVAL);
            return false;
        }

        String firstCode = playlist_native.get(0);

        YLog.d("The native ads list: " + playlist_native.toString() + ", first ad code: " + firstCode);
        showNativeByChannel(activity, firstCode, px, py, pw, ph, new Yodo1AdCallback() {
            private int index = 0; //当前播放次序
            private boolean isFinish = false;

            @Override
            public void onEvent(int eventCode, String advertCode) {
                YLog.d("showNativeAd onEvent, event code: " + eventCode + ", advert code: " + advertCode);

                switch (eventCode) {
                    case Yodo1AdConst.ADVERT_EVENT_CLICK:
                        sendMsg(activity, "Click", advertCode);
                        callback.onNativeClicked();
                        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShow, "", AnalyticsConst.ShowResulet_click);
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_CLOSE:
                        sendMsg(activity, "Close", advertCode);
                        callback.onNativeClosed();
                        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShow, "", AnalyticsConst.ShowResulet_close);
//                            AppsflyerUtils.AF_Event(activity, AppsflyerUtils.AF_INTERSTITIAL_EVENT_NAME, advertCode, AnalyticsConst.ShowResulet_close);
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_DISPLAY:
                        //保存当前时间用于进行显示间隔的判断
                        showtimes_native = System.currentTimeMillis();
                        callback.onNativeShow();

                        YLog.d("Show [" + advertCode + "] native(原生广告) ad successfully");
                        sendMsg(activity, "DisPlay", advertCode);
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_LOADED:
//                            callback.interstitialDidLoad();
                        break;
                }

            }

            @Override
            public void onAdError(int errorCode, String errorMsg, String advertCode) {
                sendMsg(activity, "ShowFailed", advertCode);
                if (index < playlist_native.size() - 1) { //播放列表还没到最后
                    //播放下一顺位的广告
                    index++;
                    String nextCode = playlist_native.get(index);

                    YLog.d("Show [" + advertCode + "] native(原生广告) ad failed, will try to play [" + nextCode + "] native ad.");
                    showNativeByChannel(activity, nextCode, px, py, pw, ph, this);
                } else { //全部播放完毕, 也就是全部失败
                    YLog.d("Show all native ad failed...");
                    Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShowChannel, "", AnalyticsConst.ShowResulet_failed);
                    if (callback != null) {
                        callback.onNativeShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                    }
                }
            }
        });
        return true;
    }

    private void showNativeByChannel(final Activity activity, final String advertCode, final float px, final float py, final float pw, final float ph, final Yodo1AdCallback callback) {

        final AdapterAdvertBase adapter = (AdapterAdvertBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter == null) {
            YLog.d("Try to show [" + advertCode + "] native ad failed, the network adapter is not exist.");
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "the network adapter is not exist", advertCode);
            return;
        }

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShowChannel, advertCode, "");

                adapter.showNativeAdvert(activity, px, py, pw, ph, new Yodo1AdCallback() {
                    @Override
                    public void onEvent(int eventCode, String advertCode) {
                        YLog.d("showNativeByChannel onEvent, event code: " + eventCode + ", ad code: " + advertCode);
                        //..统计成功，点击
                        switch (eventCode) {

                            case Yodo1AdConst.ADVERT_EVENT_CLICK:
                                Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_click);
                                callback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, advertCode);
                                break;
                            case Yodo1AdConst.ADVERT_EVENT_CLOSE:
                                Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_close);
                                callback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, advertCode);
                                showEnd(AdvertType.Native, advertCode);
                                reloadNativeAdvert(adapter, activity, advertCode);
                                //重载
                                break;
                            case Yodo1AdConst.ADVERT_EVENT_DISPLAY:
                                callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, advertCode);
                                break;
                        }
                    }

                    @Override
                    public void onAdError(int errorCode, String errorMsg, String advertCode) {
                        YLog.d("Show [" + advertCode + "] native(原生广告) ad failed, ErrorCode: " + errorCode + ", ErrorMessage: " + errorMsg);
                        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShowResultChannel, advertCode, AnalyticsConst.ShowResulet_failed);
                        callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, errorMsg, advertCode);
                        reloadNativeAdvert(adapter, activity, advertCode);
                    }
                });
            }
        });
    }

    /**
     * 预加载广告是否成功
     *
     * @param activity
     */
    public boolean nativeAdIsLoaded(final Activity activity) {
        if (playlist_native.size() == 0) {
            YLog.v("No cached native ads, ad list is empty.");
            return false;
        }

        //如果有一个加载成功即为true
        boolean isLoaded = false;
        for (int i = 0; i < playlist_native.size(); i++) {
            String advertCode = playlist_native.get(i);
            final AdapterAdvertBase adapter = (AdapterAdvertBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter == null) {
                continue;
            }
            if (adapter.nativeAdvertIsLoaded(activity)) {
                YLog.d("[" + advertCode + "] native(原生广告) ad has been loaded, don't need to reload it again.");
                isLoaded = true;
            } else {//没有完成加载的要重新加载
                YLog.d("[" + advertCode + "] native(原生广告) ad preloading failed, will reload it again.");
                reloadNativeAdvert(adapter, activity, advertCode);
            }
        }

        return isLoaded;
    }

    public void reloadNativeAdvert(final AdapterAdvertBase adapterBase, final Activity activity, String advertCode) {
        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdReloadResultChannel, advertCode, "");
        YLog.d("Yodo1AdvertHelper, reloadNativeAdvert: " + advertCode);
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                adapterBase.reloadNativeAdvert(activity, new Yodo1ReloadCallback() {
                    @Override
                    public void onReloadSuccess(String advertCode) {
                        YLog.d("Load [" + advertCode + "] native ad successfully");
                        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdReloadResultChannel, advertCode, AnalyticsConst.ReloadResulet_finish);
                    }

                    @Override
                    public void onReloadFailed(int errorCode, int adErrorCode, String adErrorMsg, String advertCode) {
                        YLog.d("Load [" + advertCode + "] native ad failed, ErrorCode: " + adErrorCode + ", ErrorMessage: " + adErrorMsg);

                        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdReloadResultChannel, advertCode, AnalyticsConst.ReloadResulet_failed);
                        Yodo1ErrorUpdataHelper.getInstance().ErrorCollection(activity, advertCode, errorCode, adErrorCode, adErrorMsg, AdvertType.Native);
                    }
                });
            }
        });
    }

    /**
     * 移除原生广告
     *
     * @param activity
     */
    public void removeNativeAd(final Activity activity) {
        for (int i = 0; i < playlist_native.size(); i++) {
            String advertCode = playlist_native.get(i);//根据播放列表循环拿到advertCode
            final AdapterAdvertBase adapter = (AdapterAdvertBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter != null) {
                adapter.removeNativeAdvert(activity);
            }
        }
    }


    /**
     * 初始化闪屏广告
     */
    private void initSplashAds(final Context activity) {
        if (!YOnlineConfigUtils.isTrunOnYodo1Ads(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd)) {
            YLog.d("Init splash ad failed, the switch is trun off.");
            return;
        }

        List<AdsConfigEntity> adList = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd);
        //移除没有对应adapter的AdsConfigEntity
        for (int i = adList.size() - 1; i >= 0; i--) {
            String advertCode = adList.get(i).getAdvertCode();
            final AdapterAdvertBase adapter = (AdapterAdvertBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter == null) {
                adList.remove(i);
            }
        }

        if (adList.size() == 0) {
            YLog.d("Init splash ad failed, SplashAdControl is empty.");
            return;
        }

        int save_time = Yodo1SharedPreferences.getInt(activity, "Platform_SplashAdShowFirstTimes") + 1;//当前游戏启动次数
        String showFirstTime = Yodo1OnlineConfig.getInstance().getConfigParam("Platform_SplashAdShowFirstTimes", "1");
        int time = Integer.valueOf(showFirstTime);
        Yodo1SharedPreferences.put(activity, "Platform_SplashAdShowFirstTimes", save_time);//将当前启动次数保存到本地
        if (time > save_time) {
            YLog.d("Yodo1AdvertHelper, 第" + time + "次启动开始展示开屏广告");
            return;
        }

        List<String> priorityList = new ArrayList<>();//优先播放的广告列表
        List<String> behindList = new ArrayList<>();//播放级别较低的广告列表
        showAllTimes_splash = Yodo1SharedPreferences.getInt(activity, "Platform_SplashAdShowAllTimes");//开屏广告展示总次数
        int splash_total = 0;//需要计算的开屏广告展示总数（用来计算开屏广告展示比例）
        for (int i = 0; i < adList.size(); i++) {
            int showTimes = Integer.valueOf(adList.get(i).getRatio());
            splash_total = splash_total + showTimes;
        }
        //闪屏广告播放计算
        for (int i = 0; i < adList.size(); i++) {
            if (showAllTimes_splash == 0) {//开屏从未展示过 直接读取到的数据添加进广告列表
                priorityList.add(adList.get(i).getAdvertCode());
            } else {
                String adCode = adList.get(i).getAdvertCode();
                int showTimes_local = Yodo1SharedPreferences.getInt(activity, adList.get(i).getAdvertCode().toLowerCase());//某一家广告的展示次数
                float ratio_local = (float) showTimes_local / showAllTimes_splash;//获取当前这个广告的播放比例

                int showTimes_online = Integer.valueOf(adList.get(i).getRatio());
                float ratio_online = (float) showTimes_online / splash_total;//获取理论上广告播放比例

                if (ratio_local < ratio_online) {
                    priorityList.add(adCode);
                } else {
                    behindList.add(adCode);
                }
            }
        }
        playlist_splash.addAll(priorityList);
        playlist_splash.addAll(behindList);

        YLog.d("The Splash ads list: " + playlist_splash.toString());
    }

    /**
     * 显示splash广告
     *
     * @param activity
     * @return 是否允许显示splash广告
     */

    public boolean showSplashAd(final Activity activity, final SplashCallback callback) {
        YLog.d("Yodo1AdvertHelper, showSplashAd call ...");
        if (playlist_splash.size() == 0) {
            YLog.v("Show splash ads is failed, ad list is empty.");
            callback.onSplashShowFailed(AdErrorCode.ADVERT_ERROR_NO_ADLIST);
            return false;
        }

        String advertCode = playlist_splash.get(0);
        YLog.d("Yodo1AdvertHelper, showSplashAdByChannel : " + advertCode);
        showSplashAdByChannel(activity, advertCode, new Yodo1AdCallback() {
            private int index = 0; //当前播放次序

            @Override
            public void onEvent(int eventCode, String advertCode) {
                switch (eventCode) {
                    case Yodo1AdConst.ADVERT_EVENT_CLICK:
                        callback.onSplashClicked();
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_CLOSE:
                        callback.onSplashClosed();
                        break;
                    case Yodo1AdConst.ADVERT_EVENT_DISPLAY:
                        YLog.d("Show [" + advertCode + "] Splash ad successfully");
                        callback.onSplashShow();

                        //保存当前时间用于进行显示间隔的判断
                        int showTimes_local = Yodo1SharedPreferences.getInt(activity, advertCode.toLowerCase());//某一家广告的展示次数
                        Yodo1SharedPreferences.put(activity, advertCode.toLowerCase(), showTimes_local + 1);//保存当前广告的展示次数
                        Yodo1SharedPreferences.put(activity, "Platform_SplashAdShowAllTimes", showAllTimes_splash + 1);//保存当前展示次数
                        break;

                }
            }

            @Override
            public void onAdError(int errorCode, String errorMsg, String advertCode) {
                Yodo1ErrorUpdataHelper.getInstance().ErrorCollection(activity, advertCode, errorCode, 0, errorMsg, AdvertType.Splash);

                if (index < playlist_splash.size() - 1) { //播放列表还没到最后
                    //播放下一顺位的广告
                    index++;

                    String nextCode = playlist_splash.get(index);
                    YLog.d("Show [" + advertCode + "] Splash ad failed, will try to play [" + nextCode + "] interstitial ad.");

                    showSplashAdByChannel(activity, nextCode, this);
                } else { //全部播放完毕, 也就是全部失败
                    YLog.d("Show all Splash ads failed...");
                    callback.onSplashShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                }
            }
        });

        return true;
    }

    /**
     * 展示某家渠道的开屏广告
     *
     * @param activity
     * @param advertCode 要展示的渠道
     * @param callback
     */
    private void showSplashAdByChannel(final Activity activity, final String advertCode, final Yodo1AdCallback callback) {
        YLog.d("Yodo1AdvertHelper, showInterstitialAdByChannel call ...");
        //统计调用
        final AdapterAdvertBase adapter = (AdapterAdvertBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter == null) {
            YLog.d("Try to show [" + advertCode + "] splash ad failed, the network adapter is not exist.");
            callback.onAdError(AdEventCode.ADVERT_ERROR_UNKNOW, "the network adapter is not exist", advertCode);
            return;
        }

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                adapter.showSplashAdvert(activity, new Yodo1AdCallback() {
                    @Override
                    public void onEvent(int eventCode, String advertCode) {
                        YLog.d("showSplashAdByChannel onEvent, event code: " + eventCode + ", ad code: " + advertCode);
                        callback.onEvent(eventCode, advertCode);
                    }

                    @Override
                    public void onAdError(int errorCode, String errorMsg, String advertCode) {
                        YLog.d("Show [" + advertCode + "] splash ad failed, ErrorCode " + errorCode + ", ErrorMessage: " + errorMsg);
                        callback.onAdError(errorCode, errorMsg, advertCode);
                    }
                });
            }
        });
    }

    /**
     * 播放完毕
     *
     * @param advertType 广告类型(插屏、视频等)
     * @param adCode
     */
    private void showEnd(AdvertType advertType, String adCode) {
        YLog.d("Yodo1AdvertHelper, showEnd call ...");
        String advertCode = adCode.toLowerCase();
        if (advertType == AdvertType.Interstitial) {
            playtimes_interstitial++;
            YLog.d("Yodo1AdvertHelper, Interstitial总共播放了" + playtimes_interstitial + "次");
            for (int i = 0; i < adverts_intersital.size(); i++) {
                if (!TextUtils.isEmpty(adverts_intersital.get(i).advertCode)) {
                    if (adverts_intersital.get(i).advertCode.equals(advertCode)) {
                        adverts_intersital.get(i).played++;
                        YLog.d("Yodo1AdvertHelper, 当前[" + advertCode + "]播放了" + adverts_intersital.get(i).played + "次");
                    }
                }
            }
            sortAdvert(adverts_intersital, playlist_intersital, playtimes_interstitial); //重排序
        } else if (advertType == AdvertType.Video) {
            playtimes_video++;
            YLog.d("Yodo1AdvertHelper, Video总共播放了" + playtimes_video + "次");
            for (int i = 0; i < adverts_video.size(); i++) {
                if (!TextUtils.isEmpty(adverts_video.get(i).advertCode)) {
                    if (adverts_video.get(i).advertCode.equals(advertCode)) {
                        adverts_video.get(i).played++;
                        YLog.d("Yodo1AdvertHelper, 当前[" + advertCode + "]播放了" + adverts_video.get(i).played + "次");
                    }
                }
            }
            sortAdvert(adverts_video, playlist_video, playtimes_video); //重排序
        } else if (advertType == AdvertType.Banner) {
            playtimes_banner++;
            YLog.d("Yodo1AdvertHelper, Banner总共播放了" + playtimes_banner + "次");
            for (int i = 0; i < adverts_banner.size(); i++) {
                if (adverts_banner.get(i).advertCode.equals(advertCode)) {
                    adverts_banner.get(i).played++;
                    YLog.d("Yodo1AdvertHelper, 当前[" + advertCode + "]播放了" + adverts_banner.get(i).played + "次");
                }
            }
            sortAdvert(adverts_banner, playlist_banner, playtimes_banner); //重排序
        } else if (advertType == AdvertType.Native) {
            playtimes_native++;
            YLog.d("Yodo1AdvertHelper, Native总共播放了" + playtimes_native + "次");
            for (int i = 0; i < adverts_native.size(); i++) {
                if (adverts_native.get(i).advertCode.equals(advertCode)) {
                    adverts_native.get(i).played++;
                    YLog.d("Yodo1AdvertHelper, 当前[" + advertCode + "]播放了" + adverts_native.get(i).played + "次");
                }
            }
            sortAdvert(adverts_native, playlist_native, playtimes_native); //重排序
        }
    }

    /**
     * 根据权重与播放次数排序
     *
     * @param advertsLst 存放广告数据实体（权重和百分比等）的集合
     * @param playList   播放列表
     */
    private void sortAdvert(ArrayList<AdvertBean> advertsLst, ArrayList<String> playList, int playtimes) {
        YLog.d("Yodo1AdvertHelper, sortAdvert call ...");
        //清空播放列表
        if (playList != null) {
            playList.clear();
        } else {
            playList = new ArrayList<String>();
        }
        List<String> overAdvert = new ArrayList<String>(); //存储已经超过播放百分比或者的广告渠道
        List<String> overMaxAdvert = new ArrayList<String>(); //存储已经超过最大播放次数的广告渠道
        List<AdvertBean> fixAdvert = new ArrayList<AdvertBean>(); //存储播放比例不为-1的广告渠道  放置在广告列表最后 按照比例计算播放列表 （-1表示优先展示的广告渠道）

        for (int i = 0; i < advertsLst.size(); i++) {
            AdvertBean bean = advertsLst.get(i);
            YLog.d("Yodo1AdvertHelper, " + bean.advertCode + "   播放次数为 : " + bean.played);
            YLog.d("Yodo1AdvertHelper, " + bean.advertCode + "   最大播放次数为 : " + bean.maxPlayeTimes);

            if (bean.maxPlayeTimes != -1 && bean.played >= bean.maxPlayeTimes) {//maxPlayeTimes = -1 表示展示次数无穷大
                overMaxAdvert.add(bean.advertCode); //筛选出播放次数超过最大播放次数的广告  放在队尾  不参与计算
                YLog.d("Yodo1AdvertHelper, " + bean.advertCode + " 已播放至最大播放次数  播放次数为 : " + bean.maxPlayeTimes);
            } else {
                if (bean.percentage == 0) { //区分广告播放比例为0的放在队首，按照在线参数获取到的顺序排列。播放顺序固定   不为-1的放在队尾，按照播放比例计算
                    playList.add(bean.advertCode);
                    YLog.d("Yodo1AdvertHelper, " + bean.advertCode + " 放入对首 ");
                } else {
                    YLog.d("Yodo1AdvertHelper, " + bean.advertCode + " 需进入排序队列 ");
                    fixAdvert.add(bean);
                }
            }
        }

        //广告播放比例计算
        for (int i = 0; i < fixAdvert.size(); i++) {
            AdvertBean bean = fixAdvert.get(i);
            float percentage_played = (float) bean.played / playtimes; //算出这个渠道的已播放量百分比
            YLog.d("Yodo1AdvertHelper, " + bean.advertCode + " percentage_played : " + percentage_played);
            YLog.d("Yodo1AdvertHelper, " + bean.advertCode + " bean.percentage : " + bean.percentage);
            if (percentage_played < bean.percentage) { //说明播放量还没有超标
                playList.add(bean.advertCode);
            } else { //播放量超标，先加入到超标集合中等待最后合并
                overAdvert.add(bean.advertCode);
            }
        }


        //将播放比例超标集合添加到播放列表队尾
        if (overAdvert.size() > 0) {
            playList.addAll(overAdvert);
        }
        //将播放播放次数超过最大播放次数的集合添加到播放列表队尾
        if (overMaxAdvert.size() > 0) {
//            playList.addAll(overMaxAdvert);
            YLog.d("Yodo1AdvertHelper, 超过最大播放次数的广告列表 : " + overMaxAdvert.toString());
        }

        YLog.d("Yodo1AdvertHelper, 排序后 playList : " + playList.toString());
    }


    /**
     * 初始化广告属性列表与播放列表，初始按权重排序    插屏
     *
     * @param advertType 广告类型
     */
    private void initAdvertList(Context context, Yodo1OnlineConfigAgent.AdvertType advertType) {
        YLog.d("Yodo1AdvertHelper, initAdvertList call ...");
        if (!YOnlineConfigUtils.isTrunOnYodo1Ads(advertType)) {
            YLog.v("Initialize " + (advertType + "").replace("Platform_", "") + " failed, the switch is turn off.");
            return;
        }

        List<AdsConfigEntity> adList = Yodo1OnlineConfigAgent.getAdsControl(advertType);

        //移除没有对应adapter的AdsConfigEntity
        for (int i = adList.size() - 1; i >= 0; i--) {
            String advertCode = adList.get(i).getAdvertCode();
            final AdapterAdvertBase adapter = (AdapterAdvertBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter == null) {
                adList.remove(i);
            }
        }

        //根据广告类型决定使用哪个ArrayList
        ArrayList<AdvertBean> advertsLst = null;
        ArrayList<String> playList = null;
        switch (advertType) {
            case Platform_InterstitialAd:
                advertsLst = adverts_intersital;
                playList = playlist_intersital;
                break;
            case Platform_VideoAd:
                advertsLst = adverts_video;
                playList = playlist_video;
                break;
            case Platform_BannerAd:
                advertsLst = adverts_banner;
                playList = playlist_banner;
                break;
            case Platform_NativeAd:
                advertsLst = adverts_native;
                playList = playlist_native;
                break;
            default:
                YLog.v("Yodo1AdvertHelper, 初始化播放列表异常， 传入的AdvertType不正确, advertType: " + advertType);
                return;
        }

        if (YOnlineConfigUtils.isTestModule(context) && YOnlineConfigUtils.isEmptyTestAdList()) {
            AdvertBean bean = new AdvertBean();
            bean.advertCode = "yodo1";
            bean.weight = 1;
            bean.maxPlayeTimes = -1;//获取最大播放数
            playList.add(bean.advertCode);
            YLog.d("Yodo1AdvertHelper, 初始化 Test Mode [" + advertType + "]播放列表：" + playList.toString());
            advertsLst.add(bean);
            return;
        }

        //算出播放百分比总数
        float total = 0;
        for (int i = 0; i < adList.size(); i++) {
            String ratio = adList.get(i).getRatio();
            if (!TextUtils.isEmpty(ratio) && !ratio.equals("-1")) {
                total += Float.valueOf(ratio);
            }

        }
        for (int i = 0; i < adList.size(); i++) {
            //实例化所有在权重列表中要播放的广告
            //并且根据总比例算出播放百分比
            AdvertBean bean = new AdvertBean();
            bean.advertCode = adList.get(i).getAdvertCode();
            bean.weight = i + 1;
            //获取最大播放数
            bean.maxPlayeTimes = Integer.valueOf(adList.get(i).getMaxShowTimes());

            float ratio = Float.valueOf(adList.get(i).getRatio());
            if (ratio != -1) {
                bean.percentage = ratio / total;
                YLog.d("Yodo1AdvertHelper, ratio: " + ratio + ", total: " + total);
            } else {
                bean.percentage = -1;
            }
            YLog.d("Yodo1AdvertHelper, bean: " + bean.advertCode + ", percentage: " + bean.percentage);

            advertsLst.add(bean);

            playList.add(advertsLst.get(i).advertCode); //初始化播放列表，默认就按权重播不考虑百分比
            YLog.d("Yodo1AdvertHelper, 初始化[" + advertType + "]播放列表, 序列" + (i + 1) + ":" + playList.get(i));
        }
        YLog.d("Yodo1AdvertHelper, 初始化[" + advertType + "]播放列表：" + playList.toString());

    }

    /**
     * 事件发生时发送广播
     */
    private void sendMsg(Context context, String event, String advertCode) {

    }

    public class AdvertBean {
        public String advertCode; //代表哪家广告平台
        public int weight; //权重,从1开始
        public float percentage; //所占的播放百分比
        public int played = 0; //已播放的次数
        public int maxPlayeTimes; //最大播放次数
    }
}
