package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.vungle.warren.InitCallback;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdaptervungle extends AdapterAdvertBase {

    public static final String CHANNEL_CODE = "Vungle";
    public static final String KEY_VUNGLE_APP_ID = "ad_vungle_app_id";
    public static final String VUNGLE_PLACEMENTID = "ad_vungle_video_placementid";
    public static final String VUNGLE_INTERSTITIAL_PLACEMENTID = "ad_vungle_inter_placementid";
    public static String APP_ID = "";
    public static String rewardedPlacementId = "";
    public static String interstitialPlacementId = "";
    private Yodo1AdCallback intersititalCallback, videoCallback; //插屏回调
    private final PlayAdCallback vunglePlayAdCallback = new PlayAdCallback() {

        @Override
        public void onAdStart(String placementReferenceId) {
            YLog.d(CHANNEL_CODE + " PlayAdCallback onAdStart, placementReferenceId: " + placementReferenceId);

            if (placementReferenceId.equals(interstitialPlacementId)) {
                if (intersititalCallback != null) {
                    intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, CHANNEL_CODE);
                }
            }

            if (placementReferenceId.equals(rewardedPlacementId)) {
                if (videoCallback != null) {
                    videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, CHANNEL_CODE);
                }
            }
        }

        @Override
        public void onAdEnd(String placementReferenceId, boolean completed, boolean isCTAClicked) {
            YLog.d(CHANNEL_CODE + " PlayAdCallback onAdEnd, placementReferenceId: " + placementReferenceId + ", completed: " + completed + ", isCTAClicked: " + isCTAClicked);

            if (placementReferenceId.equals(interstitialPlacementId) && intersititalCallback != null) {
                if (isCTAClicked) {
                    intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, CHANNEL_CODE);
                }


                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, CHANNEL_CODE);
            }

            if (placementReferenceId.equals(rewardedPlacementId) && videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, CHANNEL_CODE);
                if (completed) {
                    YLog.d("Vungle,  onAdEnd  关闭");
                    videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, CHANNEL_CODE);
                }
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, CHANNEL_CODE);
            }

        }

        @Override
        public void onError(String placementReferenceId, Throwable throwable) {
            YLog.d(CHANNEL_CODE + " PlayAdCallback onError, placementReferenceId: " + placementReferenceId + ", Throwable message: " + throwable.getMessage());
        }
    };
    private Yodo1ReloadCallback reloadInterCallback, reloadVideoCallback;
    private final LoadAdCallback vungleLoadAdCallback = new LoadAdCallback() {

        @Override
        public void onAdLoad(String placementReferenceId) {
            YLog.d(CHANNEL_CODE + " LoadAdCallback onAdLoad, placementReferenceId: " + placementReferenceId);
            if (reloadInterCallback != null && placementReferenceId.equals(interstitialPlacementId)) {
                reloadInterCallback.onReloadSuccess(getAdvertCode());
            }

            if (reloadVideoCallback != null && placementReferenceId.equals(rewardedPlacementId)) {
                reloadVideoCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onError(String placementReferenceId, Throwable throwable) {
            YLog.d(CHANNEL_CODE + " LoadAdCallback onError placementReferenceId: " + placementReferenceId + ", Throwable message: " + throwable.getMessage());

            if (reloadInterCallback != null && placementReferenceId.equals(interstitialPlacementId)) {
                reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, throwable.getMessage() + "", getAdvertCode());
            }
            if (reloadVideoCallback != null && placementReferenceId.equals(rewardedPlacementId)) {
                reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, throwable.getMessage() + "", getAdvertCode());
            }
        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }


    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(final Activity activity) {

        APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_VUNGLE_APP_ID);

        if (TextUtils.isEmpty(APP_ID)) {
            APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_VUNGLE_APP_ID);
        }
        rewardedPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, VUNGLE_PLACEMENTID);
        interstitialPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, VUNGLE_INTERSTITIAL_PLACEMENTID);

        if (TextUtils.isEmpty(APP_ID)) {
            YLog.d(CHANNEL_CODE + " APP_ID is null");
            return;
        }

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Vungle.init(APP_ID, activity.getApplicationContext(), new InitCallback() {
                    @Override
                    public void onSuccess() {
                        YLog.d(CHANNEL_CODE + " init onSuccess");

                    }

                    @Override
                    public void onError(Throwable throwable) {
                        YLog.d(CHANNEL_CODE + " init onError, cause message: " + throwable.getMessage());
                    }

                    @Override
                    public void onAutoCacheAdAvailable(String s) {
                        YLog.d(CHANNEL_CODE + " init onAutoCacheAdAvailable, s: " + s);
                    }
                });

            }
        });
    }


    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }


    @Override
    public void onDestroy(Activity activity) {
    }


    @Override
    public void showIntersititalAdvert(final Activity activity, final Yodo1AdCallback callback) {
        this.intersititalCallback = callback;

        boolean isReady = interstitialAdvertIsLoaded(activity);
        YLog.d(CHANNEL_CODE + " showIntersititalAdvert... isReady: " + isReady);

        if (isReady) {
            Vungle.playAd(interstitialPlacementId, null, vunglePlayAdCallback);
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, final Yodo1ReloadCallback callback) {
        this.reloadInterCallback = callback;

        if (!isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, callback, null)) {
            return;
        }

        YLog.d(CHANNEL_CODE + " reloadInterstitialAdvert...");

        if (Vungle.isInitialized()) {
            Vungle.loadAd(interstitialPlacementId, vungleLoadAdCallback);
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return Vungle.canPlayAd(interstitialPlacementId);
    }


    @Override
    public void showVideoAdvert(final Activity activity, final Yodo1AdCallback callback) {
        this.videoCallback = callback;

        boolean isReady = videoAdvertIsLoaded(activity);
        YLog.d(CHANNEL_CODE + " showVideoAdvert... isReady: " + isReady);

        if (isReady) {
            Vungle.playAd(rewardedPlacementId, null, vunglePlayAdCallback);
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "The AD has not been cached successfully, try again later.", getAdvertCode());
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;

        if (!isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, reloadCallback, null)) {
            return;
        }

        YLog.d(CHANNEL_CODE + " reloadVideoAdvert...");

        if (Vungle.isInitialized()) {
            Vungle.loadAd(rewardedPlacementId, vungleLoadAdCallback);
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return Vungle.canPlayAd(rewardedPlacementId);
    }


    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        Vungle.Consent consentStatus = privacy.isHasUserConsent() ? Vungle.Consent.OPTED_IN : Vungle.Consent.OPTED_OUT;
        Vungle.updateConsentStatus(consentStatus, "");
    }

    public boolean isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType advertType, Yodo1ReloadCallback reloadCallback, Yodo1AdCallback adCallback) {
        boolean isValid = true;
        if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd) {
            if (TextUtils.isEmpty(APP_ID) || TextUtils.isEmpty(interstitialPlacementId)) {
                isValid = false;
            }
        } else if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd) {
            if (TextUtils.isEmpty(APP_ID) || TextUtils.isEmpty(rewardedPlacementId)) {
                isValid = false;
            }
        }

        if (!isValid) {
            if (reloadCallback != null) {
                reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "", getAdvertCode());
            }
            if (adCallback != null) {
                adCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_ID_NULL, "", getAdvertCode());
            }
        }

        return isValid;
    }
}
