package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.integration.IntegrationHelper;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.InterstitialListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoListener;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

public class AdvertAdaptersupersonic extends AdapterAdvertBase {
    public static final String CHANNEL_CODE = "Supersonic";
    public static final String KEY_SUPERSONIC_APP_ID = "ad_supersonic_app_id";
    public static String SUPERSONIC_ID = "";
    RewardedVideoListener rewardedVideoListener = new RewardedVideoListener() {

        @Override
        public void onRewardedVideoAdClosed() {
            // called when the video is closed
            YLog.d(CHANNEL_CODE + " onRewardedVideoAdClosed");
            // here we show a dialog to the user if he was rewarded
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAvailabilityChanged(boolean available) {
            YLog.d(CHANNEL_CODE + " onRewardedVideoAvailabilityChanged, available: " + available);
            if (reloadVideoCallback != null) {
                if (available) {
                    reloadVideoCallback.onReloadSuccess(getAdvertCode());
                }
            }
        }

        @Override
        public void onRewardedVideoAdStarted() {
            YLog.d(CHANNEL_CODE + " onRewardedVideoAdStarted");
        }

        @Override
        public void onRewardedVideoAdEnded() {
            YLog.d(CHANNEL_CODE + " onRewardedVideoAdEnded");
        }

        @Override
        public void onRewardedVideoAdShowFailed(IronSourceError ironSourceError) {
            YLog.d(CHANNEL_CODE + " onRewardedVideoAdShowFailed, error code: " + ironSourceError.getErrorCode() + ", error message: " + ironSourceError.getErrorMessage());
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, ironSourceError.getErrorCode(), ironSourceError.getErrorMessage(), getAdvertCode());
            }
            if (videoCallback != null) {
                videoCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_DISPLAY_FAILED, ironSourceError.getErrorMessage(), getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdClicked(Placement placement) {
            YLog.d(CHANNEL_CODE + " onRewardedVideoAdClicked");
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdOpened() {
            YLog.d(CHANNEL_CODE + " onRewardedVideoAdOpened");
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdRewarded(Placement placement) {
            // called when the video has been rewarded and a reward can be given to the user
            String rewardName = placement.getRewardName();
            int rewardAmount = placement.getRewardAmount();
            YLog.d(CHANNEL_CODE + " onRewardedVideoAdRewarded, rewardName: " + rewardName + ", rewardAmount: " + rewardAmount);

            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

    };
    private Yodo1AdCallback intersititalCallback, videoCallback; //插屏回调
    private Yodo1ReloadCallback reloadInterCallback, reloadVideoCallback;
    InterstitialListener interstitialListener = new InterstitialListener() {
        @Override
        public void onInterstitialAdReady() {
            YLog.d(CHANNEL_CODE + " onInterstitialAdReady");
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdLoadFailed(IronSourceError ironSourceError) {
            YLog.d(CHANNEL_CODE + " onInterstitialAdLoadFailed, error code: " + ironSourceError.getErrorCode() + ", error message: " + ironSourceError.getErrorMessage());
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, ironSourceError.getErrorCode(), ironSourceError.getErrorMessage(), getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdOpened() {
            YLog.d(CHANNEL_CODE + " onInterstitialAdOpened");
        }

        @Override
        public void onInterstitialAdClosed() {
            YLog.d(CHANNEL_CODE + " onInterstitialAdClosed");

            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdShowSucceeded() {
            YLog.d(CHANNEL_CODE + " onInterstitialAdShowSucceeded");

            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdShowFailed(IronSourceError ironSourceError) {
            YLog.d(CHANNEL_CODE + " onInterstitialAdShowFailed, error code: " + ironSourceError.getErrorCode() + ", error message: " + ironSourceError.getErrorMessage());
            if (intersititalCallback != null) {
                intersititalCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_DISPLAY_FAILED, ironSourceError.getErrorMessage(), getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdClicked() {
            YLog.d(CHANNEL_CODE + " onInterstitialAdClicked");
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }


    @Override
    public void showIntersititalAdvert(final Activity activity, Yodo1AdCallback callback) {
        this.intersititalCallback = callback;

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                boolean isInterstitialReady = interstitialAdvertIsLoaded(activity);
                YLog.d(CHANNEL_CODE + " showIntersititalAdvert... isInterstitialReady: " + isInterstitialReady);
                if (isInterstitialReady) {
                    //show the interstitial
                    IronSource.showInterstitial();
                } else {
                    if (intersititalCallback != null) {
                        intersititalCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
                    }
                }
            }
        });

    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadInterCallback = callback;

        if (!isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, callback, null)) {
            return;
        }

        YLog.d(CHANNEL_CODE + " reloadInterstitialAdvert...");

        if (!interstitialAdvertIsLoaded(activity)) {
            IronSource.loadInterstitial();
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return IronSource.isInterstitialReady();
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;

        boolean isRewardedVideoAvailable = videoAdvertIsLoaded(activity);
        YLog.d(CHANNEL_CODE + " showVideoAdvert ... isRewardedVideoAvailable: " + isRewardedVideoAvailable);
        if (isRewardedVideoAvailable) {
            //show rewarded video
            IronSource.showRewardedVideo();
        } else {
            if (videoCallback != null) {
                videoCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
            }
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;
        isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, reloadCallback, null);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return IronSource.isRewardedVideoAvailable();
    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(Activity activity) {
        SUPERSONIC_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_SUPERSONIC_APP_ID);
        if (TextUtils.isEmpty(SUPERSONIC_ID)) {
            SUPERSONIC_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_SUPERSONIC_APP_ID);
        }

        if (TextUtils.isEmpty(SUPERSONIC_ID)) {
            YLog.d(CHANNEL_CODE + " SUPERSONIC_ID is null");
            return;
        }
        IronSource.init(activity, SUPERSONIC_ID);

        IntegrationHelper.validateIntegration(activity);
    }


    @Override
    public void initVideoAd(Activity activity) {
        IronSource.setRewardedVideoListener(rewardedVideoListener);
    }

    @Override
    public void initInterstitialAd(Activity activity) {
        IronSource.setInterstitialListener(interstitialListener);
    }

    @Override
    public void onResume(Activity activity) {
        if (TextUtils.isEmpty(SUPERSONIC_ID)) {
            return;
        }
        IronSource.onResume(activity);
    }

    @Override
    public void onPause(Activity activity) {

        if (TextUtils.isEmpty(SUPERSONIC_ID)) {
            return;
        }
        IronSource.onPause(activity);
    }


    @Override
    public void onDestroy(Activity activity) {
    }


    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        IronSource.setConsent(privacy.isHasUserConsent());
    }

    public boolean isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType advertType, Yodo1ReloadCallback reloadCallback, Yodo1AdCallback adCallback) {
        boolean isValid = true;
        if (TextUtils.isEmpty(SUPERSONIC_ID)) {
            isValid = false;
        }

        if (!isValid) {
            if (reloadCallback != null) {
                reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "", getAdvertCode());
            }
            if (adCallback != null) {
                adCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_ID_NULL, "", getAdvertCode());
            }
        }

        return isValid;
    }
}
