package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.text.TextUtils;

import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.banner.Yodo1BannerAlign;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

import static com.google.android.gms.ads.AdSize.BANNER;


public class AdvertAdapteradmob extends AdapterAdvertBase {

    private static final String CHANNEL_CODE = "AdMob";

    private static final String KEY_AdMob_INTERSTITIAL_ID = "ad_admob_interstitial_id";
    private static final String KEY_AdMob_BANNER_ID = "ad_admob_banner_unitId";
    private static final String KEY_AdMob_VIDEO_ID = "ad_admob_video_unitId";
    private static final String KEY_AdMob_BANNER_APPID = "ad_admob_banner_appId";
    private static final String KEY_AdMob_VIDEO_APPID = "ad_admob_video_appId";
    private static final String KEY_AdMob_INTERSTITIAL_APPID = "ad_admob_interstitial_appId";

    private String appId;
    //Banner
    public String bannerUnitId;
    private AdRequest adRequest;
    private AdView mAdView;
    private InterstitialAd mInterstitialAd;
    private RewardedVideoAd mRewardedVideoAd;
    private int align = Yodo1BannerAlign.BannerAlignHorizontalCenter | Yodo1BannerAlign.BannerAlignBottom;
    private boolean isBannerLoaded = false;
    //Interinstitial
    private String interUnitId;
    //视频
    private String videoUnitId;


    private boolean videoIsLoded = false;
    private boolean interIsLoded = false;


    private Yodo1AdCallback intersititalCallback, videoCallback, bannerCallback; //插屏回调
    private Yodo1ReloadCallback reloadInterCallback, reloadVideoCallback, reloadBannerCallback;


    private AdListener adBannerListener = new AdListener() {
        @Override
        public void onAdLoaded() {
            isBannerLoaded = true;
            // Code to be executed when an ad finishes loading.
            YLog.d(CHANNEL_CODE + " BannerAd onAdLoaded");
        }

        @Override
        public void onAdFailedToLoad(int errorCode) {
            // Code to be executed when an ad request fails.
            YLog.d(CHANNEL_CODE + " BannerAd onAdFailedToLoad, " + errorCode);
        }

        @Override
        public void onAdOpened() {
            // Code to be executed when an ad opens an overlay that
            // covers the screen.
            YLog.d(CHANNEL_CODE + " BannerAd onAdOpened");
        }

        @Override
        public void onAdLeftApplication() {
            // Code to be executed when the user has left the app.
            YLog.d(CHANNEL_CODE + " BannerAd onAdLeftApplication");
            if (bannerCallback != null) {
                bannerCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdClosed() {
            // Code to be executed when when the user is about to return
            // to the app after tapping on an ad.
            YLog.d(CHANNEL_CODE + " BannerAd onAdClosed");
            if (bannerCallback != null) {
                bannerCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }
    };


    private RewardedVideoAdListener listener = new RewardedVideoAdListener() {
        @Override
        public void onRewardedVideoAdLoaded() {
            YLog.d(CHANNEL_CODE + " RewardedVideoAd onRewardedVideoAdLoaded");
            videoIsLoded = true;
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdOpened() {
            YLog.d(CHANNEL_CODE + " RewardedVideoAd onRewardedVideoAdOpened");
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoStarted() {
            YLog.d(CHANNEL_CODE + " RewardedVideoAd onRewardedVideoStarted");
        }

        @Override
        public void onRewardedVideoAdClosed() {
            YLog.d(CHANNEL_CODE + " RewardedVideoAd onRewardedVideoAdClosed");
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onRewarded(RewardItem rewardItem) {
            YLog.d(CHANNEL_CODE + " RewardedVideoAd onRewarded");
        }

        @Override
        public void onRewardedVideoAdLeftApplication() {
            YLog.d(CHANNEL_CODE + " RewardedVideoAd onRewardedVideoAdLeftApplication");
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdFailedToLoad(int errorCode) {
            YLog.d(CHANNEL_CODE + " BannerAd onRewardedVideoAdFailedToLoad, error code:" + errorCode);
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode, "", getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoCompleted() {
            YLog.d(CHANNEL_CODE + " RewardedVideoAd onRewardedVideoCompleted");
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }
    };
    private AdListener adListener = new AdListener() {
        @Override
        public void onAdClosed() {
            YLog.d(CHANNEL_CODE + " InterstitialAd onAdClosed");

            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        //            Called when an ad request failed. The error code is usually ERROR_CODE_INTERNAL_ERROR, ERROR_CODE_INVALID_REQUEST, ERROR_CODE_NETWORK_ERROR, or ERROR_CODE_NO_FILL.
        @Override
        public void onAdFailedToLoad(int errorCode) {
            YLog.d(CHANNEL_CODE + " InterstitialAd onAdFailedToLoad, adErrorCode: " + errorCode);

            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode, "", getAdvertCode());
            }
        }

        //           Called when an ad opens an overlay that covers the screen.
        @Override
        public void onAdOpened() {
            YLog.d(CHANNEL_CODE + " InterstitialAd onAdOpened");
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        //            Called when an ad leaves the application  eg： 去往浏览器
        @Override
        public void onAdLeftApplication() {
            YLog.d(CHANNEL_CODE + " InterstitialAd onAdLeftApplication");
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        //            Called when an ad is received.
        @Override
        public void onAdLoaded() {
            YLog.d(CHANNEL_CODE + " InterstitialAd onAdLoaded");
            interIsLoded = true;
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadSuccess(getAdvertCode());
            }
        }
    };
    private Yodo1Privacy privacy;

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(Activity activity) {
        //此处读取key
        appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, CHANNEL_CODE, KEY_AdMob_BANNER_APPID);
//        appId = "ca-app-pub-7188592076082444~5943610619";
        if (TextUtils.isEmpty(appId)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_AdMob_VIDEO_APPID);
        }
        if (TextUtils.isEmpty(appId)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_AdMob_INTERSTITIAL_APPID);
        }

        if (!TextUtils.isEmpty(appId)) {
            MobileAds.initialize(activity.getApplicationContext(), appId);
        }

        Bundle admobExtras = new Bundle();
        if (privacy != null && !privacy.isHasUserConsent()) {
            admobExtras.putString("npa", "1");
        }
        AdRequest.Builder builder = new AdRequest.Builder();
        builder.addNetworkExtrasBundle(AdMobAdapter.class, admobExtras);
        adRequest = builder.build();
    }

    @Override
    public void initBannerAd(Activity activity) {
        bannerUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, CHANNEL_CODE, KEY_AdMob_BANNER_ID);

        if (TextUtils.isEmpty(bannerUnitId)) {
            YLog.d(CHANNEL_CODE + " BannerUnitId  is null");
            return;
        }

        if (mAdView == null) {
            mAdView = new AdView(activity);
            mAdView.setAdUnitId(bannerUnitId);
            mAdView.setAdSize(BANNER);
            mAdView.setAdListener(adBannerListener);
            mAdView.loadAd(adRequest);
        }
    }

    @Override
    public void initInterstitialAd(Activity activity) {
        interUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_AdMob_INTERSTITIAL_ID + "1");

        if (TextUtils.isEmpty(interUnitId)) {
            YLog.d(CHANNEL_CODE + " interUnitId is null");
            return;
        }
        YLog.d(CHANNEL_CODE + " interUnitId: " + interUnitId);

        mInterstitialAd = new InterstitialAd(activity);
        mInterstitialAd.setAdUnitId(interUnitId);

        mInterstitialAd.setAdListener(adListener);
    }

    @Override
    public void initVideoAd(Activity activity) {
        videoUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_AdMob_VIDEO_ID);
        if (TextUtils.isEmpty(videoUnitId)) {
            YLog.d(CHANNEL_CODE + " VideoUnitId is null");
            return;
        }

        // Use an activity context to get the rewarded video instance.
        mRewardedVideoAd = MobileAds.getRewardedVideoAdInstance(activity);
        mRewardedVideoAd.setRewardedVideoAdListener(listener);

    }

    @Override
    public void onResume(Activity activity) {

        if (mAdView != null) {
            mAdView.resume();
        }

        if (mRewardedVideoAd != null) {
            mRewardedVideoAd.resume(activity);
        }
    }

    @Override
    public void onPause(Activity activity) {

        if (mAdView != null) {
            mAdView.pause();
        }
        if (mRewardedVideoAd != null) {
            mRewardedVideoAd.pause(activity);
        }
    }

    @Override
    public void onDestroy(Activity activity) {

        if (mAdView != null) {
            mAdView.destroy();
        }

        if (mRewardedVideoAd != null) {
            mRewardedVideoAd.destroy(activity);
        }
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;

        this.videoIsLoded = false;

        if (mRewardedVideoAd == null) {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, "uninitialized", getAdvertCode());
            return;
        }

        if (mRewardedVideoAd.isLoaded()) {
            mRewardedVideoAd.show();
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
        }

    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;

        if (!isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, reloadCallback, null)) {
            return;
        }
        if (mRewardedVideoAd == null) {
            reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_COMMON, 0, "uninitialized", getAdvertCode());
            return;
        }

        mRewardedVideoAd.loadAd(videoUnitId, adRequest);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
//        return mRewardedVideoAd != null && mRewardedVideoAd.isLoaded();
        return videoIsLoded;
    }

    //    预加载
    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadInterCallback = reloadCallback;

        if (!isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, reloadCallback, null)) {
            return;
        }

        if (mInterstitialAd == null) {
            reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "uninitialized", getAdvertCode());
            return;
        }

        // Request a new ad if one isn't already loaded
        if (!mInterstitialAd.isLoaded()) {
            mInterstitialAd.loadAd(adRequest);
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return interIsLoded;
    }

    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.intersititalCallback = callback;
        this.interIsLoded = false;

        if (mInterstitialAd == null) {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, "uninitialized", getAdvertCode());
            return;
        }

        if (mInterstitialAd.isLoaded()) {
            mInterstitialAd.show();
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
        }
    }

    /* 显示banner广告
     * @param activity
     * @param callback
     */
    @Override
    public void showBanner(Activity activity, Yodo1AdCallback callback) {
        this.bannerCallback = callback;

        if (!isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, null, callback)) {
            return;
        }

        if (mAdView == null) {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, "uninitialized", getAdvertCode());
            return;
        }

        if (isBannerLoaded) {
            YLog.d(CHANNEL_CODE + " showBanner ");
            Yodo1BannerAlign.setYodo1BannerLayout(activity, mAdView, align);
            callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
        } else {
            YLog.d(CHANNEL_CODE + " showBanner, the banner has not been loaded.");
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
        }
    }

    /**
     * banner广告删除
     *
     * @param activity
     */
    @Override
    public void removeBanner(Activity activity) {
        isBannerLoaded = false;
        YLog.d(CHANNEL_CODE + " removeBanner");

        if (mAdView != null) {
            mAdView.destroy();
            mAdView = null;
        }
    }

    /**
     * 隐藏
     *
     * @param activity
     */
    @Override
    public void hideBanner(Activity activity) {
        YLog.d(CHANNEL_CODE + " hideBanner");
        if (mAdView != null) {
            Yodo1BannerAlign.removeYodo1BannerLayout(activity, mAdView);
        }
    }

    /**
     * 设置banner展示位置
     *
     * @param activity
     * @param align    banner展示位置
     */
    @Override
    public void setBannerAlign(Activity activity, int align) {
        this.align = align;
        YLog.d(CHANNEL_CODE + " setBannerAlign, align:" + align);
    }

    @Override
    public boolean hasLoadBanner() {
        return isBannerLoaded;
    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        this.privacy = privacy;
    }


    public boolean isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType advertType, Yodo1ReloadCallback reloadCallback, Yodo1AdCallback adCallback) {
        boolean isValid = true;
        if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd) {
            if (TextUtils.isEmpty(appId) || TextUtils.isEmpty(bannerUnitId)) {
                isValid = false;
            }
        } else if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd) {
            if (TextUtils.isEmpty(appId) || TextUtils.isEmpty(interUnitId)) {
                isValid = false;
            }
        } else if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd) {
            if (TextUtils.isEmpty(appId) || TextUtils.isEmpty(videoUnitId)) {
                isValid = false;
            }
        }

        if (!isValid) {
            if (reloadCallback != null) {
                reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "", getAdvertCode());
            }
            if (adCallback != null) {
                adCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_ID_NULL, "", getAdvertCode());
            }
        }

        return isValid;
    }
}
