/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.advert.adapter.kit;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;

public class Yodo1CountDownView
extends View {
    private int mRingColor = -16776961;
    private float mRingWidth = 10.0f;
    private int mRingProgessTextSize = 30;
    private int mWidth;
    private int mHeight;
    private Paint mPaint = new Paint(1);
    private RectF mRectF;
    private int mProgessTextColor = -1;
    private int mCountdownTime = 60;
    private float mCurrentProgress;
    private OnCountDownFinishListener mListener;

    public Yodo1CountDownView(Context context) {
        this(context, null);
    }

    public Yodo1CountDownView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public Yodo1CountDownView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.mPaint.setAntiAlias(true);
        this.setWillNotDraw(false);
    }

    public void setCountdownTime(int n2) {
        this.mCountdownTime = n2;
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        super.onLayout(bl, n2, n3, n4, n5);
        this.mWidth = this.getMeasuredWidth();
        this.mHeight = this.getMeasuredHeight();
        this.mRectF = new RectF(0.0f + this.mRingWidth / 2.0f, 0.0f + this.mRingWidth / 2.0f, (float)this.mWidth - this.mRingWidth / 2.0f, (float)this.mHeight - this.mRingWidth / 2.0f);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint.setColor(this.mRingColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.mRingWidth);
        canvas.drawArc(this.mRectF, -90.0f, this.mCurrentProgress - 360.0f, false, this.mPaint);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setTextAlign(Paint.Align.CENTER);
        String string = "" + (this.mCountdownTime - (int)(this.mCurrentProgress / 360.0f * (float)this.mCountdownTime));
        paint.setTextSize((float)this.mRingProgessTextSize);
        paint.setColor(this.mProgessTextColor);
        Paint.FontMetricsInt fontMetricsInt = paint.getFontMetricsInt();
        int n2 = (int)((this.mRectF.bottom + this.mRectF.top - (float)fontMetricsInt.bottom - (float)fontMetricsInt.top) / 2.0f);
        canvas.drawText(string, this.mRectF.centerX(), (float)n2, paint);
    }

    private ValueAnimator getValA(long l2) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 100.0f});
        valueAnimator.setDuration(l2);
        valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        valueAnimator.setRepeatCount(0);
        return valueAnimator;
    }

    public void startCountDown() {
        this.setClickable(false);
        ValueAnimator valueAnimator = this.getValA(this.mCountdownTime * 1000);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float f2 = Float.valueOf(String.valueOf(valueAnimator.getAnimatedValue())).floatValue();
                Yodo1CountDownView.this.mCurrentProgress = (int)(360.0f * (f2 / 100.0f));
                Yodo1CountDownView.this.invalidate();
            }
        });
        valueAnimator.start();
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                super.onAnimationEnd(animator);
                if (Yodo1CountDownView.this.mListener != null) {
                    Yodo1CountDownView.this.mListener.countDownFinished();
                }
                Yodo1CountDownView.this.setClickable(true);
            }
        });
    }

    public void setAddCountDownListener(OnCountDownFinishListener onCountDownFinishListener) {
        this.mListener = onCountDownFinishListener;
    }

    public static interface OnCountDownFinishListener {
        public void countDownFinished();
    }
}

