/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.tapjoy;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.IntegrationData;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.tapjoy.TJActionRequest;
import com.tapjoy.TJConnectListener;
import com.tapjoy.TJError;
import com.tapjoy.TJPlacement;
import com.tapjoy.TJPlacementListener;
import com.tapjoy.TJPlacementVideoListener;
import com.tapjoy.Tapjoy;
import com.tapjoy.TapjoyLog;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONObject;

public class TapjoyAdapter
extends AbstractAdapter
implements TJPlacementListener,
TJPlacementVideoListener {
    private static final String VERSION = "4.1.5";
    private static final String GitHash = "c85f59b06";
    private final String SDK_KEY = "sdkKey";
    private final String PLACEMENT_NAME = "placementName";
    private final int PROG_LOAD_ERROR_GET_PLACEMENT = 5000;
    private final int LOAD_ERROR_NOT_AVAILABLE = 5001;
    private ConcurrentHashMap<String, TJPlacement> mIsPlacementToAd = new ConcurrentHashMap();
    private ConcurrentHashMap<String, TJPlacement> mRvPlacementToAd = new ConcurrentHashMap();
    private ConcurrentHashMap<String, InterstitialSmashListener> mIsPlacementToListener = new ConcurrentHashMap();
    private ConcurrentHashMap<String, RewardedVideoSmashListener> mRvPlacementToListener = new ConcurrentHashMap();
    private CopyOnWriteArraySet<String> mProgrammaticPlacements = new CopyOnWriteArraySet();
    private ExecutorService mThreadPool = Executors.newSingleThreadExecutor();
    private ConcurrentHashMap<String, Boolean> mIsPlacementToIsReady = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Boolean> mRvPlacementToIsReady = new ConcurrentHashMap();
    private boolean mWasInitCalled = false;
    private boolean mWasInitCompleted = false;

    public static TapjoyAdapter startAdapter(String string) {
        return new TapjoyAdapter(string);
    }

    private TapjoyAdapter(String string) {
        super(string);
    }

    public static IntegrationData getIntegrationData(Activity activity) {
        activity = new IntegrationData("Tapjoy", VERSION);
        new IntegrationData("Tapjoy", VERSION).activities = new String[]{"com.tapjoy.TJAdUnitActivity", "com.tapjoy.mraid.view.ActionHandler", "com.tapjoy.mraid.view.Browser", "com.tapjoy.TJContentActivity"};
        return activity;
    }

    public static String getAdapterSDKVersion() {
        String string = null;
        try {
            string = Tapjoy.getVersion();
        }
        catch (Exception exception) {}
        return string;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return Tapjoy.getVersion();
    }

    protected void setConsent(boolean bl) {
        Tapjoy.setUserConsent((String)(bl ? "1" : "0"));
    }

    private synchronized void initSDK(final Activity activity, final String string, String string2) {
        if (this.mWasInitCalled) {
            return;
        }
        this.log("initSDK");
        this.mWasInitCalled = true;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.isAdaptersDebugEnabled()) {
            hashtable.put("TJC_OPTION_ENABLE_LOGGING", "true");
            Tapjoy.setDebugEnabled((boolean)true);
            TapjoyLog.setDebugEnabled((boolean)true);
        } else {
            hashtable.put("TJC_OPTION_ENABLE_LOGGING", "false");
            Tapjoy.setDebugEnabled((boolean)false);
            TapjoyLog.setDebugEnabled((boolean)false);
        }
        Tapjoy.connect((Context)activity.getApplicationContext(), (String)string2, hashtable, (TJConnectListener)new TJConnectListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onConnectSuccess() {
                TapjoyAdapter tapjoyAdapter = TapjoyAdapter.this;
                synchronized (tapjoyAdapter) {
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        Tapjoy.setUserID((String)string);
                    }
                    Tapjoy.setActivity((Activity)activity);
                    for (Object object : TapjoyAdapter.this.mIsPlacementToListener.values()) {
                        object.onInterstitialInitSuccess();
                    }
                    for (Object object : TapjoyAdapter.this.mRvPlacementToListener.keySet()) {
                        RewardedVideoSmashListener rewardedVideoSmashListener = (RewardedVideoSmashListener)TapjoyAdapter.this.mRvPlacementToListener.get(object);
                        if (TapjoyAdapter.this.mProgrammaticPlacements.contains(object)) {
                            rewardedVideoSmashListener.onRewardedVideoInitSuccess();
                            continue;
                        }
                        TapjoyAdapter.this.loadVideo((String)object);
                    }
                    TapjoyAdapter.this.mWasInitCompleted = true;
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onConnectFailure() {
                TapjoyAdapter tapjoyAdapter = TapjoyAdapter.this;
                synchronized (tapjoyAdapter) {
                    for (Object object : TapjoyAdapter.this.mIsPlacementToListener.values()) {
                        object.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Tapjoy sdk init failed", (String)"Interstitial"));
                    }
                    for (Object object : TapjoyAdapter.this.mRvPlacementToListener.keySet()) {
                        RewardedVideoSmashListener rewardedVideoSmashListener = (RewardedVideoSmashListener)TapjoyAdapter.this.mRvPlacementToListener.get(object);
                        if (TapjoyAdapter.this.mProgrammaticPlacements.contains(object)) {
                            rewardedVideoSmashListener.onRewardedVideoInitFailed(ErrorBuilder.buildInitFailedError((String)"Tapjoy sdk init failed", (String)"Rewarded Video"));
                            continue;
                        }
                        rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
                    }
                    TapjoyAdapter.this.mWasInitCompleted = true;
                    return;
                }
            }
        });
    }

    public synchronized Map<String, Object> getRvBiddingData(JSONObject object) {
        object = new HashMap<String, String>();
        object.put("token", Tapjoy.getUserToken());
        return object;
    }

    public synchronized void loadVideo(JSONObject object, RewardedVideoSmashListener rewardedVideoSmashListener, String string) {
        object = object.optString("placementName");
        this.mThreadPool.execute(new Runnable((String)object, string, rewardedVideoSmashListener){
            final /* synthetic */ String val$placementName;
            final /* synthetic */ String val$serverData;
            final /* synthetic */ RewardedVideoSmashListener val$listener;
            {
                this.val$placementName = string;
                this.val$serverData = string2;
                this.val$listener = rewardedVideoSmashListener;
            }

            @Override
            public void run() {
                TJPlacement tJPlacement = TapjoyAdapter.this.getAuctionPlacement(this.val$placementName, this.val$serverData);
                tJPlacement.setVideoListener((TJPlacementVideoListener)TapjoyAdapter.this);
                if (tJPlacement != null) {
                    TapjoyAdapter.this.mRvPlacementToAd.put(this.val$placementName, tJPlacement);
                    tJPlacement.requestContent();
                    return;
                }
                this.val$listener.onRewardedVideoAvailabilityChanged(false);
            }
        });
    }

    public synchronized void initRvForBidding(Activity activity, String string, String string2, JSONObject object, RewardedVideoSmashListener rewardedVideoSmashListener) {
        if (rewardedVideoSmashListener == null) {
            this.log("initRvForBidding listener == null");
            return;
        }
        string = object.optString("sdkKey");
        object = object.optString("placementName");
        if (TextUtils.isEmpty((CharSequence)string)) {
            rewardedVideoSmashListener.onRewardedVideoInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing sdkKey", (String)"Rewarded Video"));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)object)) {
            rewardedVideoSmashListener.onRewardedVideoInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing placementId", (String)"Rewarded Video"));
            return;
        }
        this.mRvPlacementToListener.put((String)object, rewardedVideoSmashListener);
        this.mProgrammaticPlacements.add((String)object);
        this.initSDK(activity, string2, string);
        if (this.mWasInitCompleted) {
            if (Tapjoy.isConnected()) {
                rewardedVideoSmashListener.onRewardedVideoInitSuccess();
                return;
            }
            rewardedVideoSmashListener.onRewardedVideoInitFailed(ErrorBuilder.buildInitFailedError((String)"sdk not connected", (String)"Rewarded Video"));
        }
    }

    private void loadVideo(final String string) {
        this.mThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                TJPlacement tJPlacement = TapjoyAdapter.this.getPlacement(string);
                tJPlacement.setVideoListener((TJPlacementVideoListener)TapjoyAdapter.this);
                TapjoyAdapter.this.mRvPlacementToAd.put(string, tJPlacement);
                tJPlacement.requestContent();
            }
        });
    }

    public synchronized void initRewardedVideo(Activity activity, String string, String string2, JSONObject object, RewardedVideoSmashListener rewardedVideoSmashListener) {
        string = object.optString("sdkKey");
        object = object.optString("placementName");
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)object)) {
            this.log("initRewardedVideo empty sdkKey or placementName");
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            return;
        }
        this.mRvPlacementToListener.put((String)object, rewardedVideoSmashListener);
        this.mRvPlacementToIsReady.put((String)object, false);
        this.initSDK(activity, string2, string);
        if (this.mWasInitCompleted) {
            if (Tapjoy.isConnected()) {
                this.loadVideo((String)object);
                return;
            }
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
        }
    }

    public synchronized void fetchRewardedVideo(JSONObject object) {
        object = object.optString("placementName");
        this.mRvPlacementToIsReady.put((String)object, false);
        this.mThreadPool.execute(new Runnable((String)object){
            final /* synthetic */ String val$placementName;
            {
                this.val$placementName = string;
            }

            @Override
            public void run() {
                if (TapjoyAdapter.this.mRvPlacementToAd.containsKey(this.val$placementName)) {
                    ((TJPlacement)TapjoyAdapter.this.mRvPlacementToAd.get(this.val$placementName)).requestContent();
                    return;
                }
                if (TapjoyAdapter.this.mRvPlacementToListener.containsKey(this.val$placementName)) {
                    ((RewardedVideoSmashListener)TapjoyAdapter.this.mRvPlacementToListener.get(this.val$placementName)).onRewardedVideoAvailabilityChanged(false);
                }
            }
        });
    }

    public synchronized void showRewardedVideo(final JSONObject jSONObject, final RewardedVideoSmashListener rewardedVideoSmashListener) {
        this.mRvPlacementToIsReady.put(jSONObject.optString("placementName"), false);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TapjoyAdapter tapjoyAdapter = TapjoyAdapter.this;
                synchronized (tapjoyAdapter) {
                    String string = jSONObject.optString("placementName");
                    if (TapjoyAdapter.this.mRvPlacementToAd.containsKey(string) && ((TJPlacement)TapjoyAdapter.this.mRvPlacementToAd.get(string)).isContentReady()) {
                        ((TJPlacement)TapjoyAdapter.this.mRvPlacementToAd.get(string)).showContent();
                    } else if (rewardedVideoSmashListener != null) {
                        rewardedVideoSmashListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
                        rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
                    }
                    return;
                }
            }
        });
    }

    public synchronized boolean isRewardedVideoAvailable(JSONObject object) {
        return this.mRvPlacementToIsReady.containsKey(object = object.optString("placementName")) && this.mRvPlacementToIsReady.get(object) != false;
    }

    public synchronized Map<String, Object> getIsBiddingData(JSONObject object) {
        object = new HashMap<String, String>();
        object.put("token", Tapjoy.getUserToken());
        return object;
    }

    public synchronized void initInterstitialForBidding(Activity activity, String string, String string2, JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        this.initInterstitial(activity, string, string2, jSONObject, interstitialSmashListener);
    }

    public synchronized void initInterstitial(Activity activity, String string, String string2, JSONObject object, InterstitialSmashListener interstitialSmashListener) {
        string = object.optString("sdkKey");
        object = object.optString("placementName");
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)object)) {
            interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params", (String)"Interstitial"));
            return;
        }
        this.mIsPlacementToListener.put((String)object, interstitialSmashListener);
        this.initSDK(activity, string2, string);
        if (this.mWasInitCompleted) {
            if (Tapjoy.isConnected()) {
                interstitialSmashListener.onInterstitialInitSuccess();
                return;
            }
            interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Init Failed", (String)"Interstitial"));
        }
    }

    public synchronized void loadInterstitial(final JSONObject jSONObject, final InterstitialSmashListener interstitialSmashListener, final String string) {
        this.mIsPlacementToIsReady.put(jSONObject.optString("placementName"), false);
        this.mThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                String string2 = jSONObject.optString("placementName");
                TJPlacement tJPlacement = TapjoyAdapter.this.getAuctionPlacement(string2, string);
                if (tJPlacement != null) {
                    TapjoyAdapter.this.mIsPlacementToAd.put(string2, tJPlacement);
                    tJPlacement.requestContent();
                    return;
                }
                interstitialSmashListener.onInterstitialAdLoadFailed(new IronSourceError(5000, "Load error"));
            }
        });
    }

    public synchronized void loadInterstitial(final JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        this.mIsPlacementToIsReady.put(jSONObject.optString("placementName"), false);
        this.mThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                String string = jSONObject.optString("placementName");
                TJPlacement tJPlacement = TapjoyAdapter.this.getPlacement(string);
                TapjoyAdapter.this.mIsPlacementToAd.put(string, tJPlacement);
                tJPlacement.requestContent();
            }
        });
    }

    public synchronized void showInterstitial(final JSONObject jSONObject, final InterstitialSmashListener interstitialSmashListener) {
        this.mIsPlacementToIsReady.put(jSONObject.optString("placementName"), false);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TapjoyAdapter tapjoyAdapter = TapjoyAdapter.this;
                synchronized (tapjoyAdapter) {
                    String string = jSONObject.optString("placementName");
                    if (TapjoyAdapter.this.mIsPlacementToAd.containsKey(string) && ((TJPlacement)TapjoyAdapter.this.mIsPlacementToAd.get(string)).isContentReady()) {
                        ((TJPlacement)TapjoyAdapter.this.mIsPlacementToAd.get(string)).showContent();
                    } else {
                        interstitialSmashListener.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
                    }
                    return;
                }
            }
        });
    }

    public synchronized boolean isInterstitialReady(JSONObject object) {
        return this.mIsPlacementToIsReady.containsKey(object = object.optString("placementName")) && this.mIsPlacementToIsReady.get(object) != false;
    }

    private TJPlacement getAuctionPlacement(String string, String string2) {
        string = Tapjoy.getPlacement((String)string, (TJPlacementListener)this);
        string.setMediationName("ironsource");
        string.setAdapterVersion(VERSION);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            string2 = new JSONObject(string2);
            String string3 = string2.getString("id");
            hashMap.put("id", string3);
            string2 = string2.getString("ext_data");
            hashMap.put("ext_data", string2);
        }
        catch (Exception exception) {
            this.log("generateAuctionPlacement " + exception.getMessage());
            return null;
        }
        string.setAuctionData(hashMap);
        return string;
    }

    private TJPlacement getPlacement(String string) {
        string = Tapjoy.getPlacement((String)string, (TJPlacementListener)this);
        string.setMediationName("ironsource");
        string.setAdapterVersion(VERSION);
        return string;
    }

    public void onRequestSuccess(final TJPlacement tJPlacement) {
        this.log("onRequestSuccess " + tJPlacement.getName());
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (!tJPlacement.isContentAvailable()) {
                    TapjoyAdapter.this.mThreadPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (TapjoyAdapter.this.mRvPlacementToListener.containsKey(tJPlacement.getName())) {
                                ((RewardedVideoSmashListener)TapjoyAdapter.this.mRvPlacementToListener.get(tJPlacement.getName())).onRewardedVideoAvailabilityChanged(false);
                            }
                            if (TapjoyAdapter.this.mIsPlacementToListener.containsKey(tJPlacement.getName())) {
                                ((InterstitialSmashListener)TapjoyAdapter.this.mIsPlacementToListener.get(tJPlacement.getName())).onInterstitialAdLoadFailed(new IronSourceError(5001, "No content available"));
                            }
                        }
                    });
                }
            }
        });
    }

    public void onRequestFailure(TJPlacement tJPlacement, TJError tJError) {
        this.log("onRequestFailure " + tJPlacement.getName() + " " + tJError.message);
        if (this.mRvPlacementToListener.containsKey(tJPlacement.getName())) {
            this.mRvPlacementToListener.get(tJPlacement.getName()).onRewardedVideoAvailabilityChanged(false);
        }
        if (this.mIsPlacementToListener.containsKey(tJPlacement.getName())) {
            this.mIsPlacementToListener.get(tJPlacement.getName()).onInterstitialAdLoadFailed(new IronSourceError(tJError.code, tJError.message));
        }
    }

    public void onContentReady(TJPlacement object) {
        object = object.getName();
        this.log("onContentReady " + (String)object);
        if (this.mRvPlacementToListener.containsKey(object)) {
            this.mRvPlacementToListener.get(object).onRewardedVideoAvailabilityChanged(true);
            this.mRvPlacementToIsReady.put((String)object, true);
        }
        if (this.mIsPlacementToListener.containsKey(object)) {
            this.mIsPlacementToListener.get(object).onInterstitialAdReady();
            this.mIsPlacementToIsReady.put((String)object, true);
        }
    }

    public void onContentShow(TJPlacement object) {
        object = object.getName();
        this.log("onContentShow " + (String)object);
        if (this.mRvPlacementToListener.containsKey(object)) {
            this.mRvPlacementToListener.get(object).onRewardedVideoAdOpened();
        }
        if (this.mIsPlacementToListener.containsKey(object)) {
            this.mIsPlacementToListener.get(object).onInterstitialAdOpened();
            this.mIsPlacementToListener.get(object).onInterstitialAdShowSucceeded();
        }
    }

    public void onContentDismiss(TJPlacement tJPlacement) {
        this.log("onContentDismiss " + tJPlacement.getName());
        if (this.mRvPlacementToListener.containsKey(tJPlacement.getName())) {
            this.mRvPlacementToListener.get(tJPlacement.getName()).onRewardedVideoAdClosed();
        }
        if (this.mIsPlacementToListener.containsKey(tJPlacement.getName())) {
            this.mIsPlacementToListener.get(tJPlacement.getName()).onInterstitialAdClosed();
        }
    }

    public void onPurchaseRequest(TJPlacement tJPlacement, TJActionRequest tJActionRequest, String string) {
        this.log("onPurchaseRequest " + tJPlacement.getName());
    }

    public void onRewardRequest(TJPlacement tJPlacement, TJActionRequest tJActionRequest, String string, int n2) {
        this.log("onRewardRequest " + tJPlacement.getName());
    }

    public void onVideoStart(TJPlacement tJPlacement) {
        this.log("onVideoStart " + tJPlacement.getName());
        if (this.mRvPlacementToListener.containsKey(tJPlacement.getName())) {
            this.mRvPlacementToListener.get(tJPlacement.getName()).onRewardedVideoAdStarted();
        }
    }

    public void onVideoError(TJPlacement tJPlacement, String string) {
        this.log("onVideoError " + tJPlacement.getName() + " " + string);
    }

    public void onVideoComplete(TJPlacement tJPlacement) {
        this.log("onVideoComplete " + tJPlacement.getName());
        if (this.mRvPlacementToListener.containsKey(tJPlacement.getName())) {
            this.mRvPlacementToListener.get(tJPlacement.getName()).onRewardedVideoAdEnded();
            this.mRvPlacementToListener.get(tJPlacement.getName()).onRewardedVideoAdRewarded();
        }
    }

    private void log(String string) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "TapjoyAdapter " + string, 1);
    }
}

