/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.tapjoy.TJActionRequest;
import com.tapjoy.TJConnectListener;
import com.tapjoy.TJError;
import com.tapjoy.TJPlacement;
import com.tapjoy.TJPlacementListener;
import com.tapjoy.TJPlacementVideoListener;
import com.tapjoy.Tapjoy;
import java.util.HashMap;
import java.util.Hashtable;
import org.json.JSONObject;

public class TapjoyMediationAdapter
extends MediationAdapterBase
implements MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxSignalProvider {
    private static final String MEDIATION_AGENT = "applovin";
    private TJPlacement interstitialPlacement;
    private TJPlacement rewardedPlacement;

    public TapjoyMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    public String getSdkVersion() {
        return Tapjoy.getVersion();
    }

    public String getAdapterVersion() {
        return "12.3.0.1";
    }

    public void onDestroy() {
    }

    public void initialize(MaxAdapterInitializationParameters object, Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        this.log("Initializing Tapjoy SDK...");
        this.checkExistence(new Class[]{Tapjoy.class, TJPlacement.class});
        if (!Tapjoy.isConnected()) {
            Tapjoy.setDebugEnabled((boolean)object.isTesting());
            Hashtable<String, String> hashtable = new Hashtable<String, String>(1);
            hashtable.put("TJC_OPTION_ENABLE_LOGGING", String.valueOf(object.isTesting()));
            this.updateConsentAndActivity((MaxAdapterParameters)object, activity);
            object = object.getServerParameters().getString("sdk_key");
            Tapjoy.connect((Context)activity, (String)object, hashtable, (TJConnectListener)new TJConnectListener(){

                public void onConnectSuccess() {
                    TapjoyMediationAdapter.this.log("Tapjoy SDK initialized");
                    onCompletionListener.onCompletion();
                }

                public void onConnectFailure() {
                    TapjoyMediationAdapter.this.log("Tapjoy SDK failed to initialized");
                    onCompletionListener.onCompletion();
                }
            });
            return;
        }
        this.updateConsentAndActivity((MaxAdapterParameters)object, activity);
        onCompletionListener.onCompletion();
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters object, Activity activity, MaxSignalCollectionListener maxSignalCollectionListener) {
        this.updateConsentAndActivity((MaxAdapterParameters)object, activity);
        object = Tapjoy.getUserToken();
        maxSignalCollectionListener.onSignalCollected((String)object);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.log("Loading interstitial...");
        if (!Tapjoy.isConnected()) {
            this.log("Tapjoy SDK is not initialized");
            maxInterstitialAdapterListener.onInterstitialAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.updateConsentAndActivity((MaxAdapterParameters)maxAdapterResponseParameters, activity);
        this.interstitialPlacement = this.createPlacement(activity, maxAdapterResponseParameters, new InterstitialListener(maxInterstitialAdapterListener));
        if (this.interstitialPlacement != null) {
            this.interstitialPlacement.requestContent();
            return;
        }
        maxInterstitialAdapterListener.onInterstitialAdLoadFailed(MaxAdapterError.BAD_REQUEST);
    }

    public void showInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.log("Showing interstitial...");
        if (this.interstitialPlacement.isContentReady()) {
            this.interstitialPlacement.showContent();
            return;
        }
        this.log("Interstitial ad not ready");
        maxInterstitialAdapterListener.onInterstitialAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
    }

    public void loadRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.log("Loading rewarded ad...");
        if (!Tapjoy.isConnected()) {
            this.log("Tapjoy SDK is not initialized");
            maxRewardedAdapterListener.onRewardedAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.updateConsentAndActivity((MaxAdapterParameters)maxAdapterResponseParameters, activity);
        this.rewardedPlacement = this.createPlacement(activity, maxAdapterResponseParameters, new RewardedListener(maxRewardedAdapterListener));
        if (this.rewardedPlacement != null) {
            this.rewardedPlacement.requestContent();
            return;
        }
        maxRewardedAdapterListener.onRewardedAdLoadFailed(MaxAdapterError.BAD_REQUEST);
    }

    public void showRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.log("Showing rewarded ad...");
        if (this.rewardedPlacement.isContentReady()) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                this.configureReward(maxAdapterResponseParameters);
            }
            this.rewardedPlacement.showContent();
            return;
        }
        this.log("Rewarded ad not ready");
        maxRewardedAdapterListener.onRewardedAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
    }

    private void updateConsentAndActivity(MaxAdapterParameters maxAdapterParameters, Activity activity) {
        Tapjoy.setUserConsent((String)(maxAdapterParameters.hasUserConsent() ? "1" : "0"));
        Tapjoy.belowConsentAge((boolean)maxAdapterParameters.isAgeRestrictedUser());
        Tapjoy.setActivity((Activity)activity);
    }

    private TJPlacement createPlacement(Activity activity, MaxAdapterResponseParameters object, TJPlacementListener tJPlacementListener) {
        activity = new TJPlacement((Context)activity, object.getThirdPartyAdPlacementId(), tJPlacementListener);
        boolean bl = object.getServerParameters().getBoolean("set_mediation_identifier", true);
        String string = bl ? MEDIATION_AGENT : "";
        activity.setMediationName(string);
        activity.setAdapterVersion("12.3.0.1");
        if (tJPlacementListener instanceof TJPlacementVideoListener) {
            activity.setVideoListener((TJPlacementVideoListener)tJPlacementListener);
        }
        if (!TextUtils.isEmpty((CharSequence)object.getBidResponse())) {
            try {
                object = new JSONObject(object.getBidResponse());
                object = AppLovinSdkUtils.toMap((JSONObject)object);
                activity.setAuctionData((HashMap)object);
            }
            catch (Throwable throwable) {
                this.log("Failed to load ad due to JSON deserialization error: ", throwable);
                return null;
            }
        }
        return activity;
    }

    private MaxAdapterError maxErrorCodeFromTapjoyError(TJError tJError) {
        int n2 = tJError != null ? tJError.code : 0;
        int n3 = n2 == 204 ? 204 : (n2 == -1011 ? -5204 : -5200);
        return new MaxAdapterError(n3, n2);
    }

    class RewardedListener
    implements TJPlacementListener,
    TJPlacementVideoListener {
        final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        RewardedListener(MaxRewardedAdapterListener maxRewardedAdapterListener) {
            this.listener = maxRewardedAdapterListener;
        }

        public void onRequestSuccess(TJPlacement tJPlacement) {
            if (tJPlacement.isContentAvailable()) {
                TapjoyMediationAdapter.this.log("Rewarded request succeeded");
                return;
            }
            TapjoyMediationAdapter.this.log("Rewarded request failed");
            this.listener.onRewardedAdLoadFailed(MaxAdapterError.NO_FILL);
        }

        public void onRequestFailure(TJPlacement tJPlacement, TJError tJError) {
            TapjoyMediationAdapter.this.log("Rewarded failed to load with error code: " + tJError.code + " and message: " + tJError.message);
            tJPlacement = TapjoyMediationAdapter.this.maxErrorCodeFromTapjoyError(tJError);
            this.listener.onRewardedAdLoadFailed((MaxAdapterError)tJPlacement);
        }

        public void onContentReady(TJPlacement tJPlacement) {
            TapjoyMediationAdapter.this.log("Rewarded loaded");
            this.listener.onRewardedAdLoaded();
        }

        public void onContentShow(TJPlacement tJPlacement) {
            TapjoyMediationAdapter.this.log("Rewarded shown");
            this.listener.onRewardedAdDisplayed();
        }

        public void onClick(TJPlacement tJPlacement) {
            TapjoyMediationAdapter.this.log("Rewarded clicked");
            this.listener.onRewardedAdClicked();
        }

        public void onContentDismiss(TJPlacement tJPlacement) {
            if (this.hasGrantedReward || this.alwaysReward()) {
                tJPlacement = this.retrieveReward();
                TapjoyMediationAdapter.this.log("Rewarded user with reward: " + tJPlacement);
                this.listener.onUserRewarded((MaxReward)tJPlacement);
            }
            TapjoyMediationAdapter.this.log("Rewarded hidden");
            this.listener.onRewardedAdHidden();
        }

        public void onPurchaseRequest(TJPlacement tJPlacement, TJActionRequest tJActionRequest, String string) {
        }

        public void onRewardRequest(TJPlacement tJPlacement, TJActionRequest tJActionRequest, String string, int n2) {
        }

        public void onVideoStart(TJPlacement tJPlacement) {
            TapjoyMediationAdapter.this.log("Rewarded video began");
            this.listener.onRewardedAdVideoStarted();
        }

        public void onVideoError(TJPlacement tJPlacement, String string) {
            TapjoyMediationAdapter.this.log("Rewarded failed with error message: " + string);
            this.listener.onRewardedAdDisplayFailed(MaxAdapterError.INTERNAL_ERROR);
        }

        public void onVideoComplete(TJPlacement tJPlacement) {
            TapjoyMediationAdapter.this.log("Rewarded video completed");
            this.listener.onRewardedAdVideoCompleted();
            this.hasGrantedReward = true;
        }

        private MaxReward retrieveReward() {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                return TapjoyMediationAdapter.this.getReward();
            }
            return MaxReward.createDefault();
        }

        private boolean alwaysReward() {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                return TapjoyMediationAdapter.this.shouldAlwaysRewardUser();
            }
            return false;
        }
    }

    class InterstitialListener
    implements TJPlacementListener {
        final MaxInterstitialAdapterListener listener;

        InterstitialListener(MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
            this.listener = maxInterstitialAdapterListener;
        }

        public void onRequestSuccess(TJPlacement tJPlacement) {
            if (tJPlacement.isContentAvailable()) {
                TapjoyMediationAdapter.this.log("Interstitial request succeeded");
                return;
            }
            TapjoyMediationAdapter.this.log("Interstitial request failed");
            this.listener.onInterstitialAdLoadFailed(MaxAdapterError.NO_FILL);
        }

        public void onRequestFailure(TJPlacement tJPlacement, TJError tJError) {
            TapjoyMediationAdapter.this.log("Interstitial failed to load with error code: " + tJError.code + " and message: " + tJError.message);
            tJPlacement = TapjoyMediationAdapter.this.maxErrorCodeFromTapjoyError(tJError);
            this.listener.onInterstitialAdLoadFailed((MaxAdapterError)tJPlacement);
        }

        public void onContentReady(TJPlacement tJPlacement) {
            TapjoyMediationAdapter.this.log("Interstitial loaded");
            this.listener.onInterstitialAdLoaded();
        }

        public void onContentShow(TJPlacement tJPlacement) {
            TapjoyMediationAdapter.this.log("Interstitial shown");
            this.listener.onInterstitialAdDisplayed();
        }

        public void onClick(TJPlacement tJPlacement) {
            TapjoyMediationAdapter.this.log("Interstitial clicked");
            this.listener.onInterstitialAdClicked();
        }

        public void onContentDismiss(TJPlacement tJPlacement) {
            TapjoyMediationAdapter.this.log("Interstitial hidden");
            this.listener.onInterstitialAdHidden();
        }

        public void onPurchaseRequest(TJPlacement tJPlacement, TJActionRequest tJActionRequest, String string) {
        }

        public void onRewardRequest(TJPlacement tJPlacement, TJActionRequest tJActionRequest, String string, int n2) {
        }
    }
}

