/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.adapters.MediationAdapterRouter;
import com.applovin.sdk.AppLovinSdk;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.ISDemandOnlyInterstitialListener;
import com.ironsource.mediationsdk.sdk.ISDemandOnlyRewardedVideoListener;
import com.ironsource.mediationsdk.sdk.InterstitialListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoListener;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.concurrent.atomic.AtomicBoolean;

public class IronSourceMediationAdapter
extends MediationAdapterBase
implements MaxInterstitialAdapter,
MaxRewardedAdapter {
    private static final IronSourceRouter sIronSourceRouter = new IronSourceRouter();
    private static final AtomicBoolean sIsInitialized = new AtomicBoolean();
    private String mRouterPlacementIdentifier;

    public IronSourceMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    public void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        this.checkExistence(new Class[]{InterstitialListener.class, RewardedVideoListener.class});
        sIronSourceRouter.initialize(maxAdapterInitializationParameters, activity, onCompletionListener);
    }

    public String getSdkVersion() {
        return IronSourceUtils.getSDKVersion();
    }

    public String getAdapterVersion() {
        return "6.8.4.0.0";
    }

    public void onDestroy() {
        sIronSourceRouter.removeAdapter((MaxAdapter)this, this.mRouterPlacementIdentifier);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters object, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        IronSource.setConsent((boolean)object.hasUserConsent());
        object = object.getThirdPartyAdPlacementId();
        this.log("Loading ironSource interstitial for instance ID: " + (String)object);
        this.mRouterPlacementIdentifier = IronSourceRouter.getInterstitialRouterIdentifier((String)object);
        sIronSourceRouter.addInterstitialAdapter((MaxAdapter)this, maxInterstitialAdapterListener, this.mRouterPlacementIdentifier);
        if (IronSource.isISDemandOnlyInterstitialReady((String)object)) {
            this.log("Ad is available already for instance ID: " + (String)object);
            sIronSourceRouter.onAdLoaded(this.mRouterPlacementIdentifier);
            return;
        }
        IronSource.loadISDemandOnlyInterstitial((String)object);
    }

    public void showInterstitialAd(MaxAdapterResponseParameters object, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        object = object.getThirdPartyAdPlacementId();
        this.log("Showing ironSource interstitial for instance ID: " + (String)object);
        if (IronSource.isISDemandOnlyInterstitialReady((String)object)) {
            sIronSourceRouter.addShowingAdapter((MaxAdapter)this);
            IronSource.showISDemandOnlyInterstitial((String)object);
            return;
        }
        this.log("Unable to show ironSource interstitial - no ad loaded for instance ID: " + (String)object);
        maxInterstitialAdapterListener.onInterstitialAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
    }

    public void loadRewardedAd(MaxAdapterResponseParameters object, Activity object2, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        IronSource.setConsent((boolean)object.hasUserConsent());
        object = object.getThirdPartyAdPlacementId();
        this.log("Loading ironSource rewarded for instance ID: " + (String)object);
        object2 = IronSourceRouter.getRewardedVideoRouterIdentifier((String)object);
        sIronSourceRouter.addRewardedAdapter((MaxAdapter)this, maxRewardedAdapterListener, (String)object2);
        if (IronSource.isISDemandOnlyRewardedVideoAvailable((String)object)) {
            this.log("Ad is available already for instance ID: " + (String)object);
            sIronSourceRouter.onAdLoaded((String)object2);
            return;
        }
        IronSource.loadISDemandOnlyRewardedVideo((String)object);
    }

    public void showRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity object, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        object = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        this.log("Showing ironSource rewarded for instance ID: " + (String)object);
        if (IronSource.isISDemandOnlyRewardedVideoAvailable((String)object)) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                this.configureReward(maxAdapterResponseParameters);
            }
            sIronSourceRouter.addShowingAdapter((MaxAdapter)this);
            IronSource.showISDemandOnlyRewardedVideo((String)object);
            return;
        }
        this.log("Unable to show ironSource rewarded - no ad loaded...");
        maxRewardedAdapterListener.onRewardedAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
    }

    static class IronSourceRouter
    extends MediationAdapterRouter
    implements ISDemandOnlyInterstitialListener,
    ISDemandOnlyRewardedVideoListener {
        private boolean hasGrantedReward;

        private IronSourceRouter() {
        }

        void initialize(MaxAdapterInitializationParameters object, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
            if (!sIsInitialized.getAndSet(true)) {
                if (object.getServerParameters().getBoolean("set_mediation_identifier")) {
                    IronSource.setMediationType((String)MediationAdapterBase.mediationTag());
                }
                IronSource.setAdaptersDebug((boolean)object.isTesting());
                IronSource.setConsent((boolean)object.hasUserConsent());
                IronSource.setISDemandOnlyInterstitialListener((ISDemandOnlyInterstitialListener)sIronSourceRouter);
                IronSource.setISDemandOnlyRewardedVideoListener((ISDemandOnlyRewardedVideoListener)sIronSourceRouter);
                boolean bl = object.getServerParameters().getBoolean("should_track_network_state", false);
                if (bl) {
                    IronSource.shouldTrackNetworkState((Context)activity, (boolean)true);
                }
                object = object.getServerParameters().getString("app_key");
                IronSource.initISDemandOnly((Activity)activity, (String)object, (IronSource.AD_UNIT[])new IronSource.AD_UNIT[]{IronSource.AD_UNIT.INTERSTITIAL, IronSource.AD_UNIT.REWARDED_VIDEO});
            }
            onCompletionListener.onCompletion();
        }

        public void onInterstitialAdReady(String string) {
            this.log("Interstitial loaded for instance ID: " + string);
            this.onAdLoaded(IronSourceRouter.getInterstitialRouterIdentifier(string));
        }

        public void onInterstitialAdLoadFailed(String string, IronSourceError ironSourceError) {
            this.log("Interstitial ad failed to load for instance ID: " + string + " with error: " + ironSourceError);
            this.onAdLoadFailed(IronSourceRouter.getInterstitialRouterIdentifier(string), this.toMaxError(ironSourceError));
        }

        public void onInterstitialAdOpened(String string) {
            this.log("Interstitial ad displayed for instance ID: " + string);
            this.onAdDisplayed(IronSourceRouter.getInterstitialRouterIdentifier(string));
        }

        public void onInterstitialAdClosed(String string) {
            this.log("Interstitial ad closed for instance ID: " + string);
            this.onAdHidden(IronSourceRouter.getInterstitialRouterIdentifier(string));
        }

        public void onInterstitialAdShowFailed(String string, IronSourceError ironSourceError) {
            this.log("Interstitial ad failed to show for instance ID: " + string + " with error: " + ironSourceError);
            this.onAdDisplayFailed(IronSourceRouter.getInterstitialRouterIdentifier(string), this.toMaxError(ironSourceError));
        }

        public void onInterstitialAdClicked(String string) {
            this.log("Interstitial ad clicked for instance ID: " + string);
            this.onAdClicked(IronSourceRouter.getInterstitialRouterIdentifier(string));
        }

        public void onRewardedVideoAdOpened(String string) {
            this.log("Rewarded ad shown for instance ID: " + string);
            string = IronSourceRouter.getRewardedVideoRouterIdentifier(string);
            this.onAdDisplayed(string);
            this.onRewardedAdVideoStarted(string);
        }

        public void onRewardedVideoAdClosed(String string) {
            String string2 = IronSourceRouter.getRewardedVideoRouterIdentifier(string);
            if (this.hasGrantedReward || this.alwaysReward(string2)) {
                MaxReward maxReward = this.retrieveReward(string2);
                this.log("Rewarded  ad rewarded user with reward: " + maxReward + " for instance ID: " + string);
                this.onUserRewarded(string2, maxReward);
                this.hasGrantedReward = false;
            }
            this.log("Rewarded ad hidden for instance ID: " + string);
            this.onAdHidden(string2);
        }

        public void onRewardedVideoAdLoadSuccess(String string) {
            this.log("Rewarded ad loaded for instance ID: " + string);
            this.onAdLoaded(IronSourceRouter.getRewardedVideoRouterIdentifier(string));
        }

        public void onRewardedVideoAdLoadFailed(String string, IronSourceError ironSourceError) {
            this.log("Rewarded ad failed to load for instance ID: " + string);
            this.onAdLoadFailed(IronSourceRouter.getRewardedVideoRouterIdentifier(string), this.toMaxError(ironSourceError));
        }

        public void onRewardedVideoAdRewarded(String string) {
            this.log("Rewarded ad granted reward for instance ID: " + string);
            this.onRewardedAdVideoCompleted(IronSourceRouter.getRewardedVideoRouterIdentifier(string));
            this.hasGrantedReward = true;
        }

        public void onRewardedVideoAdShowFailed(String string, IronSourceError ironSourceError) {
            this.log("Rewarded ad failed to show for instance ID: " + string + " with error: " + ironSourceError);
            this.onAdDisplayFailed(IronSourceRouter.getRewardedVideoRouterIdentifier(string), this.toMaxError(ironSourceError));
        }

        public void onRewardedVideoAdClicked(String string) {
            this.log("Rewarded ad clicked for instance ID: " + string);
            this.onAdClicked(IronSourceRouter.getRewardedVideoRouterIdentifier(string));
        }

        private MaxAdapterError toMaxError(IronSourceError ironSourceError) {
            int n2 = ironSourceError.getErrorCode();
            int n3 = 501 == n2 || 505 == n2 || 506 == n2 ? -5202 : (508 == n2 ? -5204 : (509 == n2 ? 204 : (520 == n2 ? -5207 : (524 == n2 || 526 == n2 ? -5214 : -5200))));
            return new MaxAdapterError(n3, n2);
        }

        private MaxReward retrieveReward(String string) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                return this.getReward(string);
            }
            return MaxReward.createDefault();
        }

        private boolean alwaysReward(String string) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                return this.shouldAlwaysRewardUser(string);
            }
            return false;
        }

        private static String getInterstitialRouterIdentifier(String string) {
            return string + "-" + IronSource.AD_UNIT.INTERSTITIAL.toString();
        }

        private static String getRewardedVideoRouterIdentifier(String string) {
            return string + "-" + IronSource.AD_UNIT.REWARDED_VIDEO.toString();
        }
    }
}

