/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.AppLovinMediationAdapter;
import com.applovin.mediation.adapters.MediationAdapterRouter;
import com.applovin.sdk.AppLovinSdk;
import com.chartboost.sdk.Chartboost;
import com.chartboost.sdk.ChartboostDelegate;
import com.chartboost.sdk.Libraries.CBLogging;
import com.chartboost.sdk.Model.CBError;
import java.util.concurrent.atomic.AtomicBoolean;

public class ChartboostMediationAdapter
extends AppLovinMediationAdapter
implements MaxInterstitialAdapter,
MaxRewardedAdapter {
    private static final ChartboostMediationAdapterRouter ROUTER = new ChartboostMediationAdapterRouter();
    private String mLocation;

    public ChartboostMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    public void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        this.log("Initializing Chartboost SDK...");
        this.checkExistence(new Class[]{Chartboost.class});
        ROUTER.initialize(maxAdapterInitializationParameters, activity, onCompletionListener);
    }

    public String getSdkVersion() {
        return Chartboost.getSDKVersion();
    }

    public String getAdapterVersion() {
        return "7.3.1.4";
    }

    public void onDestroy() {
        ROUTER.removeAdapter((MaxAdapter)this, this.mLocation);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.mLocation = this.retrieveLocation(maxAdapterResponseParameters);
        this.log("Loading interstitial ad for location \"" + this.mLocation + "\"...");
        ROUTER.updateConsentStatus((MaxAdapterParameters)maxAdapterResponseParameters, activity.getApplicationContext());
        ROUTER.addInterstitialAdapter((MaxAdapter)this, maxInterstitialAdapterListener, this.mLocation);
        if (Chartboost.hasInterstitial(this.mLocation)) {
            this.log("Ad is available already");
            ROUTER.onAdLoaded(this.mLocation);
            return;
        }
        Chartboost.cacheInterstitial(this.mLocation);
    }

    public void showInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.log("Showing interstitial ad for location \"" + this.mLocation + "\"...");
        this.updateShowConfigurations(maxAdapterResponseParameters);
        if (Chartboost.hasInterstitial(this.mLocation)) {
            ROUTER.addShowingAdapter((MaxAdapter)this);
            Chartboost.showInterstitial(this.mLocation);
            return;
        }
        this.log("Interstitial ad not ready");
        ROUTER.onAdDisplayFailed(this.mLocation, MaxAdapterError.AD_NOT_READY);
    }

    public void loadRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.mLocation = this.retrieveLocation(maxAdapterResponseParameters);
        this.log("Loading rewarded ad for location \"" + this.mLocation + "\"...");
        ROUTER.updateConsentStatus((MaxAdapterParameters)maxAdapterResponseParameters, activity.getApplicationContext());
        ROUTER.addRewardedAdapter((MaxAdapter)this, maxRewardedAdapterListener, this.mLocation);
        if (Chartboost.hasRewardedVideo(this.mLocation)) {
            this.log("Ad is available already");
            ROUTER.onAdLoaded(this.mLocation);
            return;
        }
        Chartboost.cacheRewardedVideo(this.mLocation);
    }

    public void showRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.log("Showing rewarded ad for location \"" + this.mLocation + "\"...");
        this.updateShowConfigurations(maxAdapterResponseParameters);
        if (Chartboost.hasRewardedVideo(this.mLocation)) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                this.configureReward(maxAdapterResponseParameters);
            }
            ROUTER.addShowingAdapter((MaxAdapter)this);
            Chartboost.showRewardedVideo(this.mLocation);
            return;
        }
        this.log("Rewarded ad not ready");
        maxRewardedAdapterListener.onRewardedAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
    }

    private String retrieveLocation(MaxAdapterResponseParameters maxAdapterResponseParameters) {
        if (!TextUtils.isEmpty((CharSequence)maxAdapterResponseParameters.getThirdPartyAdPlacementId())) {
            return maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        }
        return "Default";
    }

    private void updateShowConfigurations(MaxAdapterResponseParameters maxAdapterResponseParameters) {
        boolean bl;
        if ((maxAdapterResponseParameters = maxAdapterResponseParameters.getServerParameters()).containsKey("hide_system_ui")) {
            bl = maxAdapterResponseParameters.getBoolean("hide_system_ui");
            Chartboost.setShouldHideSystemUI(bl);
        }
        if (maxAdapterResponseParameters.containsKey("enable_activity_callbacks")) {
            bl = maxAdapterResponseParameters.getBoolean("enable_activity_callbacks");
            Chartboost.setActivityCallbacks(bl);
        }
    }

    static class ChartboostMediationAdapterRouter
    extends MediationAdapterRouter {
        private static final AtomicBoolean sIsInitialized = new AtomicBoolean();
        private final AtomicBoolean isShowingAd = new AtomicBoolean();
        private boolean hasGrantedReward;
        private final ChartboostDelegate chartboostDelegate = new ChartboostDelegate(){

            @Override
            public void didCacheInterstitial(String string) {
                ChartboostMediationAdapterRouter.this.log("Interstitial loaded");
                ChartboostMediationAdapterRouter.this.onAdLoaded(string);
            }

            @Override
            public void didFailToLoadInterstitial(String string, CBError.CBImpressionError cBImpressionError) {
                MaxAdapterError maxAdapterError = ChartboostMediationAdapterRouter.this.toMaxError(cBImpressionError);
                if (ChartboostMediationAdapterRouter.this.isShowingAd.compareAndSet(true, false)) {
                    ChartboostMediationAdapterRouter.this.log("Interstitial failed to show with error: " + (Object)((Object)cBImpressionError));
                    ChartboostMediationAdapterRouter.this.onAdDisplayFailed(string, maxAdapterError);
                    return;
                }
                ChartboostMediationAdapterRouter.this.log("Interstitial failed to load with error: " + (Object)((Object)cBImpressionError));
                ChartboostMediationAdapterRouter.this.onAdLoadFailed(string, maxAdapterError);
            }

            @Override
            public void didDisplayInterstitial(String string) {
                ChartboostMediationAdapterRouter.this.log("Interstitial shown");
                ChartboostMediationAdapterRouter.this.onAdDisplayed(string);
            }

            @Override
            public void didClickInterstitial(String string) {
                ChartboostMediationAdapterRouter.this.log("Interstitial clicked");
                ChartboostMediationAdapterRouter.this.onAdClicked(string);
            }

            @Override
            public void didDismissInterstitial(String string) {
                ChartboostMediationAdapterRouter.this.isShowingAd.set(false);
                ChartboostMediationAdapterRouter.this.log("Interstitial hidden");
                ChartboostMediationAdapterRouter.this.onAdHidden(string);
            }

            @Override
            public void didCacheRewardedVideo(String string) {
                ChartboostMediationAdapterRouter.this.log("Rewarded ad loaded");
                ChartboostMediationAdapterRouter.this.onAdLoaded(string);
            }

            @Override
            public void didFailToLoadRewardedVideo(String string, CBError.CBImpressionError cBImpressionError) {
                MaxAdapterError maxAdapterError = ChartboostMediationAdapterRouter.this.toMaxError(cBImpressionError);
                if (ChartboostMediationAdapterRouter.this.isShowingAd.compareAndSet(true, false)) {
                    ChartboostMediationAdapterRouter.this.log("Rewarded ad failed to show with error: " + (Object)((Object)cBImpressionError));
                    ChartboostMediationAdapterRouter.this.onAdDisplayFailed(string, maxAdapterError);
                    return;
                }
                ChartboostMediationAdapterRouter.this.log("Rewarded ad failed to load with error: " + (Object)((Object)cBImpressionError));
                ChartboostMediationAdapterRouter.this.onAdLoadFailed(string, maxAdapterError);
            }

            @Override
            public void didDisplayRewardedVideo(String string) {
                ChartboostMediationAdapterRouter.this.log("Rewarded ad shown");
                ChartboostMediationAdapterRouter.this.onAdDisplayed(string);
                ChartboostMediationAdapterRouter.this.onRewardedAdVideoStarted(string);
            }

            @Override
            public void didClickRewardedVideo(String string) {
                ChartboostMediationAdapterRouter.this.log("Rewarded ad clicked");
                ChartboostMediationAdapterRouter.this.onAdClicked(string);
            }

            @Override
            public void didDismissRewardedVideo(String string) {
                ChartboostMediationAdapterRouter.this.isShowingAd.set(false);
                if (ChartboostMediationAdapterRouter.this.hasGrantedReward || ChartboostMediationAdapterRouter.this.alwaysReward(string)) {
                    MaxReward maxReward = ChartboostMediationAdapterRouter.this.retrieveReward(string);
                    ChartboostMediationAdapterRouter.this.log("Rewarded ad user with reward: " + maxReward);
                    ChartboostMediationAdapterRouter.this.onUserRewarded(string, maxReward);
                    ChartboostMediationAdapterRouter.this.hasGrantedReward = false;
                }
                ChartboostMediationAdapterRouter.this.log("Rewarded ad hidden");
                ChartboostMediationAdapterRouter.this.onAdHidden(string);
            }

            @Override
            public void didCompleteRewardedVideo(String string, int n2) {
                ChartboostMediationAdapterRouter.this.log("Rewarded ad video completed");
                ChartboostMediationAdapterRouter.this.onRewardedAdVideoCompleted(string);
                ChartboostMediationAdapterRouter.this.hasGrantedReward = true;
            }

            @Override
            public void didFailToRecordClick(String string, CBError.CBClickError cBClickError) {
                ChartboostMediationAdapterRouter.this.log("Failed to record click at \"" + string + "\" because of error: " + (Object)((Object)cBClickError));
            }
        };

        private ChartboostMediationAdapterRouter() {
        }

        void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
            if (sIsInitialized.compareAndSet(false, true)) {
                this.updateConsentStatus((MaxAdapterParameters)maxAdapterInitializationParameters, activity.getApplicationContext());
                Bundle bundle = maxAdapterInitializationParameters.getServerParameters();
                String string = bundle.getString("app_id");
                String string2 = bundle.getString("app_signature");
                Chartboost.startWithAppId(activity, string, string2);
                Chartboost.setDelegate(this.chartboostDelegate);
                Chartboost.setMediation(Chartboost.CBMediation.CBMediationOther, AppLovinSdk.VERSION);
                boolean bl = bundle.getBoolean("auto_cache_ads");
                Chartboost.setAutoCacheAds(bl);
                if (maxAdapterInitializationParameters.isTesting()) {
                    Chartboost.setLoggingLevel(CBLogging.Level.ALL);
                }
                if (bundle.containsKey("prefetch_video_content")) {
                    boolean bl2 = bundle.getBoolean("prefetch_video_content");
                    Chartboost.setShouldPrefetchVideoContent(bl2);
                }
                Chartboost.onCreate(activity);
                Chartboost.onStart(activity);
                Chartboost.onResume(activity);
            }
            onCompletionListener.onCompletion();
        }

        public void addShowingAdapter(MaxAdapter maxAdapter) {
            super.addShowingAdapter(maxAdapter);
            this.isShowingAd.set(true);
        }

        void updateConsentStatus(MaxAdapterParameters object, Context context) {
            object = object.hasUserConsent() ? Chartboost.CBPIDataUseConsent.YES_BEHAVIORAL : Chartboost.CBPIDataUseConsent.NO_BEHAVIORAL;
            Chartboost.setPIDataUseConsent(context, (Chartboost.CBPIDataUseConsent)((Object)object));
        }

        /*
         * Enabled aggressive block sorting
         */
        private MaxAdapterError toMaxError(CBError.CBImpressionError cBImpressionError) {
            int n2;
            if (cBImpressionError == CBError.CBImpressionError.INTERNAL) {
                n2 = -5209;
                return new MaxAdapterError(n2, cBImpressionError.ordinal());
            }
            if (cBImpressionError == CBError.CBImpressionError.INTERNET_UNAVAILABLE) {
                n2 = -5207;
                return new MaxAdapterError(n2, cBImpressionError.ordinal());
            }
            if (cBImpressionError == CBError.CBImpressionError.TOO_MANY_CONNECTIONS) {
                n2 = -5209;
                return new MaxAdapterError(n2, cBImpressionError.ordinal());
            }
            if (cBImpressionError == CBError.CBImpressionError.WRONG_ORIENTATION) {
                n2 = -5202;
                return new MaxAdapterError(n2, cBImpressionError.ordinal());
            }
            if (cBImpressionError == CBError.CBImpressionError.FIRST_SESSION_INTERSTITIALS_DISABLED) {
                n2 = -5202;
                return new MaxAdapterError(n2, cBImpressionError.ordinal());
            }
            if (cBImpressionError == CBError.CBImpressionError.NETWORK_FAILURE) {
                n2 = -5207;
                return new MaxAdapterError(n2, cBImpressionError.ordinal());
            }
            if (cBImpressionError == CBError.CBImpressionError.NO_AD_FOUND) {
                n2 = 204;
                return new MaxAdapterError(n2, cBImpressionError.ordinal());
            }
            if (cBImpressionError == CBError.CBImpressionError.SESSION_NOT_STARTED) {
                n2 = -5204;
                return new MaxAdapterError(n2, cBImpressionError.ordinal());
            }
            if (cBImpressionError == CBError.CBImpressionError.IMPRESSION_ALREADY_VISIBLE) {
                n2 = -5201;
                return new MaxAdapterError(n2, cBImpressionError.ordinal());
            }
            if (cBImpressionError != CBError.CBImpressionError.USER_CANCELLATION && cBImpressionError != CBError.CBImpressionError.INVALID_LOCATION) {
                if (cBImpressionError == CBError.CBImpressionError.ASSETS_DOWNLOAD_FAILURE) {
                    n2 = -5203;
                    return new MaxAdapterError(n2, cBImpressionError.ordinal());
                }
                if (cBImpressionError == CBError.CBImpressionError.ASSET_PREFETCH_IN_PROGRESS) {
                    n2 = -5205;
                    return new MaxAdapterError(n2, cBImpressionError.ordinal());
                }
                if (cBImpressionError == CBError.CBImpressionError.ERROR_LOADING_WEB_VIEW || cBImpressionError == CBError.CBImpressionError.WEB_VIEW_PAGE_LOAD_TIMEOUT || cBImpressionError == CBError.CBImpressionError.WEB_VIEW_CLIENT_RECEIVED_ERROR) {
                    n2 = -5212;
                    return new MaxAdapterError(n2, cBImpressionError.ordinal());
                }
                if (cBImpressionError == CBError.CBImpressionError.INTERNET_UNAVAILABLE_AT_SHOW) {
                    n2 = -5207;
                    return new MaxAdapterError(n2, cBImpressionError.ordinal());
                }
                if (cBImpressionError == CBError.CBImpressionError.NO_HOST_ACTIVITY) {
                    n2 = -5209;
                    return new MaxAdapterError(n2, cBImpressionError.ordinal());
                }
            }
            n2 = -5200;
            return new MaxAdapterError(n2, cBImpressionError.ordinal());
        }

        private MaxReward retrieveReward(String string) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                return this.getReward(string);
            }
            return MaxReward.createDefault();
        }

        private boolean alwaysReward(String string) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                return this.shouldAlwaysRewardUser(string);
            }
            return false;
        }
    }
}

