package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.adapter.kit.Yodo1InterAdView;
import com.yodo1.advert.adapter.kit.Yodo1VideoAds;
import com.yodo1.advert.adapter.kit.Yodo1VideoCallback;
import com.yodo1.advert.banner.Yodo1BannerAlign;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.CacheMode;
import com.yodo1.nohttp.rest.OnResponseListener;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.RequestQueue;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.sdk.kit.YLog;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdapteryodo1 extends AdapterAdvertBase {

    public static final String CHANNEL_CODE = "Yodo1";
    public static final String Yodo1_WEB_URL = "https://yodo1opp.com/";
    private Yodo1ReloadCallback reloadVideoCallback, reloadInterCallback; //视频预加载回调
    private Yodo1AdCallback adVideoCallback, adInterCallback, bannerCallback; //视频预加载回调
    private Yodo1VideoCallback callback = new Yodo1VideoCallback() {

        @Override
        public void onVideoClosed() {
            if (adVideoCallback != null) {
                adVideoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onVideoFinish() {
            if (adVideoCallback != null) {
                adVideoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onVideoShow() {
            if (adVideoCallback != null) {
                adVideoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onVideoShowFailed(int errorCode) {
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode, "", getAdvertCode());
            }
        }

        @Override
        public void onVideoClicked() {

            if (adVideoCallback != null) {
                adVideoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };
    private Yodo1InterAdView adView;
    private Yodo1InterAdView.OnYodo1AdsCallBack adsCallBack = new Yodo1InterAdView.OnYodo1AdsCallBack() {
        @Override
        public void setOnAdClickListener() {
            if (adInterCallback != null) {
                adInterCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void setOnAdCloseListener() {
            if (adInterCallback != null) {
                adInterCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void setOnAdShowSuccessListener() {
            if (adInterCallback != null) {
                adInterCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void setOnAdLoadSuccessListener() {
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void setOnAdLoadFailedListener() {
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, "error: null", getAdvertCode());
            }
        }
    };
    private int align = Yodo1BannerAlign.BannerAlignHorizontalCenter | Yodo1BannerAlign.BannerAlignBottom;
    private ImageView bannerView;
    private boolean isShowSuccess = false;

    /**
     * 访问yodo1地址
     *
     * @param context
     */
    public static void goYodo1Web(Activity context) {
        Intent intent = new Intent(Intent.ACTION_VIEW);
        Uri uri = Uri.parse(Yodo1_WEB_URL);
        intent.setData(uri);
        context.startActivity(intent);
    }

    @Override
    public void showVideoAdvert(Activity activity, final Yodo1AdCallback callback) {
        YLog.d("Advert , Yodo1  showVideoAdvert");
        this.adVideoCallback = callback;
        if (Yodo1VideoAds.isReady()) {
            Yodo1VideoAds.showVideoAds(activity);
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "激励视频广告已过期，请再次请求广告后进行广告展示！", getAdvertCode());
        }

    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadVideoCallback) {
        this.reloadVideoCallback = reloadVideoCallback;
        YLog.d("Advert , Yodo1  reloadVideoAdvert");
        Yodo1VideoAds.loadYodo1Video(activity);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return Yodo1VideoAds.isReady();
    }

    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.adInterCallback = callback;
        YLog.d("Advert , Yodo1  showIntersititalAdvert");

        if (adView != null) {
            adView.showYodo1Ads(activity);
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadInterCallback = callback;
        YLog.d("Advert , Yodo1  reloadInterstitialAdvert");

    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return true;
    }

    @Override
    public void showBanner(Activity activity, final Yodo1AdCallback callback) {
        this.bannerCallback = callback;
        if (bannerView != null) {
            isShowSuccess = true;
            Yodo1BannerAlign.setYodo1BannerLayout(activity, bannerView, align);
            callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, "", getAdvertCode());
        }


    }

    @Override
    public void removeBanner(Activity activity) {
        if (bannerView != null && isShowSuccess) {
            isShowSuccess = false;
            Yodo1BannerAlign.removeYodo1BannerLayout(activity, bannerView);
            if (bannerCallback != null) {
                bannerCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

    }

    @Override
    public void hideBanner(Activity activity) {
        YLog.d("Yodo1 hideBanner ");
        if (bannerView != null && isShowSuccess) {
            isShowSuccess = false;
            Yodo1BannerAlign.removeYodo1BannerLayout(activity, bannerView);
            if (bannerCallback != null) {
                bannerCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

    }

    @Override
    public void setBannerAlign(Activity activity, int align) {
        this.align = align;

    }

    @Override
    public boolean hasLoadBanner() {
        return true;
    }

    /**
     * 加载Banner
     */
    public void loadBannerAds(final ImageView imageView) {
        RequestQueue requestQueue = NoHttp.newRequestQueue();
        String url = "https://docs.yodo1.com/media/ad-test-resource/ad-banner1.png";
        Request<Bitmap> requeset = NoHttp.createImageRequest(url, RequestMethod.GET);
        OnResponseListener<Bitmap> listener = new OnResponseListener<Bitmap>() {
            @Override
            public void onStart(int what) {
            }

            @Override
            public void onSucceed(int what, Response<Bitmap> response) {
                Bitmap bm = response.get();

                if (bannerCallback != null) {
                    bannerCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_LOADED, getAdvertCode());
                }
                imageView.setImageBitmap(bm);

            }

            @Override
            public void onFailed(int what, Response<Bitmap> response) {
                if (bannerCallback != null) {
                    bannerCallback.onEvent(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, getAdvertCode());
                }
            }

            @Override
            public void onFinish(int what) {
            }
        };
        //设置缓存模式
        requeset.setCacheMode(CacheMode.REQUEST_NETWORK_FAILED_READ_CACHE);
        requestQueue.add(1, requeset, listener);
    }

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }


    @Override
    public void onCreate(Activity activity) {

        initBannerAd(activity);
        initVideoAd(activity);
        initInterstitialAd(activity);
    }

    @Override
    public void initBannerAd(final Activity activity) {
        bannerView = new ImageView(activity);

        loadBannerAds(bannerView);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(600,
                100);//两个400分别为添加图片的大小
        bannerView.setLayoutParams(params);
        bannerView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (callback != null) {
                    goYodo1Web(activity);
                    bannerCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
                }
            }
        });
    }

    @Override
    public void initVideoAd(Activity activity) {
        Yodo1VideoAds.setYodo1VideoCallback(callback);
    }


    @Override
    public void initInterstitialAd(Activity activity) {
        adView = new Yodo1InterAdView(activity);
        adView.setOnYodo1AdsCallback(adsCallBack);
    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

}
