package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.vungle.warren.InitCallback;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdaptervungle extends AdapterAdvertBase {

    private Yodo1AdCallback intersititalCallback, videoCallback; //插屏回调
    private Yodo1ReloadCallback reloadInterCallback, reloadVideoCallback;
    public static final String CHANNEL_CODE = "Vungle";

    public static final String KEY_VUNGLE_APP_ID = "ad_vungle_app_id";
    public static String APP_ID = "";

    public static final String VUNGLE_PLACEMENTID = "ad_vungle_video_placementid";
    public static String PLACEMENTID = "";

    public static final String VUNGLE_INTERSTITIAL_PLACEMENTID = "ad_vungle_inter_placementid";
    public static String INTERSTITIAL_PLACEMENTID = "";

    private final LoadAdCallback vungleLoadAdCallback = new LoadAdCallback() {

        @Override
        public void onAdLoad(String placementReferenceId) {

            if (reloadInterCallback != null && placementReferenceId.equals(INTERSTITIAL_PLACEMENTID)) {
                reloadInterCallback.onReloadSuccess(getAdvertCode());
            }

            if (reloadVideoCallback != null && placementReferenceId.equals(PLACEMENTID)) {
                reloadVideoCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onError(String placementReferenceId, Throwable throwable) {

            if (reloadInterCallback != null && placementReferenceId.equals(INTERSTITIAL_PLACEMENTID)) {
                reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, "异常码广告位： " + placementReferenceId + " 错误信息：" + throwable.getCause(), getAdvertCode());
            }
            YLog.d("Vungle,  onError : " + placementReferenceId + "   Throwable : " + throwable.getCause());
            if (reloadVideoCallback != null && placementReferenceId.equals(PLACEMENTID)) {
                reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, "异常码广告位ID： " + placementReferenceId + " 错误信息：" + throwable.getCause(), getAdvertCode());
            }
            YLog.d("Vungle,  onError : " + placementReferenceId + "   Throwable : " + throwable.getCause());
        }
    };

    private final PlayAdCallback vunglePlayAdCallback = new PlayAdCallback() {

        @Override
        public void onAdStart(String placementReferenceId) {
            if (placementReferenceId.equals(INTERSTITIAL_PLACEMENTID)) {
                if (intersititalCallback != null) {
                    intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, CHANNEL_CODE);
                }
            }

            if (placementReferenceId.equals(PLACEMENTID)) {
                if (videoCallback != null) {
                    videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, CHANNEL_CODE);
                }
            }


        }

        @Override
        public void onAdEnd(String placementReferenceId, boolean completed, boolean isCTAClicked) {
            if (placementReferenceId.equals(INTERSTITIAL_PLACEMENTID) && intersititalCallback != null) {
                if (isCTAClicked) {
                    intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, CHANNEL_CODE);
                }


                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, CHANNEL_CODE);
            }

            if (placementReferenceId.equals(PLACEMENTID) && videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, CHANNEL_CODE);
                if (completed) {
                    YLog.d("Vungle,  onAdEnd  关闭");
                    videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, CHANNEL_CODE);
                }
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, CHANNEL_CODE);
            }

        }

        @Override
        public void onError(String placementReferenceId, Throwable throwable) {
            YLog.d("Vungle,  onError : " + placementReferenceId + "   Throwable : " + throwable.getCause());
        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }


    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(final Activity activity) {

        APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd,
                CHANNEL_CODE, KEY_VUNGLE_APP_ID);

        if (TextUtils.isEmpty(APP_ID)) {
            APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd,
                    CHANNEL_CODE, KEY_VUNGLE_APP_ID);

        }
        PLACEMENTID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd,
                CHANNEL_CODE, VUNGLE_PLACEMENTID);
        INTERSTITIAL_PLACEMENTID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd,
                CHANNEL_CODE, VUNGLE_INTERSTITIAL_PLACEMENTID);

        if (TextUtils.isEmpty(APP_ID)) {
            YLog.i("Vungle  appid  is null");
            return;
        }

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Vungle.init(APP_ID, activity.getApplicationContext(), new InitCallback() {
                    @Override
                    public void onSuccess() {
                        YLog.d("Vungle init success");

                    }

                    @Override
                    public void onError(Throwable throwable) {
                        YLog.d("Vugle init onFailure : " + throwable.getCause());
                    }

                    @Override
                    public void onAutoCacheAdAvailable(String s) {
                        YLog.d("Vugle init onAutoCacheAdAvailable : " + s);
                    }
                });

            }
        });
    }


    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }


    @Override
    public void onDestroy(Activity activity) {
    }


    @Override
    public void showIntersititalAdvert(final Activity activity, final Yodo1AdCallback callback) {
        YLog.d("Vungle, showVideoAdvert");
        this.intersititalCallback = callback;
        if (TextUtils.isEmpty(APP_ID)) {
            YLog.i("Vungle  appid  is null");
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "Vungle  appid  is null", getAdvertCode());

            return;
        }
        if (TextUtils.isEmpty(INTERSTITIAL_PLACEMENTID)) {
            YLog.i("Vungle intertitial placementid is null");
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "Vungle  intertitial placementid  is null", getAdvertCode());
            return;
        }

        if (Vungle.canPlayAd(INTERSTITIAL_PLACEMENTID)) {
            Vungle.playAd(INTERSTITIAL_PLACEMENTID, null, vunglePlayAdCallback);
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, final Yodo1ReloadCallback callback) {
        this.reloadInterCallback = callback;
        if (TextUtils.isEmpty(INTERSTITIAL_PLACEMENTID)) {
            callback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "APPID 为空", getAdvertCode());
            YLog.i("Vungle,  reloadInterstitialAdvert Interstitial PlacementId  is null");
            return;
        }
        YLog.d("Vungle, reloadInterstitialAdvert");

        if (Vungle.isInitialized()) {
            Vungle.loadAd(INTERSTITIAL_PLACEMENTID, vungleLoadAdCallback);
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return Vungle.canPlayAd(INTERSTITIAL_PLACEMENTID);
    }


    @Override
    public void showVideoAdvert(final Activity activity, final Yodo1AdCallback callback) {
        YLog.d("Vungle, showVideoAdvert");
        this.videoCallback = callback;
        if (TextUtils.isEmpty(APP_ID)) {
            YLog.i("Vungle  appid  is null");
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "Vungle  appid  is null", getAdvertCode());
            return;
        }
        if (TextUtils.isEmpty(PLACEMENTID)) {
            YLog.i("Vungle video placementid is null");
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "Vungle  video placementid  is null", getAdvertCode());
            return;
        }

        if (Vungle.canPlayAd(PLACEMENTID)) {
            Vungle.playAd(PLACEMENTID, null, vunglePlayAdCallback);
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }


    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;
        if (TextUtils.isEmpty(PLACEMENTID)) {
            reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "APPID 为空", getAdvertCode());
            YLog.i("Vungle,  reloadVideoAdvert Video PlacementId  is null");
            return;
        }
        YLog.d("Vungle, reloadVideoAdvert");


        if (Vungle.isInitialized()) {
            Vungle.loadAd(PLACEMENTID, vungleLoadAdCallback);
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return Vungle.canPlayAd(PLACEMENTID);
    }


    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        Vungle.Consent consentStatus = privacy.isHasUserConsent() ? Vungle.Consent.OPTED_IN : Vungle.Consent.OPTED_OUT;
        Vungle.updateConsentStatus(consentStatus, "");
    }
}
