package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.unity3d.ads.UnityAds;
import com.unity3d.ads.metadata.MetaData;
import com.unity3d.services.UnityServices;
import com.unity3d.services.monetization.IUnityMonetizationListener;
import com.unity3d.services.monetization.UnityMonetization;
import com.unity3d.services.monetization.placementcontent.ads.IShowAdListener;
import com.unity3d.services.monetization.placementcontent.ads.ShowAdPlacementContent;
import com.unity3d.services.monetization.placementcontent.core.PlacementContent;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

/**
 * Created by yodo1 on 17/8/31.
 */
public class AdvertAdapterunityads extends AdapterAdvertBase implements IUnityMonetizationListener {
    private Yodo1AdCallback intersititalCallback, videoCallback; //插屏回调
    private Yodo1ReloadCallback reloadInterCallback, reloadVideoCallback;
    private String interstitialPlacementId, rewardedPlacementId;

    public static final String KEY_UNITYADS_APP_ID = "ad_unityads_app_id";
    public static final String KEY_UNITYADS_INTERSTITIAL_ID = "ad_unityads_interstitial_id";
    public static final String KEY_UNITYADS_REWARDED_ID = "ad_unityads_rewarded_id";

    public static final String CHANNEL_CODE = "Unityads";


    @Override
    public void showVideoAdvert(Activity activity, final Yodo1AdCallback callback) {
        YLog.d("Advert , Unityads  showVideoAdvert");

        if (!TextUtils.isEmpty(rewardedPlacementId) && UnityMonetization.isReady(rewardedPlacementId)) {

            PlacementContent pc = UnityMonetization.getPlacementContent(rewardedPlacementId);
            if (pc.getType().equalsIgnoreCase("SHOW_AD")) {
                ShowAdPlacementContent p = (ShowAdPlacementContent) pc;
                p.show(activity, new IShowAdListener() {
                    @Override
                    public void onAdFinished(String placementId, UnityAds.FinishState withState) {
                        YLog.d("Advert , Unityads  Video onAdFinished! " + placementId + "  FinishState : " + withState);

                        if (placementId.equals(rewardedPlacementId) && withState == UnityAds.FinishState.COMPLETED) {
                            callback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
                        }
                        callback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
                    }

                    @Override
                    public void onAdStarted(String placementId) {
                        YLog.d("Advert , Unityads  Video onAdStarted! " + placementId);
                        callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
                    }
                });
            }

        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }

    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;
        if (TextUtils.isEmpty(rewardedPlacementId)) {
            reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, " 错误信息：ID NULL", getAdvertCode());
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return !TextUtils.isEmpty(rewardedPlacementId) && UnityMonetization.isReady(rewardedPlacementId);
    }


    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        YLog.d("Advert , Unityads  showIntersititalAdvert");

        if (!TextUtils.isEmpty(interstitialPlacementId) && UnityMonetization.isReady(interstitialPlacementId)) {

            PlacementContent pc = UnityMonetization.getPlacementContent(interstitialPlacementId);
            if (pc.getType().equalsIgnoreCase("SHOW_AD")) {
                ShowAdPlacementContent p = (ShowAdPlacementContent) pc;
                p.show(activity, new IShowAdListener() {
                    @Override
                    public void onAdFinished(String placementId, UnityAds.FinishState withState) {
                        YLog.d("Advert , Unityads  interstitial onAdFinished! " + placementId + "  FinishState : " + withState);

                        callback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
                    }

                    @Override
                    public void onAdStarted(String placementId) {
                        YLog.d("Advert , Unityads  interstitial onAdStarted! " + placementId);
                        callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
                    }
                });
            }

        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }

    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadInterCallback = callback;
        if (TextUtils.isEmpty(interstitialPlacementId)) {
            reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, " 错误信息：ID NULL", getAdvertCode());
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return !TextUtils.isEmpty(interstitialPlacementId) && UnityMonetization.isReady(interstitialPlacementId);
    }


    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void validateAdsAdapter(Activity activity) {
    }

    @Override
    public void onCreate(Activity activity) {
        interstitialPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE
                , KEY_UNITYADS_INTERSTITIAL_ID);
        rewardedPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE
                , KEY_UNITYADS_REWARDED_ID);

        String unityGameID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE
                , KEY_UNITYADS_APP_ID);

        if (!UnityServices.isInitialized()) {
            unityGameID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE
                    , KEY_UNITYADS_APP_ID);

            if (TextUtils.isEmpty(unityGameID)) {
                YLog.e("Unityads  APPID  is null");
                return;
            }
            UnityMonetization.initialize(activity, unityGameID, this, false);
        }

    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onUnityServicesError(UnityServices.UnityServicesError error, String message) {
        YLog.d("Advert , Unityads  Video onUnityServicesError: " + error.name() + " 错误信息：" + message);
        if (reloadInterCallback != null) {
            reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, "异常码： " + error.name() + " 错误信息：" + message, getAdvertCode());
        }

        YLog.d("Advert , Unityads  Video onUnityServicesError: " + error.name() + " 错误信息：" + message);
        if (reloadVideoCallback != null) {
            reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, "异常码： " + error.name() + " 错误信息：" + message, getAdvertCode());
        }
    }

    @Override
    public void onPlacementContentReady(String placementId, PlacementContent placementcontent) {
        YLog.d("Advert , Unityads  Video onPlacementContentReady: " + placementId);
        if (reloadInterCallback != null && placementId.equals(interstitialPlacementId)) {
            reloadInterCallback.onReloadSuccess(getAdvertCode());
        }

        if (reloadVideoCallback != null && placementId.equals(rewardedPlacementId)) {
            reloadVideoCallback.onReloadSuccess(getAdvertCode());
        }
    }

    @Override
    public void onPlacementContentStateChange(String placementId, PlacementContent placementcontent, UnityMonetization.PlacementContentState previousState, UnityMonetization.PlacementContentState newState) {
        YLog.d("Advert , Unityads  Video onPlacementContentStateChange: " + placementId);
    }


    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        MetaData gdprMetaData = new MetaData(context);
        gdprMetaData.set("gdpr.consent", privacy.isHasUserConsent());
        gdprMetaData.commit();
    }
}
