package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.integration.IntegrationHelper;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.InterstitialListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoListener;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

public class AdvertAdaptersupersonic extends AdapterAdvertBase {
    public static final String CHANNEL_CODE = "Supersonic";
    public static final String KEY_SUPERSONIC_APP_ID = "ad_supersonic_app_id";
    public static String SUPERSONIC_ID = "";
    RewardedVideoListener mRewardedVideoListener = new RewardedVideoListener() {

        @Override
        public void onRewardedVideoAdClosed() {
            // TODO Auto-generated method stub
            // called when the video is closed
            YLog.d("Supersonic.onRewardedVideoAdClosed");
            // here we show a dialog to the user if he was rewarded
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAvailabilityChanged(boolean available) {
            YLog.d("Supersonic.onVideoAvailabilityChanged : " + available);
            if (reloadVideoCallback != null) {
                if (available) {
                    reloadVideoCallback.onReloadSuccess(getAdvertCode());
                }

            }
        }

        @Override
        public void onRewardedVideoAdStarted() {
            YLog.d("Supersonic onRewardedVideoAdStarted ");
        }

        @Override
        public void onRewardedVideoAdEnded() {
            YLog.d("Supersonic onRewardedVideoAdEnded ");
        }


        @Override
        public void onRewardedVideoAdShowFailed(IronSourceError ironSourceError) {
            YLog.i("Supersonic.onRewardedVideoShowFail" + ironSourceError.getErrorMessage());
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, ironSourceError.getErrorCode(), ironSourceError.getErrorMessage(), getAdvertCode());
            }
            if (videoCallback != null) {
                videoCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_DISPLAY_FAILED, "onRewardedVideoAdShowFailed ： " + ironSourceError.getErrorMessage(), getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdClicked(Placement placement) {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdOpened() {
            // TODO Auto-generated method stub
            YLog.d("Supersonic.onRewardedVideoAdOpened");
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdRewarded(Placement placement) {
            // TODO Auto-generated method stub
            // called when the video has been rewarded and a reward can be given to the user
            String rewardName = placement.getRewardName();
            int rewardAmount = placement.getRewardAmount();
            YLog.d("Supersonic, onRewardedVideoAdRewarded: rewardName=" + rewardName + ", rewardAmount=" + rewardAmount);

            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }

        }

    };
    private Yodo1AdCallback intersititalCallback, videoCallback; //插屏回调
    private Yodo1ReloadCallback reloadInterCallback, reloadVideoCallback;
    InterstitialListener listener = new InterstitialListener() {
        @Override
        public void onInterstitialAdReady() {

            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdLoadFailed(IronSourceError ironSourceError) {

            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, ironSourceError.getErrorCode(), ironSourceError.getErrorMessage(), getAdvertCode());
            }
            YLog.d("Supersonic onInterstitialAdLoadFailed  = " + ironSourceError.getErrorCode() + "   msg = " + ironSourceError.getErrorMessage());
        }

        @Override
        public void onInterstitialAdOpened() {

        }

        @Override
        public void onInterstitialAdClosed() {
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdShowSucceeded() {
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdShowFailed(IronSourceError ironSourceError) {
            YLog.d("Supersonic onInterstitialAdShowFailed  = " + ironSourceError.getErrorCode());
            if (intersititalCallback != null) {
                intersititalCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_DISPLAY_FAILED, "onInterstitialAdShowFailed", getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdClicked() {
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }


    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }


    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1AdCallback callback) {
        this.intersititalCallback = callback;

        YLog.d("Supersonic show");
        if (TextUtils.isEmpty(SUPERSONIC_ID)) {
            YLog.i("Supersonic  APPID  is null");
            intersititalCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
            return;
        }
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (IronSource.isInterstitialReady()) {
                    //show the interstitial
                    IronSource.showInterstitial();
                } else {
                    if (intersititalCallback != null) {
                        intersititalCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
                    }
                }

            }
        });

    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadInterCallback = callback;
        if (TextUtils.isEmpty(SUPERSONIC_ID)) {
            YLog.i("Supersonic  APPID  is null");
            reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "", getAdvertCode());
            return;
        }
        IronSource.loadInterstitial();

    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return IronSource.isInterstitialReady();
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;
        YLog.d("Supersonic, showVideoAdvert ... ");
        if (videoAdvertIsLoaded(activity)) {
            //show rewarded video
            IronSource.showRewardedVideo();
        } else {
            videoCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;

        YLog.d("Supersonic, requestRewardVideo ... ");
        if (TextUtils.isEmpty(SUPERSONIC_ID)) {
            YLog.i("Supersonic  APPID  is null");
            reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "", getAdvertCode());
            return;
        }

    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {

        return IronSource.isRewardedVideoAvailable();
    }


    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(Activity activity) {
        SUPERSONIC_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE
                , KEY_SUPERSONIC_APP_ID);
        if (TextUtils.isEmpty(SUPERSONIC_ID)) {
            SUPERSONIC_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE
                    , KEY_SUPERSONIC_APP_ID);
        }

        if (TextUtils.isEmpty(SUPERSONIC_ID)) {
            YLog.i("Supersonic  APPID  is null");
            return;
        }
        //Init Interstitial
        IronSource.init(activity, SUPERSONIC_ID);
        IronSource.setInterstitialListener(listener);

        IronSource.setRewardedVideoListener(mRewardedVideoListener);
        IntegrationHelper.validateIntegration(activity);

    }


    @Override
    public void onResume(Activity activity) {
        if (TextUtils.isEmpty(SUPERSONIC_ID)) {
            YLog.i("Supersonic  APPID  is null");
            return;
        }
        IronSource.onResume(activity);
    }

    @Override
    public void onPause(Activity activity) {

        if (TextUtils.isEmpty(SUPERSONIC_ID)) {
            YLog.i("Supersonic  APPID  is null");
            return;
        }
        IronSource.onPause(activity);
    }


    @Override
    public void onDestroy(Activity activity) {
    }


    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        IronSource.setConsent(privacy.isHasUserConsent());
    }
}
