package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.os.Handler;
import android.text.TextUtils;

import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AudienceNetworkAds;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdListener;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdListener;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

public class AdvertAdapterfacebook extends AdapterAdvertBase {
    public static final String CHANNEL_CODE = "FaceBook";
    public static final String CONFIG_KEY_FACEBOOK_INTERSTITIAL_ID = "ad_facebook_sdk_key";
    public static final String CONFIG_KEY_FACEBOOK_VIDEO_ID = "ad_facebook_video_key";
    public static String INTERSTITIAL_ID = "";
    public static String VIDEO_ID = "";
    private Yodo1AdCallback intersititalCallback, videoCallback; //插屏回调
    private Yodo1ReloadCallback reloadInterCallback, reloadVideoCallback;
    private InterstitialAd interstitialAd;
    private RewardedVideoAd rewardedVideoAd = null;
    private boolean videoClose = true;
    private InterstitialAdListener adInterListener = new InterstitialAdListener() {
        @Override
        public void onInterstitialDisplayed(Ad ad) {
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onInterstitialDismissed(Ad ad) {
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

        }

        @Override
        public void onError(Ad ad, AdError adError) {

            YLog.i("Advert " + "异常码： " + adError.getErrorCode() + " 错误信息：" + adError.getErrorMessage());
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, adError.getErrorCode(), adError.getErrorMessage(), getAdvertCode());
            }
        }

        @Override
        public void onAdLoaded(Ad ad) {
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadSuccess(getAdvertCode());
            }

        }

        @Override
        public void onLoggingImpression(Ad ad) {

        }

        @Override
        public void onAdClicked(Ad ad) {
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }

        }
    };

    private RewardedVideoAdListener adVideoListener = new RewardedVideoAdListener() {
        @Override
        public void onRewardedVideoCompleted() {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onLoggingImpression(Ad ad) {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoClosed() {
            YLog.d("FaceBook onRewardedVideoClosed ");
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

        }

        @Override
        public void onError(Ad ad, AdError adError) {
            YLog.i("FaceBook Error = " + adError.getErrorMessage());
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, adError.getErrorCode(), adError.getErrorMessage(), getAdvertCode());
            }
        }

        @Override
        public void onAdLoaded(Ad ad) {
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onAdClicked(Ad ad) {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };


    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }


    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1AdCallback callback) {
        this.intersititalCallback = callback;

        if (TextUtils.isEmpty(INTERSTITIAL_ID)) {
            YLog.i("Facebook  interstitialId  is null");
            intersititalCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "Facebook  interstitialId  is null", getAdvertCode());
            return;
        }


        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {

                try {
                    if (interstitialAd != null && interstitialAd.isAdLoaded()) {
                        interstitialAd.show();
                    } else {
                        intersititalCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
                    }
                } catch (Exception exception) {
                    intersititalCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
                }
            }
        });
    }


    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return interstitialAd != null && interstitialAd.isAdLoaded() && !interstitialAd.isAdInvalidated();
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadInterCallback = callback;
        if (TextUtils.isEmpty(INTERSTITIAL_ID)) {
            YLog.i("Facebook  interstitialId  is null");
            callback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "", getAdvertCode());
            return;
        }

        if (interstitialAd != null) {
            interstitialAd.loadAd();
        }

    }

    /**
     * 播放
     *
     * @param activity
     * @param callback
     */
    @Override
    public void showVideoAdvert(final Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;
        YLog.d("FaceBook, showRewardVideo ...");
        if (TextUtils.isEmpty(VIDEO_ID)) {
            YLog.i("Facebook  videoId  is null");
            videoCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "Facebook  videoId  is null", getAdvertCode());
            return;
        }


        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {

                if (videoAdvertIsLoaded(activity)) {
                    rewardedVideoAd.show();
                } else {
                    if (videoCallback != null) {
                        videoCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
                    }
                }
            }
        });

    }

    /**
     * 预加载
     *
     * @param activity
     * @param reloadCallback
     */
    @Override
    public void reloadVideoAdvert(final Activity activity, final Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;
        YLog.d("FaceBook, reloadVideoAdvert ...");
        if (TextUtils.isEmpty(VIDEO_ID)) {
            YLog.i("Facebook  videoId  is null");
            reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "", getAdvertCode());
            return;
        }

        new Handler().postDelayed(new Runnable() {
            public void run() {
                // Check if rewardedVideoAd has been loaded successfully
                if (rewardedVideoAd == null || rewardedVideoAd.isAdLoaded()) {
                    return;
                }

                rewardedVideoAd.loadAd();
            }
        }, 1000);


    }


    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return rewardedVideoAd != null && rewardedVideoAd.isAdLoaded() && !rewardedVideoAd.isAdInvalidated();
    }


    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(Activity activity) {

        INTERSTITIAL_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd,
                CHANNEL_CODE, CONFIG_KEY_FACEBOOK_INTERSTITIAL_ID);
        VIDEO_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd,
                CHANNEL_CODE, CONFIG_KEY_FACEBOOK_VIDEO_ID);

        AudienceNetworkAds.initialize(activity);

        initInter(activity);
        initVideo(activity);
        AdSettings.addTestDevice("e98994af-e450-4d12-b3ce-50976cf15fce");
    }


    private void initInter(Activity activity) {
        if (!TextUtils.isEmpty(INTERSTITIAL_ID)) {
            interstitialAd = new InterstitialAd(activity, INTERSTITIAL_ID);
            interstitialAd.setAdListener(adInterListener);
        }

    }

    private void initVideo(Activity activity) {

        if (!TextUtils.isEmpty(VIDEO_ID)) {
            rewardedVideoAd = new RewardedVideoAd(activity, VIDEO_ID);
            rewardedVideoAd.setAdListener(adVideoListener);
        }
    }


    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {
        if (interstitialAd != null) {
            interstitialAd.destroy();
            interstitialAd = null;
        }

        if (rewardedVideoAd != null) {
            rewardedVideoAd.destroy();
            rewardedVideoAd = null;
        }
    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        AdSettings.setIsChildDirected(privacy.isAgeRestrictedUser());

    }

}
