package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.chartboost.sdk.CBLocation;
import com.chartboost.sdk.Chartboost;
import com.chartboost.sdk.ChartboostDelegate;
import com.chartboost.sdk.Libraries.CBLogging;
import com.chartboost.sdk.Model.CBError;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

public class AdvertAdapterchartboost extends AdapterAdvertBase {
    public static final String CHANNEL_CODE = "Chartboost";
    public static final String KEY_CHARTBOOST_APP_ID = "ad_chartboost_app_id";
    public static final String KEY_CHARTBOOST_SIGNATURE_ID = "ad_chartboost_signature_id";
    public static String CHARTBOOST_APP_ID = "";
    public static String CHARTBOOST_SIGNATURE_ID = "";
    private Yodo1AdCallback intersititalCallback, videoCallback; //插屏回调
    private Yodo1ReloadCallback reloadInterCallback, reloadVideoCallback;
    ChartboostDelegate delegate = new ChartboostDelegate() {

        @Override
        public boolean shouldRequestInterstitial(String location) {
            YLog.i("Chartboost shouldRequestInterstitial, location = " + location);
            return true;
        }

        @Override
        public boolean shouldDisplayInterstitial(String location) {
            YLog.i("Chartboost shouldDisplayInterstitial, location = " + location);
            return true;
        }

        @Override
        public void didCacheInterstitial(String location) {
            YLog.i("Chartboost didCacheInterstitial, location = " + location);
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void didFailToLoadInterstitial(String location, CBError.CBImpressionError error) {
            YLog.i("Chartboost didFailToLoadInterstitial, location = " + error.toString());
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, "error : " + error.name(), getAdvertCode());
            }
        }

        @Override
        public void didDismissInterstitial(String location) {
            YLog.i("Chartboost didDismissInterstitial, location = " + location);
        }

        @Override
        public void didCloseInterstitial(String location) {
            YLog.i("Chartboost didCloseInterstitial, location = " + location);
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void didClickInterstitial(String location) {
            YLog.i("Chartboost didClickInterstitial, location = " + location);
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void didDisplayInterstitial(String location) {
            YLog.i("Chartboost didDisplayInterstitial, location = " + location);
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }


        @Override
        public void didFailToRecordClick(String uri, CBError.CBClickError error) {
            YLog.d("Chartboost didFailToRecordClick, error = " + error + ", uri = " + uri);
        }

        @Override
        public boolean shouldDisplayRewardedVideo(String location) {
            YLog.d("Chartboost shouldDisplayRewardedVideo, location = " + location);
            return true;
        }

        @Override
        public void didCacheRewardedVideo(String location) {
            YLog.d("Chartboost didCacheRewardedVideo, location = " + location);

            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void didFailToLoadRewardedVideo(String location,
                                               CBError.CBImpressionError error) {
            YLog.i("Chartboost didFailToLoadRewardedVideo, location = " + location + ", error = " + error);

            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, "error : " + error.name(), getAdvertCode());
            }

        }

        @Override
        public void didDismissRewardedVideo(String location) {
            YLog.d("Chartboost didDismissRewardedVideo, location = " + location);
        }

        @Override
        public void didCloseRewardedVideo(String location) {
            YLog.d("Chartboost didCloseRewardedVideo, location = " + location);
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

        }

        @Override
        public void didClickRewardedVideo(String location) {
            YLog.d("Chartboost didClickRewardedVideo, location = " + location);
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }

        }

        @Override
        public void didCompleteRewardedVideo(String location, int reward) {
            YLog.d("Chartboost didCompleteRewardedVideo, location = " + location + ", reward = " + reward);
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }

        }

        @Override
        public void didDisplayRewardedVideo(String location) {
            YLog.d("Chartboost didDisplayRewardedVideo, location = " + location);
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }

        }

        @Override
        public void willDisplayVideo(String location) {
            YLog.d("Chartboost willDisplayVideo, location = " + location);
        }

    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }


    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1AdCallback callback) {
        this.intersititalCallback = callback;
        YLog.i("Chartboost showIntersititalAdvert, 展示");
        if (TextUtils.isEmpty(CHARTBOOST_APP_ID) && TextUtils.isEmpty(CHARTBOOST_SIGNATURE_ID)) {
            YLog.i("Chartboost  appid  is null");
            intersititalCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "Chartboost  appid  is null", getAdvertCode());
            return;
        }
        if (interstitialAdvertIsLoaded(activity)) {
            Chartboost.showInterstitial(CBLocation.LOCATION_LEADERBOARD);
        } else {
            YLog.i("Chartboost showIntersititalAdvert, 未成功预加载");
            intersititalCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadInterCallback = callback;
        if (TextUtils.isEmpty(CHARTBOOST_APP_ID) && TextUtils.isEmpty(CHARTBOOST_SIGNATURE_ID)) {
            YLog.i("Chartboost  appid  is null");
            return;
        }
        Chartboost.cacheInterstitial(CBLocation.LOCATION_LEADERBOARD);
        YLog.i("Chartboost reloadInterstitialAdvert, 预加载");
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        if (TextUtils.isEmpty(CHARTBOOST_APP_ID) && TextUtils.isEmpty(CHARTBOOST_SIGNATURE_ID)) {
            YLog.i("Chartboost  appid  is null");
            return false;
        }
        return Chartboost.hasInterstitial(CBLocation.LOCATION_LEADERBOARD);
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;
        YLog.d("Chartboost, showRewardVideo ...");
        if (videoAdvertIsLoaded(activity)) {
            Chartboost.showRewardedVideo(CBLocation.LOCATION_DEFAULT);
        } else {
            if (callback != null) {
                videoCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());

            }
        }

    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;

        if (TextUtils.isEmpty(CHARTBOOST_APP_ID) && TextUtils.isEmpty(CHARTBOOST_SIGNATURE_ID)) {
            YLog.i("Chartboost  appid  is null");
            return;
        }

        YLog.d("Chartboost, reloadVideoAdvert ...");
        Chartboost.cacheRewardedVideo(CBLocation.LOCATION_DEFAULT);

    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        if (TextUtils.isEmpty(CHARTBOOST_APP_ID) && TextUtils.isEmpty(CHARTBOOST_SIGNATURE_ID)) {
            YLog.i("Chartboost  appid  is null");
            return false;
        }
        YLog.d("Chartboost, videoAdvertIsLoaded ==" + Chartboost.hasRewardedVideo(CBLocation.LOCATION_DEFAULT));
        return Chartboost.hasRewardedVideo(CBLocation.LOCATION_DEFAULT);
    }


    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {

        CHARTBOOST_APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd
                , CHANNEL_CODE, KEY_CHARTBOOST_APP_ID);
        CHARTBOOST_SIGNATURE_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd
                , CHANNEL_CODE, KEY_CHARTBOOST_SIGNATURE_ID);

//        CHARTBOOST_APP_ID =   "4f7b433509b6025804000002";
//        CHARTBOOST_SIGNATURE_ID = "dd2d41b69ac01b80f443f5b6cf06096d457f82bd";

        if (TextUtils.isEmpty(CHARTBOOST_APP_ID) && TextUtils.isEmpty(CHARTBOOST_SIGNATURE_ID)) {
            YLog.i("Chartboost  appid  is null");
            return;
        }

        Chartboost.startWithAppId(activity, CHARTBOOST_APP_ID, CHARTBOOST_SIGNATURE_ID);
        Chartboost.setLoggingLevel(CBLogging.Level.ALL);
        Chartboost.setActivityAttrs(activity);
        Chartboost.onCreate(activity);
        Chartboost.onStart(activity);
        Chartboost.onResume(activity);
        Chartboost.setAutoCacheAds(true);
        YLog.i("Chartboost  初始化完成");

        Chartboost.setDelegate(delegate);
    }

    @Override
    public void onResume(Activity activity) {
        if (TextUtils.isEmpty(CHARTBOOST_APP_ID) && TextUtils.isEmpty(CHARTBOOST_SIGNATURE_ID)) {
            YLog.i("Chartboost  appid  is null");
            return;
        }

        Chartboost.onStart(activity);
        Chartboost.onResume(activity);


    }

    @Override
    public void onPause(Activity activity) {
        if (TextUtils.isEmpty(CHARTBOOST_APP_ID) && TextUtils.isEmpty(CHARTBOOST_SIGNATURE_ID)) {
            YLog.i("Chartboost  appid  is null");
            return;
        }
        Chartboost.onPause(activity);
        Chartboost.onStop(activity);
    }


    @Override
    public void onDestroy(Activity activity) {
        if (TextUtils.isEmpty(CHARTBOOST_APP_ID) && TextUtils.isEmpty(CHARTBOOST_SIGNATURE_ID)) {
            YLog.i("Chartboost  appid  is null");
            return;
        }
        Chartboost.onDestroy(activity);
    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        Chartboost.CBPIDataUseConsent consent = privacy.isHasUserConsent() ? Chartboost.CBPIDataUseConsent.YES_BEHAVIORAL : Chartboost.CBPIDataUseConsent.NO_BEHAVIORAL;
        Chartboost.setPIDataUseConsent(context, consent);
    }
}
