package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.ads.MaxInterstitialAd;
import com.applovin.mediation.ads.MaxRewardedAd;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;


public class AdvertAdapterapplovinmax extends AdapterAdvertBase {

    public static final String KEY_Applovin_INTERSTITIAL_ID = "ad_applovin_interstitial_id";
    public static final String KEY_Applovin_VIDEO_ID = "ad_applovin_video_id";
    public static final String CHANNEL_CODE_MAX = "ApplovinMax";
    private Yodo1AdCallback intersititalCallback, videoCallback; //插屏回调
    private Yodo1ReloadCallback reloadInterCallback, reloadVideoCallback;
    private MaxInterstitialAd interstitialAd;
    private MaxRewardedAd rewardedAd;

    private MaxAdListener adListener = new MaxAdListener() {
        @Override
        public void onAdLoaded(MaxAd maxAd) {
            YLog.d("Applovin Interstitial onAdDisplayed :  " + maxAd.getAdUnitId());
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onAdLoadFailed(String s, int i) {
            YLog.d("Applovin Interstitial onAdDisplayed :  " + s + "   " + i);
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, "error: " + s, getAdvertCode());
            }

            if (interstitialAd != null) {
                // Load the first ad
                interstitialAd.loadAd();
            }
        }

        @Override
        public void onAdDisplayed(MaxAd maxAd) {
            YLog.d("Applovin Interstitial onAdDisplayed :  " + maxAd.getAdUnitId());
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdHidden(MaxAd maxAd) {
            YLog.d("Applovin Interstitial onAdHidden :  " + maxAd.getAdUnitId());
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

            if (interstitialAd != null) {
                // Load the first ad
                interstitialAd.loadAd();
            }
        }

        @Override
        public void onAdClicked(MaxAd maxAd) {
            YLog.d("Applovin Interstitial onAdClicked :  " + maxAd.getAdUnitId());
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdDisplayFailed(MaxAd maxAd, int i) {
            YLog.d("Applovin Interstitial onAdDisplayFailed :  " + maxAd.getAdUnitId());
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, "error: " + maxAd.getAdUnitId(), getAdvertCode());
            }
            if (interstitialAd != null) {
                // Load the first ad
                interstitialAd.loadAd();
            }
        }
    };
    private MaxRewardedAdListener adVideoListener = new MaxRewardedAdListener() {
        @Override
        public void onAdLoaded(MaxAd maxAd) {
            YLog.d("Applovin Video onAdLoaded");
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onAdLoadFailed(String s, int i) {
            YLog.d("Applovin Video  onAdLoadFailed, : " + i + "   " + s);
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, s, getAdvertCode());
            }

            if (rewardedAd != null) {
                rewardedAd.loadAd();
            }
        }

        @Override
        public void onAdDisplayed(MaxAd maxAd) {
            YLog.d("Applovin Video onAdDisplayed :  " + maxAd.getAdUnitId());

        }

        @Override
        public void onAdHidden(MaxAd maxAd) {
            YLog.d("Applovin Video onAdHidden :  " + maxAd.getAdUnitId());
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

            if (rewardedAd != null) {
                rewardedAd.loadAd();
            }
        }

        @Override
        public void onAdClicked(MaxAd maxAd) {
            YLog.d("Applovin Video onAdClicked :  " + maxAd.getAdUnitId());
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdDisplayFailed(MaxAd maxAd, int i) {
            YLog.w("Advert, Applovin Video onAdDisplayFailed, : " + i + "   " + maxAd.getAdUnitId());
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, "error :  " + maxAd.getAdUnitId(), getAdvertCode());
            }

            if (rewardedAd != null) {
                rewardedAd.loadAd();
            }
        }

        @Override
        public void onRewardedVideoStarted(MaxAd maxAd) {
            YLog.d("Applovin Video onRewardedVideoStarted :  " + maxAd.getAdUnitId());
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoCompleted(MaxAd maxAd) {
            YLog.d("Applovin Video onRewardedVideoCompleted :  " + maxAd.getAdUnitId());
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onUserRewarded(MaxAd maxAd, MaxReward maxReward) {

        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE_MAX;
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;

        if (rewardedAd != null && rewardedAd.isReady()) {
            rewardedAd.showAd();
        } else {
            videoCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());

        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;

        if (rewardedAd != null) {
            rewardedAd.loadAd();
        } else {
            reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "error : ID NULL", getAdvertCode());
        }

    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return rewardedAd != null && rewardedAd.isReady();
    }


    //    预加载
    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadInterCallback = callback;
        if (interstitialAd != null) {
            // Load the first ad
            interstitialAd.loadAd();
        } else {
            callback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "ID NULL", getAdvertCode());
        }
    }


    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return interstitialAd != null && interstitialAd.isReady();
    }

    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.intersititalCallback = callback;
        if (interstitialAd != null && interstitialAd.isReady()) {
            // Load the first ad
            interstitialAd.showAd();
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }

    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(final Activity activity) {
        AppLovinSdk.initializeSdk(activity, new AppLovinSdk.SdkInitializationListener() {
            @Override
            public void onSdkInitialized(final AppLovinSdkConfiguration configuration) {
                // AppLovin SDK is initialized, start loading ads
                YLog.d("AppLovin SDK is initialized : " + configuration.getConsentDialogState().name());

                initApplovinInter(activity);
                initApplovinVideo(activity);
            }
        });


    }

    private void initApplovinInter(Activity activity) {

        String unitID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE_MAX
                , KEY_Applovin_INTERSTITIAL_ID);

        if (TextUtils.isEmpty(unitID)) {
            return;
        }
        interstitialAd = new MaxInterstitialAd(unitID, activity);
        interstitialAd.setListener(adListener);
    }


    private void initApplovinVideo(Activity activity) {
        String unitID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE_MAX
                , KEY_Applovin_VIDEO_ID);

        if (TextUtils.isEmpty(unitID)) {
            return;
        }

        rewardedAd = MaxRewardedAd.getInstance(unitID, activity);
        rewardedAd.setListener(adVideoListener);
    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }


    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {

        YLog.d("Applovin setPrivacy :  " + privacy.isHasUserConsent());
        YLog.d("Applovin setPrivacy :  " + privacy.isAgeRestrictedUser());
        AppLovinPrivacySettings.setHasUserConsent(privacy.isHasUserConsent(), context);
        AppLovinPrivacySettings.setHasUserConsent(privacy.isAgeRestrictedUser(), context);
    }

}
