package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;

import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.adview.AppLovinInterstitialAd;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinErrorCodes;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

import java.util.Map;


public class AdvertAdapterapplovin extends AdapterAdvertBase implements AppLovinAdLoadListener,
        AppLovinAdDisplayListener, AppLovinAdClickListener, AppLovinAdVideoPlaybackListener,
        AppLovinAdRewardListener {

    public static final String CHANNEL_CODE = "Applovin";
    // Ad Dispaly Listener
    AppLovinAdDisplayListener adDisplayListener = new AppLovinAdDisplayListener() {
        @Override
        public void adDisplayed(AppLovinAd appLovinAd) {
            YLog.i("Ad Displayed");

        }

        @Override
        public void adHidden(AppLovinAd appLovinAd) {
            YLog.i("Ad Dismissed");
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }
    };
    // Ad Click Listener
    AppLovinAdClickListener adClickListener = new AppLovinAdClickListener() {
        @Override
        public void adClicked(AppLovinAd appLovinAd) {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };
    private Yodo1AdCallback intersititalCallback, videoCallback; //插屏回调
    private Yodo1ReloadCallback reloadInterCallback, reloadVideoCallback;
    private AppLovinAd currentAd;
    private AppLovinIncentivizedInterstitial myIncent;
    private AppLovinAdLoadListener adLoadListener = new AppLovinAdLoadListener() {
        @Override
        public void adReceived(AppLovinAd appLovinAd) {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_LOADED, getAdvertCode());
            }

            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void failedToReceiveAd(int errorCode) {
            YLog.w("Advert, Applovin Video onAdError, adError code = " + errorCode);
            if (errorCode == AppLovinErrorCodes.NO_FILL) {
                // Indicates that no ads are currently eligible for your device & location.
                YLog.w("Advert, Applovin Video onAdError, NO_FILL ");

                if (reloadVideoCallback != null) {
                    reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode, "error : NO_FILL", getAdvertCode());
                }
            } else {
                // Unable to reach AppLovin; the user's device is likely experiencing poor connectivity.
                if (reloadVideoCallback != null) {
                    reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode, "error : " + errorCode, getAdvertCode());
                }
            }
        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
    }

    //    预加载
    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadInterCallback = callback;
        AppLovinSdk.getInstance(activity.getApplicationContext()).getAdService().loadNextAd(AppLovinAdSize.INTERSTITIAL, this);
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return currentAd == null ? false : true;
    }

    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.intersititalCallback = callback;
        if (currentAd != null) {

            final AppLovinSdk sdk = AppLovinSdk.getInstance(activity);

            final AppLovinInterstitialAdDialog interstitialAd = AppLovinInterstitialAd.create(sdk, activity);
            interstitialAd.setAdDisplayListener(this);
            interstitialAd.setAdClickListener(this);
            interstitialAd.setAdVideoPlaybackListener(this);
            interstitialAd.showAndRender(currentAd);
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }

    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
        AppLovinSdk.initializeSdk(activity, new AppLovinSdk.SdkInitializationListener() {
            @Override
            public void onSdkInitialized(final AppLovinSdkConfiguration configuration) {
                // AppLovin SDK is initialized, start loading ads
                YLog.d("AppLovin SDK is initialized : " + configuration.getConsentDialogState().name());
            }
        });
    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void onDestroy(Activity activity) {
        if (myIncent != null) {
            myIncent.dismiss();
        }
    }

    @Override
    public void adClicked(AppLovinAd appLovinAd) {
        if (intersititalCallback != null) {
            intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
        }
    }

    @Override
    public void adDisplayed(AppLovinAd appLovinAd) {
        if (intersititalCallback != null) {
            intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
        }
    }

    @Override
    public void adHidden(AppLovinAd appLovinAd) {
        if (intersititalCallback != null) {
            intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
        }


    }

    @Override
    public void adReceived(AppLovinAd appLovinAd) {
        currentAd = appLovinAd;
        if (reloadInterCallback != null) {
            reloadInterCallback.onReloadSuccess(getAdvertCode());
        }
    }

    @Override
    public void failedToReceiveAd(int i) {
        if (reloadInterCallback != null) {
            reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, "error: " + i, getAdvertCode());
        }
    }


    @Override
    public void userRewardVerified(AppLovinAd ad, Map<String, String> response) {

    }

    @Override
    public void userOverQuota(AppLovinAd ad, Map<String, String> response) {

    }

    @Override
    public void userRewardRejected(AppLovinAd ad, Map<String, String> response) {

    }

    @Override
    public void validationRequestFailed(AppLovinAd ad, int errorCode) {

    }

    @Override
    public void userDeclinedToViewAd(AppLovinAd ad) {

    }

    @Override
    public void videoPlaybackBegan(AppLovinAd appLovinAd) {
        if (videoCallback != null) {
            videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
        }
    }

    @Override
    public void videoPlaybackEnded(AppLovinAd appLovinAd, double v, boolean b) {
        if (videoCallback != null) {
            videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
        }
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;
        if (myIncent.isAdReadyToDisplay()) {
            myIncent.show(activity, this, this, adDisplayListener, adClickListener);
        } else {
            videoCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;
        myIncent = AppLovinIncentivizedInterstitial.create(activity);
        myIncent.preload(adLoadListener);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return myIncent.isAdReadyToDisplay();
    }


    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        AppLovinPrivacySettings.setHasUserConsent(privacy.isHasUserConsent(), context);
        AppLovinPrivacySettings.setHasUserConsent(privacy.isAgeRestrictedUser(), context);
    }
}
