/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.applovin;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinAdViewDisplayErrorCode;
import com.applovin.adview.AppLovinAdViewEventListener;
import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.adview.AppLovinInterstitialAd;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkSettings;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdapterUtils;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IntegrationData;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

class AppLovinAdapter
extends AbstractAdapter {
    private static final String VERSION = "4.3.4";
    private static final String GitHash = "f2e5bcb59";
    private static final String ZONE_ID = "zoneId";
    private static final String SDK_KEY = "sdkKey";
    private Activity mActivity;
    private AppLovinSdk mAppLovinSdk;
    private Boolean mDidInitSdk = false;
    private ConcurrentHashMap<String, ALBannerListener> mZoneIdToAppLovinListener;
    private ConcurrentHashMap<String, BannerSmashListener> mZoneIdToBannerSmashListener;
    private ConcurrentHashMap<String, FrameLayout.LayoutParams> mZoneIdToBannerLayout;
    private ConcurrentHashMap<String, AppLovinAdView> mZoneIdToBannerAd;
    private ConcurrentHashMap<String, Boolean> mZoneIdToIsAdReadyStatus;
    private ConcurrentHashMap<String, AppLovinAd> mZoneIdToIsAd;
    private ConcurrentHashMap<String, AppLovinInterstitialAdDialog> mZoneIdToIsAdDialog;
    private ConcurrentHashMap<String, InterstitialSmashListener> mZoneIdToIsListener;
    private ConcurrentHashMap<String, AppLovinIncentivizedInterstitial> mZoneIdToRvAd;
    private ConcurrentHashMap<String, RewardedVideoSmashListener> mZoneIdToRvListener;
    private Boolean mConsentCollectingUserData = null;

    public static AppLovinAdapter startAdapter(String string) {
        return new AppLovinAdapter(string);
    }

    private AppLovinAdapter(String string) {
        super(string);
        this.mAllBannerSmashes = new CopyOnWriteArrayList();
        this.mZoneIdToAppLovinListener = new ConcurrentHashMap();
        this.mZoneIdToBannerSmashListener = new ConcurrentHashMap();
        this.mZoneIdToBannerLayout = new ConcurrentHashMap();
        this.mZoneIdToBannerAd = new ConcurrentHashMap();
        this.mZoneIdToIsAd = new ConcurrentHashMap();
        this.mZoneIdToIsAdDialog = new ConcurrentHashMap();
        this.mZoneIdToRvAd = new ConcurrentHashMap();
        this.mZoneIdToIsListener = new ConcurrentHashMap();
        this.mZoneIdToRvListener = new ConcurrentHashMap();
        this.mZoneIdToIsAdReadyStatus = new ConcurrentHashMap();
    }

    public static IntegrationData getIntegrationData(Activity activity) {
        IntegrationData integrationData = new IntegrationData("AppLovin", VERSION);
        integrationData.activities = new String[]{"com.applovin.adview.AppLovinInterstitialActivity", "com.applovin.adview.AppLovinConfirmationActivity"};
        return integrationData;
    }

    public static String getAdapterSDKVersion() {
        String string = null;
        try {
            string = "9.2.1";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return "9.2.1";
    }

    public void onResume(Activity activity) {
        this.mActivity = activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConsent(boolean bl) {
        AppLovinAdapter appLovinAdapter = this;
        synchronized (appLovinAdapter) {
            if (this.mDidInitSdk.booleanValue()) {
                AppLovinPrivacySettings.setHasUserConsent((boolean)bl, (Context)this.mActivity);
            } else {
                this.mConsentCollectingUserData = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSdk(Activity activity, String string) {
        AppLovinAdapter appLovinAdapter = this;
        synchronized (appLovinAdapter) {
            if (!this.mDidInitSdk.booleanValue()) {
                AppLovinSdkSettings appLovinSdkSettings = new AppLovinSdkSettings();
                boolean bl = false;
                try {
                    bl = this.isAdaptersDebugEnabled();
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                appLovinSdkSettings.setVerboseLogging(bl);
                this.mAppLovinSdk = AppLovinSdk.getInstance((String)string, (AppLovinSdkSettings)appLovinSdkSettings, (Context)activity);
                this.mAppLovinSdk.initializeSdk();
                this.mDidInitSdk = true;
                if (this.mConsentCollectingUserData != null) {
                    this.setConsent(this.mConsentCollectingUserData);
                }
            }
        }
    }

    public void initRewardedVideo(final Activity activity, String string, final String string2, JSONObject jSONObject, final RewardedVideoSmashListener rewardedVideoSmashListener) {
        if (rewardedVideoSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " RV init failed: RewardedVideoSmashListener is empty", 2);
            return;
        }
        final String string3 = jSONObject.optString(SDK_KEY);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            return;
        }
        final String string4 = this.getZoneId(jSONObject);
        this.mActivity = activity;
        this.mZoneIdToRvListener.put(string4, rewardedVideoSmashListener);
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AppLovinAdapter.this.initSdk(activity, string3);
                AppLovinIncentivizedInterstitial appLovinIncentivizedInterstitial = null;
                appLovinIncentivizedInterstitial = !TextUtils.isEmpty((CharSequence)string4) ? AppLovinIncentivizedInterstitial.create((String)string4, (AppLovinSdk)AppLovinAdapter.this.mAppLovinSdk) : AppLovinIncentivizedInterstitial.create((AppLovinSdk)AppLovinAdapter.this.mAppLovinSdk);
                AppLovinAdapter.this.mZoneIdToRvAd.put(string4, appLovinIncentivizedInterstitial);
                appLovinIncentivizedInterstitial.setUserIdentifier(string2);
                appLovinIncentivizedInterstitial.preload(new AppLovinAdLoadListener(){

                    public void adReceived(AppLovinAd appLovinAd) {
                        rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(true);
                    }

                    public void failedToReceiveAd(int n2) {
                        rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
                    }
                });
            }
        });
    }

    public void fetchRewardedVideo(JSONObject jSONObject) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + ": in fetchRewardedVideo", 0);
        final String string = this.getZoneId(jSONObject);
        if (this.mZoneIdToRvAd.containsKey(string)) {
            this.mZoneIdToRvAd.get(string).preload(new AppLovinAdLoadListener(){

                public void adReceived(AppLovinAd appLovinAd) {
                    if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                        ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAvailabilityChanged(true);
                    }
                }

                public void failedToReceiveAd(int n2) {
                    if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                        ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAvailabilityChanged(false);
                    }
                }
            });
        }
    }

    public void showRewardedVideo(JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        String string = this.getZoneId(jSONObject);
        if (!(rewardedVideoSmashListener == null || this.mZoneIdToRvAd.containsKey(string) && this.mZoneIdToRvAd.get(string).isAdReadyToDisplay())) {
            rewardedVideoSmashListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.getDynamicUserId())) {
            this.mZoneIdToRvAd.get(string).setUserIdentifier(this.getDynamicUserId());
        }
        this.mZoneIdToRvAd.get(string).show((Context)this.mActivity, new AppLovinAdRewardListener(){

            public void userRewardVerified(AppLovinAd appLovinAd, Map<String, String> map) {
            }

            public void userOverQuota(AppLovinAd appLovinAd, Map<String, String> map) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "userOverQuota", 1);
            }

            public void userRewardRejected(AppLovinAd appLovinAd, Map<String, String> map) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "userRewardRejected", 1);
            }

            public void validationRequestFailed(AppLovinAd appLovinAd, int n2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "validationRequestFailed " + AppLovinAdapter.this.getErrorString(n2) + "(" + n2 + ")", 1);
            }

            public void userDeclinedToViewAd(AppLovinAd appLovinAd) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "userDeclinedToViewAd", 1);
                String string = AppLovinAdapter.this.getZoneId(appLovinAd);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAdClosed();
                }
            }
        }, new AppLovinAdVideoPlaybackListener(){

            public void videoPlaybackBegan(AppLovinAd appLovinAd) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "videoPlaybackBegan", 1);
                String string = AppLovinAdapter.this.getZoneId(appLovinAd);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAdStarted();
                }
            }

            public void videoPlaybackEnded(AppLovinAd appLovinAd, double d2, boolean bl) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "videoPlaybackEnded ; isFullyWatched: " + bl, 1);
                String string = AppLovinAdapter.this.getZoneId(appLovinAd);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAdEnded();
                    if (bl) {
                        ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAdRewarded();
                    }
                }
            }
        }, new AppLovinAdDisplayListener(){

            public void adDisplayed(AppLovinAd appLovinAd) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "adDisplayed", 1);
                String string = AppLovinAdapter.this.getZoneId(appLovinAd);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAdOpened();
                }
            }

            public void adHidden(AppLovinAd appLovinAd) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "adHidden", 1);
                final String string = AppLovinAdapter.this.getZoneId(appLovinAd);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAvailabilityChanged(false);
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAdClosed();
                }
                if (AppLovinAdapter.this.mZoneIdToRvAd.containsKey(string)) {
                    ((AppLovinIncentivizedInterstitial)AppLovinAdapter.this.mZoneIdToRvAd.get(string)).preload(new AppLovinAdLoadListener(){

                        public void adReceived(AppLovinAd appLovinAd) {
                            if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                                ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAvailabilityChanged(true);
                            }
                        }

                        public void failedToReceiveAd(int n2) {
                            if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                                ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAvailabilityChanged(false);
                            }
                        }
                    });
                }
            }
        }, new AppLovinAdClickListener(){

            public void adClicked(AppLovinAd appLovinAd) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "adClicked", 1);
                String string = AppLovinAdapter.this.getZoneId(appLovinAd);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAdClicked();
                }
            }
        });
    }

    public synchronized boolean isRewardedVideoAvailable(JSONObject jSONObject) {
        String string = this.getZoneId(jSONObject);
        return this.mZoneIdToRvAd.containsKey(string) && this.mZoneIdToRvAd.get(string).isAdReadyToDisplay();
    }

    public void initInterstitial(final Activity activity, String string, String string2, JSONObject jSONObject, final InterstitialSmashListener interstitialSmashListener) {
        if (interstitialSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " IS init failed: InterstitialSmashListener is empty", 2);
            return;
        }
        final String string3 = jSONObject.optString(SDK_KEY);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            this.log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " initInterstitial empty sdkKey", 3);
            interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"initInterstitial empty sdkKey", (String)"Interstitial"));
            return;
        }
        final String string4 = this.getZoneId(jSONObject);
        this.mActivity = activity;
        this.mZoneIdToIsListener.put(string4, interstitialSmashListener);
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AppLovinAdapter.this.initSdk(activity, string3);
                AppLovinInterstitialAdDialog appLovinInterstitialAdDialog = AppLovinInterstitialAd.create((AppLovinSdk)AppLovinAdapter.this.mAppLovinSdk, (Context)activity);
                AppLovinAdapter.this.mZoneIdToIsAdDialog.put(string4, appLovinInterstitialAdDialog);
                appLovinInterstitialAdDialog.setAdClickListener(new AppLovinAdClickListener(){

                    public void adClicked(AppLovinAd appLovinAd) {
                        if (AppLovinAdapter.this.mZoneIdToIsListener.containsKey(string4)) {
                            ((InterstitialSmashListener)AppLovinAdapter.this.mZoneIdToIsListener.get(string4)).onInterstitialAdClicked();
                        }
                    }
                });
                appLovinInterstitialAdDialog.setAdDisplayListener(new AppLovinAdDisplayListener(){

                    public void adDisplayed(AppLovinAd appLovinAd) {
                        if (AppLovinAdapter.this.mZoneIdToIsListener.containsKey(string4)) {
                            ((InterstitialSmashListener)AppLovinAdapter.this.mZoneIdToIsListener.get(string4)).onInterstitialAdOpened();
                            ((InterstitialSmashListener)AppLovinAdapter.this.mZoneIdToIsListener.get(string4)).onInterstitialAdShowSucceeded();
                        }
                    }

                    public void adHidden(AppLovinAd appLovinAd) {
                        if (AppLovinAdapter.this.mZoneIdToIsListener.containsKey(string4)) {
                            ((InterstitialSmashListener)AppLovinAdapter.this.mZoneIdToIsListener.get(string4)).onInterstitialAdClosed();
                        }
                    }
                });
                interstitialSmashListener.onInterstitialInitSuccess();
            }
        });
    }

    public void loadInterstitial(JSONObject jSONObject, final InterstitialSmashListener interstitialSmashListener) {
        if (interstitialSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " IS load failed: InterstitialSmashListener is empty", 2);
            return;
        }
        final String string = this.getZoneId(jSONObject);
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " loadInterstitial <" + string + ">", 0);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.mAppLovinSdk.getAdService().loadNextAdForZoneId(string, new AppLovinAdLoadListener(){

                public void adReceived(AppLovinAd appLovinAd) {
                    IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Interstitial adReceived zoneId=" + AppLovinAdapter.this.getZoneId(appLovinAd), 1);
                    interstitialSmashListener.onInterstitialAdReady();
                    AppLovinAdapter.this.mZoneIdToIsAd.put(string, appLovinAd);
                    AppLovinAdapter.this.mZoneIdToIsAdReadyStatus.put(string, true);
                }

                public void failedToReceiveAd(int n2) {
                    String string2 = AppLovinAdapter.this.getErrorString(n2) + "( " + n2 + " )";
                    interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)string2));
                    AppLovinAdapter.this.mZoneIdToIsAdReadyStatus.put(string, false);
                }
            });
        } else {
            this.mAppLovinSdk.getAdService().loadNextAd(AppLovinAdSize.INTERSTITIAL, new AppLovinAdLoadListener(){

                public void adReceived(AppLovinAd appLovinAd) {
                    IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Interstitial adReceived", 1);
                    interstitialSmashListener.onInterstitialAdReady();
                    AppLovinAdapter.this.mZoneIdToIsAd.put(string, appLovinAd);
                    AppLovinAdapter.this.mZoneIdToIsAdReadyStatus.put(string, true);
                }

                public void failedToReceiveAd(int n2) {
                    String string2 = AppLovinAdapter.this.getErrorString(n2) + "( " + n2 + " )";
                    interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)string2));
                    AppLovinAdapter.this.mZoneIdToIsAdReadyStatus.put(string, false);
                }
            });
        }
    }

    public void showInterstitial(JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        String string = this.getZoneId(jSONObject);
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " showInterstitial <" + string + ">", 0);
        if (!(interstitialSmashListener == null || this.mZoneIdToIsAd.containsKey(string) && this.mZoneIdToIsAdDialog.containsKey(string))) {
            interstitialSmashListener.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
            return;
        }
        this.mZoneIdToIsAdDialog.get(string).showAndRender(this.mZoneIdToIsAd.get(string));
        this.mZoneIdToIsAdReadyStatus.put(string, false);
    }

    public boolean isInterstitialReady(JSONObject jSONObject) {
        String string = this.getZoneId(jSONObject);
        return this.mZoneIdToIsAdDialog.containsKey(string) && this.mZoneIdToIsAdReadyStatus.containsKey(string) && this.mZoneIdToIsAdReadyStatus.get(string) != false;
    }

    public void initBanners(final Activity activity, String string, String string2, JSONObject jSONObject, final BannerSmashListener bannerSmashListener) {
        if (bannerSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " initBanners listener == null", 3);
        }
        if (jSONObject == null || activity == null) {
            bannerSmashListener.onBannerInitFailed(ErrorBuilder.buildInitFailedError((String)"null parameters", (String)"Banner"));
            return;
        }
        final String string3 = jSONObject.optString(SDK_KEY);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            bannerSmashListener.onBannerInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params", (String)"Banner"));
            return;
        }
        this.mActivity = activity;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AppLovinAdapter.this.initSdk(activity, string3);
                bannerSmashListener.onBannerInitSuccess();
            }
        });
    }

    public void loadBanner(final IronSourceBannerLayout ironSourceBannerLayout, JSONObject jSONObject, final BannerSmashListener bannerSmashListener) {
        if (bannerSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " loadBanner listener == null", 3);
            return;
        }
        if (ironSourceBannerLayout == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " loadBanner banner == null", 3);
            return;
        }
        final AppLovinAdSize appLovinAdSize = this.calculateBannerSize(ironSourceBannerLayout.getSize(), AdapterUtils.isLargeScreen((Activity)ironSourceBannerLayout.getActivity()));
        if (appLovinAdSize == null) {
            bannerSmashListener.onBannerAdLoadFailed(ErrorBuilder.unsupportedBannerSize((String)this.getProviderName()));
            return;
        }
        final String string = this.getZoneId(jSONObject);
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " loadBanner: " + this.getProviderName() + ", zoneID <" + string + ">", 1);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    AppLovinAdView appLovinAdView;
                    FrameLayout.LayoutParams layoutParams;
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        layoutParams = AppLovinAdapter.this.calcLayoutParams(ironSourceBannerLayout.getSize(), appLovinAdSize, ironSourceBannerLayout.getActivity());
                        appLovinAdView = new AppLovinAdView(AppLovinAdapter.this.mAppLovinSdk, appLovinAdSize, (Context)ironSourceBannerLayout.getActivity());
                    } else {
                        layoutParams = AppLovinAdapter.this.calcLayoutParams(ISBannerSize.BANNER, AppLovinAdSize.BANNER, ironSourceBannerLayout.getActivity());
                        appLovinAdView = new AppLovinAdView(AppLovinAdapter.this.mAppLovinSdk, AppLovinAdSize.BANNER, (Context)ironSourceBannerLayout.getActivity());
                    }
                    ALBannerListener aLBannerListener = new ALBannerListener(string);
                    appLovinAdView.setAdLoadListener((AppLovinAdLoadListener)aLBannerListener);
                    appLovinAdView.setAdClickListener((AppLovinAdClickListener)aLBannerListener);
                    appLovinAdView.setAdDisplayListener((AppLovinAdDisplayListener)aLBannerListener);
                    appLovinAdView.setAdViewEventListener((AppLovinAdViewEventListener)aLBannerListener);
                    AppLovinAdapter.this.mZoneIdToBannerSmashListener.put(string, bannerSmashListener);
                    AppLovinAdapter.this.mZoneIdToBannerAd.put(string, appLovinAdView);
                    AppLovinAdapter.this.mZoneIdToBannerLayout.put(string, layoutParams);
                    AppLovinAdapter.this.mZoneIdToAppLovinListener.put(string, aLBannerListener);
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        appLovinAdView.loadNextAd();
                    } else {
                        AppLovinAdapter.this.mAppLovinSdk.getAdService().loadNextAdForZoneId(string, (AppLovinAdLoadListener)aLBannerListener);
                    }
                }
                catch (Exception exception) {
                    IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)(AppLovinAdapter.this.getProviderName() + " loadBanner exception " + exception.getMessage()));
                    bannerSmashListener.onBannerAdLoadFailed(ironSourceError);
                }
            }
        });
    }

    private AppLovinAdSize calculateBannerSize(ISBannerSize iSBannerSize, boolean bl) {
        switch (iSBannerSize.getDescription()) {
            case "BANNER": 
            case "LARGE": {
                return AppLovinAdSize.BANNER;
            }
            case "RECTANGLE": {
                return AppLovinAdSize.MREC;
            }
            case "SMART": {
                return bl ? AppLovinAdSize.LEADER : AppLovinAdSize.BANNER;
            }
            case "CUSTOM": {
                if (iSBannerSize.getHeight() < 40 || iSBannerSize.getHeight() > 60) break;
                return AppLovinAdSize.BANNER;
            }
        }
        return null;
    }

    private FrameLayout.LayoutParams calcLayoutParams(ISBannerSize iSBannerSize, AppLovinAdSize appLovinAdSize, Activity activity) {
        int n2 = 320;
        if (iSBannerSize.getDescription().equals("RECTANGLE")) {
            n2 = 300;
        } else if (iSBannerSize.getDescription().equals("SMART") && AdapterUtils.isLargeScreen((Activity)activity)) {
            n2 = 728;
        }
        int n3 = AdapterUtils.dpToPixels((Activity)activity, (int)n2);
        int n4 = AdapterUtils.dpToPixels((Activity)activity, (int)appLovinAdSize.getHeight());
        return new FrameLayout.LayoutParams(n3, n4, 17);
    }

    public void destroyBanner(JSONObject jSONObject) {
        String string = this.getZoneId(jSONObject);
        AppLovinAdView appLovinAdView = this.mZoneIdToBannerAd.get(string);
        if (appLovinAdView != null) {
            appLovinAdView.destroy();
        }
        if (this.mZoneIdToBannerAd != null) {
            this.mZoneIdToBannerAd.remove(string);
        }
    }

    public void reloadBanner(JSONObject jSONObject) {
        final String string = this.getZoneId(jSONObject);
        final AppLovinAdView appLovinAdView = this.mZoneIdToBannerAd.get(string);
        final ALBannerListener aLBannerListener = this.mZoneIdToAppLovinListener.get(string);
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + "Banner reloadBanner: <" + string + ">", 1);
        if (appLovinAdView == null || aLBannerListener == null) {
            this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + ":reloadBanner() failed, null parameters", 2);
            return;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (TextUtils.isEmpty((CharSequence)string)) {
                    appLovinAdView.loadNextAd();
                } else {
                    AppLovinAdapter.this.mAppLovinSdk.getAdService().loadNextAdForZoneId(string, (AppLovinAdLoadListener)aLBannerListener);
                }
            }
        });
    }

    private String getErrorString(int n2) {
        switch (n2) {
            case -102: {
                return "Ad fetch timeout";
            }
            case -300: {
                return "No ad pre-loaded";
            }
            case -500: {
                return "Server timeout";
            }
            case -400: {
                return "Unknown server error";
            }
            case -600: {
                return "User closed video before reward";
            }
            case 204: {
                return "No fill";
            }
            case -103: {
                return "No network available";
            }
            case -6: {
                return "Unable to render ad";
            }
            case -1: {
                return "Unspecified error";
            }
        }
        return "Unknown error";
    }

    private String getZoneId(JSONObject jSONObject) {
        return !TextUtils.isEmpty((CharSequence)jSONObject.optString(ZONE_ID)) ? jSONObject.optString(ZONE_ID) : "";
    }

    private String getZoneId(AppLovinAd appLovinAd) {
        return appLovinAd.getZoneId() != null ? appLovinAd.getZoneId() : "";
    }

    private class ALBannerListener
    implements AppLovinAdViewEventListener,
    AppLovinAdClickListener,
    AppLovinAdDisplayListener,
    AppLovinAdLoadListener {
        private String mZoneId;

        ALBannerListener(String string) {
            this.mZoneId = string;
        }

        public void adClicked(AppLovinAd appLovinAd) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adClicked:  <" + this.mZoneId + ">", 1);
            BannerSmashListener bannerSmashListener = (BannerSmashListener)AppLovinAdapter.this.mZoneIdToBannerSmashListener.get(this.mZoneId);
            if (bannerSmashListener != null) {
                bannerSmashListener.onBannerAdClicked();
            }
        }

        public void adDisplayed(AppLovinAd appLovinAd) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adDisplayed: <" + this.mZoneId + ">", 1);
        }

        public void adHidden(AppLovinAd appLovinAd) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adHidden: <" + this.mZoneId + ">", 1);
        }

        public void adReceived(final AppLovinAd appLovinAd) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adReceived: <" + this.mZoneId + ">", 1);
            final AppLovinAdView appLovinAdView = (AppLovinAdView)AppLovinAdapter.this.mZoneIdToBannerAd.get(this.mZoneId);
            final FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)AppLovinAdapter.this.mZoneIdToBannerLayout.get(this.mZoneId);
            final BannerSmashListener bannerSmashListener = (BannerSmashListener)AppLovinAdapter.this.mZoneIdToBannerSmashListener.get(this.mZoneId);
            if (appLovinAdView != null && bannerSmashListener != null && layoutParams != null) {
                Handler handler = new Handler(Looper.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        appLovinAdView.renderAd(appLovinAd);
                        bannerSmashListener.onBannerAdLoaded((View)appLovinAdView, layoutParams);
                    }
                });
            } else {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " adReceived: null parameter", 3);
            }
        }

        public void failedToReceiveAd(int n2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner failedToReceiveAd", 1);
            BannerSmashListener bannerSmashListener = (BannerSmashListener)AppLovinAdapter.this.mZoneIdToBannerSmashListener.get(this.mZoneId);
            if (bannerSmashListener != null) {
                String string = AppLovinAdapter.this.getErrorString(n2) + "(" + n2 + ")";
                IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)string);
                bannerSmashListener.onBannerAdLoadFailed(ironSourceError);
            }
        }

        public void adOpenedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adOpenedFullscreen", 1);
        }

        public void adClosedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adClosedFullscreen", 1);
        }

        public void adLeftApplication(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " adLeftApplication:  <" + this.mZoneId + ">", 1);
            BannerSmashListener bannerSmashListener = (BannerSmashListener)AppLovinAdapter.this.mZoneIdToBannerSmashListener.get(this.mZoneId);
            if (bannerSmashListener != null) {
                bannerSmashListener.onBannerAdLeftApplication();
            }
        }

        public void adFailedToDisplay(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView, AppLovinAdViewDisplayErrorCode appLovinAdViewDisplayErrorCode) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adFailedToDisplay", 1);
        }
    }
}

