/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.AppLovinMediationAdapter;
import com.applovin.mediation.adapters.MediationAdapterRouter;
import com.applovin.sdk.AppLovinSdk;
import com.vungle.warren.AdConfig;
import com.vungle.warren.BuildConfig;
import com.vungle.warren.InitCallback;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import com.vungle.warren.error.VungleException;
import java.util.concurrent.atomic.AtomicBoolean;

public class VungleMediationAdapter
extends AppLovinMediationAdapter
implements MaxInterstitialAdapter,
MaxRewardedAdapter {
    private static final VungleMediationAdapterRouter ROUTER = new VungleMediationAdapterRouter();
    private static String sSdkVersion;
    private String mPlacementId;

    public VungleMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    public void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        this.log("Initializing Vungle SDK...");
        this.checkExistence(new Class[]{Vungle.class});
        ROUTER.initialize(maxAdapterInitializationParameters, activity, onCompletionListener);
    }

    public String getSdkVersion() {
        if (sSdkVersion == null) {
            sSdkVersion = AppLovinSdk.VERSION_CODE >= 90500 ? this.getVersionString(BuildConfig.class, "VERSION_NAME") : "6.3.24";
        }
        return sSdkVersion;
    }

    public String getAdapterVersion() {
        return "6.3.24.6";
    }

    public void onDestroy() {
        ROUTER.removeAdapter((MaxAdapter)this, this.mPlacementId);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.log("Loading interstitial ad...");
        this.mPlacementId = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        ROUTER.addInterstitialAdapter((MaxAdapter)this, maxInterstitialAdapterListener, this.mPlacementId);
        if (Vungle.canPlayAd((String)this.mPlacementId)) {
            ROUTER.onAdLoaded(this.mPlacementId);
        } else {
            this.loadAd(this.mPlacementId, maxAdapterResponseParameters);
        }
    }

    public void showInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.log("Showing interstitial ad...");
        String string = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        if (Vungle.canPlayAd((String)string)) {
            ROUTER.addShowingAdapter((MaxAdapter)this);
            this.showAd(string, maxAdapterResponseParameters.getServerParameters());
        } else {
            this.log("Interstitial ad not ready");
            maxInterstitialAdapterListener.onInterstitialAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.log("Loading rewarded ad...");
        this.mPlacementId = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        ROUTER.addRewardedAdapter((MaxAdapter)this, maxRewardedAdapterListener, this.mPlacementId);
        if (Vungle.canPlayAd((String)this.mPlacementId)) {
            ROUTER.onAdLoaded(this.mPlacementId);
        } else {
            this.loadAd(this.mPlacementId, maxAdapterResponseParameters);
        }
    }

    public void showRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.log("Showing rewarded ad...");
        String string = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        if (Vungle.canPlayAd((String)string)) {
            ROUTER.addShowingAdapter((MaxAdapter)this);
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                this.configureReward(maxAdapterResponseParameters);
            }
            this.showAd(string, maxAdapterResponseParameters.getServerParameters());
        } else {
            this.log("Rewarded ad not ready");
            maxRewardedAdapterListener.onRewardedAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
        }
    }

    private void loadAd(String string, MaxAdapterResponseParameters maxAdapterResponseParameters) {
        ROUTER.updateUserConsent(maxAdapterResponseParameters.hasUserConsent());
        Vungle.loadAd((String)string, (LoadAdCallback)ROUTER.getLoadAdCallback());
    }

    private void showAd(String string, Bundle bundle) {
        AdConfig adConfig = new AdConfig();
        if (bundle.containsKey("muted")) {
            adConfig.setMuted(bundle.getBoolean("muted"));
        }
        if (bundle.containsKey("ordinal")) {
            adConfig.setOrdinal(bundle.getInt("ordinal"));
        }
        if (bundle.containsKey("immersive_mode")) {
            adConfig.setImmersiveMode(bundle.getBoolean("immersive_mode"));
        }
        if (bundle.containsKey("flex_view_auto_dismiss_seconds")) {
            adConfig.setFlexViewCloseTime(bundle.getInt("flex_view_auto_dismiss_seconds"));
        }
        Vungle.playAd((String)string, (AdConfig)adConfig, (PlayAdCallback)ROUTER.getPlayAdCallback());
    }

    private static MaxAdapterError toMaxError(Throwable throwable) {
        if (throwable instanceof VungleException) {
            VungleException vungleException = (VungleException)throwable;
            int n2 = vungleException.getExceptionCode();
            int n3 = 0 == n2 ? -5202 : (1 == n2 ? 204 : (2 == n2 ? -5200 : (3 == n2 ? -5202 : (4 == n2 ? -5201 : (6 == n2 ? -5204 : (7 == n2 ? -5204 : (9 == n2 ? -5204 : (10 == n2 ? -5209 : (11 == n2 ? -5207 : (13 == n2 ? -5202 : (14 == n2 ? -5208 : -5200)))))))))));
            return new MaxAdapterError(n3, VungleMediationAdapter.toErrorMessage(vungleException));
        }
        return new MaxAdapterError(-5200, throwable.getClass() + ": " + throwable.getLocalizedMessage());
    }

    private static String toErrorMessage(VungleException vungleException) {
        return vungleException.getExceptionCode() + ": " + vungleException.getLocalizedMessage();
    }

    private static class VungleMediationAdapterRouter
    extends MediationAdapterRouter {
        private static final AtomicBoolean sIsInitialized = new AtomicBoolean();
        private final LoadAdCallback mLoadAdCallback = new LoadAdCallback(){

            public void onAdLoad(String string) {
                VungleMediationAdapterRouter.this.onAdLoaded(string);
            }

            public void onError(String string, Throwable throwable) {
                VungleMediationAdapterRouter.this.onAdLoadFailed(string, VungleMediationAdapter.toMaxError(throwable));
            }
        };
        private final PlayAdCallback mPlayAdCallback = new PlayAdCallback(){

            public void onAdStart(String string) {
                VungleMediationAdapterRouter.this.onAdDisplayed(string);
                VungleMediationAdapterRouter.this.onRewardedAdVideoStarted(string);
            }

            public void onAdEnd(String string, boolean bl, boolean bl2) {
                if (bl2) {
                    VungleMediationAdapterRouter.this.onAdClicked(string);
                }
                if (bl) {
                    VungleMediationAdapterRouter.this.onRewardedAdVideoCompleted(string);
                    VungleMediationAdapterRouter.this.onUserRewarded(string, VungleMediationAdapterRouter.this.retrieveReward(string));
                } else if (VungleMediationAdapterRouter.this.shouldAlwaysReward(string)) {
                    VungleMediationAdapterRouter.this.onUserRewarded(string, VungleMediationAdapterRouter.this.retrieveReward(string));
                }
                VungleMediationAdapterRouter.this.onAdHidden(string);
            }

            public void onError(String string, Throwable throwable) {
                VungleMediationAdapterRouter.this.onAdDisplayFailed(string, VungleMediationAdapter.toMaxError(throwable));
            }
        };

        private VungleMediationAdapterRouter() {
        }

        void updateUserConsent(boolean bl) {
            Vungle.Consent consent = bl ? Vungle.Consent.OPTED_IN : Vungle.Consent.OPTED_OUT;
            Vungle.updateConsentStatus((Vungle.Consent)consent, (String)"");
        }

        void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
            this.updateUserConsent(maxAdapterInitializationParameters.hasUserConsent());
            if (Vungle.isInitialized()) {
                this.log("Vungle SDK initialized");
                onCompletionListener.onCompletion();
            } else if (!sIsInitialized.getAndSet(true)) {
                String string = maxAdapterInitializationParameters.getServerParameters().getString("app_id", null);
                Vungle.init((String)string, (Context)activity.getApplicationContext(), (InitCallback)new InitCallback(){

                    public void onSuccess() {
                        VungleMediationAdapterRouter.this.log("Vungle SDK initialized");
                        onCompletionListener.onCompletion();
                    }

                    public void onError(Throwable throwable) {
                        VungleMediationAdapterRouter.this.log("Vungle SDK failed to initialize with error", throwable);
                        onCompletionListener.onCompletion();
                    }

                    public void onAutoCacheAdAvailable(String string) {
                        VungleMediationAdapterRouter.this.log("Auto-cached ad " + string);
                    }
                });
            }
        }

        LoadAdCallback getLoadAdCallback() {
            return this.mLoadAdCallback;
        }

        PlayAdCallback getPlayAdCallback() {
            return this.mPlayAdCallback;
        }

        private MaxReward retrieveReward(String string) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                return this.getReward(string);
            }
            return MaxReward.createDefault();
        }

        private boolean shouldAlwaysReward(String string) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                return this.shouldAlwaysRewardUser(string);
            }
            return false;
        }
    }
}

