/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.adapters.MediationAdapterRouter;
import com.applovin.sdk.AppLovinSdk;
import com.unity3d.ads.IUnityAdsListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.mediation.IUnityAdsExtendedListener;
import com.unity3d.ads.metadata.MediationMetaData;
import com.unity3d.ads.metadata.MetaData;

public class UnityAdsMediationAdapter
extends MediationAdapterBase
implements MaxInterstitialAdapter,
MaxRewardedAdapter {
    private static final String GAME_ID_PARAMETER = "game_id";
    private static final UnityMediationAdapterRouter ROUTER = new UnityMediationAdapterRouter();
    private String mPlacementId;

    public UnityAdsMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    public void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        ROUTER.initialize(maxAdapterInitializationParameters, activity, onCompletionListener);
    }

    public String getSdkVersion() {
        return UnityAds.getVersion();
    }

    public String getAdapterVersion() {
        return "3.1.0.0";
    }

    public void onDestroy() {
        ROUTER.removeAdapter((MaxAdapter)this, this.mPlacementId);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.log("Loading interstitial ad...");
        this.mPlacementId = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        ROUTER.updateUserConsent(maxAdapterResponseParameters.hasUserConsent(), activity.getApplicationContext());
        ROUTER.addInterstitialAdapter((MaxAdapter)this, maxInterstitialAdapterListener, this.mPlacementId);
        if (UnityAds.isReady((String)this.mPlacementId)) {
            ROUTER.onAdLoaded(this.mPlacementId);
        } else {
            ROUTER.onAdLoadFailed(this.mPlacementId, this.getLoadError(this.mPlacementId));
        }
    }

    public void showInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.log("Showing interstitial ad...");
        String string = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        if (UnityAds.isReady((String)string)) {
            ROUTER.addShowingAdapter((MaxAdapter)this);
            UnityAds.show((Activity)activity, (String)string);
        } else {
            this.log("Interstitial ad not ready");
            maxInterstitialAdapterListener.onInterstitialAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.log("Loading rewarded ad...");
        this.mPlacementId = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        ROUTER.updateUserConsent(maxAdapterResponseParameters.hasUserConsent(), activity.getApplicationContext());
        ROUTER.addRewardedAdapter((MaxAdapter)this, maxRewardedAdapterListener, this.mPlacementId);
        if (UnityAds.isReady((String)this.mPlacementId)) {
            ROUTER.onAdLoaded(this.mPlacementId);
        } else {
            ROUTER.onAdLoadFailed(this.mPlacementId, this.getLoadError(this.mPlacementId));
        }
    }

    public void showRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.log("Showing rewarded ad...");
        String string = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        if (UnityAds.isReady((String)string)) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                this.configureReward(maxAdapterResponseParameters);
            }
            ROUTER.addShowingAdapter((MaxAdapter)this);
            UnityAds.show((Activity)activity, (String)string);
        } else {
            this.log("Rewarded ad not ready");
            maxRewardedAdapterListener.onRewardedAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
        }
    }

    private MaxAdapterError getLoadError(String string) {
        UnityAds.PlacementState placementState = UnityAds.getPlacementState((String)string);
        if (placementState == UnityAds.PlacementState.NOT_AVAILABLE) {
            return new MaxAdapterError(-5202);
        }
        if (placementState == UnityAds.PlacementState.DISABLED) {
            return new MaxAdapterError(-5202);
        }
        if (placementState == UnityAds.PlacementState.NO_FILL) {
            return MaxAdapterError.NO_FILL;
        }
        return MaxAdapterError.AD_NOT_READY;
    }

    private static MaxAdapterError toMaxError(UnityAds.UnityAdsError unityAdsError) {
        int n2 = unityAdsError == UnityAds.UnityAdsError.NOT_INITIALIZED ? -5204 : (unityAdsError == UnityAds.UnityAdsError.INITIALIZE_FAILED ? -5209 : (unityAdsError == UnityAds.UnityAdsError.INVALID_ARGUMENT ? -5201 : (unityAdsError == UnityAds.UnityAdsError.VIDEO_PLAYER_ERROR ? -5209 : (unityAdsError == UnityAds.UnityAdsError.INIT_SANITY_CHECK_FAIL ? -5201 : (unityAdsError == UnityAds.UnityAdsError.AD_BLOCKER_DETECTED ? -5203 : (unityAdsError == UnityAds.UnityAdsError.FILE_IO_ERROR ? -5209 : (unityAdsError == UnityAds.UnityAdsError.DEVICE_ID_ERROR ? -5209 : (unityAdsError == UnityAds.UnityAdsError.SHOW_ERROR ? -5209 : (unityAdsError == UnityAds.UnityAdsError.INTERNAL_ERROR ? -5209 : -5200)))))))));
        String string = unityAdsError != null ? unityAdsError.name() : "UNKNOWN";
        return new MaxAdapterError(n2, string);
    }

    private static class UnityMediationAdapterRouter
    extends MediationAdapterRouter
    implements IUnityAdsListener,
    IUnityAdsExtendedListener {
        private UnityMediationAdapterRouter() {
        }

        void updateUserConsent(boolean bl, Context context) {
            MetaData metaData = new MetaData(context);
            metaData.set("gdpr.consent", (Object)bl);
            metaData.commit();
        }

        void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
            this.updateUserConsent(maxAdapterInitializationParameters.hasUserConsent(), activity.getApplicationContext());
            if (!UnityAds.isInitialized()) {
                Object object;
                this.log("Initializing UnityAds SDK...");
                if (maxAdapterInitializationParameters.getServerParameters().getBoolean("set_mediation_identifier")) {
                    object = new MediationMetaData((Context)activity);
                    object.setName(UnityAdsMediationAdapter.mediationTag());
                    object.setVersion(AppLovinSdk.VERSION);
                    object.commit();
                }
                UnityAds.setDebugMode((boolean)maxAdapterInitializationParameters.isTesting());
                object = maxAdapterInitializationParameters.getServerParameters().getString(UnityAdsMediationAdapter.GAME_ID_PARAMETER, null);
                UnityAds.initialize((Activity)activity, (String)object, (IUnityAdsListener)this, (boolean)maxAdapterInitializationParameters.isTesting());
                this.log("UnityAds SDK initialized");
            } else {
                this.log("UnityAds SDK is initialized already");
            }
            onCompletionListener.onCompletion();
        }

        public void onUnityAdsReady(String string) {
        }

        public void onUnityAdsStart(String string) {
            this.onAdDisplayed(string);
            this.onRewardedAdVideoStarted(string);
        }

        public void onUnityAdsFinish(String string, UnityAds.FinishState finishState) {
            if (finishState == UnityAds.FinishState.COMPLETED) {
                this.onRewardedAdVideoCompleted(string);
                this.onUserRewarded(string, this.retrieveReward(string));
                this.onAdHidden(string);
            } else if (finishState == UnityAds.FinishState.SKIPPED) {
                this.onRewardedAdVideoCompleted(string);
                if (this.alwaysReward(string)) {
                    this.onUserRewarded(string, this.retrieveReward(string));
                }
                this.onAdHidden(string);
            } else if (finishState == UnityAds.FinishState.ERROR) {
                this.log("UnityAds failed to finish ad for placement " + string);
                this.onAdDisplayFailed(string, MaxAdapterError.INTERNAL_ERROR);
            }
        }

        public void onUnityAdsError(UnityAds.UnityAdsError unityAdsError, String string) {
            String string2 = unityAdsError != null ? unityAdsError.name() : "UNKNOWN";
            this.log("UnityAds did error " + unityAdsError.name() + " with message: " + string);
        }

        public void onUnityAdsClick(String string) {
            this.onAdClicked(string);
        }

        public void onUnityAdsPlacementStateChanged(String string, UnityAds.PlacementState placementState, UnityAds.PlacementState placementState2) {
            if (placementState2 == UnityAds.PlacementState.READY) {
                this.log("Placement " + string + " is ready");
                this.onAdLoaded(string);
            } else if (placementState2 == UnityAds.PlacementState.WAITING) {
                this.log("Placement " + string + " is loading...");
            } else if (placementState2 == UnityAds.PlacementState.NOT_AVAILABLE) {
                this.log("Placement " + string + " is not available");
                MaxAdapterError maxAdapterError = new MaxAdapterError(-5202, "PLACEMENT_NOT_AVAILABLE");
                this.onAdLoadFailed(string, maxAdapterError);
            } else if (placementState2 == UnityAds.PlacementState.DISABLED) {
                this.log("Placement " + string + " is disabled - please check your Unity admin tools.");
                MaxAdapterError maxAdapterError = new MaxAdapterError(-5202, "PLACEMENT_DISABLED");
                this.onAdLoadFailed(string, maxAdapterError);
            } else if (placementState2 == UnityAds.PlacementState.NO_FILL) {
                this.log("Placement " + string + " NO FILL'd");
                this.onAdLoadFailed(string, MaxAdapterError.NO_FILL);
            }
        }

        private MaxReward retrieveReward(String string) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                return this.getReward(string);
            }
            return MaxReward.createDefault();
        }

        private boolean alwaysReward(String string) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                return this.shouldAlwaysRewardUser(string);
            }
            return false;
        }
    }
}

