/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;
import com.mintegral.msdk.MIntegralConstans;
import com.mintegral.msdk.activity.MTGCommonActivity;
import com.mintegral.msdk.interstitialvideo.out.InterstitialVideoListener;
import com.mintegral.msdk.interstitialvideo.out.MTGInterstitialVideoHandler;
import com.mintegral.msdk.out.MIntegralSDKFactory;
import com.mintegral.msdk.out.MTGConfiguration;
import com.mintegral.msdk.out.MTGRewardVideoHandler;
import com.mintegral.msdk.out.RewardVideoListener;
import com.mintegral.msdk.reward.player.MTGRewardVideoActivity;
import com.mintegral.msdk.system.a;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class MintegralMediationAdapter
extends MediationAdapterBase
implements MaxInterstitialAdapter,
MaxRewardedAdapter {
    private static final AtomicBoolean sIsInitialized = new AtomicBoolean();
    private static final String APP_ID_PARAMETER = "app_id";
    private static final String APP_KEY_PARAMETER = "app_key";
    private static final String NOT_INITIALIZED = "init error";
    private static final String NO_FILL_1 = "no ads available can show";
    private static final String NO_FILL_2 = "no ads available";
    private static final String NO_FILL_3 = "no server ads available";
    private static final String NO_FILL_4 = "no ads source";
    private static final String NETWORK_ERROR = "network exception";
    private static final String BAD_REQUEST = "request parameter is null";
    private static final String TIMEOUT = "load timeout";
    private static final String EXCEPTION_RETURN_EMPTY = "EXCEPTION_RETURN_EMPTY";
    private static final String EXCEPTION_TIMEOUT = "EXCEPTION_TIMEOUT";
    private static final String EXCEPTION_IV_RECALLNET_INVALIDATE = "EXCEPTION_IV_RECALLNET_INVALIDATE";
    private static final String EXCEPTION_SIGN_ERROR = "EXCEPTION_SIGN_ERROR";
    private static final String EXCEPTION_UNIT_NOT_FOUND = "EXCEPTION_UNIT_NOT_FOUND";
    private static final String EXCEPTION_UNIT_ID_EMPTY = "EXCEPTION_UNIT_ID_EMPTY";
    private static final String EXCEPTION_UNIT_NOT_FOUND_IN_APP = "EXCEPTION_UNIT_NOT_FOUND_IN_APP";
    private static final String EXCEPTION_UNIT_ADTYPE_ERROR = "EXCEPTION_UNIT_ADTYPE_ERROR";
    private static final String EXCEPTION_APP_ID_EMPTY = "EXCEPTION_APP_ID_EMPTY";
    private static final String EXCEPTION_APP_NOT_FOUND = "EXCEPTION_APP_NOT_FOUND";
    private static String sSdkVersion;
    private MTGInterstitialVideoHandler mtgInterstitialVideoHandler;
    private MTGRewardVideoHandler mtgRewardVideoHandler;

    public MintegralMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    public void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        this.checkExistence(new Class[]{MTGInterstitialVideoHandler.class, MTGRewardVideoHandler.class});
        this.checkExistence(new Class[]{MTGCommonActivity.class, MTGRewardVideoActivity.class});
        MIntegralConstans.DEBUG = maxAdapterInitializationParameters.isTesting();
        if (!sIsInitialized.getAndSet(true)) {
            String string = maxAdapterInitializationParameters.getServerParameters().getString(APP_ID_PARAMETER);
            String string2 = maxAdapterInitializationParameters.getServerParameters().getString(APP_KEY_PARAMETER);
            a a2 = MIntegralSDKFactory.getMIntegralSDK();
            int n2 = maxAdapterInitializationParameters.hasUserConsent() ? 1 : 0;
            a2.setUserPrivateInfoType((Context)activity, "authority_all_info", n2);
            a2.setConsentStatus((Context)activity, n2);
            Map map = a2.getMTGConfigurationMap(string, string2);
            a2.init(map, (Context)activity);
        }
        onCompletionListener.onCompletion();
    }

    public String getSdkVersion() {
        if (sSdkVersion == null) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                sSdkVersion = this.getVersionString(MTGConfiguration.class, "SDK_VERSION");
            } else {
                return "MAL_9.10.41";
            }
        }
        return sSdkVersion;
    }

    public String getAdapterVersion() {
        return "9.10.4.1";
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, final MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.log("Loading Mintegral interstitial...");
        this.mtgInterstitialVideoHandler = new MTGInterstitialVideoHandler(activity, maxAdapterResponseParameters.getThirdPartyAdPlacementId());
        this.mtgInterstitialVideoHandler.setInterstitialVideoListener(new InterstitialVideoListener(){

            public void onVideoLoadSuccess(String string) {
                MintegralMediationAdapter.this.log("Interstitial successfully loaded and video has been downloaded");
                maxInterstitialAdapterListener.onInterstitialAdLoaded();
            }

            public void onLoadSuccess(String string) {
                MintegralMediationAdapter.this.log("Interstitial successfully loaded but video still needs to be downloaded");
            }

            public void onVideoLoadFail(String string) {
                MintegralMediationAdapter.this.log("Interstitial failed to load: " + string);
                maxInterstitialAdapterListener.onInterstitialAdLoadFailed(MintegralMediationAdapter.this.toMaxError(string));
            }

            public void onAdShow() {
                MintegralMediationAdapter.this.log("Interstitial displayed");
                maxInterstitialAdapterListener.onInterstitialAdDisplayed();
            }

            public void onShowFail(String string) {
                MintegralMediationAdapter.this.log("Interstitial failed to show: " + string);
                maxInterstitialAdapterListener.onInterstitialAdDisplayFailed(MintegralMediationAdapter.this.toMaxError(string));
            }

            public void onVideoAdClicked(String string) {
                MintegralMediationAdapter.this.log("Interstitial clicked");
                maxInterstitialAdapterListener.onInterstitialAdClicked();
            }

            public void onAdClose(boolean bl) {
                MintegralMediationAdapter.this.log("Interstitial hidden");
                maxInterstitialAdapterListener.onInterstitialAdHidden();
            }

            public void onVideoComplete(String string) {
                MintegralMediationAdapter.this.log("Interstitial video completed");
            }

            public void onEndcardShow(String string) {
                MintegralMediationAdapter.this.log("Interstitial endcard shown");
            }
        });
        this.mtgInterstitialVideoHandler.load();
    }

    public void showInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.log("Showing Mintegral interstitial...");
        if (this.mtgInterstitialVideoHandler != null) {
            this.mtgInterstitialVideoHandler.show();
        } else {
            this.log("Unable to show Mintegral interstitial - no ad loaded...");
            maxInterstitialAdapterListener.onInterstitialAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, final MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.log("Loading Mintegral rewarded...");
        this.mtgRewardVideoHandler = new MTGRewardVideoHandler(activity, maxAdapterResponseParameters.getThirdPartyAdPlacementId());
        this.mtgRewardVideoHandler.setRewardVideoListener(new RewardVideoListener(){

            public void onVideoLoadSuccess(String string) {
                MintegralMediationAdapter.this.log("Rewarded ad successfully loaded and video has been downloaded");
                maxRewardedAdapterListener.onRewardedAdLoaded();
            }

            public void onLoadSuccess(String string) {
                MintegralMediationAdapter.this.log("Rewarded ad successfully loaded but video still needs to be downloaded");
            }

            public void onVideoLoadFail(String string) {
                MintegralMediationAdapter.this.log("Rewarded ad failed to load: " + string);
                maxRewardedAdapterListener.onRewardedAdLoadFailed(MintegralMediationAdapter.this.toMaxError(string));
            }

            public void onAdShow() {
                MintegralMediationAdapter.this.log("Rewarded ad displayed");
                maxRewardedAdapterListener.onRewardedAdDisplayed();
                maxRewardedAdapterListener.onRewardedAdVideoStarted();
            }

            public void onShowFail(String string) {
                MintegralMediationAdapter.this.log("Rewarded ad failed to show: " + string);
                maxRewardedAdapterListener.onRewardedAdDisplayFailed(MintegralMediationAdapter.this.toMaxError(string));
            }

            public void onVideoAdClicked(String string) {
                MintegralMediationAdapter.this.log("Rewarded ad clicked");
                maxRewardedAdapterListener.onRewardedAdClicked();
            }

            public void onAdClose(boolean bl, String string, float f2) {
                MintegralMediationAdapter.this.log("Rewarded ad hidden");
                if (bl) {
                    maxRewardedAdapterListener.onRewardedAdVideoCompleted();
                    maxRewardedAdapterListener.onUserRewarded(this.retrieveReward());
                } else if (this.alwaysReward()) {
                    maxRewardedAdapterListener.onUserRewarded(this.retrieveReward());
                }
                maxRewardedAdapterListener.onRewardedAdHidden();
            }

            public void onVideoComplete(String string) {
                MintegralMediationAdapter.this.log("Rewarded ad video completed");
            }

            public void onEndcardShow(String string) {
                MintegralMediationAdapter.this.log("Rewarded ad endcard shown");
            }

            private MaxReward retrieveReward() {
                if (AppLovinSdk.VERSION_CODE >= 90500) {
                    return MintegralMediationAdapter.this.getReward();
                }
                return MaxReward.createDefault();
            }

            private boolean alwaysReward() {
                if (AppLovinSdk.VERSION_CODE >= 90500) {
                    return MintegralMediationAdapter.this.shouldAlwaysRewardUser();
                }
                return false;
            }
        });
        if (this.mtgRewardVideoHandler.isReady()) {
            maxRewardedAdapterListener.onRewardedAdLoaded();
        } else {
            this.mtgRewardVideoHandler.load();
        }
    }

    public void showRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.log("Showing Mintegral rewarded...");
        if (this.mtgRewardVideoHandler != null && this.mtgRewardVideoHandler.isReady()) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                this.configureReward(maxAdapterResponseParameters);
            }
            String string = maxAdapterResponseParameters.getServerParameters().getString("reward_id", "");
            String string2 = maxAdapterResponseParameters.getServerParameters().getString("user_id", "");
            this.mtgRewardVideoHandler.show(string, string2);
        } else {
            this.log("Unable to show Mintegral rewarded - no ad loaded...");
            maxRewardedAdapterListener.onRewardedAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
        }
    }

    public void onDestroy() {
        if (this.mtgInterstitialVideoHandler != null) {
            this.mtgInterstitialVideoHandler.setInterstitialVideoListener(null);
        }
        this.mtgInterstitialVideoHandler = null;
        if (this.mtgRewardVideoHandler != null) {
            this.mtgRewardVideoHandler.setRewardVideoListener(null);
        }
        this.mtgRewardVideoHandler = null;
    }

    private MaxAdapterError toMaxError(String string) {
        int n2 = NOT_INITIALIZED.equals(string) || EXCEPTION_IV_RECALLNET_INVALIDATE.equalsIgnoreCase(string) ? -5204 : (NO_FILL_1.equalsIgnoreCase(string) || NO_FILL_2.equalsIgnoreCase(string) || NO_FILL_3.equalsIgnoreCase(string) || NO_FILL_4.equalsIgnoreCase(string) || EXCEPTION_RETURN_EMPTY.equalsIgnoreCase(string) ? 204 : (NETWORK_ERROR.equalsIgnoreCase(string) ? -5207 : (BAD_REQUEST.equalsIgnoreCase(string) ? -5203 : (TIMEOUT.equalsIgnoreCase(string) || EXCEPTION_TIMEOUT.equalsIgnoreCase(string) ? -5206 : (EXCEPTION_SIGN_ERROR.equalsIgnoreCase(string) || EXCEPTION_UNIT_NOT_FOUND.equalsIgnoreCase(string) || EXCEPTION_UNIT_ID_EMPTY.equalsIgnoreCase(string) || EXCEPTION_UNIT_NOT_FOUND_IN_APP.equalsIgnoreCase(string) || EXCEPTION_UNIT_ADTYPE_ERROR.equalsIgnoreCase(string) || EXCEPTION_APP_ID_EMPTY.equalsIgnoreCase(string) || EXCEPTION_APP_NOT_FOUND.equalsIgnoreCase(string) ? -5202 : -5200)))));
        return new MaxAdapterError(n2, string);
    }
}

