/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.adapters.MediationAdapterRouter;
import com.applovin.sdk.AppLovinSdk;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.ISDemandOnlyInterstitialListener;
import com.ironsource.mediationsdk.sdk.ISDemandOnlyRewardedVideoListener;
import com.ironsource.mediationsdk.sdk.InterstitialListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoListener;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.concurrent.atomic.AtomicBoolean;

public class IronSourceMediationAdapter
extends MediationAdapterBase
implements MaxInterstitialAdapter,
MaxRewardedAdapter {
    private static final IronSourceRouter sIronSourceRouter = new IronSourceRouter();
    private static final AtomicBoolean sIsInitialized = new AtomicBoolean();
    private String mRouterPlacementIdentifier;

    public IronSourceMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    public void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        this.checkExistence(new Class[]{InterstitialListener.class, RewardedVideoListener.class});
        sIronSourceRouter.initialize(maxAdapterInitializationParameters, activity, onCompletionListener);
    }

    public String getSdkVersion() {
        return IronSourceUtils.getSDKVersion();
    }

    public String getAdapterVersion() {
        return "6.8.4.0.0";
    }

    public void onDestroy() {
        sIronSourceRouter.removeAdapter((MaxAdapter)this, this.mRouterPlacementIdentifier);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        IronSource.setConsent((boolean)maxAdapterResponseParameters.hasUserConsent());
        String string = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        this.log("Loading ironSource interstitial for instance ID: " + string);
        this.mRouterPlacementIdentifier = IronSourceRouter.getInterstitialRouterIdentifier(string);
        sIronSourceRouter.addInterstitialAdapter((MaxAdapter)this, maxInterstitialAdapterListener, this.mRouterPlacementIdentifier);
        if (IronSource.isISDemandOnlyInterstitialReady((String)string)) {
            this.log("Ad is available already for instance ID: " + string);
            sIronSourceRouter.onAdLoaded(this.mRouterPlacementIdentifier);
        } else {
            IronSource.loadISDemandOnlyInterstitial((String)string);
        }
    }

    public void showInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        String string = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        this.log("Showing ironSource interstitial for instance ID: " + string);
        if (IronSource.isISDemandOnlyInterstitialReady((String)string)) {
            sIronSourceRouter.addShowingAdapter((MaxAdapter)this);
            IronSource.showISDemandOnlyInterstitial((String)string);
        } else {
            this.log("Unable to show ironSource interstitial - no ad loaded for instance ID: " + string);
            maxInterstitialAdapterListener.onInterstitialAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        IronSource.setConsent((boolean)maxAdapterResponseParameters.hasUserConsent());
        String string = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        this.log("Loading ironSource rewarded for instance ID: " + string);
        String string2 = IronSourceRouter.getRewardedVideoRouterIdentifier(string);
        sIronSourceRouter.addRewardedAdapter((MaxAdapter)this, maxRewardedAdapterListener, string2);
        if (IronSource.isISDemandOnlyRewardedVideoAvailable((String)string)) {
            this.log("Ad is available already for instance ID: " + string);
            sIronSourceRouter.onAdLoaded(string2);
        } else {
            IronSource.loadISDemandOnlyRewardedVideo((String)string);
        }
    }

    public void showRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        String string = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        this.log("Showing ironSource rewarded for instance ID: " + string);
        if (IronSource.isISDemandOnlyRewardedVideoAvailable((String)string)) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                this.configureReward(maxAdapterResponseParameters);
            }
            sIronSourceRouter.addShowingAdapter((MaxAdapter)this);
            IronSource.showISDemandOnlyRewardedVideo((String)string);
        } else {
            this.log("Unable to show ironSource rewarded - no ad loaded...");
            maxRewardedAdapterListener.onRewardedAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
        }
    }

    private static class IronSourceRouter
    extends MediationAdapterRouter
    implements ISDemandOnlyInterstitialListener,
    ISDemandOnlyRewardedVideoListener {
        private boolean hasGrantedReward;

        private IronSourceRouter() {
        }

        void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
            if (!sIsInitialized.getAndSet(true)) {
                if (maxAdapterInitializationParameters.getServerParameters().getBoolean("set_mediation_identifier")) {
                    IronSource.setMediationType((String)MediationAdapterBase.mediationTag());
                }
                IronSource.setAdaptersDebug((boolean)maxAdapterInitializationParameters.isTesting());
                IronSource.setConsent((boolean)maxAdapterInitializationParameters.hasUserConsent());
                IronSource.setISDemandOnlyInterstitialListener((ISDemandOnlyInterstitialListener)sIronSourceRouter);
                IronSource.setISDemandOnlyRewardedVideoListener((ISDemandOnlyRewardedVideoListener)sIronSourceRouter);
                boolean bl = maxAdapterInitializationParameters.getServerParameters().getBoolean("should_track_network_state", false);
                if (bl) {
                    IronSource.shouldTrackNetworkState((Context)activity, (boolean)true);
                }
                String string = maxAdapterInitializationParameters.getServerParameters().getString("app_key");
                IronSource.initISDemandOnly((Activity)activity, (String)string, (IronSource.AD_UNIT[])new IronSource.AD_UNIT[]{IronSource.AD_UNIT.INTERSTITIAL, IronSource.AD_UNIT.REWARDED_VIDEO});
            }
            onCompletionListener.onCompletion();
        }

        public void onInterstitialAdReady(String string) {
            this.log("Interstitial loaded for instance ID: " + string);
            this.onAdLoaded(IronSourceRouter.getInterstitialRouterIdentifier(string));
        }

        public void onInterstitialAdLoadFailed(String string, IronSourceError ironSourceError) {
            this.log("Interstitial ad failed to load for instance ID: " + string + " with error: " + ironSourceError);
            this.onAdLoadFailed(IronSourceRouter.getInterstitialRouterIdentifier(string), this.toMaxError(ironSourceError));
        }

        public void onInterstitialAdOpened(String string) {
            this.log("Interstitial ad displayed for instance ID: " + string);
            this.onAdDisplayed(IronSourceRouter.getInterstitialRouterIdentifier(string));
        }

        public void onInterstitialAdClosed(String string) {
            this.log("Interstitial ad closed for instance ID: " + string);
            this.onAdHidden(IronSourceRouter.getInterstitialRouterIdentifier(string));
        }

        public void onInterstitialAdShowFailed(String string, IronSourceError ironSourceError) {
            this.log("Interstitial ad failed to show for instance ID: " + string + " with error: " + ironSourceError);
            this.onAdDisplayFailed(IronSourceRouter.getInterstitialRouterIdentifier(string), this.toMaxError(ironSourceError));
        }

        public void onInterstitialAdClicked(String string) {
            this.log("Interstitial ad clicked for instance ID: " + string);
            this.onAdClicked(IronSourceRouter.getInterstitialRouterIdentifier(string));
        }

        public void onRewardedVideoAdOpened(String string) {
            this.log("Rewarded ad shown for instance ID: " + string);
            String string2 = IronSourceRouter.getRewardedVideoRouterIdentifier(string);
            this.onAdDisplayed(string2);
            this.onRewardedAdVideoStarted(string2);
        }

        public void onRewardedVideoAdClosed(String string) {
            String string2 = IronSourceRouter.getRewardedVideoRouterIdentifier(string);
            if (this.hasGrantedReward || this.alwaysReward(string2)) {
                MaxReward maxReward = this.retrieveReward(string2);
                this.log("Rewarded  ad rewarded user with reward: " + maxReward + " for instance ID: " + string);
                this.onUserRewarded(string2, maxReward);
                this.hasGrantedReward = false;
            }
            this.log("Rewarded ad hidden for instance ID: " + string);
            this.onAdHidden(string2);
        }

        public void onRewardedVideoAdLoadSuccess(String string) {
            this.log("Rewarded ad loaded for instance ID: " + string);
            this.onAdLoaded(IronSourceRouter.getRewardedVideoRouterIdentifier(string));
        }

        public void onRewardedVideoAdLoadFailed(String string, IronSourceError ironSourceError) {
            this.log("Rewarded ad failed to load for instance ID: " + string);
            this.onAdLoadFailed(IronSourceRouter.getRewardedVideoRouterIdentifier(string), this.toMaxError(ironSourceError));
        }

        public void onRewardedVideoAdRewarded(String string) {
            this.log("Rewarded ad granted reward for instance ID: " + string);
            this.onRewardedAdVideoCompleted(IronSourceRouter.getRewardedVideoRouterIdentifier(string));
            this.hasGrantedReward = true;
        }

        public void onRewardedVideoAdShowFailed(String string, IronSourceError ironSourceError) {
            this.log("Rewarded ad failed to show for instance ID: " + string + " with error: " + ironSourceError);
            this.onAdDisplayFailed(IronSourceRouter.getRewardedVideoRouterIdentifier(string), this.toMaxError(ironSourceError));
        }

        public void onRewardedVideoAdClicked(String string) {
            this.log("Rewarded ad clicked for instance ID: " + string);
            this.onAdClicked(IronSourceRouter.getRewardedVideoRouterIdentifier(string));
        }

        private MaxAdapterError toMaxError(IronSourceError ironSourceError) {
            int n2 = ironSourceError.getErrorCode();
            int n3 = 501 == n2 || 505 == n2 || 506 == n2 ? -5202 : (508 == n2 ? -5204 : (509 == n2 ? 204 : (520 == n2 ? -5207 : (524 == n2 || 526 == n2 ? -5214 : -5200))));
            return new MaxAdapterError(n3, n2);
        }

        private MaxReward retrieveReward(String string) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                return this.getReward(string);
            }
            return MaxReward.createDefault();
        }

        private boolean alwaysReward(String string) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                return this.shouldAlwaysRewardUser(string);
            }
            return false;
        }

        private static String getInterstitialRouterIdentifier(String string) {
            return string + "-" + IronSource.AD_UNIT.INTERSTITIAL.toString();
        }

        private static String getRewardedVideoRouterIdentifier(String string) {
            return string + "-" + IronSource.AD_UNIT.REWARDED_VIDEO.toString();
        }
    }
}

