/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.facebook.ads.AudienceNetworkAds;
import com.facebook.ads.BidderTokenProvider;
import com.facebook.ads.BuildConfig;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdListener;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdExtendedListener;
import com.facebook.ads.RewardedVideoAdListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class FacebookMediationAdapter
extends MediationAdapterBase
implements MaxAdViewAdapter,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxSignalProvider {
    private static final AtomicBoolean sIsInitialized = new AtomicBoolean();
    private static String sSdkVersion;
    private AdView mAdView;
    private InterstitialAd mInterstitialAd;
    private RewardedVideoAd mRewardedVideoAd;
    private AtomicBoolean onRewardedAdVideoCompletedCalled = new AtomicBoolean();
    private AtomicBoolean onRewardedAdHiddenCalled = new AtomicBoolean();

    public FacebookMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    public void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        this.checkExistence(new Class[]{InterstitialAd.class, InterstitialAdListener.class, AdSettings.class});
        this.updateAdSettings(maxAdapterInitializationParameters.getServerParameters(), maxAdapterInitializationParameters.isAgeRestrictedUser());
        if (sIsInitialized.compareAndSet(false, true)) {
            ArrayList arrayList = maxAdapterInitializationParameters.getServerParameters().getStringArrayList("placement_ids");
            AudienceNetworkAds.InitListener initListener = new AudienceNetworkAds.InitListener(){

                public void onInitialized(AudienceNetworkAds.InitResult initResult) {
                    if (initResult.isSuccess()) {
                        FacebookMediationAdapter.this.log("Facebook SDK successfully finished initialization");
                    } else {
                        FacebookMediationAdapter.this.log("Facebook SDK failed to finished initialization: " + initResult.getMessage());
                    }
                    onCompletionListener.onCompletion();
                }
            };
            if (maxAdapterInitializationParameters.isTesting()) {
                AdSettings.setDebugBuild((boolean)true);
            }
            this.log("Initializing Facebook SDK with placements: " + arrayList);
            AudienceNetworkAds.buildInitSettings((Context)activity).withMediationService(this.getMediationIdentifier(maxAdapterInitializationParameters.getServerParameters())).withPlacementIds((List)arrayList).withInitListener(initListener).initialize();
        } else {
            this.log("Facebook attempted initialization already - marking initialization as completed");
            onCompletionListener.onCompletion();
        }
    }

    public String getSdkVersion() {
        if (sSdkVersion == null) {
            sSdkVersion = AppLovinSdk.VERSION_CODE >= 90500 ? this.getVersionString(BuildConfig.class, "VERSION_NAME") : "5.4.0";
        }
        return sSdkVersion;
    }

    public String getAdapterVersion() {
        return "5.4.0.0";
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, final MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        final String string = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        this.log("Loading interstitial ad: " + string + "...");
        this.updateAdSettings(maxAdapterResponseParameters.getServerParameters(), maxAdapterResponseParameters.isAgeRestrictedUser());
        this.mInterstitialAd = new InterstitialAd(activity.getApplicationContext(), string);
        this.mInterstitialAd.setAdListener(new InterstitialAdListener(){

            public void onAdLoaded(Ad ad2) {
                FacebookMediationAdapter.this.log("Interstitial ad loaded: " + string);
                maxInterstitialAdapterListener.onInterstitialAdLoaded();
            }

            public void onError(Ad ad2, AdError adError) {
                FacebookMediationAdapter.this.log("Interstitial ad (" + string + ") failed to load with error code (" + adError.getErrorCode() + ") and message: " + adError.getErrorMessage());
                maxInterstitialAdapterListener.onInterstitialAdLoadFailed(FacebookMediationAdapter.toMaxError(adError));
            }

            public void onAdClicked(Ad ad2) {
                FacebookMediationAdapter.this.log("Interstitial ad clicked: " + string);
                maxInterstitialAdapterListener.onInterstitialAdClicked();
            }

            public void onLoggingImpression(Ad ad2) {
                FacebookMediationAdapter.this.log("Interstitial ad logging impression: " + string);
                maxInterstitialAdapterListener.onInterstitialAdDisplayed();
            }

            public void onInterstitialDisplayed(Ad ad2) {
                FacebookMediationAdapter.this.log("Interstitial ad displayed: " + string);
            }

            public void onInterstitialDismissed(Ad ad2) {
                FacebookMediationAdapter.this.log("Interstitial ad hidden: " + string);
                maxInterstitialAdapterListener.onInterstitialAdHidden();
            }
        });
        if (this.mInterstitialAd.isAdLoaded() && !this.mInterstitialAd.isAdInvalidated()) {
            this.log("An interstitial ad has been loaded already");
            maxInterstitialAdapterListener.onInterstitialAdLoaded();
        } else if (TextUtils.isEmpty((CharSequence)maxAdapterResponseParameters.getBidResponse())) {
            this.log("Loading mediated interstitial ad...");
            this.mInterstitialAd.loadAd();
        } else {
            this.log("Loading bidding interstitial ad...");
            this.mInterstitialAd.loadAdFromBid(maxAdapterResponseParameters.getBidResponse());
        }
    }

    public void showInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.log("Showing interstitial ad: " + maxAdapterResponseParameters.getThirdPartyAdPlacementId() + "...");
        if (this.mInterstitialAd != null && this.mInterstitialAd.isAdLoaded()) {
            if (!this.mInterstitialAd.isAdInvalidated()) {
                this.mInterstitialAd.show();
            } else {
                this.log("Unable to show interstitial - ad expired...");
                maxInterstitialAdapterListener.onInterstitialAdDisplayFailed(MaxAdapterError.AD_EXPIRED);
            }
        } else {
            this.log("Unable to show interstitial - no ad loaded...");
            maxInterstitialAdapterListener.onInterstitialAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, final MaxRewardedAdapterListener maxRewardedAdapterListener) {
        final String string = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        this.log("Loading rewarded: " + string + "...");
        this.updateAdSettings(maxAdapterResponseParameters.getServerParameters(), maxAdapterResponseParameters.isAgeRestrictedUser());
        this.mRewardedVideoAd = new RewardedVideoAd(activity.getApplicationContext(), string);
        this.mRewardedVideoAd.setAdListener((RewardedVideoAdListener)new RewardedVideoAdExtendedListener(){
            private boolean hasGrantedReward;

            public void onAdLoaded(Ad ad2) {
                FacebookMediationAdapter.this.log("Rewarded ad loaded: " + string);
                maxRewardedAdapterListener.onRewardedAdLoaded();
            }

            public void onError(Ad ad2, AdError adError) {
                FacebookMediationAdapter.this.log("Rewarded ad (" + string + ") failed to load with error code (" + adError.getErrorCode() + ") and message: " + adError.getErrorMessage());
                maxRewardedAdapterListener.onRewardedAdLoadFailed(FacebookMediationAdapter.toMaxError(adError));
            }

            public void onAdClicked(Ad ad2) {
                FacebookMediationAdapter.this.log("Rewarded ad clicked: " + string);
                maxRewardedAdapterListener.onRewardedAdClicked();
            }

            public void onRewardedVideoClosed() {
                FacebookMediationAdapter.this.log("Rewarded ad hidden: " + string);
                if (FacebookMediationAdapter.this.onRewardedAdHiddenCalled.compareAndSet(false, true)) {
                    if (this.hasGrantedReward || this.alwaysReward()) {
                        MaxReward maxReward = this.retrieveReward();
                        FacebookMediationAdapter.this.log("Rewarded user with reward: " + maxReward);
                        maxRewardedAdapterListener.onUserRewarded(maxReward);
                    }
                    maxRewardedAdapterListener.onRewardedAdHidden();
                }
            }

            public void onRewardedVideoCompleted() {
                FacebookMediationAdapter.this.log("Rewarded ad video completed: " + string);
                if (FacebookMediationAdapter.this.onRewardedAdVideoCompletedCalled.compareAndSet(false, true)) {
                    maxRewardedAdapterListener.onRewardedAdVideoCompleted();
                    this.hasGrantedReward = true;
                }
            }

            public void onLoggingImpression(Ad ad2) {
                FacebookMediationAdapter.this.log("Rewarded ad logging impression: " + string);
                maxRewardedAdapterListener.onRewardedAdDisplayed();
                maxRewardedAdapterListener.onRewardedAdVideoStarted();
            }

            public void onRewardedVideoActivityDestroyed() {
                FacebookMediationAdapter.this.log("Rewarded ad Activity destroyed: " + string);
                if (FacebookMediationAdapter.this.onRewardedAdVideoCompletedCalled.compareAndSet(false, true)) {
                    maxRewardedAdapterListener.onRewardedAdVideoCompleted();
                }
                if (FacebookMediationAdapter.this.onRewardedAdHiddenCalled.compareAndSet(false, true)) {
                    maxRewardedAdapterListener.onRewardedAdHidden();
                }
            }

            private MaxReward retrieveReward() {
                if (AppLovinSdk.VERSION_CODE >= 90500) {
                    return FacebookMediationAdapter.this.getReward();
                }
                return MaxReward.createDefault();
            }

            private boolean alwaysReward() {
                if (AppLovinSdk.VERSION_CODE >= 90500) {
                    return FacebookMediationAdapter.this.shouldAlwaysRewardUser();
                }
                return false;
            }
        });
        if (this.mRewardedVideoAd.isAdLoaded() && !this.mRewardedVideoAd.isAdInvalidated()) {
            this.log("A rewarded ad has been loaded already");
            maxRewardedAdapterListener.onRewardedAdLoaded();
        } else if (TextUtils.isEmpty((CharSequence)maxAdapterResponseParameters.getBidResponse())) {
            this.log("Loading mediated rewarded ad...");
            this.mRewardedVideoAd.loadAd();
        } else {
            this.log("Loading bidding rewarded ad...");
            this.mRewardedVideoAd.loadAdFromBid(maxAdapterResponseParameters.getBidResponse());
        }
    }

    public void showRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.log("Showing rewarded ad: " + maxAdapterResponseParameters.getThirdPartyAdPlacementId() + "...");
        if (this.mRewardedVideoAd != null && this.mRewardedVideoAd.isAdLoaded()) {
            if (!this.mRewardedVideoAd.isAdInvalidated()) {
                if (AppLovinSdk.VERSION_CODE >= 90500) {
                    this.configureReward(maxAdapterResponseParameters);
                }
                this.mRewardedVideoAd.show();
            } else {
                this.log("Unable to show rewarded ad - ad expired...");
                maxRewardedAdapterListener.onRewardedAdDisplayFailed(MaxAdapterError.AD_EXPIRED);
            }
        } else {
            this.log("Unable to show rewarded ad - no ad loaded...");
            maxRewardedAdapterListener.onRewardedAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
        }
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters maxAdapterSignalCollectionParameters, Activity activity, MaxSignalCollectionListener maxSignalCollectionListener) {
        this.log("Collecting signal...");
        String string = BidderTokenProvider.getBidderToken((Context)activity);
        maxSignalCollectionListener.onSignalCollected(string);
    }

    public void loadAdViewAd(MaxAdapterResponseParameters maxAdapterResponseParameters, MaxAdFormat maxAdFormat, Activity activity, final MaxAdViewAdapterListener maxAdViewAdapterListener) {
        final String string = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        this.log("Loading banner ad: " + string + "...");
        this.updateAdSettings(maxAdapterResponseParameters.getServerParameters(), maxAdapterResponseParameters.isAgeRestrictedUser());
        this.mAdView = new AdView((Context)activity, string, this.toAdSize(maxAdFormat));
        this.mAdView.setAdListener(new AdListener(){

            public void onAdLoaded(Ad ad2) {
                FacebookMediationAdapter.this.log("Banner ad loaded: " + string);
                maxAdViewAdapterListener.onAdViewAdLoaded((View)FacebookMediationAdapter.this.mAdView);
            }

            public void onError(Ad ad2, AdError adError) {
                FacebookMediationAdapter.this.log("Banner ad (" + string + ") failed to load with error code (" + adError.getErrorCode() + ") and message: " + adError.getErrorMessage());
                maxAdViewAdapterListener.onAdViewAdLoadFailed(FacebookMediationAdapter.toMaxError(adError));
            }

            public void onAdClicked(Ad ad2) {
                FacebookMediationAdapter.this.log("Banner ad clicked: " + string);
                maxAdViewAdapterListener.onAdViewAdClicked();
            }

            public void onLoggingImpression(Ad ad2) {
                FacebookMediationAdapter.this.log("Banner ad displayed: " + string);
                maxAdViewAdapterListener.onAdViewAdDisplayed();
            }
        });
        if (TextUtils.isEmpty((CharSequence)maxAdapterResponseParameters.getBidResponse())) {
            this.log("Loading mediated banner ad...");
            this.mAdView.loadAd();
        } else {
            this.log("Loading bidding banner ad...");
            this.mAdView.loadAdFromBid(maxAdapterResponseParameters.getBidResponse());
        }
    }

    public void onDestroy() {
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd.destroy();
            this.mInterstitialAd = null;
        }
        if (this.mRewardedVideoAd != null) {
            this.mRewardedVideoAd.destroy();
            this.mRewardedVideoAd = null;
        }
        if (this.mAdView != null) {
            this.mAdView.destroy();
            this.mAdView = null;
        }
    }

    private AdSize toAdSize(MaxAdFormat maxAdFormat) {
        if (maxAdFormat == MaxAdFormat.BANNER) {
            return AdSize.BANNER_HEIGHT_50;
        }
        if (maxAdFormat == MaxAdFormat.LEADER) {
            return AdSize.BANNER_HEIGHT_90;
        }
        if (maxAdFormat == MaxAdFormat.MREC) {
            return AdSize.RECTANGLE_HEIGHT_250;
        }
        throw new IllegalArgumentException("Invalid ad format: " + maxAdFormat);
    }

    private void updateAdSettings(Bundle bundle, boolean bl) {
        boolean bl2;
        if (bundle.containsKey("video_autoplay")) {
            bl2 = bundle.getBoolean("video_autoplay");
            AdSettings.setVideoAutoplay((boolean)bl2);
        }
        if (bundle.containsKey("child_directed_treatment")) {
            bl2 = bundle.getBoolean("child_directed_treatment");
            AdSettings.setIsChildDirected((boolean)bl2);
        } else {
            AdSettings.setIsChildDirected((boolean)bl);
        }
        String string = bundle.getString("test_device_ids", null);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            List<String> list = Arrays.asList(string.split(","));
            AdSettings.addTestDevices(list);
        }
        AdSettings.setMediationService((String)this.getMediationIdentifier(bundle));
    }

    private static MaxAdapterError toMaxError(AdError adError) {
        int n2 = adError == AdError.NETWORK_ERROR ? -5207 : (adError == AdError.NO_FILL ? 204 : (adError == AdError.LOAD_TOO_FREQUENTLY ? -5201 : (adError == AdError.SERVER_ERROR ? -5208 : (adError == AdError.INTERNAL_ERROR ? -5206 : -5200))));
        int n3 = adError != null ? adError.getErrorCode() : 0;
        return new MaxAdapterError(n2, n3);
    }

    private String getMediationIdentifier(Bundle bundle) {
        boolean bl = bundle.getBoolean("set_mediation_identifier", true);
        return bl ? "APPLOVIN_" + AppLovinSdk.VERSION + ":" + this.getAdapterVersion() : "";
    }
}

