package com.yodo1.advert.helper;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.LocaleList;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.entity.AdvertType;
import com.yodo1.advert.utils.YOnlineConfigUtils;
import com.yodo1.android.ops.net.HttpListener;
import com.yodo1.android.ops.net.Yodo1HttpManage;
import com.yodo1.android.ops.net.Yodo1SDKResponse;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.sdk.kit.MD5EncodeUtil;
import com.yodo1.sdk.kit.SysUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1CommonUtils;
import com.yodo1.sdk.kit.Yodo1DeviceUtils;
import com.yodo1.sdk.kit.Yodo1NetWorkUtils;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import static com.yodo1.advert.entity.AdvertType.*;


/**
 * Created by zhuxiaochen on 2018/4/3.
 */

public class Yodo1ErrorUpdataHelper {
    private Yodo1ErrorUpdataHelper() {
    }


    private static class Yodo1ErrorUpdataHelperInstance {
        private static final Yodo1ErrorUpdataHelper INSTANCE = new Yodo1ErrorUpdataHelper();
    }

    public static Yodo1ErrorUpdataHelper getInstance() {
        return Yodo1ErrorUpdataHelperInstance.INSTANCE;
    }

    private final String ErrorMsg = "Yodo1ErrorUpdataMsg";
    private final String ErrorRecentMsg = "Yodo1ErrorRecentMsg";
    private static final String errorUpdataUrl = "https://hades.yodo1api.com/hades/feedback";
    private static JSONArray array = new JSONArray();
    private List<String> list = new ArrayList<String>();

    public void ErrorCollection(Context context, String advertCode, int errorCode, int adErrorCode,String adErrorMsg, AdvertType advertType) {
        YLog.d("ErrorCollection：  " + advertCode + "  " + adErrorMsg);

        String tag = advertCode + "&" + advertType.name();
        if (list.contains(tag)) {
            YLog.d("当前上报信息中已经包含此异常信息，重复信息将不再保存");
            return;
        }

        list.add(tag);
        JSONObject object = new JSONObject();
        try {
            object.put("target", advertCode);
            object.put("time", System.currentTimeMillis());

            if (advertType == Interstitial) {
                object.put("step_id", "requestInterstitialAD");
                object.put("step_des", "请求插屏广告");
            } else if (advertType == Video) {
                object.put("step_id", "requestVideoAD");
                object.put("step_des", "请求视频广告");
            } else if (advertType == Banner) {
                object.put("step_id", "requestBannerAD");
                object.put("step_des", "展示Banner广告");
            } else if (advertType == Splash) {
                object.put("step_id", "requestSplashAD");
                object.put("step_des", "展示开屏广告");
            } else if (advertType == Native) {
                object.put("step_id", "requestNativeAD");
                object.put("step_des", "请求原生广告");
            }


            if (errorCode == Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION) {
                if (adErrorCode == 0 & !TextUtils.isEmpty(adErrorMsg)){
                    object.put("type_id", "1003");
                    object.put("type_des", adErrorMsg);
                } else if (adErrorCode != 0 & TextUtils.isEmpty(adErrorMsg)) {
                    object.put("type_id", adErrorCode);
                    object.put("type_des", "广告请求失败");
                } else {
                    object.put("type_id", adErrorCode);
                    object.put("type_des", adErrorMsg);
                }

                object.put("advice_solver", "it");
            } else if (errorCode == Yodo1AdConst.ADVERT_ERROR_ID_NULL) {
                object.put("type_id", "1000");
                object.put("type_des", "缺少参数");
                object.put("advice_solver", "ops");
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }

        array.put(object);

        Yodo1SharedPreferences.put(context, ErrorMsg, array.toString());
        Yodo1SharedPreferences.put(context, ErrorRecentMsg, object.toString());
    }

    /**
     * 信息上报
     *
     * @param context
     */
    public void updata(final Context context, String appKey) {

        boolean adSwitch = YOnlineConfigUtils.isTrunOnErrorUpdataSwitch();
        if (!adSwitch){
            YLog.d("ErrorCollection 错误信息收集开关关闭，暂停上报");
            return;
        }
        String errorMsg = Yodo1SharedPreferences.getString(context, ErrorMsg);
        if (TextUtils.isEmpty(errorMsg)) {
            YLog.d("ErrorCollection 本地无缓存信息，暂停上报");
            return;
        }


        int net = Yodo1NetWorkUtils.getAPNType(context);
        String net_type = "";
        if (net == 1){
            net_type = "wifi";
        } else  if (net == 2){
            net_type = "4g";
        } else  if (net == 3){
            net_type = "2g";
        } else {
            net_type = "net_error";
        }

        Locale locale;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            locale = context.getResources().getConfiguration().getLocales().get(0);
        } else {
            locale = context.getResources().getConfiguration().locale;
        }

        JSONObject submitJson = new JSONObject();
        JSONObject dataJson = new JSONObject();
        try {
            JSONArray errJson = new JSONArray(errorMsg);
            dataJson.put("game_appkey", appKey);
            dataJson.put("device_country_code", locale.getCountry());
            dataJson.put("device_language_code", locale.getLanguage());
            dataJson.put("sdk_type", Yodo1OnlineConfig.SDKTyoe);
            dataJson.put("sdk_version", Yodo1OnlineConfig.SDKVersion);
            dataJson.put("os", "android");
            dataJson.put("os_version", android.os.Build.VERSION.RELEASE);
            dataJson.put("device_id", Yodo1DeviceUtils.getDeviceId(context));
            dataJson.put("device_name", android.os.Build.MODEL);
            dataJson.put("network", net_type);
            dataJson.put("game_version", SysUtils.getVersionName(context));
            dataJson.put("channel", Yodo1OnlineConfig.ChannelCode);
            dataJson.put("error", errJson);

            long timestamp = System.currentTimeMillis();
            submitJson.put("record", "client_ad");
            submitJson.put("sign", MD5EncodeUtil.MD5Encode("client_ad" + timestamp + "yodo1"));
            submitJson.put("timestamp", timestamp);
            submitJson.put("data", dataJson);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        String submitStr = submitJson.toString();
        YLog.d("ErrorCollection  上报信息 submitStr ： " + submitStr);
        Request<String> request = NoHttp.createStringRequest(errorUpdataUrl, RequestMethod.POST);
        request.setDefineRequestBody(submitStr, "text/plain;charset=UTF-8");
        Yodo1HttpManage.getInstance().connect(0, request, new HttpListener<String>() {
            @Override
            public void onSucceed(int what, Response<String> response) {
                YLog.d("ErrorCollection  上报结果" + response.get());
                Yodo1SharedPreferences.put(context, ErrorMsg, "");
            }

            @Override
            public void onFailed(int what, Response<String> response) {
                YLog.d("ErrorCollection  上报失败");
            }
        }, false);
    }




}
