package com.yodo1.advert.factory;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;

import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.utils.YOnlineConfigUtils;
import com.yodo1.android.ops.net.Yodo1HttpManage;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.onlineconfig.Yodo1OnlineConfigListener;
import com.yodo1.plugin.dmp.yodo1.open.Yodo1Analytics;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1CommonUtils;
import com.yodo1.sdk.kit.Yodo1PropertiesUtils;

import java.util.Map;

public class ActivityObserver implements Application.ActivityLifecycleCallbacks {

    String mainClassName = "";
    @Override
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {

        mainClassName = Yodo1CommonUtils.getMetedataStr(activity, "YODO1_MAIN_CLASS");;

        if(TextUtils.isEmpty(mainClassName)) {
            mainClassName = Yodo1PropertiesUtils.getInstance().getBasicConfigValue("mainClassName");
        }

        boolean on = YOnlineConfigUtils.isTrunOnYodo1Ads(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd);

        //1: 当前是游戏主Activity  2: 开屏广告已打开
        if (activity.getClass().getName() .equals(mainClassName) && on){
            Intent intent = new Intent(activity, Yodo1SplashAdActivity.class);
            activity.startActivity(intent);
        }


    }

    @Override
    public void onActivityStarted(Activity activity) {

    }

    @Override
    public void onActivityResumed(Activity activity) {
        if (activity.getClass().getName() .equals(mainClassName) ){
            YLog.d("ActivityObserver, onActivityResumed");
            Yodo1OnlineConfig.getInstance().getOnlineConfig(new Yodo1OnlineConfigListener() {
                @Override
                public void getDataFinish(int code, String onlineConfig) {

                }
            });
            if (Yodo1OnlineConfig.getInstance().hasData()) {
                for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters().entrySet()) {
                    if (adapter.getValue() != null) {
                        adapter.getValue().onResume(activity);
                    }
                }
                Yodo1Analytics.onResume(activity);
            }
        }

    }

    @Override
    public void onActivityPaused(Activity activity) {
        if (activity.getClass().getName() .equals(mainClassName) ){

            for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters().entrySet()) {
                if (adapter.getValue() != null) {
                    adapter.getValue().onPause(activity);
                }
            }

            Yodo1Analytics.onPause(activity);
        }

    }

    @Override
    public void onActivityStopped(Activity activity) {

    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

    }

    @Override
    public void onActivityDestroyed(Activity activity) {

        if (activity.getClass().getName() .equals(mainClassName) ){

            for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters().entrySet()) {
                if (adapter.getValue() != null) {
                    adapter.getValue().onDestroy(activity);
                }
            }

            Yodo1Analytics.onDestroy();
            Yodo1HttpManage.getInstance().onDestroy();
        }



    }
}
