package com.yodo1.advert.adapter.kit;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.yodo1.advert.adapter.AdvertAdapteryodo1;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.CacheMode;
import com.yodo1.nohttp.rest.OnResponseListener;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.RequestQueue;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.sdk.kit.RR;


/**
 * Created by zhuxc
 * 头像列表
 */

public class Yodo1InterAdView extends RelativeLayout {
    private OnYodo1AdsCallBack adsCallBack;
    private Context context;
    private ImageView adImg;
    private ImageButton adCloseBtn;
    private Bitmap bm;
    private FrameLayout frameLayout;
    private RelativeLayout view;
    private boolean isLoded;

    public Yodo1InterAdView(Context context) {
        super(context);
        this.context = context;
        view = (RelativeLayout) View.inflate(context, RR.layout(context,"yodo1_inter_view"),this);
        initView();
        loadAds();
    }

    private void initView() {
        adImg = findViewById(RR.id(context,"yodo1_iv_interimg"));
        adCloseBtn = findViewById(RR.id(context,"yodo1_iv_interclose"));

        adImg.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {

                Intent intent = new Intent(Intent.ACTION_VIEW);
                Uri uri = Uri.parse(AdvertAdapteryodo1.Yodo1_WEB_URL);
                intent.setData(uri);
                context.startActivity(intent);

                adsCallBack.setOnAdClickListener();
            }
        });

        adCloseBtn.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                removeYodo1Ads();
                adsCallBack.setOnAdCloseListener();
            }
        });
    }


    public boolean adLoaded(){

        return isLoded;
    }



    /**
     * 加载广告
     */
    public  void loadAds() {
        String url = "https://docs.yodo1.com/media/ad-test-resource/ad-interestital.png";
        RequestQueue requestQueue = NoHttp.newRequestQueue();
        Request<Bitmap> requeset = NoHttp.createImageRequest(url, RequestMethod.GET);
        OnResponseListener<Bitmap> listener = new OnResponseListener<Bitmap>() {
            @Override
            public void onStart(int what) {
            }

            @Override
            public void onSucceed(int what, Response<Bitmap> response) {
                bm = response.get();
                isLoded = true;
                adsCallBack.setOnAdLoadSuccessListener();
            }

            @Override
            public void onFailed(int what, Response<Bitmap> response) {

                adsCallBack.setOnAdLoadFailedListener();
            }

            @Override
            public void onFinish(int what) {
            }
        };
        //设置缓存模式
        requeset.setCacheMode(CacheMode.REQUEST_NETWORK_FAILED_READ_CACHE);
        requestQueue.add(1, requeset, listener);

    }



    public void showYodo1Ads(Activity activity){

        if (isLoded){
            frameLayout = (FrameLayout)activity.findViewById(android.R.id.content);
            frameLayout.addView(view);
            adImg.setImageBitmap(bm);
            adsCallBack.setOnAdShowSuccessListener();
        }

    }


    public void removeYodo1Ads(){
        frameLayout.removeView(view);
        isLoded = false;
        bm = null;
    }



    public void setOnYodo1AdsCallback(OnYodo1AdsCallBack callback) {
        this.adsCallBack = callback;
    }



    public interface OnYodo1AdsCallBack{
        void setOnAdClickListener();

        void setOnAdCloseListener();

        void setOnAdShowSuccessListener();


        void setOnAdLoadSuccessListener();

        void setOnAdLoadFailedListener();


    }


}
