package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.tapjoy.TJActionRequest;
import com.tapjoy.TJConnectListener;
import com.tapjoy.TJError;
import com.tapjoy.TJPlacement;
import com.tapjoy.TJPlacementListener;
import com.tapjoy.TJPlacementVideoListener;
import com.tapjoy.Tapjoy;
import com.tapjoy.TapjoyLog;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

import java.util.Hashtable;

/**
 * Created by yodo1 on 17/8/31.
 */
public class AdvertAdaptertapjoy extends AdapterAdvertBase {
    private Yodo1AdCallback intersititalCallback, videoCallback; //插屏回调
    private Yodo1ReloadCallback reloadInterCallback, reloadVideoCallback;
    private TJPlacement directInterPlayPlacement, directVideoPlayPlacement;

    public static final String CHANNEL_CODE = "Tapjoy";

    public static final String KEY_APPKEY = "ad_tapjoy_appkey"; //sdk密钥
    public static String appkey = "";

    public static final String KEY_PLACEMENT_VIDEO = "ad_tapjoy_placement_video";//视频广告位
    public static String placementVideo = "";

    public static final String KEY_PLACEMENT_INTERSTITIAL = "ad_tapjoy_placement_interstitial";//插屏广告位
    public static String placementInterstitial = "";


    private TJPlacementListener videoListener = new TJPlacementListener() {

        @Override
        public void onRequestSuccess(TJPlacement tjPlacement) {
            YLog.i("Tapjoy  onRequestSuccess");
        }

        @Override
        public void onRequestFailure(TJPlacement tjPlacement, TJError tjError) {
            YLog.i("Tapjoy  onRequestFailure");
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, tjError.code, "异常码： " + tjPlacement + " 错误信息：" + tjError.message, getAdvertCode());
            }
        }

        @Override
        public void onContentReady(TJPlacement tjPlacement) {
            YLog.i("Tapjoy  onContentReady");
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onContentShow(TJPlacement tjPlacement) {
            YLog.i("Tapjoy  onContentShow");
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onContentDismiss(TJPlacement tjPlacement) {
            YLog.i("Tapjoy  onContentDismiss");
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onPurchaseRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s) {
            YLog.i("Tapjoy  onPurchaseRequest");
        }

        @Override
        public void onRewardRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s, int i) {
            YLog.i("Tapjoy  onRewardRequest");
        }

        @Override
        public void onClick(TJPlacement tjPlacement) {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };


    private TJPlacementVideoListener tjPlacementVideoListener = new TJPlacementVideoListener() {
        @Override
        public void onVideoStart(TJPlacement tjPlacement) {

        }

        @Override
        public void onVideoError(TJPlacement tjPlacement, String s) {

        }

        @Override
        public void onVideoComplete(TJPlacement tjPlacement) {
            // Best Practice: We recommend calling getCurrencyBalance as often as possible so the user�s balance is always up-to-date.
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }
    };

    @Override
    public void showVideoAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.videoCallback = callback;
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (directVideoPlayPlacement != null && directVideoPlayPlacement.isContentReady()) {
                    directVideoPlayPlacement.showContent();

                } else {
                    callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", CHANNEL_CODE);
                }

            }
        });

    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;
        if (TextUtils.isEmpty(placementVideo)) {
            YLog.e("AdvertAdapterTapjoy, placementVideo is null");
            reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "", getAdvertCode());
            return;
        }

        try {
            if (Tapjoy.isConnected()) {
                YLog.i("AdvertAdapterTapjoy, video onConnectSuccess");
                directVideoPlayPlacement = Tapjoy.getPlacement(placementVideo, videoListener);

                directVideoPlayPlacement.setVideoListener(tjPlacementVideoListener);
                directVideoPlayPlacement.requestContent();
            } else {
                YLog.d("Tapjoy SDK must finish connecting before requesting content.");
            }
        } catch (Exception e) {
            e.printStackTrace();
        } catch (Error e) {
            e.printStackTrace();
        }
    }


    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return directVideoPlayPlacement != null && directVideoPlayPlacement.isContentReady();
    }


    private TJPlacementListener interstitialListener = new TJPlacementListener() {

        @Override
        public void onRequestSuccess(TJPlacement tjPlacement) {
            YLog.i("Tapjoy  onRequestSuccess");
        }

        @Override
        public void onRequestFailure(TJPlacement tjPlacement, TJError tjError) {
            YLog.i("Tapjoy  onRequestFailure ");
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, tjError.code, "异常码： " + tjPlacement + " 错误信息：" + tjError.message, getAdvertCode());
            }

        }

        @Override
        public void onContentReady(TJPlacement tjPlacement) {
            YLog.i("Tapjoy  onContentReady");
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onContentShow(TJPlacement tjPlacement) {
            YLog.i("Tapjoy  onContentShow");
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, CHANNEL_CODE);
            }
        }

        @Override
        public void onContentDismiss(TJPlacement tjPlacement) {
            YLog.i("Tapjoy  onContentDismiss");
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, CHANNEL_CODE);
            }
        }

        @Override
        public void onPurchaseRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s) {
            YLog.i("Tapjoy  onPurchaseRequest");
        }

        @Override
        public void onRewardRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s, int i) {
            YLog.i("Tapjoy  onRewardRequest");
        }

        @Override
        public void onClick(TJPlacement tjPlacement) {
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };


    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.intersititalCallback = callback;

        try {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (directInterPlayPlacement != null && directInterPlayPlacement.isContentReady()) {
                        directInterPlayPlacement.showContent();

                    } else {
                        callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", CHANNEL_CODE);
                    }

                }
            });
        } catch (Exception exception) {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "Exception", CHANNEL_CODE);
        }


    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadInterCallback = callback;
        if (TextUtils.isEmpty(placementInterstitial)) {
            YLog.e("AdvertAdapterTapjoy, placementInterstitial is null");
            reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "", getAdvertCode());
            return;
        }

        try {
            if (Tapjoy.isConnected()) {
                directInterPlayPlacement = Tapjoy.getPlacement(placementInterstitial, interstitialListener);
                directInterPlayPlacement.requestContent();
            } else {
                YLog.i("Tapjoy SDK must finish connecting before requesting content.");
            }
        } catch (Exception exception) {
            YLog.i("Tapjoy SDK Exception .");
        }

    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return directInterPlayPlacement != null && directInterPlayPlacement.isContentReady();
    }

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
        appkey = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE
                , KEY_APPKEY);
        placementVideo = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE
                , KEY_PLACEMENT_VIDEO);
        placementInterstitial = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE
                , KEY_PLACEMENT_INTERSTITIAL);


        if (TextUtils.isEmpty(appkey)) {
            return;
        }
        Hashtable<String, Object> connectFlags = new Hashtable<String, Object>();
        boolean isDebugEnabled = false;
        if (isDebugEnabled) {
            connectFlags.put("TJC_OPTION_ENABLE_LOGGING", "true");
            Tapjoy.setDebugEnabled(true);
            TapjoyLog.setDebugEnabled(true);
        } else {
            connectFlags.put("TJC_OPTION_ENABLE_LOGGING", "false");
            Tapjoy.setDebugEnabled(false);
            TapjoyLog.setDebugEnabled(false);
        }
        YLog.i("AdvertCoreTapjoy, init ...");
        Tapjoy.setActivity(activity);
        Tapjoy.connect(activity.getApplicationContext(), appkey, connectFlags, new TJConnectListener() {
            @Override
            public void onConnectSuccess() {
                YLog.i("Tapjoy  connectSuccess");

            }

            @Override
            public void onConnectFailure() {
                YLog.i("Tapjoy  onConnectFail");
            }
        });


    }

    @Override
    public void onResume(Activity activity) {
        Tapjoy.onActivityStart(activity);
    }

    @Override
    public void onPause(Activity activity) {
        Tapjoy.onActivityStart(activity);
    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        Tapjoy.setUserConsent(privacy.isHasUserConsent() ? "1" : "0");
        Tapjoy.belowConsentAge(privacy.isAgeRestrictedUser());
        Tapjoy.setActivity(context);
    }

}
