package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.text.TextUtils;

import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.banner.Yodo1BannerAlign;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

import static com.google.android.gms.ads.AdSize.BANNER;


public class AdvertAdapteradmob extends AdapterAdvertBase {

    private static final String CHANNEL_CODE = "AdMob";

    private static final String KEY_AdMob_INTERSTITIAL_ID = "ad_admob_interstitial_id";
    private static final String KEY_AdMob_BANNER_ID = "ad_admob_banner_unitId";
    private static final String KEY_AdMob_VIDEO_ID = "ad_admob_video_unitId";
    private static final String KEY_AdMob_BANNER_APPID = "ad_admob_banner_appId";
    private static final String KEY_AdMob_VIDEO_APPID = "ad_admob_video_appId";
    private static final String KEY_AdMob_INTERSTITIAL_APPID = "ad_admob_interstitial_appId";
    //Banner
    public String BannerUnitId = "";
    private AdRequest adRequest;
    private AdView mAdView;
    private InterstitialAd mInterstitialAd;
    private RewardedVideoAd mRewardedVideoAd;
    private int align = Yodo1BannerAlign.BannerAlignHorizontalCenter | Yodo1BannerAlign.BannerAlignBottom;
    private boolean isBannerLoaded = false;
    //Interinstitial
    private String InterUnitId;
    //视频
    private String VideoUnitId = "";


    private Yodo1AdCallback intersititalCallback, videoCallback, bannerCallback; //插屏回调
    private Yodo1ReloadCallback reloadInterCallback, reloadVideoCallback, reloadBannerCallback;


    private AdListener adBannerListener = new AdListener() {
        @Override
        public void onAdLoaded() {
            isBannerLoaded = true;
            // Code to be executed when an ad finishes loading.
            YLog.d("Admob onAdLoaded");
        }

        @Override
        public void onAdFailedToLoad(int errorCode) {
            // Code to be executed when an ad request fails.
            YLog.i("Admob onAdFailedToLoad" + errorCode);

        }

        @Override
        public void onAdOpened() {
            // Code to be executed when an ad opens an overlay that
            // covers the screen.
            YLog.d("Admob onAdOpened");
        }

        @Override
        public void onAdLeftApplication() {
            // Code to be executed when the user has left the app.
            if (bannerCallback != null) {
                bannerCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdClosed() {
            // Code to be executed when when the user is about to return
            // to the app after tapping on an ad.
            if (bannerCallback != null) {
                bannerCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }
    };


    private RewardedVideoAdListener listener = new RewardedVideoAdListener() {
        @Override
        public void onRewardedVideoAdLoaded() {
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdOpened() {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoStarted() {

        }

        @Override
        public void onRewardedVideoAdClosed() {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onRewarded(RewardItem rewardItem) {

        }

        @Override
        public void onRewardedVideoAdLeftApplication() {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdFailedToLoad(int errorCode) {
            YLog.d("AdMob   onRewardedVideoAdFailedToLoad: " + errorCode);

            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode, "异常码： " + errorCode + " 错误信息：" + errorCode, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoCompleted() {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }
    };
    private AdListener adListener = new AdListener() {
        @Override
        public void onAdClosed() {
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        //            Called when an ad request failed. The error code is usually ERROR_CODE_INTERNAL_ERROR, ERROR_CODE_INVALID_REQUEST, ERROR_CODE_NETWORK_ERROR, or ERROR_CODE_NO_FILL.
        @Override
        public void onAdFailedToLoad(int errorCode) {
            YLog.d("Advert, Admob Interstitial onAdFailedToLoad, adErrorCode = " + errorCode);

            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode, "异常码： " + errorCode + " 错误信息：" + errorCode, getAdvertCode());
            }
        }

        //           Called when an ad opens an overlay that covers the screen.
        @Override
        public void onAdOpened() {
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        //            Called when an ad leaves the application  eg： 去往浏览器
        @Override
        public void onAdLeftApplication() {
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        //            Called when an ad is received.
        @Override
        public void onAdLoaded() {
            YLog.d("Advert, AdMob Interstitial onAdLoaded ... ");
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadSuccess(getAdvertCode());
            }

        }

    };
    private Yodo1Privacy privacy;

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(Activity activity) {
        //此处读取key
        String appid = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, CHANNEL_CODE
                , KEY_AdMob_BANNER_APPID);

//            appid = "ca-app-pub-7188592076082444~5943610619";
        if (TextUtils.isEmpty(appid)) {
            appid = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE
                    , KEY_AdMob_VIDEO_APPID);
        }
        if (TextUtils.isEmpty(appid)) {
            appid = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE
                    , KEY_AdMob_INTERSTITIAL_APPID);
        }

        if (!TextUtils.isEmpty(appid)) {
            MobileAds.initialize(activity.getApplicationContext(), appid);
        }

        Bundle admobExtras = new Bundle();
        if (privacy !=null && !privacy.isHasUserConsent()) {
            admobExtras.putString("npa", "1");
        }
        AdRequest.Builder builder = new AdRequest.Builder();
        builder.addNetworkExtrasBundle(AdMobAdapter.class, admobExtras);
        adRequest = builder.build();

        initVideoAdMob(activity);
        iniIntertAdmob(activity);
        iniBannertAdmob(activity);

    }

    private void iniBannertAdmob(Activity activity) {

        BannerUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, CHANNEL_CODE
                , KEY_AdMob_BANNER_ID);

        if (TextUtils.isEmpty(BannerUnitId)) {
            YLog.e("AdMob  BannerUnitId  is null");
            return;
        }

        if (mAdView == null) {
            mAdView = new AdView(activity);
            mAdView.setAdUnitId(BannerUnitId);
            mAdView.setAdSize(BANNER);
            mAdView.setAdListener(adBannerListener);
            mAdView.loadAd(adRequest);
        }


    }

    private void iniIntertAdmob(Activity activity) {


        InterUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE
                , KEY_AdMob_INTERSTITIAL_ID + "1");


        if (TextUtils.isEmpty(InterUnitId)) {
            YLog.e("Admob  InterUnitId  is null");
            return;
        }
        YLog.d("Admob InterUnitId : " + InterUnitId);

        mInterstitialAd = new InterstitialAd(activity);
        mInterstitialAd.setAdUnitId(InterUnitId);

        mInterstitialAd.setAdListener(adListener);

    }

    private void initVideoAdMob(Activity activity) {
        VideoUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE
                , KEY_AdMob_VIDEO_ID);
        if (TextUtils.isEmpty(VideoUnitId)) {
            YLog.e("AdMob VideoUnitId  is null");
            return;
        }

        // Use an activity context to get the rewarded video instance.
        mRewardedVideoAd = MobileAds.getRewardedVideoAdInstance(activity);
        mRewardedVideoAd.setRewardedVideoAdListener(listener);

    }

    @Override
    public void onResume(Activity activity) {

        if (mAdView != null) {
            mAdView.resume();
        }

        if (mRewardedVideoAd != null) {
            mRewardedVideoAd.resume(activity);
        }
    }

    @Override
    public void onPause(Activity activity) {

        if (mAdView != null) {
            mAdView.pause();
        }
        if (mRewardedVideoAd != null) {
            mRewardedVideoAd.pause(activity);
        }
    }

    @Override
    public void onDestroy(Activity activity) {

        if (mAdView != null) {
            mAdView.destroy();
        }

        if (mRewardedVideoAd != null) {
            mRewardedVideoAd.destroy(activity);
        }
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;
        if (mRewardedVideoAd != null && mRewardedVideoAd.isLoaded()) {
            mRewardedVideoAd.show();
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;
        if (TextUtils.isEmpty(VideoUnitId)) {
            reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "", getAdvertCode());
            YLog.e("AdMob Video UnitId  is null");
            return;
        }

        YLog.d("Admob reloadVideoAdvert : " + VideoUnitId);
        if (mRewardedVideoAd != null) {
            mRewardedVideoAd.loadAd(VideoUnitId, adRequest);
        }

    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return mRewardedVideoAd != null && mRewardedVideoAd.isLoaded();
    }

    //    预加载
    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadInterCallback = callback;
        if (TextUtils.isEmpty(InterUnitId)) {
            YLog.e("Admob  APPID  is null");
            callback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "", getAdvertCode());
            return;
        }

        // Request a new ad if one isn't already loaded
        if (mInterstitialAd != null && !mInterstitialAd.isLoaded()) {
            mInterstitialAd.loadAd(adRequest);
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        if (TextUtils.isEmpty(InterUnitId)) {
            YLog.e("Admob  APPID  is null");
            return false;
        }

        return mInterstitialAd != null && mInterstitialAd.isLoaded();
    }

    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.intersititalCallback = callback;
        if (TextUtils.isEmpty(InterUnitId)) {
            YLog.e("Admob  APPID  is null");
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
            return;
        }

        if (mInterstitialAd != null && mInterstitialAd.isLoaded()) {
            YLog.d("admob  展示成功 Key：  " + InterUnitId);
            mInterstitialAd.show();
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }


    }

    /* 显示banner广告
     * @param activity
     * @param callback
     */
    @Override
    public void showBanner(Activity activity, Yodo1AdCallback callback) {
        this.bannerCallback = callback;

        if (TextUtils.isEmpty(BannerUnitId)) {
            YLog.e("AdMob  UnitId  is null");
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, "showBannerFailed", getAdvertCode());
            return;
        }

        if (isBannerLoaded) {
            YLog.d("AdMob showBanner ");
            Yodo1BannerAlign.setYodo1BannerLayout(activity, mAdView, align);
            callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
        } else {
            YLog.d("AdMob showBanner  error");
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, "onAdFailedToLoad", getAdvertCode());

        }

    }

    ;

    /**
     * banner广告删除
     *
     * @param activity
     */
    @Override
    public void removeBanner(Activity activity) {
        isBannerLoaded = false;
        YLog.d("AdMob removeBanner ");

        if (mAdView != null) {
            mAdView.destroy();
            mAdView = null;
        }
    }

    /**
     * 隐藏
     *
     * @param activity
     */
    @Override
    public void hideBanner(Activity activity) {
        YLog.d("AdMob hideBanner ");
        if (mAdView != null) {
            Yodo1BannerAlign.removeYodo1BannerLayout(activity, mAdView);
        }
    }

    /**
     * 设置banner展示位置
     *
     * @param activity
     * @param align    banner展示位置
     */
    @Override
    public void setBannerAlign(Activity activity, int align) {
        this.align = align;
        YLog.d("AdMob setBannerAlign");
    }

    @Override
    public boolean hasLoadBanner() {
        return isBannerLoaded;
    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        this.privacy = privacy;
    }

}
