package com.yodo1.advert;

import android.app.Activity;

import com.yodo1.sdk.kit.Yodo1Privacy;

/**
 * Created by yodo1 on 2016/3/22.
 */
public abstract class AdapterAdvertBase implements AdLifecycle {
    /**
     * 返回该广告渠道的AdvertCode，要与类名后缀一致
     *
     * @return
     */
    public abstract String getAdvertCode();


    /**
     * 返回该广告SDK的版本号
     *
     * @return
     */
    public String getSDKVesion() {
        return null;
    }

    /**
     * 校验广告SDK manifest声明是否正确
     */
    public void validateAdsAdapter(Activity activity) {
    }


    /*
     * EU consent and GDPR
     */
    public void setPrivacy(final Yodo1Privacy privacy, final Activity context) {
    }


    /*
     * 初始化插屏广告
     */
    public void initInterstitialAd(Activity activity) {
    }


    /*
     * 初始化视频广告
     */
    public void initVideoAd(Activity activity) {
    }


    /*
     * 初始化Banner
     */
    public void initBannerAd(Activity activity) {
    }


    /*
     * 初始化原生广告
     */
    public void initNativeAd(Activity activity) {
    }


    /**
     * 显示游戏视频广告
     *
     * @param activity
     * @param callback
     */
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
    }


    /**
     * 游戏视频预加载方法
     *
     * @param activity
     */
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
    }


    /**
     * 游戏视频是否预加载完成的方法
     *
     * @param activity
     */
    public boolean videoAdvertIsLoaded(Activity activity) {
        return false;
    }


    /**
     * 显示插屏广告
     *
     * @param activity
     * @param callback
     */
    public void showSplashAdvert(Activity activity, Yodo1AdCallback callback) {
    }


    /**
     * 显示插屏广告
     *
     * @param activity
     * @param callback
     */
    public void showIntersititalAdvert(Activity activity, Yodo1AdCallback callback) {
    }


    /**
     * 插屏广告预加载方法
     *
     * @param activity
     */
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
    }


    /**
     * 游戏视频是否预加载完成的方法
     *
     * @param activity
     */
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return false;
    }


    /* 显示banner广告
     * @param activity
     * @param callback
     */
    public void showBanner(Activity activity, Yodo1AdCallback callback) {
    }


    /**
     * 移除banner广告
     *
     * @param activity
     */
    public void removeBanner(Activity activity) {
    }


    /**
     * 隐藏banner
     *
     * @param activity
     */
    public void hideBanner(Activity activity) {
    }


    /**
     * 设置广告显示位置
     *
     * @param activity
     * @param align
     */
    public void setBannerAlign(Activity activity, int align) {
    }


    /**
     * 广告是否预加载成功
     */
    public boolean hasLoadBanner() {
        return false;
    }


    /**
     * 显示原生广告
     *
     * @param activity
     * @param px       广告的x位置，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param py       广告的y位置，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param pw       广告的宽度width，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param ph       广告的高度height，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param callback
     */
    public void showNativeAdvert(Activity activity, float px, float py, float pw, float ph, Yodo1AdCallback callback) {
    }


    /**
     * 广告删除
     *
     * @param activity
     */
    public void removeNativeAdvert(Activity activity) {
    }


    /**
     * 广告预加载方法
     *
     * @param activity
     */
    public void reloadNativeAdvert(Activity activity, Yodo1ReloadCallback callback) {
    }


    /**
     * 是否预加载完成的方法
     *
     * @param activity
     */
    public boolean nativeAdvertIsLoaded(Activity activity) {
        return false;
    }


}
