/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.unityads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.IntegrationData;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.unity3d.ads.IUnityAdsListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.mediation.IUnityAdsExtendedListener;
import com.unity3d.ads.metadata.MediationMetaData;
import com.unity3d.ads.metadata.MetaData;
import com.unity3d.ads.metadata.PlayerMetaData;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.json.JSONObject;

class UnityAdsAdapter
extends AbstractAdapter
implements IUnityAdsListener,
IUnityAdsExtendedListener {
    private static final String VERSION = "4.1.4";
    private static final String GitHash = "b49296b36";
    private Activity mActivity;
    private boolean mDidInit = false;
    private final String GAME_ID = "sourceId";
    private final String PLACEMENT_ID = "zoneId";
    private final String CONSENT_GDPR = "gdpr.consent";
    private ConcurrentHashMap<String, InterstitialSmashListener> mZoneIdToIsListener = new ConcurrentHashMap();
    private ConcurrentHashMap<String, RewardedVideoSmashListener> mZoneIdToRvListener = new ConcurrentHashMap();
    private CopyOnWriteArraySet<String> mISZoneReceivedFirstStatus = new CopyOnWriteArraySet();
    private Boolean mConsentCollectingUserData = null;

    public static UnityAdsAdapter startAdapter(String string) {
        return new UnityAdsAdapter(string);
    }

    private UnityAdsAdapter(String string) {
        super(string);
    }

    public static IntegrationData getIntegrationData(Activity activity) {
        activity = new IntegrationData("UnityAds", VERSION);
        new IntegrationData("UnityAds", VERSION).activities = new String[]{"com.unity3d.services.ads.adunit.AdUnitActivity", "com.unity3d.services.ads.adunit.AdUnitTransparentActivity", "com.unity3d.services.ads.adunit.AdUnitTransparentSoftwareActivity", "com.unity3d.services.ads.adunit.AdUnitSoftwareActivity"};
        return activity;
    }

    public static String getAdapterSDKVersion() {
        String string = null;
        try {
            string = UnityAds.getVersion();
        }
        catch (Exception exception) {}
        return string;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return UnityAds.getVersion();
    }

    public void onResume(Activity activity) {
        this.mActivity = activity;
    }

    protected synchronized void setConsent(boolean bl) {
        if (this.mDidInit) {
            MetaData metaData = new MetaData((Context)this.mActivity);
            metaData.set("gdpr.consent", (Object)bl);
            metaData.commit();
            return;
        }
        this.mConsentCollectingUserData = bl;
    }

    private synchronized void initSDK(Activity activity, String string) {
        if (!this.mDidInit) {
            this.mActivity = activity;
            MediationMetaData mediationMetaData = new MediationMetaData((Context)activity);
            mediationMetaData.setName("IronSource");
            mediationMetaData.setVersion(VERSION);
            mediationMetaData.commit();
            UnityAds.initialize((Activity)activity, (String)string, (IUnityAdsListener)this);
            boolean bl = false;
            try {
                bl = this.isAdaptersDebugEnabled();
            }
            catch (NoSuchMethodError noSuchMethodError) {}
            UnityAds.setDebugMode((boolean)bl);
            if (this.mConsentCollectingUserData != null) {
                UnityAdsAdapter unityAdsAdapter = this;
                unityAdsAdapter.setConsent(unityAdsAdapter.mConsentCollectingUserData);
            }
            this.mDidInit = true;
        }
    }

    public synchronized void initRewardedVideo(Activity activity, String string, String string2, JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        string = jSONObject.optString("sourceId");
        string2 = jSONObject.optString("zoneId");
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " initRewardedVideo gameId: <" + string + "> placementId: <" + string2 + ">", 1);
        if (rewardedVideoSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " initRewardedVideo: null listener", 3);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.mZoneIdToRvListener.put(string2, rewardedVideoSmashListener);
        }
        if (this.mISZoneReceivedFirstStatus.contains(string2)) {
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(UnityAds.isReady((String)string2));
        }
        this.initSDK(activity, string);
    }

    public synchronized void fetchRewardedVideo(JSONObject object) {
        object = object.optString("zoneId");
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " fetchRewardedVideo with placementId: <" + (String)object + ">", 1);
        RewardedVideoSmashListener rewardedVideoSmashListener = this.mZoneIdToRvListener.get(object);
        if (rewardedVideoSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " fetchRewardedVideo: null listener", 3);
            return;
        }
        if (UnityAds.isReady((String)object)) {
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(true);
            return;
        }
        if (UnityAds.getPlacementState((String)object) != UnityAds.PlacementState.WAITING) {
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
        }
    }

    public synchronized void showRewardedVideo(JSONObject object, RewardedVideoSmashListener rewardedVideoSmashListener) {
        object = object.optString("zoneId");
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " showRewardedVideo placementId: <" + (String)object + ">", 1);
        if (UnityAds.isReady((String)object)) {
            if (!TextUtils.isEmpty((CharSequence)this.getDynamicUserId())) {
                rewardedVideoSmashListener = new PlayerMetaData((Context)this.mActivity);
                rewardedVideoSmashListener.setServerId(this.getDynamicUserId());
                rewardedVideoSmashListener.commit();
            }
            UnityAds.show((Activity)this.mActivity, (String)object);
            return;
        }
        if (rewardedVideoSmashListener != null) {
            rewardedVideoSmashListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
        }
    }

    public boolean isRewardedVideoAvailable(JSONObject jSONObject) {
        return UnityAds.isReady((String)jSONObject.optString("zoneId"));
    }

    public synchronized void initInterstitial(Activity activity, String string, String string2, JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        string = jSONObject.optString("sourceId");
        if (TextUtils.isEmpty((CharSequence)string)) {
            if (interstitialSmashListener != null) {
                interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params", (String)"Interstitial"));
            }
            return;
        }
        string2 = jSONObject.optString("zoneId");
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " initInterstitial gameId: <" + string + "> placementId: <" + string2 + ">", 1);
        if (!TextUtils.isEmpty((CharSequence)string2) && interstitialSmashListener != null) {
            this.mZoneIdToIsListener.put(string2, interstitialSmashListener);
        }
        this.initSDK(activity, jSONObject.optString("sourceId"));
        if (interstitialSmashListener != null) {
            interstitialSmashListener.onInterstitialInitSuccess();
        }
    }

    public void loadInterstitial(JSONObject object, InterstitialSmashListener interstitialSmashListener) {
        object = object.optString("zoneId");
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " loadInterstitial placementId <" + (String)object + ">", 1);
        if (interstitialSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + "null listener for placement Id <" + (String)object + ">", 3);
            return;
        }
        if (UnityAds.isReady((String)object)) {
            interstitialSmashListener.onInterstitialAdReady();
            return;
        }
        if (UnityAds.getPlacementState((String)object) != UnityAds.PlacementState.WAITING) {
            interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)"Ad unavailable"));
        }
    }

    public void showInterstitial(JSONObject object, InterstitialSmashListener interstitialSmashListener) {
        object = object.optString("zoneId");
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " showInterstitial placementId <" + (String)object + ">", 1);
        if (UnityAds.isReady((String)object)) {
            UnityAds.show((Activity)this.mActivity, (String)object);
            return;
        }
        if (interstitialSmashListener != null) {
            interstitialSmashListener.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
        }
    }

    public boolean isInterstitialReady(JSONObject object) {
        object = object.optString("zoneId");
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " isInterstitialReady placementId <" + (String)object + ">", 1);
        return UnityAds.isReady((String)object);
    }

    public void onUnityAdsReady(String string) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " onUnityAdsReady placementId <" + string + ">", 1);
    }

    public void onUnityAdsStart(String string) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " onUnityAdsStart: placementId <" + string + ">", 1);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            RewardedVideoSmashListener rewardedVideoSmashListener = this.mZoneIdToRvListener.get(string);
            if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAdOpened();
                rewardedVideoSmashListener.onRewardedVideoAdStarted();
                return;
            }
            if ((string = this.mZoneIdToIsListener.get(string)) != null) {
                string.onInterstitialAdOpened();
                string.onInterstitialAdShowSucceeded();
            }
        }
    }

    public void onUnityAdsFinish(String string, UnityAds.FinishState finishState) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " onUnityAdsFinish placementId: <" + string + "> finishState: " + finishState + ")", 1);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            RewardedVideoSmashListener rewardedVideoSmashListener = this.mZoneIdToRvListener.get(string);
            if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(UnityAds.isReady((String)string));
                if (finishState.equals((Object)UnityAds.FinishState.COMPLETED)) {
                    rewardedVideoSmashListener.onRewardedVideoAdEnded();
                    rewardedVideoSmashListener.onRewardedVideoAdRewarded();
                }
                rewardedVideoSmashListener.onRewardedVideoAdClosed();
                return;
            }
            if ((string = this.mZoneIdToIsListener.get(string)) != null) {
                string.onInterstitialAdClosed();
            }
        }
    }

    public void onUnityAdsError(UnityAds.UnityAdsError unityAdsError, String string) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " onUnityAdsError(errorType: " + unityAdsError + ", errorMessage: " + string + ")", 1);
    }

    public void onUnityAdsClick(String string) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " onUnityAdsClick placementId: <" + string + ">", 1);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            RewardedVideoSmashListener rewardedVideoSmashListener = this.mZoneIdToRvListener.get(string);
            if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAdClicked();
                return;
            }
            if ((string = this.mZoneIdToIsListener.get(string)) != null) {
                string.onInterstitialAdClicked();
            }
        }
    }

    public synchronized void onUnityAdsPlacementStateChanged(String string, UnityAds.PlacementState placementState, UnityAds.PlacementState placementState2) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " onUnityAdsPlacementStateChanged placementId: <" + string + "> from " + placementState + " to " + placementState2, 1);
        if (placementState2.equals((Object)placementState) || placementState2.equals((Object)UnityAds.PlacementState.WAITING)) {
            return;
        }
        this.mISZoneReceivedFirstStatus.add(string);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            placementState = this.mZoneIdToRvListener.get(string);
            if (placementState != null) {
                placementState.onRewardedVideoAvailabilityChanged(UnityAds.isReady((String)string));
                return;
            }
            placementState = this.mZoneIdToIsListener.get(string);
            if (placementState != null) {
                if (UnityAds.isReady((String)string)) {
                    placementState.onInterstitialAdReady();
                    return;
                }
                placementState.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)(string + " placement state: " + placementState2.toString())));
            }
        }
    }
}

