/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.applovin;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinAdViewDisplayErrorCode;
import com.applovin.adview.AppLovinAdViewEventListener;
import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.adview.AppLovinInterstitialAd;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkSettings;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdapterUtils;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IntegrationData;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

class AppLovinAdapter
extends AbstractAdapter {
    private static final String VERSION = "4.3.4";
    private static final String GitHash = "f2e5bcb59";
    private static final String ZONE_ID = "zoneId";
    private static final String SDK_KEY = "sdkKey";
    private Activity mActivity;
    private AppLovinSdk mAppLovinSdk;
    private Boolean mDidInitSdk = Boolean.FALSE;
    private ConcurrentHashMap<String, ALBannerListener> mZoneIdToAppLovinListener;
    private ConcurrentHashMap<String, BannerSmashListener> mZoneIdToBannerSmashListener;
    private ConcurrentHashMap<String, FrameLayout.LayoutParams> mZoneIdToBannerLayout;
    private ConcurrentHashMap<String, AppLovinAdView> mZoneIdToBannerAd;
    private ConcurrentHashMap<String, Boolean> mZoneIdToIsAdReadyStatus;
    private ConcurrentHashMap<String, AppLovinAd> mZoneIdToIsAd;
    private ConcurrentHashMap<String, AppLovinInterstitialAdDialog> mZoneIdToIsAdDialog;
    private ConcurrentHashMap<String, InterstitialSmashListener> mZoneIdToIsListener;
    private ConcurrentHashMap<String, AppLovinIncentivizedInterstitial> mZoneIdToRvAd;
    private ConcurrentHashMap<String, RewardedVideoSmashListener> mZoneIdToRvListener;
    private Boolean mConsentCollectingUserData = null;

    public static AppLovinAdapter startAdapter(String string) {
        return new AppLovinAdapter(string);
    }

    private AppLovinAdapter(String string) {
        super(string);
        this.mAllBannerSmashes = new CopyOnWriteArrayList();
        this.mZoneIdToAppLovinListener = new ConcurrentHashMap();
        this.mZoneIdToBannerSmashListener = new ConcurrentHashMap();
        this.mZoneIdToBannerLayout = new ConcurrentHashMap();
        this.mZoneIdToBannerAd = new ConcurrentHashMap();
        this.mZoneIdToIsAd = new ConcurrentHashMap();
        this.mZoneIdToIsAdDialog = new ConcurrentHashMap();
        this.mZoneIdToRvAd = new ConcurrentHashMap();
        this.mZoneIdToIsListener = new ConcurrentHashMap();
        this.mZoneIdToRvListener = new ConcurrentHashMap();
        this.mZoneIdToIsAdReadyStatus = new ConcurrentHashMap();
    }

    public static IntegrationData getIntegrationData(Activity activity) {
        activity = new IntegrationData("AppLovin", VERSION);
        new IntegrationData("AppLovin", VERSION).activities = new String[]{"com.applovin.adview.AppLovinInterstitialActivity", "com.applovin.adview.AppLovinConfirmationActivity"};
        return activity;
    }

    public static String getAdapterSDKVersion() {
        String string = null;
        string = "9.2.1";
        return "9.2.1";
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return "9.2.1";
    }

    public void onResume(Activity activity) {
        this.mActivity = activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConsent(boolean bl) {
        AppLovinAdapter appLovinAdapter = this;
        synchronized (appLovinAdapter) {
            if (this.mDidInitSdk.booleanValue()) {
                AppLovinPrivacySettings.setHasUserConsent((boolean)bl, (Context)this.mActivity);
            } else {
                this.mConsentCollectingUserData = bl;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSdk(Activity activity, String string) {
        AppLovinAdapter appLovinAdapter = this;
        synchronized (appLovinAdapter) {
            if (!this.mDidInitSdk.booleanValue()) {
                AppLovinSdkSettings appLovinSdkSettings = new AppLovinSdkSettings();
                boolean bl = false;
                try {
                    bl = this.isAdaptersDebugEnabled();
                }
                catch (NoSuchMethodError noSuchMethodError) {}
                appLovinSdkSettings.setVerboseLogging(bl);
                this.mAppLovinSdk = AppLovinSdk.getInstance((String)string, (AppLovinSdkSettings)appLovinSdkSettings, (Context)activity);
                this.mAppLovinSdk.initializeSdk();
                this.mDidInitSdk = Boolean.TRUE;
                if (this.mConsentCollectingUserData != null) {
                    AppLovinAdapter appLovinAdapter2 = this;
                    appLovinAdapter2.setConsent(appLovinAdapter2.mConsentCollectingUserData);
                }
            }
            return;
        }
    }

    public void initRewardedVideo(final Activity activity, final String string, String string2, JSONObject object, RewardedVideoSmashListener rewardedVideoSmashListener) {
        if (rewardedVideoSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " RV init failed: RewardedVideoSmashListener is empty", 2);
            return;
        }
        string = object.optString(SDK_KEY);
        if (TextUtils.isEmpty((CharSequence)string)) {
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            return;
        }
        object = this.getZoneId((JSONObject)object);
        this.mActivity = activity;
        this.mZoneIdToRvListener.put((String)object, rewardedVideoSmashListener);
        activity.runOnUiThread(new Runnable((String)object, string2, rewardedVideoSmashListener){
            final /* synthetic */ String val$zoneId;
            final /* synthetic */ String val$userId;
            final /* synthetic */ RewardedVideoSmashListener val$listener;
            {
                this.val$zoneId = string2;
                this.val$userId = string3;
                this.val$listener = rewardedVideoSmashListener;
            }

            @Override
            public void run() {
                AppLovinAdapter.this.initSdk(activity, string);
                AppLovinIncentivizedInterstitial appLovinIncentivizedInterstitial = !TextUtils.isEmpty((CharSequence)this.val$zoneId) ? AppLovinIncentivizedInterstitial.create((String)this.val$zoneId, (AppLovinSdk)AppLovinAdapter.this.mAppLovinSdk) : AppLovinIncentivizedInterstitial.create((AppLovinSdk)AppLovinAdapter.this.mAppLovinSdk);
                AppLovinAdapter.this.mZoneIdToRvAd.put(this.val$zoneId, appLovinIncentivizedInterstitial);
                appLovinIncentivizedInterstitial.setUserIdentifier(this.val$userId);
                appLovinIncentivizedInterstitial.preload(new AppLovinAdLoadListener(){

                    public void adReceived(AppLovinAd appLovinAd) {
                        val$listener.onRewardedVideoAvailabilityChanged(true);
                    }

                    public void failedToReceiveAd(int n2) {
                        val$listener.onRewardedVideoAvailabilityChanged(false);
                    }
                });
            }
        });
    }

    public void fetchRewardedVideo(JSONObject object) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + ": in fetchRewardedVideo", 0);
        object = this.getZoneId((JSONObject)object);
        if (this.mZoneIdToRvAd.containsKey(object)) {
            this.mZoneIdToRvAd.get(object).preload(new AppLovinAdLoadListener((String)object){
                final /* synthetic */ String val$zoneId;
                {
                    this.val$zoneId = string;
                }

                public void adReceived(AppLovinAd appLovinAd) {
                    if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(this.val$zoneId)) {
                        ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(this.val$zoneId)).onRewardedVideoAvailabilityChanged(true);
                    }
                }

                public void failedToReceiveAd(int n2) {
                    if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(this.val$zoneId)) {
                        ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(this.val$zoneId)).onRewardedVideoAvailabilityChanged(false);
                    }
                }
            });
        }
    }

    public void showRewardedVideo(JSONObject object, RewardedVideoSmashListener rewardedVideoSmashListener) {
        object = this.getZoneId((JSONObject)object);
        if (!(rewardedVideoSmashListener == null || this.mZoneIdToRvAd.containsKey(object) && this.mZoneIdToRvAd.get(object).isAdReadyToDisplay())) {
            rewardedVideoSmashListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.getDynamicUserId())) {
            this.mZoneIdToRvAd.get(object).setUserIdentifier(this.getDynamicUserId());
        }
        this.mZoneIdToRvAd.get(object).show((Context)this.mActivity, new AppLovinAdRewardListener(){

            public void userRewardVerified(AppLovinAd appLovinAd, Map<String, String> map) {
            }

            public void userOverQuota(AppLovinAd appLovinAd, Map<String, String> map) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "userOverQuota", 1);
            }

            public void userRewardRejected(AppLovinAd appLovinAd, Map<String, String> map) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "userRewardRejected", 1);
            }

            public void validationRequestFailed(AppLovinAd appLovinAd, int n2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "validationRequestFailed " + AppLovinAdapter.this.getErrorString(n2) + "(" + n2 + ")", 1);
            }

            public void userDeclinedToViewAd(AppLovinAd object) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "userDeclinedToViewAd", 1);
                object = AppLovinAdapter.this.getZoneId(object);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(object)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(object)).onRewardedVideoAdClosed();
                }
            }
        }, new AppLovinAdVideoPlaybackListener(){

            public void videoPlaybackBegan(AppLovinAd object) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "videoPlaybackBegan", 1);
                object = AppLovinAdapter.this.getZoneId(object);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(object)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(object)).onRewardedVideoAdStarted();
                }
            }

            public void videoPlaybackEnded(AppLovinAd object, double d2, boolean bl) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "videoPlaybackEnded ; isFullyWatched: " + bl, 1);
                object = AppLovinAdapter.this.getZoneId(object);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(object)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(object)).onRewardedVideoAdEnded();
                    if (bl) {
                        ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(object)).onRewardedVideoAdRewarded();
                    }
                }
            }
        }, new AppLovinAdDisplayListener(){

            public void adDisplayed(AppLovinAd object) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "adDisplayed", 1);
                object = AppLovinAdapter.this.getZoneId(object);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(object)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(object)).onRewardedVideoAdOpened();
                }
            }

            public void adHidden(AppLovinAd object) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "adHidden", 1);
                object = AppLovinAdapter.this.getZoneId(object);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(object)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(object)).onRewardedVideoAvailabilityChanged(false);
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(object)).onRewardedVideoAdClosed();
                }
                if (AppLovinAdapter.this.mZoneIdToRvAd.containsKey(object)) {
                    ((AppLovinIncentivizedInterstitial)AppLovinAdapter.this.mZoneIdToRvAd.get(object)).preload(new AppLovinAdLoadListener((String)object){
                        final /* synthetic */ String val$zoneId;
                        {
                            this.val$zoneId = string;
                        }

                        public void adReceived(AppLovinAd appLovinAd) {
                            if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(this.val$zoneId)) {
                                ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(this.val$zoneId)).onRewardedVideoAvailabilityChanged(true);
                            }
                        }

                        public void failedToReceiveAd(int n2) {
                            if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(this.val$zoneId)) {
                                ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(this.val$zoneId)).onRewardedVideoAvailabilityChanged(false);
                            }
                        }
                    });
                }
            }
        }, new AppLovinAdClickListener(){

            public void adClicked(AppLovinAd object) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "adClicked", 1);
                object = AppLovinAdapter.this.getZoneId(object);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(object)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(object)).onRewardedVideoAdClicked();
                }
            }
        });
    }

    public synchronized boolean isRewardedVideoAvailable(JSONObject object) {
        return this.mZoneIdToRvAd.containsKey(object = this.getZoneId((JSONObject)object)) && this.mZoneIdToRvAd.get(object).isAdReadyToDisplay();
    }

    public void initInterstitial(final Activity activity, final String string, final String string2, JSONObject jSONObject, final InterstitialSmashListener interstitialSmashListener) {
        if (interstitialSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " IS init failed: InterstitialSmashListener is empty", 2);
            return;
        }
        string = jSONObject.optString(SDK_KEY);
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " initInterstitial empty sdkKey", 3);
            interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"initInterstitial empty sdkKey", (String)"Interstitial"));
            return;
        }
        string2 = this.getZoneId(jSONObject);
        this.mActivity = activity;
        this.mZoneIdToIsListener.put(string2, interstitialSmashListener);
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AppLovinAdapter.this.initSdk(activity, string);
                AppLovinInterstitialAdDialog appLovinInterstitialAdDialog = AppLovinInterstitialAd.create((AppLovinSdk)AppLovinAdapter.this.mAppLovinSdk, (Context)activity);
                AppLovinAdapter.this.mZoneIdToIsAdDialog.put(string2, appLovinInterstitialAdDialog);
                appLovinInterstitialAdDialog.setAdClickListener(new AppLovinAdClickListener(){

                    public void adClicked(AppLovinAd appLovinAd) {
                        if (AppLovinAdapter.this.mZoneIdToIsListener.containsKey(string2)) {
                            ((InterstitialSmashListener)AppLovinAdapter.this.mZoneIdToIsListener.get(string2)).onInterstitialAdClicked();
                        }
                    }
                });
                appLovinInterstitialAdDialog.setAdDisplayListener(new AppLovinAdDisplayListener(){

                    public void adDisplayed(AppLovinAd appLovinAd) {
                        if (AppLovinAdapter.this.mZoneIdToIsListener.containsKey(string2)) {
                            ((InterstitialSmashListener)AppLovinAdapter.this.mZoneIdToIsListener.get(string2)).onInterstitialAdOpened();
                            ((InterstitialSmashListener)AppLovinAdapter.this.mZoneIdToIsListener.get(string2)).onInterstitialAdShowSucceeded();
                        }
                    }

                    public void adHidden(AppLovinAd appLovinAd) {
                        if (AppLovinAdapter.this.mZoneIdToIsListener.containsKey(string2)) {
                            ((InterstitialSmashListener)AppLovinAdapter.this.mZoneIdToIsListener.get(string2)).onInterstitialAdClosed();
                        }
                    }
                });
                interstitialSmashListener.onInterstitialInitSuccess();
            }
        });
    }

    public void loadInterstitial(JSONObject object, final InterstitialSmashListener interstitialSmashListener) {
        if (interstitialSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " IS load failed: InterstitialSmashListener is empty", 2);
            return;
        }
        object = this.getZoneId((JSONObject)object);
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " loadInterstitial <" + (String)object + ">", 0);
        if (!TextUtils.isEmpty((CharSequence)object)) {
            this.mAppLovinSdk.getAdService().loadNextAdForZoneId((String)object, new AppLovinAdLoadListener((String)object){
                final /* synthetic */ String val$zoneId;
                {
                    this.val$zoneId = string;
                }

                public void adReceived(AppLovinAd appLovinAd) {
                    IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Interstitial adReceived zoneId=" + AppLovinAdapter.this.getZoneId(appLovinAd), 1);
                    interstitialSmashListener.onInterstitialAdReady();
                    AppLovinAdapter.this.mZoneIdToIsAd.put(this.val$zoneId, appLovinAd);
                    AppLovinAdapter.this.mZoneIdToIsAdReadyStatus.put(this.val$zoneId, Boolean.TRUE);
                }

                public void failedToReceiveAd(int n2) {
                    String string = AppLovinAdapter.this.getErrorString(n2) + "( " + n2 + " )";
                    interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)string));
                    AppLovinAdapter.this.mZoneIdToIsAdReadyStatus.put(this.val$zoneId, Boolean.FALSE);
                }
            });
            return;
        }
        this.mAppLovinSdk.getAdService().loadNextAd(AppLovinAdSize.INTERSTITIAL, new AppLovinAdLoadListener((String)object){
            final /* synthetic */ String val$zoneId;
            {
                this.val$zoneId = string;
            }

            public void adReceived(AppLovinAd appLovinAd) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Interstitial adReceived", 1);
                interstitialSmashListener.onInterstitialAdReady();
                AppLovinAdapter.this.mZoneIdToIsAd.put(this.val$zoneId, appLovinAd);
                AppLovinAdapter.this.mZoneIdToIsAdReadyStatus.put(this.val$zoneId, Boolean.TRUE);
            }

            public void failedToReceiveAd(int n2) {
                String string = AppLovinAdapter.this.getErrorString(n2) + "( " + n2 + " )";
                interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)string));
                AppLovinAdapter.this.mZoneIdToIsAdReadyStatus.put(this.val$zoneId, Boolean.FALSE);
            }
        });
    }

    public void showInterstitial(JSONObject object, InterstitialSmashListener interstitialSmashListener) {
        object = this.getZoneId((JSONObject)object);
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " showInterstitial <" + (String)object + ">", 0);
        if (!(interstitialSmashListener == null || this.mZoneIdToIsAd.containsKey(object) && this.mZoneIdToIsAdDialog.containsKey(object))) {
            interstitialSmashListener.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
            return;
        }
        this.mZoneIdToIsAdDialog.get(object).showAndRender(this.mZoneIdToIsAd.get(object));
        this.mZoneIdToIsAdReadyStatus.put((String)object, Boolean.FALSE);
    }

    public boolean isInterstitialReady(JSONObject object) {
        return this.mZoneIdToIsAdDialog.containsKey(object = this.getZoneId((JSONObject)object)) && this.mZoneIdToIsAdReadyStatus.containsKey(object) && this.mZoneIdToIsAdReadyStatus.get(object) != false;
    }

    public void initBanners(final Activity activity, final String string, String string2, JSONObject jSONObject, final BannerSmashListener bannerSmashListener) {
        if (bannerSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " initBanners listener == null", 3);
        }
        if (jSONObject == null || activity == null) {
            bannerSmashListener.onBannerInitFailed(ErrorBuilder.buildInitFailedError((String)"null parameters", (String)"Banner"));
            return;
        }
        string = jSONObject.optString(SDK_KEY);
        if (TextUtils.isEmpty((CharSequence)string)) {
            bannerSmashListener.onBannerInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params", (String)"Banner"));
            return;
        }
        this.mActivity = activity;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AppLovinAdapter.this.initSdk(activity, string);
                bannerSmashListener.onBannerInitSuccess();
            }
        });
    }

    public void loadBanner(IronSourceBannerLayout ironSourceBannerLayout, JSONObject object, BannerSmashListener bannerSmashListener) {
        if (bannerSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " loadBanner listener == null", 3);
            return;
        }
        if (ironSourceBannerLayout == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " loadBanner banner == null", 3);
            return;
        }
        AppLovinAdSize appLovinAdSize = this.calculateBannerSize(ironSourceBannerLayout.getSize(), AdapterUtils.isLargeScreen((Activity)ironSourceBannerLayout.getActivity()));
        if (appLovinAdSize == null) {
            bannerSmashListener.onBannerAdLoadFailed(ErrorBuilder.unsupportedBannerSize((String)this.getProviderName()));
            return;
        }
        object = this.getZoneId((JSONObject)object);
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " loadBanner: " + this.getProviderName() + ", zoneID <" + (String)object + ">", 1);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable((String)object, ironSourceBannerLayout, appLovinAdSize, bannerSmashListener){
            final /* synthetic */ String val$zoneId;
            final /* synthetic */ IronSourceBannerLayout val$banner;
            final /* synthetic */ AppLovinAdSize val$bannerSize;
            final /* synthetic */ BannerSmashListener val$listener;
            {
                this.val$zoneId = string;
                this.val$banner = ironSourceBannerLayout;
                this.val$bannerSize = appLovinAdSize;
                this.val$listener = bannerSmashListener;
            }

            @Override
            public void run() {
                try {
                    AppLovinAdView appLovinAdView;
                    FrameLayout.LayoutParams layoutParams;
                    if (TextUtils.isEmpty((CharSequence)this.val$zoneId)) {
                        layoutParams = AppLovinAdapter.this.calcLayoutParams(this.val$banner.getSize(), this.val$bannerSize, this.val$banner.getActivity());
                        appLovinAdView = new AppLovinAdView(AppLovinAdapter.this.mAppLovinSdk, this.val$bannerSize, (Context)this.val$banner.getActivity());
                    } else {
                        layoutParams = AppLovinAdapter.this.calcLayoutParams(ISBannerSize.BANNER, AppLovinAdSize.BANNER, this.val$banner.getActivity());
                        appLovinAdView = new AppLovinAdView(AppLovinAdapter.this.mAppLovinSdk, AppLovinAdSize.BANNER, (Context)this.val$banner.getActivity());
                    }
                    ALBannerListener aLBannerListener = new ALBannerListener(this.val$zoneId);
                    appLovinAdView.setAdLoadListener((AppLovinAdLoadListener)aLBannerListener);
                    appLovinAdView.setAdClickListener((AppLovinAdClickListener)aLBannerListener);
                    appLovinAdView.setAdDisplayListener((AppLovinAdDisplayListener)aLBannerListener);
                    appLovinAdView.setAdViewEventListener((AppLovinAdViewEventListener)aLBannerListener);
                    AppLovinAdapter.this.mZoneIdToBannerSmashListener.put(this.val$zoneId, this.val$listener);
                    AppLovinAdapter.this.mZoneIdToBannerAd.put(this.val$zoneId, appLovinAdView);
                    AppLovinAdapter.this.mZoneIdToBannerLayout.put(this.val$zoneId, layoutParams);
                    AppLovinAdapter.this.mZoneIdToAppLovinListener.put(this.val$zoneId, aLBannerListener);
                    if (!TextUtils.isEmpty((CharSequence)this.val$zoneId)) {
                        AppLovinAdapter.this.mAppLovinSdk.getAdService().loadNextAdForZoneId(this.val$zoneId, (AppLovinAdLoadListener)aLBannerListener);
                        return;
                    }
                    appLovinAdView.loadNextAd();
                }
                catch (Exception exception) {
                    IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)(AppLovinAdapter.this.getProviderName() + " loadBanner exception " + exception.getMessage()));
                    this.val$listener.onBannerAdLoadFailed(ironSourceError);
                }
            }
        });
    }

    private AppLovinAdSize calculateBannerSize(ISBannerSize iSBannerSize, boolean bl) {
        switch (iSBannerSize.getDescription()) {
            case "BANNER": 
            case "LARGE": {
                return AppLovinAdSize.BANNER;
            }
            case "RECTANGLE": {
                return AppLovinAdSize.MREC;
            }
            case "SMART": {
                if (bl) {
                    return AppLovinAdSize.LEADER;
                }
                return AppLovinAdSize.BANNER;
            }
            case "CUSTOM": {
                if (iSBannerSize.getHeight() < 40 || iSBannerSize.getHeight() > 60) break;
                return AppLovinAdSize.BANNER;
            }
        }
        return null;
    }

    private FrameLayout.LayoutParams calcLayoutParams(ISBannerSize iSBannerSize, AppLovinAdSize appLovinAdSize, Activity activity) {
        int n2 = 320;
        if (iSBannerSize.getDescription().equals("RECTANGLE")) {
            n2 = 300;
        } else if (iSBannerSize.getDescription().equals("SMART") && AdapterUtils.isLargeScreen((Activity)activity)) {
            n2 = 728;
        }
        int n3 = AdapterUtils.dpToPixels((Activity)activity, (int)n2);
        int n4 = AdapterUtils.dpToPixels((Activity)activity, (int)appLovinAdSize.getHeight());
        return new FrameLayout.LayoutParams(n3, n4, 17);
    }

    public void destroyBanner(JSONObject object) {
        AppLovinAdView appLovinAdView = this.mZoneIdToBannerAd.get(object = this.getZoneId((JSONObject)object));
        if (appLovinAdView != null) {
            appLovinAdView.destroy();
        }
        if (this.mZoneIdToBannerAd != null) {
            this.mZoneIdToBannerAd.remove(object);
        }
    }

    public void reloadBanner(JSONObject object) {
        object = this.getZoneId((JSONObject)object);
        AppLovinAdView appLovinAdView = this.mZoneIdToBannerAd.get(object);
        ALBannerListener aLBannerListener = this.mZoneIdToAppLovinListener.get(object);
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + "Banner reloadBanner: <" + (String)object + ">", 1);
        if (appLovinAdView == null || aLBannerListener == null) {
            this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + ":reloadBanner() failed, null parameters", 2);
            return;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable((String)object, appLovinAdView, aLBannerListener){
            final /* synthetic */ String val$zoneId;
            final /* synthetic */ AppLovinAdView val$adView;
            final /* synthetic */ ALBannerListener val$applovinListener;
            {
                this.val$zoneId = string;
                this.val$adView = appLovinAdView;
                this.val$applovinListener = aLBannerListener;
            }

            @Override
            public void run() {
                if (TextUtils.isEmpty((CharSequence)this.val$zoneId)) {
                    this.val$adView.loadNextAd();
                    return;
                }
                AppLovinAdapter.this.mAppLovinSdk.getAdService().loadNextAdForZoneId(this.val$zoneId, (AppLovinAdLoadListener)this.val$applovinListener);
            }
        });
    }

    private String getErrorString(int n2) {
        switch (n2) {
            case -102: {
                return "Ad fetch timeout";
            }
            case -300: {
                return "No ad pre-loaded";
            }
            case -500: {
                return "Server timeout";
            }
            case -400: {
                return "Unknown server error";
            }
            case -600: {
                return "User closed video before reward";
            }
            case 204: {
                return "No fill";
            }
            case -103: {
                return "No network available";
            }
            case -6: {
                return "Unable to render ad";
            }
            case -1: {
                return "Unspecified error";
            }
        }
        return "Unknown error";
    }

    private String getZoneId(JSONObject jSONObject) {
        if (!TextUtils.isEmpty((CharSequence)jSONObject.optString(ZONE_ID))) {
            return jSONObject.optString(ZONE_ID);
        }
        return "";
    }

    private String getZoneId(AppLovinAd appLovinAd) {
        if (appLovinAd.getZoneId() != null) {
            return appLovinAd.getZoneId();
        }
        return "";
    }

    private class ALBannerListener
    implements AppLovinAdViewEventListener,
    AppLovinAdClickListener,
    AppLovinAdDisplayListener,
    AppLovinAdLoadListener {
        private String mZoneId;

        ALBannerListener(String string) {
            this.mZoneId = string;
        }

        public void adClicked(AppLovinAd appLovinAd) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adClicked:  <" + this.mZoneId + ">", 1);
            appLovinAd = (BannerSmashListener)AppLovinAdapter.this.mZoneIdToBannerSmashListener.get(this.mZoneId);
            if (appLovinAd != null) {
                appLovinAd.onBannerAdClicked();
            }
        }

        public void adDisplayed(AppLovinAd appLovinAd) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adDisplayed: <" + this.mZoneId + ">", 1);
        }

        public void adHidden(AppLovinAd appLovinAd) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adHidden: <" + this.mZoneId + ">", 1);
        }

        public void adReceived(final AppLovinAd appLovinAd) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adReceived: <" + this.mZoneId + ">", 1);
            final AppLovinAdView appLovinAdView = (AppLovinAdView)AppLovinAdapter.this.mZoneIdToBannerAd.get(this.mZoneId);
            final FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)AppLovinAdapter.this.mZoneIdToBannerLayout.get(this.mZoneId);
            final BannerSmashListener bannerSmashListener = (BannerSmashListener)AppLovinAdapter.this.mZoneIdToBannerSmashListener.get(this.mZoneId);
            if (appLovinAdView != null && bannerSmashListener != null && layoutParams != null) {
                Handler handler = new Handler(Looper.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        appLovinAdView.renderAd(appLovinAd);
                        bannerSmashListener.onBannerAdLoaded((View)appLovinAdView, layoutParams);
                    }
                });
                return;
            }
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " adReceived: null parameter", 3);
        }

        public void failedToReceiveAd(int n2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner failedToReceiveAd", 1);
            BannerSmashListener bannerSmashListener = (BannerSmashListener)AppLovinAdapter.this.mZoneIdToBannerSmashListener.get(this.mZoneId);
            if (bannerSmashListener != null) {
                String string = AppLovinAdapter.this.getErrorString(n2) + "(" + n2 + ")";
                string = ErrorBuilder.buildLoadFailedError((String)string);
                bannerSmashListener.onBannerAdLoadFailed((IronSourceError)string);
            }
        }

        public void adOpenedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adOpenedFullscreen", 1);
        }

        public void adClosedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adClosedFullscreen", 1);
        }

        public void adLeftApplication(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " adLeftApplication:  <" + this.mZoneId + ">", 1);
            appLovinAd = (BannerSmashListener)AppLovinAdapter.this.mZoneIdToBannerSmashListener.get(this.mZoneId);
            if (appLovinAd != null) {
                appLovinAd.onBannerAdLeftApplication();
            }
        }

        public void adFailedToDisplay(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView, AppLovinAdViewDisplayErrorCode appLovinAdViewDisplayErrorCode) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adFailedToDisplay", 1);
        }
    }
}

