/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.adapters.MediationAdapterRouter;
import com.applovin.sdk.AppLovinSdk;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.ISDemandOnlyInterstitialListener;
import com.ironsource.mediationsdk.sdk.ISDemandOnlyRewardedVideoListener;
import com.ironsource.mediationsdk.sdk.InterstitialListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoListener;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.concurrent.atomic.AtomicBoolean;

public class IronSourceMediationAdapter
extends MediationAdapterBase
implements MaxInterstitialAdapter,
MaxRewardedAdapter {
    private static final String PLACEMENT_NAME = "placement_name";
    private static final IronSourceRouter sIronSourceRouter = new IronSourceRouter();
    private static final AtomicBoolean sIsFirstLoad = new AtomicBoolean(true);
    private static final AtomicBoolean sIsInitialized = new AtomicBoolean();
    private String mInstanceId;

    public IronSourceMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    public void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        this.checkExistence(new Class[]{InterstitialListener.class, RewardedVideoListener.class});
        sIronSourceRouter.initialize(maxAdapterInitializationParameters, activity, onCompletionListener);
    }

    public String getSdkVersion() {
        return IronSourceUtils.getSDKVersion();
    }

    public String getAdapterVersion() {
        return "6.8.3.0.1";
    }

    public void onDestroy() {
        IronSourceMediationAdapter ironSourceMediationAdapter = this;
        sIronSourceRouter.removeAdapter((MaxAdapter)ironSourceMediationAdapter, ironSourceMediationAdapter.mInstanceId);
        sIsFirstLoad.set(false);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.log("Loading ironSource interstitial...");
        IronSource.setConsent((boolean)maxAdapterResponseParameters.hasUserConsent());
        this.mInstanceId = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        sIronSourceRouter.addInterstitialAdapter((MaxAdapter)this, maxInterstitialAdapterListener, this.mInstanceId);
        if (IronSource.isISDemandOnlyInterstitialReady((String)this.mInstanceId)) {
            this.log("Ad is available already");
            sIronSourceRouter.onAdLoaded(this.mInstanceId);
            return;
        }
        IronSource.loadISDemandOnlyInterstitial((String)this.mInstanceId);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void showInterstitialAd(MaxAdapterResponseParameters object, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.log("Showing ironSource interstitial...");
        this.mInstanceId = object.getThirdPartyAdPlacementId();
        if (!IronSource.isISDemandOnlyInterstitialReady((String)this.mInstanceId)) {
            void var3_4;
            this.log("Unable to show ironSource interstitial - no ad loaded...");
            var3_4.onInterstitialAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
            return;
        }
        sIronSourceRouter.addShowingAdapter((MaxAdapter)this);
        String string = object.getServerParameters().getString(PLACEMENT_NAME);
        if (TextUtils.isEmpty((CharSequence)string)) {
            IronSource.showISDemandOnlyInterstitial((String)this.mInstanceId);
            return;
        }
        IronSource.showISDemandOnlyInterstitial((String)this.mInstanceId, (String)string);
    }

    public void loadRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.log("Loading ironSource rewarded...");
        IronSource.setConsent((boolean)maxAdapterResponseParameters.hasUserConsent());
        this.mInstanceId = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        sIronSourceRouter.addRewardedAdapter((MaxAdapter)this, maxRewardedAdapterListener, this.mInstanceId);
        if (IronSource.isISDemandOnlyRewardedVideoAvailable((String)this.mInstanceId)) {
            this.log("Ad is available already");
            sIronSourceRouter.onAdLoaded(this.mInstanceId);
            return;
        }
        if (!sIsFirstLoad.get()) {
            this.log("Failed to load ironSource rewarded - no ads available...");
            maxRewardedAdapterListener.onRewardedAdLoadFailed(MaxAdapterError.NO_FILL);
            return;
        }
        this.log("First ad load, waiting for rewarded availability callback...");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void showRewardedAd(MaxAdapterResponseParameters object, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.log("Showing ironSource rewarded...");
        this.mInstanceId = object.getThirdPartyAdPlacementId();
        if (!IronSource.isISDemandOnlyRewardedVideoAvailable((String)this.mInstanceId)) {
            void var3_4;
            this.log("Unable to show ironSource rewarded - no ad loaded...");
            var3_4.onRewardedAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
            return;
        }
        if (AppLovinSdk.VERSION_CODE >= 90500) {
            this.configureReward((MaxAdapterResponseParameters)object);
        }
        sIronSourceRouter.addShowingAdapter((MaxAdapter)this);
        String string = object.getServerParameters().getString(PLACEMENT_NAME);
        if (TextUtils.isEmpty((CharSequence)string)) {
            IronSource.showISDemandOnlyRewardedVideo((String)this.mInstanceId);
            return;
        }
        IronSource.showISDemandOnlyRewardedVideo((String)this.mInstanceId, (String)string);
    }

    private static class IronSourceRouter
    extends MediationAdapterRouter
    implements ISDemandOnlyInterstitialListener,
    ISDemandOnlyRewardedVideoListener {
        private boolean hasGrantedReward;

        private IronSourceRouter() {
        }

        void initialize(MaxAdapterInitializationParameters object, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
            if (!sIsInitialized.getAndSet(true)) {
                if (object.getServerParameters().getBoolean("set_mediation_identifier")) {
                    IronSource.setMediationType((String)MediationAdapterBase.mediationTag());
                }
                IronSource.setAdaptersDebug((boolean)object.isTesting());
                IronSource.setConsent((boolean)object.hasUserConsent());
                IronSource.setISDemandOnlyInterstitialListener((ISDemandOnlyInterstitialListener)sIronSourceRouter);
                IronSource.setISDemandOnlyRewardedVideoListener((ISDemandOnlyRewardedVideoListener)sIronSourceRouter);
                boolean bl = object.getServerParameters().getBoolean("should_track_network_state", false);
                if (bl) {
                    IronSource.shouldTrackNetworkState((Context)activity, (boolean)true);
                }
                object = object.getServerParameters().getString("app_key");
                IronSource.initISDemandOnly((Activity)activity, (String)object, (IronSource.AD_UNIT[])new IronSource.AD_UNIT[]{IronSource.AD_UNIT.INTERSTITIAL, IronSource.AD_UNIT.REWARDED_VIDEO});
            }
            onCompletionListener.onCompletion();
        }

        public void onInterstitialAdReady(String string) {
            this.onAdLoaded(string);
        }

        public void onInterstitialAdLoadFailed(String string, IronSourceError ironSourceError) {
            this.onAdLoadFailed(string, this.toMaxError(ironSourceError));
        }

        public void onInterstitialAdOpened(String string) {
        }

        public void onInterstitialAdClosed(String string) {
            this.onAdHidden(string);
        }

        public void onInterstitialAdShowSucceeded(String string) {
            this.onAdDisplayed(string);
        }

        public void onInterstitialAdShowFailed(String string, IronSourceError ironSourceError) {
            this.onAdDisplayFailed(string, this.toMaxError(ironSourceError));
        }

        public void onInterstitialAdClicked(String string) {
            this.onAdClicked(string);
        }

        public void onRewardedVideoAdOpened(String string) {
            this.onAdDisplayed(string);
            this.onRewardedAdVideoStarted(string);
        }

        public void onRewardedVideoAdClosed(String string) {
            if (this.hasGrantedReward || this.alwaysReward(string)) {
                MaxReward maxReward = this.retrieveReward(string);
                this.onUserRewarded(string, maxReward);
                this.hasGrantedReward = false;
            }
            this.onAdHidden(string);
        }

        public void onRewardedVideoAvailabilityChanged(String string, boolean bl) {
            if (sIsFirstLoad.get()) {
                if (bl) {
                    this.onAdLoaded(string);
                    return;
                }
                this.onAdLoadFailed(string, MaxAdapterError.NO_FILL);
            }
        }

        public void onRewardedVideoAdRewarded(String string, Placement placement) {
            this.onRewardedAdVideoCompleted(string);
            this.hasGrantedReward = true;
        }

        public void onRewardedVideoAdShowFailed(String string, IronSourceError ironSourceError) {
            this.onAdDisplayFailed(string, this.toMaxError(ironSourceError));
        }

        public void onRewardedVideoAdClicked(String string, Placement placement) {
            this.onAdClicked(string);
        }

        private MaxAdapterError toMaxError(IronSourceError ironSourceError) {
            int n2 = ironSourceError.getErrorCode();
            int n3 = 501 == n2 || 505 == n2 || 506 == n2 ? -5202 : (508 == n2 ? -5204 : (509 == n2 ? 204 : (520 == n2 ? -5207 : -5200)));
            return new MaxAdapterError(n3, n2);
        }

        private MaxReward retrieveReward(String string) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                return this.getReward(string);
            }
            return MaxReward.createDefault();
        }

        private boolean alwaysReward(String string) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                return this.shouldAlwaysRewardUser(string);
            }
            return false;
        }
    }
}

