package com.yodo1.sdk.permission.request.fragment;

import android.support.annotation.NonNull;

import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.permission.bean.Special;
import com.yodo1.sdk.permission.callbcak.RequestPermissionListener;
import com.yodo1.sdk.permission.callbcak.SpecialPermissionListener;
import com.yodo1.sdk.permission.request.IPermissionActions;


/**
 * @author cd5160866
 */
public class FragmentProxy implements IPermissionActions {

    private static final String TAG = FragmentProxy.class.getSimpleName();

    private IPermissionActions fragmentImp;

    public FragmentProxy(IPermissionActions fragmentImp) {
        this.fragmentImp = fragmentImp;
    }

    @Override
    public void requestPermissions(@NonNull String[] permissions, RequestPermissionListener listener) {
        this.fragmentImp.requestPermissions(permissions, listener);
        YLog.d(fragmentImp.getClass().getSimpleName() + " request:" + hashCode());
    }

    @Override
    public void requestSpecialPermission(Special permission, SpecialPermissionListener listener) {
        this.fragmentImp.requestSpecialPermission(permission, listener);
        YLog.d(fragmentImp.getClass().getSimpleName() + " requestSpecial:" + hashCode());
    }

}
