package com.yodo1.onlineconfig;

import android.Manifest;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.location.Location;
import android.location.LocationManager;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;

import com.yodo1.android.ops.net.HttpListener;
import com.yodo1.android.ops.net.Yodo1HttpManage;
import com.yodo1.android.ops.net.Yodo1RequestListener;
import com.yodo1.android.ops.net.Yodo1SDKResponse;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.sdk.kit.MD5EncodeUtil;
import com.yodo1.sdk.kit.SysUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1CommonUtils;
import com.yodo1.sdk.kit.Yodo1DeviceUtils;
import com.yodo1.sdk.kit.Yodo1PermissonUtils;
import com.yodo1.sdk.kit.Yodo1PropertiesUtils;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.concurrent.LinkedBlockingQueue;

/**
 * Created by yodo1 on 2017/8/7.
 */

public class Yodo1OnlineConfig {
    public static final String ONLINECONFIG_ACTION = "cn.yodo1.broadcastreceiverregister.OnlineConfig";
        private static final String onlineConfigUrl = "https://olc.yodo1api.com/config/getDataV2/";
//    private static final String onlineConfigUrl = "http://olc-test.yodo1.int:8080/config/getDataV2";
    private static final String onlineConfigCDNUrl = "https://ocd.yodo1api.com/configfiles/";
    private static final String DATAIDENTIFER = "data_identifer";
    private static final String LOCATION_IDENTIFER = "location_identifer";
    private static final String LOCATION_IDENTIFER_TTL = "location_identifer_ttl";
    private static final String GAME_APPK = "game_appkey";
    private static final String GAME_CHANNELCODE = "game_channelcode";
    private static final String GAME_VERSIONNAME = "game_version";
    private static final String TIMESTAMP_GETDATA = "timestamp_getdata";
    private static final String ONLINECONFIG = "OnlineConfigParams";
    private static final String ONLINECONFIG_TESTINFO = "OnlineConfigParams_TestInfo";
    private static final String ONLINECONFIG_TESTDEVICE = "OnlineConfigParams_TestDevice";
    private static final String ONLINECONFIG_TESTDEVICE_SOURCE = "OnlineConfigParams_TestDeviceSource";
    public static String ChannelCode = "";
    public static String SDKVersion = "";
    public static String SDKTyoe = "";

    private static long time = 0;
    private static String appKey = "";
    private static Context context;
    //地理标识
    private static String location_lng = "";//手机当前经度，保留小数点后两位
    private static String location_lat = "";//手机当前纬度，保留小数点后两位
    private static volatile Yodo1OnlineConfig instance;
    public JSONObject dataObj = null;
    public JSONObject testObj = null;

    private Yodo1OnlineConfig() {
    }

    public static Yodo1OnlineConfig getInstance() {
        if (instance == null) {
            synchronized (Yodo1OnlineConfig.class) {
                if (instance == null) {
                    instance = new Yodo1OnlineConfig();
                }
            }
        }
        return instance;
    }

    /**
     * 根据接口获取在线参数
     *
     * @param listener 回调
     */
    private static void getOnlineConfig(final Yodo1RequestListener listener) {
        new Thread(new Runnable() {
            @Override
            public void run() {
                //首先获取设备ID
                String deviceId = "";
                AdvertisingConnection connection = new AdvertisingConnection();
                Intent intent = new Intent(
                        "com.google.android.gms.ads.identifier.service.START");
                intent.setPackage("com.google.android.gms");
                if (context.bindService(intent, connection, Context.BIND_AUTO_CREATE)) {
                    try {
                        AdvertisingInterface adInterface = new AdvertisingInterface(
                                connection.getBinder());
                        deviceId = adInterface.getId();
                    } catch (RemoteException e) {
                    } catch (InterruptedException e) {
                    } finally {
                        context.unbindService(connection);
                    }
                }

                if (TextUtils.isEmpty(deviceId)) {
                    deviceId = Yodo1DeviceUtils.getDeviceId(context);
                }

                Yodo1SharedPreferences.put(context, "YDEVICEID", deviceId);//保存设备ID

                //获取版本信息
                String version = SysUtils.getVersionName(context) + "";

                String data = Yodo1SharedPreferences.getString(context, DATAIDENTIFER);
                String data_identifer = !TextUtils.isEmpty(data) ? !data.equals("null") ? data : "0" : "0";
                String time = System.currentTimeMillis() + "";
                String sign = MD5EncodeUtil.MD5Encode(appKey + version + ChannelCode + time + "yodo1");//签名
                String location_identifer = Yodo1SharedPreferences.getString(context, LOCATION_IDENTIFER);
                String location_identifer_ttl = Yodo1SharedPreferences.getString(context, LOCATION_IDENTIFER_TTL);
                String timestamp_getdata = Yodo1SharedPreferences.getString(context, TIMESTAMP_GETDATA);

                if (!TextUtils.isEmpty(location_identifer)) {
                    try {
                        long time_ttl = Long.valueOf(location_identifer_ttl);
                        long time_getdata = Long.valueOf(timestamp_getdata);
                        long time_now = Long.valueOf(time);

                        //在线参数本次请求的时间戳和上次请求返回的时间戳比较   大于上次请求返回的有效时长  清空location_identifer和data_identifer
                        if ((time_getdata - time_now) > (time_ttl * 60 * 60 * 1000)) {
                            location_identifer = "";
                            data_identifer = "0";
                            Yodo1SharedPreferences.put(context, LOCATION_IDENTIFER, "");//删除本地已经缓存的地理标识
                        }
                    } catch (NumberFormatException e) {
                        location_identifer = "";
                    }

                } else {
                    location_identifer = "";
                }


                JSONObject dataJson = new JSONObject();
                try {
                    dataJson.put("game_appkey", appKey);
                    dataJson.put("device_id", deviceId);//设备ID
                    dataJson.put("version", version);
                    dataJson.put("channel", ChannelCode);
                    dataJson.put("sdk_type", SDKTyoe);
                    dataJson.put("sdk_version", SDKVersion);
                    dataJson.put("data_identifer", data_identifer);
                    dataJson.put("location_identifer", location_identifer);
                    dataJson.put("location_lng", location_lng);
                    dataJson.put("location_lat", location_lat);
                    dataJson.put("timestamp", time);
                    dataJson.put("sign", sign);

                } catch (JSONException e) {
                    e.printStackTrace();
                }

                String submitStr = dataJson.toString();
                YLog.d("Yodo1GetOnlineConfig-getOnlineConfig 请求在线参数: " + submitStr);
                Request<String> request = NoHttp.createStringRequest(onlineConfigUrl, RequestMethod.POST);
                request.setDefineRequestBody(submitStr, "text/plain;charset=UTF-8");
                Yodo1HttpManage.getInstance().connect(0, request, new HttpListener<String>() {
                    @Override
                    public void onSucceed(int what, Response<String> response) {
                        YLog.d("Yodo1GetOnlineConfig-getOnlineConfig 获取到在线参数: " + response.get());
                        Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(1, response);
                        listener.onYodo1RequestComplete(resp);
                    }

                    @Override
                    public void onFailed(int what, Response<String> response) {
                        Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(1, response);
                        listener.onYodo1RequestComplete(resp);
                    }
                }, false);

            }
        }).start();

    }

    /**
     * 获取广告数据
     *
     * @return
     * @throws JSONException
     */
    public JSONObject getJsonData() throws JSONException {

        if (dataObj != null) {
            return dataObj;//若JsaonArray数据不为空  直接返回
        }

        String data = Yodo1SharedPreferences.getString(context, ONLINECONFIG);
        if (!TextUtils.isEmpty(data)) {
            dataObj = new JSONObject(data);
        }
        return dataObj;
    }

    /**
     * 获取高级测试信息
     *
     * @return
     * @throws JSONException
     */
    public JSONObject getJsonTestData() throws JSONException {

        if (testObj != null) {
            return testObj;//若JsaonArray数据不为空  直接返回
        }

        String data = Yodo1SharedPreferences.getString(context, ONLINECONFIG_TESTINFO);
        if (!TextUtils.isEmpty(data)) {
            testObj = new JSONObject(data);
        }
        return testObj;
    }

    /**
     * 判断本地是否有数据
     *
     * @return
     */
    public boolean hasData() {
        boolean bl = false;
        String data = Yodo1SharedPreferences.getString(context, ONLINECONFIG);
        if (!TextUtils.isEmpty(data)) {
            bl = true;
        }
        return bl;
    }

    /**
     * 提供给外部调用
     */
    public void getOnlineConfig(final Yodo1OnlineConfigListener listener) {

        //后台进入前台二十分钟后重新请求数据
        if (System.currentTimeMillis() - time < 60000 * 20) {
            return;
        }
        time = System.currentTimeMillis();

        getOnlineConfig(new Yodo1RequestListener() {
            @Override
            public void onYodo1RequestComplete(Yodo1SDKResponse responseObject) {
                String resMsg = responseObject.getResponseString();
                int errorCode = -1;
                try {
                    if (resMsg != null) {
                        JSONObject jsonObj = new JSONObject(resMsg);
                        errorCode = jsonObj.optInt("error_code");

                        if (errorCode == 0) {
                            String data_identifer = jsonObj.optString("data_identifer");
                            String location_identifer = jsonObj.optString("location_identifer");//地理标识  客户端本地存
                            String location_identifer_ttl = jsonObj.optString("location_identifer_ttl");//地理标识有效时长   小时，客户端本地存
                            boolean is_test_model = jsonObj.optBoolean("is_test_model");//当前是否为测试设备
                            String device_source = jsonObj.optString("device_source");
                            JSONObject testListObj = jsonObj.optJSONObject("test_list");//测试列表信息  目前只有adlist 之后还会有其他的

                            if (testListObj != null)
                                Yodo1SharedPreferences.put(context, ONLINECONFIG_TESTINFO, testListObj.toString());

                            Yodo1SharedPreferences.put(context, ONLINECONFIG_TESTDEVICE, is_test_model);
                            Yodo1SharedPreferences.put(context, ONLINECONFIG_TESTDEVICE_SOURCE, device_source);

                            JSONObject objData = jsonObj.optJSONObject("data");
                            objData.put("is_test_model", is_test_model);
                            objData.put("device_source", device_source);
                            Yodo1SharedPreferences.put(context, DATAIDENTIFER, data_identifer);
                            Yodo1SharedPreferences.put(context, ONLINECONFIG, objData.toString());
                            //当本地地理标识为空的时候再保存获取到的地理标识
                            if (TextUtils.isEmpty(Yodo1SharedPreferences.getString(context, LOCATION_IDENTIFER))) {
                                Yodo1SharedPreferences.put(context, LOCATION_IDENTIFER, location_identifer);
                            }
                            Yodo1SharedPreferences.put(context, LOCATION_IDENTIFER_TTL, location_identifer_ttl);
                            Yodo1SharedPreferences.put(context, TIMESTAMP_GETDATA, System.currentTimeMillis() + "");
                            Yodo1SharedPreferences.put(context, GAME_APPK, appKey);
                            Yodo1SharedPreferences.put(context, GAME_CHANNELCODE, ChannelCode);
                            Yodo1SharedPreferences.put(context, GAME_VERSIONNAME, SysUtils.getVersionName(context) + "");
                            YLog.d("Yodo1OnlineConfig-getOnlineConfig 获取到的在线参数: " + resMsg);

                            listener.getDataFinish(errorCode, objData.toString());

                            sendMsg();
                        } else if (errorCode == 10) {
                            YLog.d("Yodo1OnlineConfig-getOnlineConfig 本地参数已是最新，无需更新");
                            listener.getDataFinish(errorCode, Yodo1SharedPreferences.getString(context, ONLINECONFIG));

                            sendMsg();
                        } else {
                            String error = jsonObj.optString("error");
                            YLog.d("Yodo1OnlineConfig-getOnlineConfig 获取在线参数异常, 需获取静态参数, ErrorCode: " + errorCode + ", Error: " + error);
                            //需拼接静态参数，获取在线参数静态数据
                            time = 0;
                            getCDNOnlineConfig(listener);
                        }

                    } else {
                        time = 0;
                        getCDNOnlineConfig(listener);
                    }
                } catch (JSONException e) {
                    YLog.d("Yodo1OnlineConfig-getOnlineConfig json解析异常, message: " + e.getMessage() + ", cause: " + e.getCause());
                    time = 0;
                    getCDNOnlineConfig(listener);
                }

            }
        });
    }

    /**
     * 获取在线参数
     *
     * @param key
     * @return
     */
    public String getConfigParam(String key, String defaultValue) {
        String result = defaultValue;
        try {
            JSONObject obj = getJsonData();
            if (obj != null && !TextUtils.isEmpty(obj.optString(key))) {
                result = obj.optString(key);
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
        YLog.d("Yodo1GetOnlineConfig-getConfigParam " + key + " = " + result);
        return result;

    }

    /**
     * 在线参数初始化
     *
     * @param context
     */
    public void init(final Context context, final String appKey) {
        this.appKey = appKey;
        this.context = context;

    }


    /**
     * 在线参数初始化
     *
     * @param context
     */
    public void initConfig(final Context context) {
        this.context = context;
        if (TextUtils.isEmpty(ChannelCode)) {
            ChannelCode = Yodo1CommonUtils.getMetedataStr(context, "Yodo1ChannelCode");
            SDKVersion = Yodo1CommonUtils.getMetedataStr(context, "Yodo1SDKVersion");
            SDKTyoe = Yodo1CommonUtils.getMetedataStr(context, "Yodo1SDKType");
        }

        if (TextUtils.isEmpty(ChannelCode)) {
            ChannelCode = "Default";
        }

        YLog.v("Yodo1 SDK Version: " + SDKVersion);
        getLocation();//读取当前位置

    }

    /**
     * 根据接口获取在线参数静态数据
     */
    private void getCDNOnlineConfig(final Yodo1OnlineConfigListener listener) {
        getCDNOnlineConfig(new Yodo1RequestListener() {
            @Override
            public void onYodo1RequestComplete(Yodo1SDKResponse responseObject) {
                String resMsg = responseObject.getResponseString();
                YLog.d("Yodo1GetOnlineConfig-getCDNOnlineConfig 获取CDN在线参数:" + resMsg);
                try {
                    if (resMsg != null) {
                        JSONObject jsonObj = new JSONObject(resMsg.replace(" ", ""));
                        String data_identifer = jsonObj.optString("data_identifer");

                        String local_data = Yodo1SharedPreferences.getString(context, DATAIDENTIFER);

                        if (TextUtils.isEmpty(local_data)) {
                            local_data = "0";
                        }

                        if (Long.valueOf(data_identifer) > Long.valueOf(local_data)) {

                            JSONObject objData = jsonObj.optJSONObject("data");
                            boolean is_test_model = jsonObj.optBoolean("is_test_model");//当前是否为测试设备
                            String device_source = jsonObj.optString("device_source");
                            JSONObject testListObj = jsonObj.optJSONObject("test_list");//测试列表信息  目前只有adlist 之后还会有其他的

                            Yodo1SharedPreferences.put(context, ONLINECONFIG_TESTINFO, testListObj.toString());
                            Yodo1SharedPreferences.put(context, ONLINECONFIG_TESTDEVICE, is_test_model);
                            Yodo1SharedPreferences.put(context, ONLINECONFIG_TESTDEVICE_SOURCE, device_source);
                            Yodo1SharedPreferences.put(context, DATAIDENTIFER, data_identifer);
                            Yodo1SharedPreferences.put(context, ONLINECONFIG, objData.toString());

                            listener.getDataFinish(0, objData.toString());
                        } else {
                            listener.getDataFinish(0, Yodo1SharedPreferences.getString(context, ONLINECONFIG));
                        }
                        sendMsg();
                    } else {
                        listener.getDataFinish(-1, "");
                    }


                } catch (JSONException e) {
                    YLog.d("Yodo1GetOnlineConfig-getCDNOnlineConfig json解析异常, message: " + e.getMessage() + ", cause: " + e.getCause());
                    listener.getDataFinish(-1, "");
                }

            }
        });
    }

    /**
     * 根据接口获取在线参数
     *
     * @param listener 回调
     */
    private void getCDNOnlineConfig(final Yodo1RequestListener listener) {
        String domain = onlineConfigCDNUrl;
        String url = domain + MD5EncodeUtil.MD5Encode(appKey) + ".json";

        Request<String> request = NoHttp.createStringRequest(url);
        Yodo1HttpManage.getInstance().connect(0, request, new HttpListener<String>() {
            @Override
            public void onSucceed(int what, Response<String> response) {
                YLog.d("Yodo1GetOnlineConfig-getCDNOnlineConfig CDN response: " + response.get());
                Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(0, response);
                listener.onYodo1RequestComplete(resp);
            }

            @Override
            public void onFailed(int what, Response<String> response) {
                Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(0, response);
                listener.onYodo1RequestComplete(resp);
            }
        }, false);
    }


    /**
     * 获取当前的位置信息
     */
    private void getLocation() {
        try {
            boolean permissionCheck = Yodo1PermissonUtils.hasPermission(context, Manifest.permission.READ_PHONE_STATE);
            if (permissionCheck) {
                LocationManager locationManager = (LocationManager) context.getSystemService(Context.LOCATION_SERVICE);

                Location location = locationManager.getLastKnownLocation(LocationManager.GPS_PROVIDER);
                if (location != null) {
                    YLog.d("Yodo1GetOnlineConfig-getLocation 当前GPS定位经纬度为: getLatitude = " + location.getLatitude() + ", getLongitude = " + location.getLongitude());
                    location_lng = String.format("%.2f", location.getLongitude());
                    location_lat = String.format("%.2f", location.getLatitude());
                } else {
                    location = locationManager.getLastKnownLocation(LocationManager.NETWORK_PROVIDER);

                    if (location != null) {
                        YLog.d("Yodo1GetOnlineConfig-getLocation 当前网络定位经纬度为: getLatitude = " + location.getLatitude() + ", getLongitude = " + location.getLongitude());

                        location_lng = String.format("%.2f", location.getLongitude());
                        location_lat = String.format("%.2f", location.getLatitude());
                    }
                }
            } else {
                YLog.d("Yodo1GetOnlineConfig-getLocation 缺少定位权限");
            }
        } catch (Exception e) {
            YLog.d("Yodo1GetOnlineConfig-getLocation 当前定位异常");
        }
    }


    /**
     * 拉取到在线参数之后发送广播初始化
     */
    private void sendMsg() {
        YLog.d("Yodo1GetOnlineConfig-sendMsg 获取到在线参数，发送广播");
        context.sendBroadcast(new Intent(ONLINECONFIG_ACTION));
    }


    /**
     * 获取GAID
     */
    private static final class AdvertisingConnection implements ServiceConnection {
        private final LinkedBlockingQueue<IBinder> queue = new LinkedBlockingQueue<>(1);
        boolean retrieved = false;

        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                this.queue.put(service);
            } catch (InterruptedException localInterruptedException) {
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }

        public IBinder getBinder() throws InterruptedException {
            if (this.retrieved)
                throw new IllegalStateException();
            this.retrieved = true;
            return this.queue.take();
        }
    }

    private static final class AdvertisingInterface implements IInterface {
        private IBinder binder;

        public AdvertisingInterface(IBinder pBinder) {
            binder = pBinder;
        }

        public IBinder asBinder() {
            return binder;
        }

        public String getId() throws RemoteException {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            String id;
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                binder.transact(1, data, reply, 0);
                reply.readException();
                id = reply.readString();
            } finally {
                reply.recycle();
                data.recycle();
            }
            return id;
        }

        public boolean isLimitAdTrackingEnabled(boolean paramBoolean)
                throws RemoteException {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            boolean limitAdTracking;
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                data.writeInt(paramBoolean ? 1 : 0);
                binder.transact(2, data, reply, 0);
                reply.readException();
                limitAdTracking = 0 != reply.readInt();
            } finally {
                reply.recycle();
                data.recycle();
            }
            return limitAdTracking;
        }
    }
}
