package com.yodo1.advert.video.channel;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.facebook.ads.*;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.plugin.facebook.AdConfigFaceBook;
import com.yodo1.advert.plugin.facebook.AdvertCoreFaceboosk;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.sdk.kit.YLog;

/**
 * Created by yodo1 on 2016/4/7.
 */
public class AdvertAdapterfacebook extends AdVideoAdapterBase {
    private Yodo1AdCallback videoCallback; //视频回调
    private Yodo1ReloadCallback reloadCallback; //视频预加载回调

    private RewardedVideoAd rewardedVideoAd = null;

    private boolean isLoaded = false;

    private RewardedVideoAdListener adListener = new RewardedVideoAdListener() {
        @Override
        public void onRewardedVideoCompleted() {
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
            isLoaded = false;
        }

        @Override
        public void onLoggingImpression(Ad ad) {
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoClosed() {
            YLog.i("FaceBook onRewardedVideoClosed " );
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onError(Ad ad, AdError adError) {
            YLog.e("FaceBook Error = " + adError.getErrorMessage());
            isLoaded = false;
            if(reloadCallback != null){
                reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION,adError.getErrorCode() , adError.getErrorMessage(), getAdvertCode());
            }
        }

        @Override
        public void onAdLoaded(Ad ad) {
            isLoaded = true;
            if(reloadCallback != null){
                reloadCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onAdClicked(Ad ad) {
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };

    /**
     * 播放
     * @param activity
     * @param callback
     */
    @Override
    public void showVideoAdvert(final Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;
        YLog.i("FaceBook, showRewardVideo ...");
        if (TextUtils.isEmpty( AdConfigFaceBook.VIDEO_ID)){
            YLog.e("Facebook  videoId  is null");
            videoCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "Facebook  videoId  is null", getAdvertCode());
            return ;
        }


        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {

                if (videoAdvertIsLoaded(activity)) {
                    rewardedVideoAd.show();
                } else {
                    if (videoCallback != null) {
                        videoCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
                    }
                }
            }
        });

        isLoaded = false;
    }
    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreFaceboosk.getInstance().validateAdsAdapter(activity);
    }
    /**
     * 预加载
     * @param activity
     * @param reloadCallback
     */
    @Override
    public void reloadVideoAdvert(final Activity activity,final Yodo1ReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
        YLog.i("FaceBook, reloadVideoAdvert ...");
        if (TextUtils.isEmpty( AdConfigFaceBook.VIDEO_ID)){
            YLog.e("Facebook  videoId  is null");
            reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL,0,"", getAdvertCode());
            return ;
        }

        if (rewardedVideoAd != null) {
            rewardedVideoAd.destroy();
            rewardedVideoAd = null;
        }

        rewardedVideoAd = new RewardedVideoAd(activity, AdConfigFaceBook.VIDEO_ID);
        rewardedVideoAd.setAdListener(adListener);
        rewardedVideoAd.loadAd();
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        YLog.i("FaceBook, videoAdvertIsLoaded = " + isLoaded);
        return rewardedVideoAd != null && rewardedVideoAd.isAdLoaded() ;
    }

    @Override
    public String getAdvertCode() {
        return AdConfigFaceBook.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(final Activity activity) {
        AdConfigFaceBook.VIDEO_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd,
                AdConfigFaceBook.CHANNEL_CODE, AdConfigFaceBook.CONFIG_KEY_FACEBOOK_VIDEO_ID);

        if(TextUtils.isEmpty( AdConfigFaceBook.VIDEO_ID)){
            YLog.e("AdConfigFaceBook.VIDEO_ID is null");
            return;
        }


    }


    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }



    @Override
    public void onDestroy(Activity activity) {
        if (rewardedVideoAd != null) {
            rewardedVideoAd.destroy();
            rewardedVideoAd = null;
        }
    }


}
