package com.yodo1.advert.video.channel;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.ads.MaxRewardedAd;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinErrorCodes;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.plugin.applovin.AdConfigApplovin;
import com.yodo1.advert.plugin.applovin.AdvertCoreApplovin;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.sdk.kit.YLog;

import java.util.Map;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdapterapplovinmax extends AdVideoAdapterBase {

    private Yodo1AdCallback videoCallback; //视频回调
    private Yodo1ReloadCallback reloadCallback; //视频预加载回调
    private MaxRewardedAd rewardedAd;
    private MaxRewardedAdListener adListener = new MaxRewardedAdListener() {
        @Override
        public void onAdLoaded(MaxAd maxAd) {
            YLog.d("Applovin Video onAdLoaded");
            if (reloadCallback != null) {
                reloadCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onAdLoadFailed(String s, int i) {
            YLog.d("Applovin Video  onAdLoadFailed, : " + i + "   " + s);
            if (reloadCallback != null) {
                reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, s, getAdvertCode());
            }

            if (rewardedAd != null){
                rewardedAd.loadAd();
            }
        }

        @Override
        public void onAdDisplayed(MaxAd maxAd) {
            YLog.d("Applovin Video onAdDisplayed :  " + maxAd.getAdUnitId());

        }

        @Override
        public void onAdHidden(MaxAd maxAd) {
            YLog.d("Applovin Video onAdHidden :  " + maxAd.getAdUnitId());
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

            if (rewardedAd != null){
                rewardedAd.loadAd();
            }
        }

        @Override
        public void onAdClicked(MaxAd maxAd) {
            YLog.d("Applovin Video onAdClicked :  " + maxAd.getAdUnitId());
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdDisplayFailed(MaxAd maxAd, int i) {
            YLog.w("Advert, Applovin Video onAdDisplayFailed, : " + i + "   " + maxAd.getAdUnitId());
            if (reloadCallback != null) {
                reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, "error :  " + maxAd.getAdUnitId(), getAdvertCode());
            }

            if (rewardedAd != null){
                rewardedAd.loadAd();
            }
        }

        @Override
        public void onRewardedVideoStarted(MaxAd maxAd) {
            YLog.d("Applovin Video onRewardedVideoStarted :  " + maxAd.getAdUnitId());
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoCompleted(MaxAd maxAd) {
            YLog.d("Applovin Video onRewardedVideoCompleted :  " + maxAd.getAdUnitId());
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onUserRewarded(MaxAd maxAd, MaxReward maxReward) {

        }
    };

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;

        if ( rewardedAd.isReady() )
        {
            rewardedAd.showAd();
        } else {
            videoCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());

        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
//        YLog.w("Advert, Applovin Video reloadVideoAdvert ");

        if (rewardedAd != null){
            rewardedAd.loadAd();
        } else {
            reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "error : ID NULL", getAdvertCode());

        }

    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return rewardedAd != null && rewardedAd.isReady();
    }

    @Override
    public String getAdvertCode() {
        return AdConfigApplovin.CHANNEL_CODE_MAX;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreApplovin.getInstance().validateAdsAdapter(activity);
    }

    @Override
    public void onCreate(Activity activity) {

        AdvertCoreApplovin.getInstance().Init(activity);
        String unitID =  Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigApplovin.CHANNEL_CODE_MAX
                , AdConfigApplovin.KEY_Applovin_VIDEO_ID);

        if (TextUtils.isEmpty(unitID)){
            return;
        }

        rewardedAd = MaxRewardedAd.getInstance( unitID, activity );
        rewardedAd.setListener( adListener );
    }


    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }


    @Override
    public void onDestroy(Activity activity) {
    }


}
