package com.yodo1.advert.video.channel;

import android.app.Activity;
import android.app.Application;

import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinErrorCodes;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.plugin.applovin.AdConfigApplovin;
import com.yodo1.advert.plugin.applovin.AdvertCoreApplovin;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.sdk.kit.YLog;

import java.util.Map;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdapterapplovin extends AdVideoAdapterBase {

    // Reward Listener
    AppLovinAdRewardListener adRewardListener = new AppLovinAdRewardListener() {
        @Override
        public void userRewardVerified(AppLovinAd appLovinAd, Map map) {
            // AppLovin servers validated the reward. Refresh user balance from your server.  We will also pass the number of coins
            // awarded and the name of the currency.  However, ideally, you should verify this with your server before granting it.

            // i.e. - "Coins", "Gold", whatever you set in the dashboard.
            String currencyName = (String) map.get("currency");

            // For example, "5" or "5.00" if you've specified an amount in the UI.
            String amountGivenString = (String) map.get("amount");

            YLog.i("Rewarded " + amountGivenString + " " + currencyName);
            // By default we'll show a alert informing your user of the currency & amount earned.
            // If you don't want this, you can turn it off in the Manage Apps UI.
        }

        @Override
        public void userOverQuota(AppLovinAd appLovinAd, Map map) {
            // Your user has already earned the max amount you allowed for the day at this point, so
            // don't give them any more money. By default we'll show them a alert explaining this,
            // though you can change that from the AppLovin dashboard.
        }

        @Override
        public void userRewardRejected(AppLovinAd appLovinAd, Map map) {
            // Your user couldn't be granted a reward for this view. This could happen if you've blacklisted
            // them, for example. Don't grant them any currency. By default we'll show them an alert explaining this,
            // though you can change that from the AppLovin dashboard.
        }

        @Override
        public void validationRequestFailed(AppLovinAd appLovinAd, int responseCode) {
            if (responseCode == AppLovinErrorCodes.INCENTIVIZED_USER_CLOSED_VIDEO) {
                // Your user exited the video prematurely. It's up to you if you'd still like to grant
                // a reward in this case. Most developers choose not to. Note that this case can occur
                // after a reward was initially granted (since reward validation happens as soon as a
                // video is launched).
            } else if (responseCode == AppLovinErrorCodes.INCENTIVIZED_SERVER_TIMEOUT || responseCode == AppLovinErrorCodes.INCENTIVIZED_UNKNOWN_SERVER_ERROR) {
                // Some server issue happened here. Don't grant a reward. By default we'll show the user
                // a alert telling them to try again later, but you can change this in the
                // AppLovin dashboard.
            } else if (responseCode == AppLovinErrorCodes.INCENTIVIZED_NO_AD_PRELOADED) {
                // Indicates that the developer called for a rewarded video before one was available.
                // Note: This code is only possible when working with rewarded videos.
            }
        }

        @Override
        public void userDeclinedToViewAd(AppLovinAd appLovinAd) {
            // This method will be invoked if the user selected "no" when asked if they want to view an ad.
            // If you've disabled the pre-video prompt in the "Manage Apps" UI on our website, then this method won't be called.
        }
    };
    private Yodo1AdCallback videoCallback; //视频回调
    // Video Playback Listener
    AppLovinAdVideoPlaybackListener adVideoPlaybackListener = new AppLovinAdVideoPlaybackListener() {
        @Override
        public void videoPlaybackBegan(AppLovinAd appLovinAd) {
            YLog.i("Video Started");
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void videoPlaybackEnded(AppLovinAd appLovinAd, double v, boolean b) {
            YLog.i("Video Ended");
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }
    };
    // Ad Dispaly Listener
    AppLovinAdDisplayListener adDisplayListener = new AppLovinAdDisplayListener() {
        @Override
        public void adDisplayed(AppLovinAd appLovinAd) {
            YLog.i("Ad Displayed");

        }

        @Override
        public void adHidden(AppLovinAd appLovinAd) {
            YLog.i("Ad Dismissed");
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }
    };
    // Ad Click Listener
    AppLovinAdClickListener adClickListener = new AppLovinAdClickListener() {
        @Override
        public void adClicked(AppLovinAd appLovinAd) {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };
    private Yodo1ReloadCallback reloadCallback; //视频预加载回调
    private AppLovinIncentivizedInterstitial myIncent;
    private AppLovinAdLoadListener adLoadListener = new AppLovinAdLoadListener() {
        @Override
        public void adReceived(AppLovinAd appLovinAd) {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_LOADED, getAdvertCode());
            }

            if (reloadCallback != null) {
                reloadCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void failedToReceiveAd(int errorCode) {
//        adErrorCode==204    Indicates that no ads are currently eligible for your device & location
            YLog.w("Advert, Applovin Video onAdError, adError code = " + errorCode);
            if (errorCode == AppLovinErrorCodes.NO_FILL) {
                // Indicates that no ads are currently eligible for your device & location.
                YLog.w("Advert, Applovin Video onAdError, NO_FILL ");

                if (reloadCallback != null) {
                    reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode, "error : NO_FILL", getAdvertCode());
                }
            } else {
                // Unable to reach AppLovin; the user's device is likely experiencing poor connectivity.

                if (reloadCallback != null) {
                    reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode, "error : " + errorCode, getAdvertCode());
                }
            }
        }
    };

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;
        if (myIncent.isAdReadyToDisplay()) {
            myIncent.show(activity, adRewardListener, adVideoPlaybackListener, adDisplayListener, adClickListener);
        } else {
            videoCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
//        YLog.w("Advert, Applovin Video reloadVideoAdvert ");
        myIncent = AppLovinIncentivizedInterstitial.create(activity);
        myIncent.preload(adLoadListener);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return myIncent.isAdReadyToDisplay();
    }

    @Override
    public String getAdvertCode() {
        return AdConfigApplovin.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreApplovin.getInstance().validateAdsAdapter(activity);
    }

    @Override
    public void onCreate(Activity activity) {

        AdvertCoreApplovin.getInstance().Init(activity);

    }


    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }


    @Override
    public void onDestroy(Activity activity) {
        myIncent.dismiss();
    }


}
