package com.yodo1.advert.video.channel;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.plugin.admob.AdConfigAdMob;
import com.yodo1.advert.plugin.admob.AdvertCoreAdMob;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.sdk.kit.YLog;

public class AdvertAdapteradmob extends AdVideoAdapterBase {
    private String UnitId = "";
    private boolean isLoded = false;
    private Yodo1AdCallback videoCallback; //视频回调
    private Yodo1ReloadCallback reloadCallback; //视频预加载回调
    private RewardedVideoAd mRewardedVideoAd;
    private RewardedVideoAdListener listener = new RewardedVideoAdListener() {
        @Override
        public void onRewardedVideoAdLoaded() {
            isLoded = true;
            if (reloadCallback != null) {
                reloadCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdOpened() {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoStarted() {

        }

        @Override
        public void onRewardedVideoAdClosed() {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onRewarded(RewardItem rewardItem) {

        }

        @Override
        public void onRewardedVideoAdLeftApplication() {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdFailedToLoad(int errorCode) {
            YLog.i("AdMob   onRewardedVideoAdFailedToLoad: " + errorCode);

            if (reloadCallback != null) {
                reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode, "异常码： " + errorCode + " 错误信息：" + errorCode, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoCompleted() {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }
    };

    @Override
    public String getAdvertCode() {
        return AdConfigAdMob.CHANNEL_CODE;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreAdMob.getInstance().validateAds(activity);
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
        UnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigAdMob.CHANNEL_CODE
                , AdConfigAdMob.KEY_AdMob_VIDEO_ID);
        if (TextUtils.isEmpty(UnitId)) {
            YLog.e("AdMob Video Appid  is null");
            return;
        }

        //此处读取key
        AdvertCoreAdMob.getInstance().initAdMob(activity);
//        MobileAds.initialize(activity,
//                "ca-app-pub-3940256099942544~3347511713");

        // Use an activity context to get the rewarded video instance.
        mRewardedVideoAd = MobileAds.getRewardedVideoAdInstance(activity);
        mRewardedVideoAd.setRewardedVideoAdListener(listener);


    }


    @Override
    public void onResume(Activity activity) {
        if (mRewardedVideoAd != null) {
            mRewardedVideoAd.resume(activity);
        }
    }

    @Override
    public void onPause(Activity activity) {
        if (mRewardedVideoAd != null) {
            mRewardedVideoAd.pause(activity);
        }
    }


    @Override
    public void onDestroy(Activity activity) {
        if (mRewardedVideoAd != null) {
            mRewardedVideoAd.destroy(activity);
        }
    }


    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;
        if (mRewardedVideoAd != null && mRewardedVideoAd.isLoaded()) {
            mRewardedVideoAd.show();
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }

        isLoded = false;
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
        if (TextUtils.isEmpty(UnitId)) {
            reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "", getAdvertCode());
            YLog.e("AdMob Video UnitId  is null");
            return;
        }

        YLog.d("Admob reloadVideoAdvert : " + UnitId);
        if (mRewardedVideoAd != null) {
            mRewardedVideoAd.loadAd(UnitId,
                    new AdRequest.Builder().addTestDevice("C8F01879446BEC2C7519C0B7191B3782").build());
        }

    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return isLoded;
    }
}
