package com.yodo1.advert.video;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.PixelFormat;
import android.media.MediaMetadataRetriever;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.KeyEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.yodo1.advert.plugin.yodo1.AdConfigYodo1;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.CacheMode;
import com.yodo1.nohttp.rest.OnResponseListener;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.RequestQueue;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.sdk.kit.RR;
import com.yodo1.sdk.kit.YLog;

import java.io.IOException;


public class Yodo1VPActivity extends Activity {
    private Yodo1CountDownView cdv;
    private SurfaceView surfaceView;
    private RelativeLayout rel_video, rel_down;
    private ImageView img_bg, imgclose;
    private Yodo1VideoCallback callback = Yodo1VideoAds.yodo1VideoCallback;
    private Bitmap bm;
    private MediaPlayer player;
    private SurfaceHolder holder;
    private boolean videoPause = false;
    private String videoPath = "";
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Intent intent = getIntent();
        int orientation = intent.getIntExtra("orientation", 1);
        if (orientation == Configuration.ORIENTATION_PORTRAIT) {
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        } else {
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
        }

        getWindow().setFormat(PixelFormat.TRANSLUCENT);
        requestWindowFeature(Window.FEATURE_NO_TITLE);//隐藏标题
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN);//设置全屏
        setContentView(RR.layout(this, "yodo1_vp_activity"));


        initView();
        videoPath = getCacheDir().getAbsolutePath() + "/local_video.mp4";

        loadLoaingPage(orientation);
    }

    /**
     * 初始化View
     */
    public void initView() {
        cdv = findViewById(RR.id(this, "yodo1_view_countdowm"));
        surfaceView = findViewById(RR.id(this, "yodo1_surfaceview_player"));
        rel_video = findViewById(RR.id(this, "yodo1_rel_player"));
        rel_down = findViewById(RR.id(this, "yodo1_rel_closepage"));
        img_bg = findViewById(RR.id(this, "yodo1_iv_bgimage"));
        imgclose = findViewById(RR.id(this, "yodo1_iv_close"));

        player=new MediaPlayer();
        img_bg.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                AdConfigYodo1.goYodo1Web(Yodo1VPActivity.this);
            }
        });

        imgclose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                callback.onVideoClosed();

                finish();
            }
        });

        surfaceView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                callback.onVideoClicked();
            }
        });

    }


    /**
     * 播放视频资源
     *
     */
    public void loadVideoView() {


        try {
            surfaceView.getHolder().addCallback(new MyCallBack());
            player.setOnPreparedListener(new MediaPlayer.OnPreparedListener() {
                @Override
                public void onPrepared(MediaPlayer mp) {
                    player.start();
                    YLog.d("Yodo1VP  播放成功 ： " );
                    callback.onVideoShow();
                }
            });

            player.setOnCompletionListener(new MediaPlayer.OnCompletionListener() {
                @Override
                public void onCompletion(MediaPlayer mp) {
                    YLog.d("Yodo1VP  播放完成 ： " );

                callback.onVideoFinish();
                rel_video.setVisibility(View.GONE);
                rel_down.setVisibility(View.VISIBLE);

                if (bm!=null){
                    img_bg.setImageBitmap(bm);
                } else {
                    if (getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT) {
                        img_bg.setImageResource(RR.drawable(Yodo1VPActivity.this, "yodo1splash_portrait"));
                    } else {
                        img_bg.setImageResource(RR.drawable(Yodo1VPActivity.this, "yodo1splash_landscape"));
                    }
                }
                }
            });
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(videoPath);
            String duration = mmr.extractMetadata(MediaMetadataRetriever.METADATA_KEY_DURATION);

            //设置倒计时时间
            int time = (int) Math.round(Double.valueOf(duration) / 1000);
            setCdvCountDown(time);
            YLog.d("Yodo1VP  当前视频总时长 ： " + duration);
            YLog.d("Yodo1VP  当前视频总时长 ： " + time);


        }catch (Exception e){
        }

    }


    /**
     * 设置倒计时
     * @param time
     */
    private void setCdvCountDown(int time){
        cdv.setCountdownTime(time);

        cdv.startCountDown();//开始倒计时
    }



    @Override
    protected void onResume() {
        super.onResume();

        if ( videoPause ){
            videoPause = false;
            rel_video.setVisibility(View.VISIBLE);
            rel_down.setVisibility(View.GONE);
        }
        loadVideoView();
    }

    int position = 0;
    @Override
    protected void onPause() {
        super.onPause();


        if (rel_video.getVisibility() == View.VISIBLE){
            videoPause = true;
        }
        if (player != null && player.isPlaying()) {
            try {
                player.pause();
                videoPause = true;

            }catch (Exception e){
            }
        }

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();

        try {

            if (player != null){
                if (player.isPlaying()){
                    player.stop();
                }
                player.release();//释放资源
                player.reset();
                player = null;
            }
        }catch (IllegalStateException e){}


    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if ((keyCode == KeyEvent.KEYCODE_BACK)) {
            return false;
        } else {
            return super.onKeyDown(keyCode, event);
        }
    }


    /**
     * 加载落地页
     * @param orientation
     */
    private void loadLoaingPage(int orientation){
        String url = "https://docs.yodo1.com/media/ad-test-resource/ad-video-landing-page-portrait.png";
        if (orientation == Configuration.ORIENTATION_PORTRAIT) {
            url = "https://docs.yodo1.com/media/ad-test-resource/ad-video-landing-page-landscape.png";
        }


        RequestQueue requestQueue = NoHttp.newRequestQueue();
        Request<Bitmap> requeset = NoHttp.createImageRequest(url, RequestMethod.GET);
        OnResponseListener<Bitmap> listener = new OnResponseListener<Bitmap>() {
            @Override
            public void onStart(int what) {
            }

            @Override
            public void onSucceed(int what, Response<Bitmap> response) {
                bm = response.get();
            }

            @Override
            public void onFailed(int what, Response<Bitmap> response) {

            }

            @Override
            public void onFinish(int what) {
            }
        };
        //设置缓存模式
        requeset.setCacheMode(CacheMode.REQUEST_NETWORK_FAILED_READ_CACHE);
        requestQueue.add(1, requeset, listener);
    }


    private class MyCallBack implements SurfaceHolder.Callback {
        @Override
        public void surfaceCreated(SurfaceHolder holder) {
            Uri uri = Uri.parse(videoPath);

            player.setDisplay(holder);
            if (!player.isPlaying()) {
                try {
                    player.reset();
                    player.setDataSource(Yodo1VPActivity.this,uri);
                    player.prepare();
                    player.seekTo(position);

                    YLog.d("Yodo1VP  开始播放 ： " + position);
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }

        }

        @Override
        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {

        }

        @Override
        public void surfaceDestroyed(SurfaceHolder holder) {
            if (player.isPlaying()) {
                position = player.getCurrentPosition();
                player.stop();

                YLog.d("Yodo1VP  当前播放市场 ： " + position);
            }
        }
    }
}
