package com.yodo1.advert.plugin.supersonic;

import android.app.Activity;
import android.content.Intent;
import android.os.AsyncTask;
import android.text.TextUtils;


import com.ironsource.adapters.supersonicads.SupersonicConfig;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.sdk.SSAFactory;
import com.yodo1.sdk.kit.ValidateUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;

import java.util.Arrays;
import java.util.List;


/**
 * Created by yodo1 on 2016/4/21.
 */
public class AdvertCoreSupersonic {
    private final String FALLBACK_USER_ID = "userId";
    private boolean init = false;

    private static AdvertCoreSupersonic instance;
    private AdvertCoreSupersonic(){}
    public static AdvertCoreSupersonic getInstance(){
        if(instance == null){
            instance = new AdvertCoreSupersonic();
        }
        return instance;
    }

    public void onResume(Activity activity) {
        if (TextUtils.isEmpty(AdConfigSupersonic.SUPERSONIC_ID)){
            YLog.e("Supersonic  APPID  is null");
            return;
        }
        IronSource.onResume(activity);

    }

    public void onPause(Activity activity) {
        if (TextUtils.isEmpty(AdConfigSupersonic.SUPERSONIC_ID)){
            YLog.e("Supersonic  APPID  is null");
            return;
        }
        IronSource.onPause(activity);
    }

    public void startIronSourceInitTask(final Activity activity){

        if (!init){
            init = true;
            //若插屏视频广告key一致，读取一个即可
            //若插屏视频广告key一致，读取一个即可
            AdConfigSupersonic.SUPERSONIC_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigSupersonic.CHANNEL_CODE
                    , AdConfigSupersonic.KEY_SUPERSONIC_APP_ID);
            if (TextUtils.isEmpty(AdConfigSupersonic.SUPERSONIC_ID)){
                AdConfigSupersonic.SUPERSONIC_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigSupersonic.CHANNEL_CODE
                        , AdConfigSupersonic.KEY_SUPERSONIC_APP_ID);
            }

            if (TextUtils.isEmpty(AdConfigSupersonic.SUPERSONIC_ID)){
                YLog.e("Supersonic  APPID  is null");
                return;
            }

            IronSource.init(activity, AdConfigSupersonic.SUPERSONIC_ID);
        }

    }


    private boolean validate = false;
    public  void validateAdsAdapter(Activity activity){
        if(!validate) {
            List<String> supersonicActivities = Arrays.asList(new String[] { "com.ironsource.sdk.controller.ControllerActivity" ,
                    "com.ironsource.sdk.controller.InterstitialActivity" ,"com.ironsource.sdk.controller.OpenUrlActivity" });
            ValidateUtils.validateActivities(activity,supersonicActivities);

            validate = true;
        }
    }

}
