package com.yodo1.advert.plugin.applovin;

import android.app.Activity;

import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.yodo1.sdk.kit.ValidateUtils;
import com.yodo1.sdk.kit.YLog;

import java.util.Arrays;
import java.util.List;

/**
 * Created by yodo1 on 2016/4/21.
 */
public class AdvertCoreApplovin {
    private static AdvertCoreApplovin instance;
    private boolean validate = false;
    private boolean init = false;


    private AdvertCoreApplovin() {
    }

    public static AdvertCoreApplovin getInstance() {
        if (instance == null) {
            instance = new AdvertCoreApplovin();
        }
        return instance;
    }

    public void validateAdsAdapter(Activity activity) {
        if (!validate) {
            List<String> adapplovinActivities = Arrays.asList(new String[]{"com.applovin.adview.AppLovinInterstitialActivity",
                    "com.applovin.adview.AppLovinConfirmationActivity"});
            ValidateUtils.validateActivities(activity, adapplovinActivities);

            List<String> adapplovinMate = Arrays.asList(new String[]{"applovin.sdk.key"});
            ValidateUtils.validateMetaData(activity, adapplovinMate);
            validate = true;
        }

    }

    public void Init(Activity activity) {
        if (!init) {
            AppLovinSdk.initializeSdk( activity, new AppLovinSdk.SdkInitializationListener() {
                @Override
                public void onSdkInitialized(final AppLovinSdkConfiguration configuration)
                {
                    // AppLovin SDK is initialized, start loading ads
                    YLog.d("AppLovin SDK is initialized : " + configuration.getConsentDialogState().name());
                }
            } );

            init = true;
        }

    }

}
