package com.yodo1.advert.interstitial.channel;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.plugin.vungle.AdConfigVungle;
import com.yodo1.advert.plugin.vungle.AdvertCoreVungle;
import com.yodo1.sdk.kit.YLog;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdaptervungle extends AdInterstitialAdapterBase {

    private Yodo1AdCallback intersititalCallback;//插屏回调
    private Yodo1ReloadCallback callback;
    
    private final LoadAdCallback vungleLoadAdCallback = new LoadAdCallback() {

        @Override
        public void onAdLoad(String placementReferenceId) {

            if(callback != null){
                callback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onError(String placementReferenceId, Throwable throwable) {

            if(callback != null){
                callback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION,0,"异常码广告位： "+placementReferenceId + " 错误信息：" + throwable.getCause(), getAdvertCode());
            }
            YLog.d("Vungle,  onError : " + placementReferenceId + "   Throwable : " + throwable.getCause());

        }
    };

    private final PlayAdCallback vunglePlayAdCallback = new PlayAdCallback() {

        @Override
        public void onAdStart(String placementReferenceId) {
            if (placementReferenceId.equals(AdConfigVungle.INTERSTITIAL_PLACEMENTID)) {
                if (intersititalCallback != null) {
                    intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, AdConfigVungle.CHANNEL_CODE);
                }
            }

        }

        @Override
        public void onAdEnd(String placementReferenceId, boolean completed, boolean isCTAClicked) {
            if (placementReferenceId.equals(AdConfigVungle.INTERSTITIAL_PLACEMENTID) && intersititalCallback != null) {
                if (isCTAClicked){
                    intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, AdConfigVungle.CHANNEL_CODE);
                }


                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, AdConfigVungle.CHANNEL_CODE);
            }


        }

        @Override
        public void onError(String placementReferenceId, Throwable throwable) {
            YLog.d("Vungle,  onError : " + placementReferenceId + "   Throwable : " + throwable.getCause());
        }
    };
    
    @Override
    public String getAdvertCode() {
        return AdConfigVungle.CHANNEL_CODE;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {

        AdvertCoreVungle.getInstance().validateAdsAdapter(activity);

    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(final Activity activity) {

        AdvertCoreVungle.getInstance().init(activity);
    }



    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }



    @Override
    public void onDestroy(Activity activity) {
    }



    @Override
    public void showIntersititalAdvert(final Activity activity,final Yodo1AdCallback callback) {
        YLog.d("Vungle, showVideoAdvert");
        this.intersititalCallback = callback;
        if (TextUtils.isEmpty( AdConfigVungle.APP_ID)){
            YLog.i("Vungle  appid  is null");
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "Vungle  appid  is null", getAdvertCode());

            return ;
        }
        if (TextUtils.isEmpty(AdConfigVungle.INTERSTITIAL_PLACEMENTID)){
            YLog.i("Vungle intertitial placementid is null");
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "Vungle  intertitial placementid  is null", getAdvertCode());
            return;
        }

        if (Vungle.canPlayAd(AdConfigVungle.INTERSTITIAL_PLACEMENTID)) {
            Vungle.playAd(AdConfigVungle.INTERSTITIAL_PLACEMENTID, null, vunglePlayAdCallback);
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity,final Yodo1ReloadCallback callback) {
        this.callback = callback;
        if (TextUtils.isEmpty(AdConfigVungle.INTERSTITIAL_PLACEMENTID)){
            callback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL,0,"APPID 为空",getAdvertCode());
            YLog.i("Vungle,  reloadInterstitialAdvert Interstitial PlacementId  is null");
            return;
        }
        YLog.d("Vungle, reloadInterstitialAdvert");

        if (Vungle.isInitialized()) {
            Vungle.loadAd(AdConfigVungle.INTERSTITIAL_PLACEMENTID, vungleLoadAdCallback);
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return Vungle.canPlayAd(AdConfigVungle.INTERSTITIAL_PLACEMENTID);
    }


}
