package com.yodo1.advert.interstitial.channel;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.ironsource.mediationsdk.IronSource;

import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.InterstitialListener;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.plugin.supersonic.AdConfigSupersonic;
import com.yodo1.sdk.kit.YLog;

public class AdvertAdaptersupersonic extends AdInterstitialAdapterBase{
    private Yodo1AdCallback intersititalCallback; //插屏回调
    private Yodo1ReloadCallback reloadCallback;

    InterstitialListener listener = new InterstitialListener() {
        @Override
        public void onInterstitialAdReady() {

            if(reloadCallback != null){
                reloadCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdLoadFailed(IronSourceError ironSourceError) {

            if(reloadCallback != null){
                reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION,ironSourceError.getErrorCode(),ironSourceError.getErrorMessage(), getAdvertCode());
            }
            YLog.i("Supersonic onInterstitialAdLoadFailed  = " + ironSourceError.getErrorCode() + "   msg = " + ironSourceError.getErrorMessage());
        }

        @Override
        public void onInterstitialAdOpened() {

        }

        @Override
        public void onInterstitialAdClosed() {
            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdShowSucceeded() {
            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdShowFailed(IronSourceError ironSourceError) {
            YLog.i("Supersonic onInterstitialAdShowFailed  = " + ironSourceError.getErrorCode());
            if(intersititalCallback != null){
                intersititalCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_DISPLAY_FAILED, "onInterstitialAdShowFailed",getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdClicked() {
            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }


    };
    @Override
    public String getAdvertCode() {
        return AdConfigSupersonic.CHANNEL_CODE;
    }
    @Override
    public void validateAdsAdapter(Activity activity) {
    }

    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1AdCallback callback) {
        this.intersititalCallback = callback;

        YLog.i("Supersonic show");
        if (TextUtils.isEmpty(AdConfigSupersonic.SUPERSONIC_ID) ){
            YLog.e("Supersonic  APPID  is null");
            intersititalCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
            return ;
        }
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (IronSource.isInterstitialReady()) {
                    //show the interstitial
                    IronSource.showInterstitial();
                }else {
                    if(intersititalCallback != null){
                        intersititalCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
                    }
                }

            }
        });

    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadCallback = callback;
        if (TextUtils.isEmpty(AdConfigSupersonic.SUPERSONIC_ID)){
            YLog.e("Supersonic  APPID  is null");
            reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL,0,"",getAdvertCode());
            return ;
        }
        IronSource.loadInterstitial();

    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return IronSource.isInterstitialReady();
    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(Activity activity) {
        AdConfigSupersonic.SUPERSONIC_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigSupersonic.CHANNEL_CODE
                , AdConfigSupersonic.KEY_SUPERSONIC_APP_ID);
        if (TextUtils.isEmpty(AdConfigSupersonic.SUPERSONIC_ID)){
            YLog.e("Supersonic  APPID  is null");
            return;
        }
        //Init Interstitial
        IronSource.init(activity, AdConfigSupersonic.SUPERSONIC_ID, IronSource.AD_UNIT.INTERSTITIAL);
        IronSource.setInterstitialListener(listener);
    }


    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }



    @Override
    public void onDestroy(Activity activity) {
    }



}
