package com.yodo1.advert.interstitial.channel;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;

import com.applovin.mediation.AppLovinExtras;
import com.applovin.mediation.ApplovinAdapter;
import com.google.ads.mediation.tapjoy.TapjoyAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.InterstitialAd;
import com.ironsource.mediationsdk.IronSource;
import com.vungle.mediation.VungleInterstitialAdapter;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.plugin.admob.AdConfigAdMob;
import com.yodo1.advert.plugin.admob.AdvertCoreAdMob;
import com.yodo1.sdk.kit.YLog;

import java.util.ArrayList;

public class AdvertAdapteradmob extends AdInterstitialAdapterBase {

    public ArrayList<Boolean> isLoded;
    int ads = 0;
    private Yodo1AdCallback intersititalCallback; //插屏回调
    private Yodo1ReloadCallback reloadCallback;
    private AdRequest adRequest;
    private ArrayList<InterstitialAd> interstitialAds;
    private ArrayList<String> keys;

    @Override
    public String getAdvertCode() {
        return AdConfigAdMob.CHANNEL_CODE;
    }


    //    预加载
    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadCallback = callback;
        if (keys == null || keys.size() == 0) {
            YLog.e("Admob  APPID  is null");
            callback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "", getAdvertCode());
            return;
        }

        // Request a new ad if one isn't already loaded
        //同时预加载四个广告位的广告
        for (int i = 0; i < ads; i++) {
            YLog.i("admob  请求第  " + (i + 1) + " 个广告位");
            reloadAdvert(interstitialAds.get(i));
        }
    }


    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        if (keys == null || keys.size() == 0) {
            YLog.e("Admob  APPID  is null");
            return false;
        }

        return reloadAdvertForAll(interstitialAds);
    }

    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.intersititalCallback = callback;
        if (keys == null || keys.size() == 0) {
            YLog.e("Admob  APPID  is null");
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
            return;
        }


        // Request a new ad if one isn't already loaded
        //展示指定广告位广告
        int index = 0;
        while (index >= 0 && index < ads) {
            YLog.i("admob  展示第  " + (index + 1) + " 个广告位");
            if (isLoaded(interstitialAds.get(index), index)) {
                interstitialAds.get(index).show();
                isLoded.add(index, false);
                break;
            } else {
                YLog.i("admob第" + (index + 1) + "个广告位广告预加载失败");
                if (index == ads - 1) {
                    callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
                }

            }

            index++;
        }

    }

    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreAdMob.getInstance().validateAds(activity);
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
        AdvertCoreAdMob.getInstance().initAdMob(activity);
        isLoded = new ArrayList();
        keys = new ArrayList();

        keys.add(Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigAdMob.CHANNEL_CODE
                , AdConfigAdMob.KEY_AdMob_INTERSTITIAL_ID + "1"));
        keys.add(Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigAdMob.CHANNEL_CODE
                , AdConfigAdMob.KEY_AdMob_INTERSTITIAL_ID + "2"));
        keys.add(Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigAdMob.CHANNEL_CODE
                , AdConfigAdMob.KEY_AdMob_INTERSTITIAL_ID + "3"));
        keys.add(Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigAdMob.CHANNEL_CODE
                , AdConfigAdMob.KEY_AdMob_INTERSTITIAL_ID + "4"));

//        keys.add("ca-app-pub-7188592076082444/6710711140");
        ads = keys.size();

        if (keys == null || keys.size() == 0) {
            YLog.e("Admob  APPID  is null");
            return;
        }
        YLog.d("Admob Keys : " + keys);

        Bundle applovin = new AppLovinExtras.Builder()
                .setMuteAudio(true)
                .build();

        Bundle tapjoy = new TapjoyAdapter.TapjoyExtrasBundleBuilder()
                .setDebug(true)
                .build();

        adRequest = new AdRequest.Builder()
                .addNetworkExtrasBundle(TapjoyAdapter.class, tapjoy)
                .addNetworkExtrasBundle(ApplovinAdapter.class, applovin)
                .addNetworkExtrasBundle(VungleInterstitialAdapter.class, null) // Interstitial.
                .build();

        interstitialAds = new ArrayList<>();
        for (int i = 0; i < ads; i++) {
            YLog.i("admob  初始化第  " + (i + 1) + " 广告  key: " + keys.get(i));
            initAdmob(activity, i);

        }


    }


    @Override
    public void onResume(Activity activity) {
        IronSource.onResume(activity);
    }

    @Override
    public void onPause(Activity activity) {
        IronSource.onPause(activity);
    }


    @Override
    public void onDestroy(Activity activity) {

    }


    //预加载指定广告位广告
    public void reloadAdvert(InterstitialAd mInterstitialAd) {
        // Request a new ad if one isn't already loaded
        if (mInterstitialAd != null && !mInterstitialAd.isLoaded()) {
            mInterstitialAd.loadAd(adRequest);
        }
    }

    //判断所有广告位是否有广告加载成功
    public boolean reloadAdvertForAll(ArrayList<InterstitialAd> interstitialAds) {
        // Request a new ad if one isn't already loaded
        for (int i = 0; i < interstitialAds.size(); i++) {
            if (isLoaded(interstitialAds.get(i), i)) {
                YLog.i("admob  第  " + (i + 1) + " 广告位有广告");
                return true;
            }
        }
        return false;
    }

    //指定广告位广告是否加载成功
    public boolean isLoaded(InterstitialAd mInterstitialAd, int i) {
//        return mInterstitialAd != null && mInterstitialAd.isLoaded();
        return isLoded.get(i);
    }


    private void initAdmob(Activity activity, final int i) {
        isLoded.add(i, false);
        InterstitialAd interstitialAd = new InterstitialAd(activity);
        interstitialAd.setAdUnitId(keys.get(i));

        interstitialAd.setAdListener(new AdListener() {
            @Override
            public void onAdClosed() {
                if (intersititalCallback != null) {
                    intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
                }
            }

            //            Called when an ad request failed. The error code is usually ERROR_CODE_INTERNAL_ERROR, ERROR_CODE_INVALID_REQUEST, ERROR_CODE_NETWORK_ERROR, or ERROR_CODE_NO_FILL.
            @Override
            public void onAdFailedToLoad(int errorCode) {
                YLog.i("Advert, Admob Interstitial onAdFailedToLoad, adErrorCode = " + errorCode);

                if (reloadCallback != null) {
                    reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode, "异常码： " + errorCode + " 错误信息：" + errorCode, getAdvertCode());
                }
            }

            //           Called when an ad opens an overlay that covers the screen.
            @Override
            public void onAdOpened() {
                if (intersititalCallback != null) {
                    intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
                }
            }

            //            Called when an ad leaves the application  eg： 去往浏览器
            @Override
            public void onAdLeftApplication() {
                if (intersititalCallback != null) {
                    intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
                }
            }

            //            Called when an ad is received.
            @Override
            public void onAdLoaded() {
                YLog.i("Advert, AdMob Interstitial onAdLoaded ... ");
                isLoded.add(i, true);
                if (reloadCallback != null) {
                    reloadCallback.onReloadSuccess(getAdvertCode());
                }

            }
        });


        interstitialAds.add(interstitialAd);
    }
}
